/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.slots;

import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.ScalableHeightLabel;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.ParallelTransition;
import javafx.animation.Timeline;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.util.Duration;

class Suggestion {
    public static final Duration FADE_IN_SPEED = Duration.millis((double)150.0);
    public static final Duration FADE_OUT_SPEED = Duration.millis((double)150.0);
    private final String text;
    private boolean showing = true;
    private final ScalableHeightLabel type;
    private final ScalableHeightLabel prefix;
    private final ScalableHeightLabel matching;
    private final ScalableHeightLabel next;
    private final ScalableHeightLabel suffix;
    private final ScalableHeightLabel fixedPostSuffix;
    private final ScalableHeightLabel buttonHint;
    private boolean showingHint;
    private Animation animation;
    private final BorderPane pane;

    private List<ScalableHeightLabel> allLabels() {
        return Arrays.asList(this.type, this.prefix, this.matching, this.next, this.suffix, this.fixedPostSuffix, this.buttonHint);
    }

    public Suggestion(String text, String unmatchableSuffix, String type, boolean typeMatch, DoubleExpression typeWidth, boolean direct) {
        this.text = text;
        this.type = new ScalableHeightLabel(type, false);
        this.type.minWidthProperty().bind((ObservableValue)typeWidth);
        this.type.maxWidthProperty().bind((ObservableValue)typeWidth);
        JavaFXUtil.setPseudoclass("bj-match", typeMatch, new Node[]{this.type});
        this.prefix = new ScalableHeightLabel("", false);
        this.matching = new ScalableHeightLabel("", false);
        this.next = new ScalableHeightLabel(text.substring(0, 1), false);
        this.suffix = new ScalableHeightLabel(text.substring(1), false);
        this.fixedPostSuffix = new ScalableHeightLabel(unmatchableSuffix, false);
        JavaFXUtil.addStyleClass((Styleable)this.type, "suggestion-type");
        JavaFXUtil.addStyleClass((Styleable)this.prefix, "suggestion-prefix");
        JavaFXUtil.addStyleClass((Styleable)this.matching, "suggestion-matching");
        JavaFXUtil.addStyleClass((Styleable)this.next, "suggestion-next");
        JavaFXUtil.addStyleClass((Styleable)this.suffix, "suggestion-suffix");
        this.prefix.setMinWidth(Double.NEGATIVE_INFINITY);
        this.matching.setMinWidth(Double.NEGATIVE_INFINITY);
        this.next.setMinWidth(Double.NEGATIVE_INFINITY);
        this.suffix.setMinWidth(0.0);
        this.fixedPostSuffix.setMinWidth(0.0);
        this.buttonHint = new ScalableHeightLabel("\u21b5", false);
        JavaFXUtil.addStyleClass((Styleable)this.buttonHint, "suggestion-button-hint");
        this.buttonHint.setMinWidth(Double.NEGATIVE_INFINITY);
        this.buttonHint.setOpacity(0.0);
        this.showingHint = false;
        HBox hbox = new HBox();
        hbox.getChildren().addAll((Object[])new Node[]{this.type, this.prefix, this.matching, this.next, this.suffix, this.fixedPostSuffix});
        hbox.setSpacing(0.0);
        this.pane = new BorderPane();
        this.pane.setCenter((Node)hbox);
        this.pane.setRight((Node)this.buttonHint);
        JavaFXUtil.addStyleClass((Styleable)this.pane, "suggestion", direct ? "suggestion-direct" : "suggestion-similar");
    }

    public void setHighlight(boolean on) {
        JavaFXUtil.setPseudoclass("bj-suggestion-highlight", on, new Node[]{this.pane});
        this.setHintShowing(on, true);
    }

    public void animateOut(boolean immediate) {
        if (this.showing) {
            if (this.animation != null) {
                this.animation.stop();
            }
            this.showing = false;
            if (immediate) {
                this.allLabels().forEach(l -> l.setToNothing());
                this.pane.setManaged(false);
                this.pane.setVisible(false);
            } else {
                this.animation = new ParallelTransition((Animation[])this.allLabels().stream().map(l -> l.getShrinkToNothingTimeline(FADE_OUT_SPEED)).collect(Collectors.toList()).toArray(new Timeline[0]));
                this.animation.setOnFinished(e -> {
                    this.pane.setManaged(false);
                    this.pane.setVisible(false);
                });
                this.animation.play();
            }
        }
    }

    public void animateIn(boolean immediate) {
        if (!this.showing) {
            if (this.animation != null) {
                this.animation.stop();
            }
            this.showing = true;
            this.pane.setManaged(true);
            this.pane.setVisible(true);
            if (immediate) {
                this.allLabels().forEach(l -> l.setToFullHeight());
            } else {
                this.animation = new ParallelTransition((Animation[])this.allLabels().stream().map(l -> l.getGrowToFullHeightTimeline(FADE_IN_SPEED)).collect(Collectors.toList()).toArray(new Timeline[0]));
                this.animation.play();
            }
        }
    }

    public void notifyEligible(int at, int len, boolean canTab, boolean immediate) {
        if (canTab) {
            this.setHintShowing(true, immediate);
        } else {
            this.setHintShowing(false, immediate);
        }
        this.prefix.setText(this.text.substring(0, at));
        int end = Math.min(at + len, this.text.length());
        this.matching.setText(this.text.substring(at, end));
        String rest = this.text.substring(end);
        if (rest.length() >= 1) {
            this.next.setText(rest.substring(0, 1));
            this.suffix.setText(rest.substring(1));
        } else {
            this.next.setText("");
            this.suffix.setText("");
        }
    }

    private void setHintShowing(boolean shouldShow, boolean immediate) {
        if (this.showingHint != shouldShow) {
            double targetOpacity;
            this.showingHint = shouldShow;
            double d = targetOpacity = shouldShow ? 1.0 : 0.0;
            if (immediate) {
                this.buttonHint.setOpacity(targetOpacity);
            } else {
                FadeTransition ft = new FadeTransition(Duration.millis((double)200.0), (Node)this.buttonHint);
                ft.setToValue(targetOpacity);
                ft.play();
            }
        }
    }

    public String getText() {
        return this.text;
    }

    public Region getNode() {
        return this.pane;
    }
}

