/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.slots;

import bluej.stride.framedjava.ast.NameDefSlotFragment;
import bluej.stride.framedjava.ast.ParamFragment;
import bluej.stride.framedjava.ast.TextSlotFragment;
import bluej.stride.framedjava.ast.TypeSlotFragment;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.errors.CodeError;
import bluej.stride.framedjava.errors.EmptyError;
import bluej.stride.framedjava.frames.CodeFrame;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameContentRow;
import bluej.stride.generic.InteractionManager;
import bluej.stride.slots.Focus;
import bluej.stride.slots.FocusParent;
import bluej.stride.slots.HeaderItem;
import bluej.stride.slots.SlotLabel;
import bluej.stride.slots.SlotTraversalChars;
import bluej.stride.slots.SlotValueListener;
import bluej.stride.slots.TextSlot;
import bluej.stride.slots.TypeCompletionCalculator;
import bluej.stride.slots.TypeTextSlot;
import bluej.stride.slots.VariableNameDefTextSlot;
import bluej.utility.Debug;
import bluej.utility.Utility;
import bluej.utility.javafx.FXRunnable;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.SharedTransition;
import bluej.utility.javafx.binding.ConcatMapListBinding;
import bluej.utility.javafx.binding.DeepListBinding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Cursor;
import javafx.scene.input.MouseEvent;

public class FormalParameters {
    protected final InteractionManager editor;
    protected final ObservableList<FormalParameter> params;
    protected final Frame parentFrame;
    protected final CodeFrame<? extends CodeElement> codeParentFrame;
    private final FrameContentRow row;
    protected String stylePrefix;
    private final SlotLabel spacer;
    private final SlotLabel open = new SlotLabel("(", new String[0]);
    private final SlotLabel close = new SlotLabel(")", new String[0]);
    private boolean normalView = true;
    private FXRunnable updateSlots;
    private ObservableList<HeaderItem> boundSlots;

    public FormalParameters(InteractionManager editor, Frame parentFrame, CodeFrame<? extends CodeElement> codeParentFrame, FrameContentRow row, String stylePrefix) {
        this.editor = editor;
        this.parentFrame = parentFrame;
        this.codeParentFrame = codeParentFrame;
        if (parentFrame != codeParentFrame) {
            throw new IllegalArgumentException("codeFrame and codeParentFrame should be identical");
        }
        this.row = row;
        this.stylePrefix = stylePrefix;
        this.params = FXCollections.observableArrayList();
        this.open.getStyleClass().add((Object)"bracket-label");
        this.spacer = new SlotLabel(" ", new String[0]);
        JavaFXUtil.addStyleClass(this.spacer, "param-spacer");
        this.spacer.setOpacity(0.0);
        this.spacer.setCursor(Cursor.TEXT);
        this.spacer.setOnMouseClicked((EventHandler<? super MouseEvent>)((EventHandler)e -> {
            if (this.normalView) {
                this.addNewAfter(null).requestFocus(Focus.LEFT);
                e.consume();
            }
        }));
        this.close.getStyleClass().add((Object)"bracket-label");
    }

    public FormalParameter findFormal(HeaderItem slot) {
        return this.params.stream().filter(p -> p.getType() == slot || p.getName() == slot).findFirst().orElse(null);
    }

    private FormalParameter createFormal(TypeSlotFragment type, NameDefSlotFragment name) {
        SimpleBooleanProperty freshProperty = new SimpleBooleanProperty(true);
        Runnable checkStillFocused = () -> this.lambda$createFormal$711((BooleanProperty)freshProperty);
        TypeTextSlot typeSlot = new TypeTextSlot(this.editor, this.parentFrame, this.codeParentFrame, this.row, new TypeCompletionCalculator(this.editor), this.stylePrefix, (BooleanProperty)freshProperty, checkStillFocused){
            final /* synthetic */ BooleanProperty val$freshProperty;
            final /* synthetic */ Runnable val$checkStillFocused;
            {
                this.val$freshProperty = booleanProperty;
                this.val$checkStillFocused = runnable;
                super(editor, frameParent, codeFrameParent, row, completionCalculator, stylePrefix);
            }

            @Override
            protected BooleanExpression getFreshExtra(CodeError err) {
                if (err instanceof EmptyError) {
                    return this.val$freshProperty;
                }
                return super.getFreshExtra(err);
            }

            @Override
            public void lostFocus() {
                super.lostFocus();
                if (this.val$freshProperty.get()) {
                    Platform.runLater((Runnable)this.val$checkStillFocused);
                }
            }
        };
        VariableNameDefTextSlot nameSlot = new VariableNameDefTextSlot(this.editor, this.parentFrame, this.codeParentFrame, this.row, this.stylePrefix, (BooleanProperty)freshProperty, checkStillFocused){
            final /* synthetic */ BooleanProperty val$freshProperty;
            final /* synthetic */ Runnable val$checkStillFocused;
            {
                this.val$freshProperty = booleanProperty;
                this.val$checkStillFocused = runnable;
                super(editor, frameParent, codeFrameParent, row, stylePrefix);
            }

            @Override
            protected BooleanExpression getFreshExtra(CodeError err) {
                if (err instanceof EmptyError) {
                    return this.val$freshProperty;
                }
                return super.getFreshExtra(err);
            }

            @Override
            public void lostFocus() {
                super.lostFocus();
                if (this.val$freshProperty.get()) {
                    Platform.runLater((Runnable)this.val$checkStillFocused);
                }
            }
        };
        TextSlot<TypeSlotFragment> paramType = this.initialiseTextSlot("paramType", type, true, typeSlot);
        TextSlot<NameDefSlotFragment> paramName = this.initialiseTextSlot("paramName", name, false, nameSlot);
        return new FormalParameter(paramType, paramName);
    }

    private <F extends TextSlotFragment> TextSlot<F> initialiseTextSlot(String promptText, F value, final boolean isType, final TextSlot<F> textSlot) {
        textSlot.setPromptText(promptText);
        textSlot.setText(value);
        textSlot.addValueListener(new SlotValueListener(){

            @Override
            public boolean valueChanged(HeaderItem slot, String oldValue, String newValue, FocusParent<HeaderItem> parent) {
                if (newValue.contains(",")) {
                    if (isType) {
                        if (FormalParameters.this.findFormal(slot).getName().isFocused()) {
                            Platform.runLater(() -> FormalParameters.this.addNewAfter(FormalParameters.this.findFormal(slot)).requestFocus(Focus.LEFT));
                        } else if (FormalParameters.this.findFormal(slot).getType().isFocused()) {
                            Platform.runLater(() -> FormalParameters.this.addNewBefore(FormalParameters.this.findFormal(slot)).requestFocus(Focus.LEFT));
                        }
                    } else {
                        Platform.runLater(() -> FormalParameters.this.addNewAfter(FormalParameters.this.findFormal(slot)).requestFocus(Focus.LEFT));
                    }
                    return false;
                }
                if (newValue.contains(")")) {
                    if (!isType && newValue.endsWith(")")) {
                        parent.focusRight(textSlot);
                    }
                    return false;
                }
                return true;
            }

            @Override
            public void backSpacePressedAtStart(HeaderItem slot) {
                FormalParameters.this.backSpacePressedAtStart(slot);
            }

            @Override
            public void deletePressedAtEnd(HeaderItem slot) {
                FormalParameters.this.deletePressedAtEnd(slot);
            }
        });
        textSlot.addFocusListener(this.parentFrame);
        textSlot.addValueListener(SlotTraversalChars.IDENTIFIER);
        return textSlot;
    }

    public void addFormal(TypeSlotFragment type, NameDefSlotFragment name) {
        this.params.add((Object)this.createFormal(type, name));
    }

    private FormalParameter addNewBefore(FormalParameter before) {
        return this.insertBefore(before, this.createFormal(new TypeSlotFragment(""), new NameDefSlotFragment("")));
    }

    private FormalParameter addNewAfter(FormalParameter after) {
        return this.insertAfter(after, this.createFormal(new TypeSlotFragment(""), new NameDefSlotFragment("")));
    }

    private FormalParameter insertBefore(FormalParameter before, FormalParameter slot) {
        this.params.add(before == null ? 0 : this.params.indexOf((Object)before), (Object)slot);
        this.editor.modifiedFrame(this.parentFrame);
        return slot;
    }

    private FormalParameter insertAfter(FormalParameter after, FormalParameter slot) {
        this.params.add(after == null ? 0 : this.params.indexOf((Object)after) + 1, (Object)slot);
        this.editor.modifiedFrame(this.parentFrame);
        return slot;
    }

    public boolean ensureAtLeastOneParameter() {
        if (this.params.isEmpty()) {
            this.addNewAfter(null);
            return true;
        }
        return false;
    }

    private void backSpacePressedAtStart(HeaderItem slot) {
        FormalParameter formal = this.findFormal(slot);
        if (formal.getType() == slot) {
            int index = this.params.indexOf((Object)formal);
            if (index == 0) {
                this.row.focusLeft(formal.getType());
            } else if (formal.getName().isAlmostBlank() && formal.getType().isAlmostBlank()) {
                this.deleteFormal(formal);
                ((FormalParameter)this.params.get(index - 1)).getName().requestFocus(Focus.RIGHT);
            } else {
                this.deleteFormal((FormalParameter)this.params.get(index - 1));
            }
        } else {
            formal.getType().requestFocus(Focus.RIGHT);
        }
    }

    private void deletePressedAtEnd(HeaderItem slot) {
        int index;
        FormalParameter formal = this.findFormal(slot);
        if (formal.getType() != slot && (index = this.params.indexOf((Object)formal)) < this.params.size() - 1) {
            this.deleteFormal((FormalParameter)this.params.get(index + 1));
        }
    }

    private void deleteFormal(FormalParameter param) {
        param.cleanup();
        this.params.remove((Object)param);
        this.editor.modifiedFrame(this.parentFrame);
    }

    public void checkForEmptySlot() {
        if (this.params.size() == 1 && ((FormalParameter)this.params.get(0)).isEmpty() && !((FormalParameter)this.params.get(0)).isFocused()) {
            this.deleteFormal((FormalParameter)this.params.get(0));
        }
    }

    public ObservableList<HeaderItem> getSlots() {
        if (this.boundSlots == null) {
            this.boundSlots = FXCollections.observableArrayList();
            ConcatMapListBinding.bind(this.boundSlots, this.params, FormalParameter::getSlots);
            DeepListBinding<HeaderItem> binding = new DeepListBinding<HeaderItem>(this.boundSlots){
                {
                    FormalParameters.this.updateSlots = this::update;
                }

                @Override
                protected Stream<ObservableList<?>> getListenTargets() {
                    return Stream.concat(Stream.of(FormalParameters.this.params), FormalParameters.this.params.stream().map(FormalParameter::getSlots));
                }

                @Override
                protected Stream<HeaderItem> calculateValues() {
                    ArrayList<ObservableList> commas = new ArrayList<ObservableList>();
                    for (int i = 0; i < FormalParameters.this.params.size() - 1; ++i) {
                        SlotLabel comma = new SlotLabel(", ", new String[0]);
                        JavaFXUtil.addStyleClass(comma, "formal-comma");
                        commas.add(FXCollections.observableArrayList((Object[])new HeaderItem[]{comma}));
                    }
                    Stream<SlotLabel> start = FormalParameters.this.params.size() == 0 ? Stream.of(FormalParameters.this.open, FormalParameters.this.spacer) : Stream.of(FormalParameters.this.open);
                    return Utility.concat(start, Utility.interleave(FormalParameters.this.params.stream().map(FormalParameter::getSlots), commas.stream()).flatMap(Collection::stream), Stream.of(FormalParameters.this.close));
                }
            };
            binding.startListening();
        }
        return this.boundSlots;
    }

    public boolean isEmpty() {
        return this.params.isEmpty();
    }

    public void escape(HeaderItem src) {
        if (this.params.size() == 1 && ((FormalParameter)this.params.get(0)).isEmpty()) {
            this.row.focusDown(src);
        }
    }

    public void focusBeginning() {
        if (!this.params.isEmpty()) {
            ((FormalParameter)this.params.get(0)).requestFocus(Focus.LEFT);
        }
    }

    public List<ParamFragment> getSlotElement() {
        return Utility.mapList(this.params, FormalParameter::getSlotElement);
    }

    public void deleteFirstParam() {
        if (this.params.size() > 0) {
            this.params.remove(0);
        }
    }

    public <T> void setParams(List<T> src, Function<T, String> getType, Function<T, String> getName) {
        this.params.setAll(Utility.mapList(src, x -> this.createFormal(new TypeSlotFragment((String)getType.apply(x)), new NameDefSlotFragment((String)getName.apply(x)))));
    }

    public Stream<String> getVars() {
        return this.params.stream().map(FormalParameter::getName).map(TextSlot::getText);
    }

    public void setView(Frame.View view, SharedTransition animate) {
        boolean bl = this.normalView = view == Frame.View.NORMAL;
        if (this.updateSlots != null) {
            this.updateSlots.run();
        }
    }

    private /* synthetic */ void lambda$createFormal$711(BooleanProperty freshProperty) {
        freshProperty.set(freshProperty.get() && this.params.stream().anyMatch(p -> p.isFocused()));
    }

    private class FormalParameter {
        private final TextSlot<TypeSlotFragment> type;
        private final TextSlot<NameDefSlotFragment> name;

        protected FormalParameter(TextSlot<TypeSlotFragment> type, TextSlot<NameDefSlotFragment> name) {
            this.type = type;
            this.name = name;
        }

        public void cleanup() {
            this.type.cleanup();
            this.name.cleanup();
        }

        public TextSlot<TypeSlotFragment> getType() {
            return this.type;
        }

        public TextSlot<NameDefSlotFragment> getName() {
            return this.name;
        }

        public ParamFragment getSlotElement() {
            return new ParamFragment((TypeSlotFragment)this.type.getSlotElement(), (NameDefSlotFragment)this.name.getSlotElement());
        }

        public boolean isEmpty() {
            return this.type.isEmpty() && this.name.isEmpty();
        }

        public boolean isFocused() {
            return this.getType().isFocused() || this.getName().isFocused();
        }

        public void requestFocus(Focus on) {
            if (on == Focus.LEFT) {
                this.type.requestFocus(on);
            } else if (on == Focus.RIGHT) {
                this.name.requestFocus(on);
            } else if (on == Focus.SELECT_ALL) {
                Debug.message("Focus.SELECT_ALL in PairParameterSlot::requestFocus is not implemented");
            }
        }

        public ObservableList<HeaderItem> getSlots() {
            return FXCollections.observableArrayList((Object[])new HeaderItem[]{this.type, this.name});
        }
    }
}

