/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.operations;

import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCursor;
import bluej.stride.generic.InteractionManager;
import bluej.stride.generic.RecallableFocus;
import bluej.stride.operations.AbstractOperation;
import bluej.stride.slots.EditableSlot;
import java.util.Collections;
import java.util.List;
import javafx.application.Platform;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.MenuItem;
import javafx.scene.input.KeyCombination;

public abstract class FrameOperation
extends AbstractOperation {
    private KeyCombination shortcut;

    public FrameOperation(InteractionManager editor, String identifier, AbstractOperation.Combine combine) {
        this(editor, identifier, combine, null);
    }

    public FrameOperation(InteractionManager editor, String identifier, AbstractOperation.Combine combine, KeyCombination shortcut) {
        super(editor, identifier, combine);
        this.shortcut = shortcut;
    }

    protected void enablePreview() {
    }

    protected void disablePreview() {
    }

    public void onMenuShowing(CustomMenuItem item) {
    }

    public void onMenuHidden(CustomMenuItem item) {
    }

    public void activate(Frame frame) {
        this.activate(Collections.singletonList(frame));
    }

    public void activate(Frame frame, RecallableFocus focus) {
        this.activate(Collections.singletonList(frame), focus);
    }

    public void activate(List<Frame> frames) {
        Frame first = this.editor.getSelection().getSelected().isEmpty() ? null : (Frame)this.editor.getSelection().getSelected().get(0);
        FrameCursor focus = first == null ? null : first.getCursorBefore();
        this.activate(frames, (RecallableFocus)focus);
    }

    public void activate(List<Frame> frames, RecallableFocus focus) {
        this.editor.beginRecordingState(focus);
        this.disablePreview();
        this.execute(frames);
        this.editor.endRecordingState(focus);
    }

    protected abstract void execute(List<Frame> var1);

    public boolean onlyOnContextMenu() {
        return false;
    }

    public EditableSlot.SortedMenuItem getMenuItem(boolean contextMenu) {
        MenuItem item;
        if (contextMenu) {
            CustomMenuItem customItem = this.initializeCustomItem();
            customItem.getContent().setOnMouseEntered(e -> this.enablePreview());
            customItem.getContent().setOnMouseExited(e -> this.disablePreview());
            item = customItem;
        } else {
            item = this.initializeNormalItem();
        }
        item.setOnAction(e -> Platform.runLater(() -> {
            this.activate(this.editor.getSelection().getSelected());
            e.consume();
        }));
        if (this.shortcut != null) {
            item.setAccelerator(this.shortcut);
        }
        return this.getLabels().get(0).getOrder().item(item);
    }
}

