/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.generic;

import bluej.stride.framedjava.frames.GreenfootFrameDictionary;
import bluej.stride.generic.CanvasParent;
import bluej.stride.generic.ExtensionDescription;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCanvas;
import bluej.stride.generic.FrameContentItem;
import bluej.stride.generic.FrameCursor;
import bluej.stride.generic.FrameTypeCheck;
import bluej.stride.generic.InteractionManager;
import bluej.stride.generic.Sidebar;
import bluej.utility.javafx.FXConsumer;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.SharedTransition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.binding.DoubleExpression;
import javafx.geometry.Bounds;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.effect.BlendMode;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public abstract class SingleCanvasFrame
extends Frame
implements CanvasParent {
    protected FrameCanvas canvas;
    private Sidebar sidebar;
    private boolean collapsible = false;
    private boolean collapsed = false;
    private PlusMinus collapsedIndicator;

    protected SingleCanvasFrame(InteractionManager editor, String caption, String stylePrefix) {
        super(editor, caption, stylePrefix);
        this.canvas = this.createCanvas(editor, stylePrefix);
        this.sidebar = Sidebar.addSidebar(editor, this.getSidebarContainer(), (Observable)this.getNode().layoutBoundsProperty(), stylePrefix);
        this.contents.setAll((Object[])new FrameContentItem[]{this.getHeaderRow(), this.canvas});
    }

    protected void setCollapsible(boolean collapsible) {
        if (collapsible != this.collapsible) {
            if (collapsible) {
                this.collapsedIndicator = new PlusMinus();
                this.collapsedIndicator.setCursor(Cursor.HAND);
                this.collapsedIndicator.setOnMouseClicked(e -> {
                    this.setCollapsed(!this.collapsed);
                    e.consume();
                });
                this.collapsedIndicator.setOnMouseEntered(e -> {
                    if (this.collapsed) {
                        this.collapsedIndicator.drawPlus(true);
                    } else {
                        this.collapsedIndicator.drawMinus(true);
                    }
                });
                this.collapsedIndicator.setOnMouseExited(e -> {
                    if (this.collapsed) {
                        this.collapsedIndicator.drawPlus(false);
                    } else {
                        this.collapsedIndicator.drawMinus(false);
                    }
                });
                this.addTopRight((Node)this.collapsedIndicator);
            }
            this.collapsible = collapsible;
        }
    }

    @Override
    public boolean isCollapsible() {
        return this.collapsible;
    }

    @Override
    public void setCollapsed(boolean collapse) {
        if (collapse && !this.collapsible) {
            return;
        }
        if (collapse != this.collapsed) {
            if (collapse) {
                this.collapsedIndicator.drawPlus(false);
            } else {
                this.collapsedIndicator.drawMinus(false);
            }
            this.collapsed = collapse;
        }
    }

    public void dissolve() {
        this.expandContents();
        this.getParentCanvas().removeBlock(this);
    }

    public void expandContents() {
        FrameCanvas p = this.getParentCanvas();
        this.canvas.emptyTo(p, this);
    }

    public FrameCanvas getCanvas() {
        return this.canvas;
    }

    protected FXConsumer<String> updateSidebarCurried(String prefix) {
        return content -> this.sidebar.textProperty().set((Object)(prefix + "(" + content + ")"));
    }

    protected void setSidebar(String content) {
        this.sidebar.setText(content);
    }

    @Override
    public double lowestCursorY() {
        Bounds canvasBounds = this.canvas.getSceneBounds();
        return canvasBounds.getMaxY() + this.canvas.getBottomMargin();
    }

    protected FrameCanvas createCanvas(InteractionManager editor, String stylePrefix) {
        return new FrameCanvas(editor, this, stylePrefix);
    }

    @Override
    public List<ExtensionDescription> getAvailableInnerExtensions(FrameCanvas canvas, FrameCursor cursor) {
        return Collections.emptyList();
    }

    @Override
    public Frame getFrame() {
        return this;
    }

    @Override
    public void setView(Frame.View oldView, Frame.View newView, SharedTransition animateProgress) {
        super.setView(oldView, newView, animateProgress);
        JavaFXUtil.setPseudoclass("bj-java-preview", newView == Frame.View.JAVA_PREVIEW, this.sidebar.getStyleable());
        this.canvas.getCursors().forEach(c -> c.setView(newView, animateProgress));
        if (this.isFrameEnabled() && (oldView == Frame.View.JAVA_PREVIEW || newView == Frame.View.JAVA_PREVIEW)) {
            this.canvas.previewCurly(newView == Frame.View.JAVA_PREVIEW, this.header.getLeftFirstItem() + this.tweakCurlyX(), this.tweakOpeningCurlyY(), animateProgress);
        }
        this.canvas.setView(oldView, newView, animateProgress);
    }

    protected DoubleExpression tweakOpeningCurlyY() {
        return null;
    }

    protected double tweakCurlyX() {
        return 0.0;
    }

    @Override
    protected List<? extends Node> calculateContents(List<Node> normalContent) {
        ArrayList<? extends Node> content = new ArrayList<Node>(super.calculateContents(normalContent));
        if (this.sidebar != null) {
            content.add(0, (Node)this.sidebar.getNode());
        }
        return content;
    }

    @Override
    public FrameTypeCheck check(FrameCanvas child) {
        if (child == this.canvas) {
            return GreenfootFrameDictionary.checkStatement();
        }
        throw new IllegalStateException("Asking about unknown child of SingleCanvasFrame");
    }

    private static class PlusMinus
    extends Canvas {
        private static final double DIAMETER = 15.0;
        private static final double BAR_WIDTH = 2.0;

        public PlusMinus() {
            this.setWidth(20.0);
            this.setHeight(15.0);
            this.drawPlus(false);
        }

        public void drawPlus(boolean light) {
            this.drawMinus(light);
            GraphicsContext gc = this.getGraphicsContext2D();
            gc.clearRect(6.5, 0.0, 2.0, 15.0);
        }

        public void drawMinus(boolean light) {
            GraphicsContext gc = this.getGraphicsContext2D();
            gc.clearRect(0.0, 0.0, this.getWidth(), this.getHeight());
            gc.setGlobalBlendMode(BlendMode.SRC_OVER);
            gc.setFill((Paint)Color.rgb((int)0, (int)0, (int)0, (double)(light ? 0.1 : 0.2)));
            gc.fillOval(0.0, 0.0, 15.0, 15.0);
            gc.clearRect(0.0, 6.5, 15.0, 2.0);
        }
    }
}

