/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.generic;

import bluej.stride.generic.CanvasParent;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCanvas;
import bluej.stride.generic.FrameContentItem;
import bluej.stride.generic.InteractionManager;
import bluej.stride.generic.Sidebar;
import bluej.stride.operations.FrameOperation;
import bluej.stride.operations.PullUpContentsOperation;
import bluej.utility.javafx.FXConsumer;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.SharedTransition;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.Observable;
import javafx.geometry.Bounds;
import javafx.scene.Node;

public abstract class MultiCanvasFrame
extends Frame
implements CanvasParent {
    protected final List<FrameCanvas> canvases = new ArrayList<FrameCanvas>();
    protected final List<FrameContentItem> dividers = new ArrayList<FrameContentItem>();
    private final Sidebar sidebar;

    protected MultiCanvasFrame(InteractionManager editor, String caption, String stylePrefix) {
        super(editor, caption, stylePrefix);
        this.sidebar = Sidebar.addSidebar(editor, this.getSidebarContainer(), (Observable)this.getNode().layoutBoundsProperty(), stylePrefix);
    }

    protected void addCanvas(FrameContentItem divider, FrameCanvas canvas, int at) {
        this.canvases.add(at, canvas);
        this.dividers.add(at, divider);
        this.updateDisplay();
    }

    protected void addCanvas(FrameContentItem divider, FrameCanvas canvas) {
        this.addCanvas(divider, canvas, this.canvases.size());
    }

    protected void removeCanvas(FrameCanvas canvas) {
        int index = this.canvases.indexOf(canvas);
        this.dividers.remove(index);
        this.canvases.remove(index);
        this.updateDisplay();
    }

    private void updateDisplay() {
        ArrayList<FrameContentItem> updatedChildren = new ArrayList<FrameContentItem>();
        updatedChildren.add(this.header);
        for (int i = 0; i < this.canvases.size(); ++i) {
            if (this.dividers.get(i) != null) {
                updatedChildren.add(this.dividers.get(i));
            }
            updatedChildren.add(this.canvases.get(i));
            this.canvases.get(i).setLastInMulti(i == this.canvases.size() - 1);
        }
        this.modifyChildren(updatedChildren);
        this.contents.setAll(updatedChildren);
    }

    protected void modifyChildren(List<FrameContentItem> updatedChildren) {
    }

    @Override
    public List<FrameOperation> getContextOperations() {
        List<FrameOperation> r = super.getContextOperations();
        r.add(new PullUpContentsOperation(this.getEditor()));
        return r;
    }

    protected final FrameCanvas getLastCanvas() {
        return this.canvases.get(this.canvases.size() - 1);
    }

    @Override
    public double lowestCursorY() {
        Bounds canvasBounds = this.getLastCanvas().getSceneBounds();
        return canvasBounds.getMaxY() + this.getLastCanvas().getBottomMargin();
    }

    protected FXConsumer<String> updateSidebarCurried(String prefix) {
        return content -> this.sidebar.textProperty().set((Object)(prefix + "(" + content + ")"));
    }

    @Override
    public void setView(Frame.View oldView, Frame.View newView, SharedTransition animate) {
        super.setView(oldView, newView, animate);
        JavaFXUtil.setPseudoclass("bj-java-preview", newView == Frame.View.JAVA_PREVIEW, this.sidebar.getStyleable());
        this.getCanvases().forEach(c -> {
            c.getCursors().forEach(cur -> cur.setView(newView, animate));
            if (this.isFrameEnabled() && (oldView == Frame.View.JAVA_PREVIEW || newView == Frame.View.JAVA_PREVIEW)) {
                c.previewCurly(newView == Frame.View.JAVA_PREVIEW, this.header.getLeftFirstItem(), null, animate);
            }
            c.setView(oldView, newView, animate);
        });
    }

    @Override
    protected List<? extends Node> calculateContents(List<Node> normalContent) {
        ArrayList<? extends Node> content = new ArrayList<Node>(super.calculateContents(normalContent));
        if (this.sidebar != null) {
            content.add(0, (Node)this.sidebar.getNode());
        }
        return content;
    }

    @Override
    public Frame getFrame() {
        return this;
    }
}

