/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.generic;

import bluej.editor.stride.FrameEditorTab;
import bluej.stride.framedjava.ast.Loader;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.frames.CodeFrame;
import bluej.stride.framedjava.frames.GreenfootFrameCategory;
import bluej.stride.framedjava.frames.GreenfootFrameDictionary;
import bluej.stride.framedjava.frames.NormalMethodFrame;
import bluej.stride.framedjava.frames.VarFrame;
import bluej.stride.generic.CanvasParent;
import bluej.stride.generic.ExtensionDescription;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCanvas;
import bluej.stride.generic.FrameDictionary;
import bluej.stride.generic.FrameTypeCheck;
import bluej.stride.generic.InteractionManager;
import bluej.stride.generic.RecallableFocus;
import bluej.stride.operations.PasteFrameOperation;
import bluej.stride.slots.EditableSlot;
import bluej.utility.Debug;
import bluej.utility.Utility;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.SharedTransition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.binding.NumberExpressionBase;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;

public class FrameCursor
implements RecallableFocus {
    public static final int FULL_HEIGHT = 5;
    public static final int HIDE_HEIGHT = 0;
    final int ERROR_COUNT_TRIGGER = 2;
    int consecutiveErrors = 0;
    private ContextMenu menu;
    private final FrameCanvas parentCanvas;
    private final Button node = new Button();
    private static final Map<InteractionManager, TotalHeightBinding> shrinkingHeightBindings = new IdentityHashMap<InteractionManager, TotalHeightBinding>();
    private final InteractionManager editor;
    private Timeline animation;
    private Canvas redCross;
    private Canvas copyingPlus;
    private ImageView dragTargetOverlayFake;

    public boolean keyTyped(FrameEditorTab editor, FrameCanvas parentCanvas, char key, boolean viaRedirect) {
        if (!editor.isEditable() || !this.canInsert()) {
            return false;
        }
        if ((key = Character.toLowerCase(key)) == '?') {
            editor.cheatSheetShowingProperty().set(!editor.cheatSheetShowingProperty().get());
            return true;
        }
        if (Character.isLetter(key) || Arrays.asList(Character.valueOf('/'), Character.valueOf('\\'), Character.valueOf('*'), Character.valueOf('='), Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('\n'), Character.valueOf(' ')).contains(Character.valueOf(key))) {
            boolean selection;
            List available = editor.getDictionary().getFramesForShortcutKey(key).stream().filter(t -> parentCanvas.getParent().check(parentCanvas).canInsert((GreenfootFrameCategory)((Object)((Object)t.getCategory())))).collect(Collectors.toList());
            boolean bl = selection = !editor.getSelection().getSelected().isEmpty();
            if (selection) {
                List<Frame> nonIgnoredFrames;
                List targets = editor.getSelection().getSelected();
                if (targets.size() == 1) {
                    for (ExtensionDescription extension : ((Frame)targets.get(0)).getAvailableExtensions()) {
                        if (extension.getShortcutKey() != key) continue;
                        extension.activate();
                        return true;
                    }
                }
                if (key == '\\') {
                    boolean allDisabled = targets.stream().filter(f -> f.canHaveEnabledState(false)).allMatch(f -> !f.isFrameEnabled());
                    editor.beginRecordingState((RecallableFocus)this);
                    targets.stream().filter(f -> f.canHaveEnabledState(allDisabled)).forEach(t -> t.setFrameEnabled(allDisabled));
                    editor.endRecordingState((RecallableFocus)this);
                    return true;
                }
                if (key == 'n') {
                    nonIgnoredFrames = targets.stream().filter(f -> f.isEffectiveFrame()).collect(Collectors.toList());
                    if (nonIgnoredFrames.stream().allMatch(f -> f instanceof VarFrame)) {
                        new VarFrame.ToggleFinalVar((InteractionManager)editor).activate(nonIgnoredFrames);
                        return true;
                    }
                    if (nonIgnoredFrames.stream().allMatch(f -> f instanceof NormalMethodFrame)) {
                        new NormalMethodFrame.ToggleFinalMethod((InteractionManager)editor).activate(nonIgnoredFrames);
                        return true;
                    }
                }
                if (key == 's') {
                    nonIgnoredFrames = targets.stream().filter(f -> f.isEffectiveFrame()).collect(Collectors.toList());
                    if (nonIgnoredFrames.stream().allMatch(f -> f instanceof VarFrame && ((VarFrame)f).isField(this.getParentCanvas()))) {
                        new VarFrame.ToggleStaticVar((InteractionManager)editor).activate(nonIgnoredFrames);
                        return true;
                    }
                    if (nonIgnoredFrames.stream().allMatch(f -> f instanceof NormalMethodFrame)) {
                        new NormalMethodFrame.ToggleStaticMethod((InteractionManager)editor).activate(nonIgnoredFrames);
                        return true;
                    }
                }
            }
            if (!selection) {
                Frame before = this.getFrameBefore();
                if (CanvasParent.processInnerExtensionKey(this.getParentCanvas().getParent(), this.getParentCanvas(), this, key, this, before == null)) {
                    return true;
                }
                if (this.getFrameAfter() != null && this.getFrameAfter().notifyPrefixKey(key, this)) {
                    return true;
                }
                if (before != null && before.notifyExtensionKey(key, this)) {
                    return true;
                }
            }
            if (available.size() > 1) {
                throw new IllegalStateException("Ambigious keypress: " + key + " in frame: " + parentCanvas.getParent());
            }
            if (available.size() == 1) {
                FrameDictionary.Entry frameType = (FrameDictionary.Entry)available.get(0);
                if (!selection || frameType.validOnSelection()) {
                    Frame newFrame;
                    editor.beginRecordingState((RecallableFocus)this);
                    this.disappear();
                    if (selection) {
                        List selected = editor.getSelection().getSelected();
                        List<Frame> selectedCopy = Utility.mapList(selected, f -> Loader.loadElement(((CodeElement)((CodeFrame)((Object)f)).getCode()).toXML()).createFrame((InteractionManager)editor));
                        newFrame = frameType.getFactory().createBlock((InteractionManager)editor, selectedCopy);
                        this.insertBlockBefore(newFrame);
                        selected.forEach(f -> f.getParentCanvas().removeBlock((Frame)f));
                        editor.getSelection().clear();
                    } else {
                        newFrame = frameType.getFactory().createBlock((InteractionManager)editor);
                        this.insertBlockBefore(newFrame);
                    }
                    editor.modifiedFrame(newFrame);
                    newFrame.markFresh();
                    if (viaRedirect) {
                        editor.scrollTo((Node)this.getNode(), -20.0, Duration.millis((double)2000.0));
                    }
                    if (!newFrame.focusWhenJustAdded()) {
                        this.appear();
                        editor.updateCatalog(this);
                    }
                    editor.endRecordingState(null);
                    this.consecutiveErrors = 0;
                    return true;
                }
            } else {
                ++this.consecutiveErrors;
                if (this.consecutiveErrors >= 2) {
                    editor.cheatSheetShowingProperty().set(true);
                }
                return true;
            }
        }
        editor.getSelection().clear();
        return false;
    }

    public static void editorClosing(InteractionManager editor) {
        shrinkingHeightBindings.remove(editor);
    }

    public FrameCursor(FrameEditorTab editor, FrameCanvas parentCanvas) {
        this.node.getStyleClass().add((Object)"frame-cursor");
        this.node.setMaxWidth(100.0);
        this.node.setMaxHeight(0.0);
        this.node.setOpacity(0.0);
        this.parentCanvas = parentCanvas;
        if (parentCanvas == null) {
            throw new IllegalArgumentException("BlockCursor: parentCanvas cannot be null");
        }
        this.editor = editor;
        if (editor != null) {
            shrinkingHeightBindings.putIfAbsent((InteractionManager)editor, new TotalHeightBinding());
        }
        this.node.minWidthProperty().bind((ObservableValue)this.node.maxWidthProperty());
        this.node.prefWidthProperty().bind((ObservableValue)this.node.maxWidthProperty());
        this.node.minHeightProperty().bind((ObservableValue)this.node.maxHeightProperty());
        this.node.prefHeightProperty().bind((ObservableValue)this.node.maxHeightProperty());
        shrinkingHeightBindings.get(editor).shrink(this, 0.0, false);
        JavaFXUtil.addChangeListener(this.node.focusedProperty(), nowFocused -> this.animateShowHide((boolean)nowFocused, true));
        JavaFXUtil.addChangeListener(this.node.localToSceneTransformProperty(), t -> this.adjustDragTargetPosition());
        if (editor != null) {
            editor.setupFrameCursor(this);
        }
        this.node.addEventFilter(MouseEvent.MOUSE_PRESSED, e -> {
            if (e.getButton() == MouseButton.PRIMARY && editor != null && !this.isFocused()) {
                editor.clickNearestCursor(e.getSceneX(), e.getSceneY(), e.isShiftDown());
                e.consume();
            }
        });
        JavaFXUtil.listenForContextMenu((Node)this.node, this::showContextMenu);
        this.getNode().focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean nowFocused) {
                if (!nowFocused.booleanValue()) {
                    FrameCursor.this.consecutiveErrors = 0;
                }
            }
        });
        this.getNode().setOnKeyTyped(event -> {
            try {
                String character = event.getCharacter();
                if (!character.isEmpty()) {
                    char key = character.toCharArray()[0];
                    if (!event.isShortcutDown() && this.keyTyped(editor, parentCanvas, key, false)) {
                        event.consume();
                    }
                }
            }
            catch (Exception ex) {
                Debug.reportError("CURSOR KEY PRESS: ", ex);
            }
        });
        this.getNode().setOnKeyPressed(event -> {
            if (!editor.isEditable()) {
                return;
            }
            if (!(event.getCode() != KeyCode.BACK_SPACE && event.getCode() != KeyCode.DELETE || editor.getSelection().getSelected().isEmpty())) {
                List toDelete = editor.getSelection().getSelected();
                FrameCursor focusAfter = ((Frame)toDelete.get(0)).getCursorBefore();
                if (toDelete.stream().allMatch(f -> f.getParentCanvas() == this.getParentCanvas())) {
                    FrameCanvas c = this.getParentCanvas();
                    toDelete.forEach(f -> c.removeBlock((Frame)f));
                } else {
                    Debug.message("Warning: trying to delete selection from remote cursor");
                }
                editor.getSelection().clear();
                focusAfter.requestFocus();
                editor.updateCatalog(focusAfter);
                event.consume();
                return;
            }
            if (event.getCode() == KeyCode.BACK_SPACE) {
                Frame target = parentCanvas.getFrameBefore(this);
                if (target != null) {
                    editor.beginRecordingState((RecallableFocus)this);
                    FrameCursor cursorBeforeTarget = parentCanvas.getCursorBefore(target);
                    parentCanvas.removeBlock(target);
                    editor.modifiedFrame(target);
                    cursorBeforeTarget.requestFocus();
                    editor.endRecordingState((RecallableFocus)cursorBeforeTarget);
                } else {
                    editor.beginRecordingState((RecallableFocus)this);
                    FrameCursor cursorBeforeTarget = parentCanvas.getParent().getCursorBefore(parentCanvas);
                    CanvasParent.processInnerExtensionKey(parentCanvas.getParent(), parentCanvas, this, '\b', this, true);
                    editor.endRecordingState((RecallableFocus)cursorBeforeTarget);
                }
            } else if (event.getCode() == KeyCode.ESCAPE) {
                Frame target = parentCanvas.getFrameBefore(this);
                if (target != null) {
                    target.escape(null, null);
                } else {
                    Frame BeforeTarget = parentCanvas.getParent().getCursorBefore(parentCanvas).getFrameAfter();
                    if (BeforeTarget != null) {
                        BeforeTarget.escape(null, null);
                    }
                }
            } else if (event.getCode() == KeyCode.DELETE) {
                Frame target = parentCanvas.getFrameAfter(this);
                if (target != null) {
                    editor.beginRecordingState((RecallableFocus)this);
                    parentCanvas.removeBlock(target);
                    editor.modifiedFrame(target);
                    editor.endRecordingState((RecallableFocus)this);
                }
            } else if (event.getCode() == KeyCode.ENTER) {
                this.keyTyped(editor, parentCanvas, '\n', false);
            }
        });
    }

    private void animateShowHide(boolean show, boolean animate) {
        if (this.animation != null) {
            this.animation.stop();
        }
        this.node.setOpacity(show ? 1.0 : 0.0);
        if (this.getParentCanvas().blockCount() == 0) {
            this.node.maxHeightProperty().unbind();
            this.node.setMaxHeight(show ? 5.0 : 0.0);
        } else if (show) {
            shrinkingHeightBindings.get(this.editor).grow(this, 5, animate);
        } else {
            shrinkingHeightBindings.get(this.editor).shrink(this, 0.0, animate);
        }
    }

    public void showAsDropTarget(boolean showAsSource, boolean dragPossible, boolean copying) {
        int chosen = dragPossible ? (showAsSource ? 1 : 0) : 2;
        this.animateShowHide(true, false);
        this.setDragClass(chosen);
        this.updateDragCopyState(copying);
    }

    private void setDragClass(int classIndex) {
        JavaFXUtil.selectPseudoClass((Node)this.node, classIndex, "bj-drag-possible", "bj-drag-source", "bj-drag-impossible");
        this.setDragTargetOverlayVisible(classIndex != -1, classIndex == 2);
    }

    private void adjustDragTargetPosition() {
        if (this.dragTargetOverlayFake != null) {
            Pane dragTargetCursorPane = this.editor.getDragTargetCursorPane();
            Bounds scenePos = this.getNode().localToScene(this.getNode().getBoundsInLocal());
            Bounds panePos = dragTargetCursorPane.sceneToLocal(scenePos);
            this.dragTargetOverlayFake.setLayoutX(panePos.getMinX());
            this.dragTargetOverlayFake.setLayoutY(panePos.getMinY());
            if (this.redCross != null) {
                this.redCross.setLayoutX(this.dragTargetOverlayFake.getLayoutX() + this.node.widthProperty().divide(2.0).subtract(this.redCross.getWidth() / 2.0).get());
                this.redCross.setLayoutY(this.dragTargetOverlayFake.getLayoutY() + this.node.heightProperty().divide(2.0).subtract(this.redCross.getHeight() / 2.0).get());
            }
            if (this.copyingPlus != null) {
                this.copyingPlus.setLayoutX(this.dragTargetOverlayFake.getLayoutX() + this.node.getWidth());
                this.copyingPlus.setLayoutY(this.dragTargetOverlayFake.getLayoutY() - this.copyingPlus.getWidth());
            }
        }
    }

    private void setDragTargetOverlayVisible(boolean visible, boolean showCross) {
        Pane dragTargetCursorPane = this.editor.getDragTargetCursorPane();
        if (visible) {
            WritableImage snapshot = this.getNode().snapshot(null, null);
            this.dragTargetOverlayFake = new ImageView((Image)snapshot);
            dragTargetCursorPane.getChildren().add((Object)this.dragTargetOverlayFake);
            if (showCross && this.redCross == null) {
                this.redCross = new Canvas(15.0, 15.0);
                GraphicsContext gc = this.redCross.getGraphicsContext2D();
                gc.setStroke((Paint)Color.RED);
                gc.setLineWidth(2.0);
                gc.strokeLine(1.0, 1.0, this.redCross.getWidth() - 2.0, this.redCross.getHeight() - 2.0);
                gc.strokeLine(this.redCross.getWidth() - 2.0, 1.0, 1.0, this.redCross.getHeight() - 2.0);
                dragTargetCursorPane.getChildren().add((Object)this.redCross);
            }
            this.adjustDragTargetPosition();
        } else {
            if (this.dragTargetOverlayFake != null) {
                dragTargetCursorPane.getChildren().remove((Object)this.dragTargetOverlayFake);
                this.dragTargetOverlayFake = null;
            }
            if (this.redCross != null) {
                dragTargetCursorPane.getChildren().remove((Object)this.redCross);
                this.redCross = null;
            }
            if (this.copyingPlus != null) {
                dragTargetCursorPane.getChildren().remove((Object)this.copyingPlus);
                this.copyingPlus = null;
            }
        }
    }

    public void stopShowAsDropTarget() {
        this.animateShowHide(false, false);
        this.setDragClass(-1);
    }

    public void insertBlockAfter(Frame b) {
        this.getParentCanvas().insertBlockAfter(b, this);
    }

    public void insertBlockBefore(Frame b) {
        this.getParentCanvas().insertBlockBefore(b, this);
    }

    public FrameTypeCheck check() {
        return this.getParentCanvas().getParent().check(this.getParentCanvas());
    }

    public void insertFramesAfter(List<Frame> frames) {
        ArrayList<Frame> rev = new ArrayList<Frame>(frames);
        Collections.reverse(rev);
        rev.forEach(f -> this.getParentCanvas().insertBlockAfter((Frame)f, this));
    }

    public FrameCursor getNextSkip() {
        return this.parentCanvas.getNextCursor(this, false);
    }

    public FrameCursor getPrevSkip() {
        return this.parentCanvas.getPrevCursor(this, false);
    }

    public FrameCursor getUp() {
        Frame frameBefore = this.getFrameBefore();
        if (frameBefore != null) {
            return frameBefore.getCursorBefore();
        }
        return this.parentCanvas.getParent().getCursorBefore(this.parentCanvas);
    }

    public FrameCursor getDown() {
        Frame frameAfter = this.getFrameAfter();
        if (frameAfter != null) {
            return frameAfter.getCursorAfter();
        }
        return this.parentCanvas.getParent().getCursorAfter(this.parentCanvas);
    }

    public Frame getFrameBefore() {
        return this.parentCanvas.getFrameBefore(this);
    }

    public Frame getFrameAfter() {
        return this.parentCanvas.getFrameAfter(this);
    }

    public FrameCanvas getParentCanvas() {
        return this.parentCanvas;
    }

    public Frame getEnclosingFrame() {
        return this.getParentCanvas().getParent().getFrame();
    }

    public Region getNode() {
        return this.node;
    }

    public void requestFocus() {
        this.node.requestFocus();
    }

    public Bounds getSceneBounds() {
        return this.node.localToScene(this.node.getBoundsInLocal());
    }

    protected void disappear() {
        this.animateShowHide(false, false);
    }

    protected void appear() {
        this.animateShowHide(true, false);
    }

    public InteractionManager getEditor() {
        return this.editor;
    }

    private boolean showContextMenu(double screenX, double screenY) {
        if (JavaFXUtil.hasPseudoclass((Styleable)this.node, "bj-java-preview")) {
            return false;
        }
        if (this.menu != null) {
            this.menu.hide();
        }
        this.menu = EditableSlot.MenuItems.makeContextMenu(Collections.singletonMap(EditableSlot.TopLevelMenu.EDIT, this.getMenuItems(true)));
        if (this.menu.getItems().size() > 0) {
            this.menu.show((Node)this.node, screenX, screenY);
            return true;
        }
        return false;
    }

    public EditableSlot.MenuItems getMenuItems(boolean contextMenu) {
        EditableSlot.MenuItems menuItems = new EditableSlot.MenuItems((ObservableList<EditableSlot.SortedMenuItem>)FXCollections.observableArrayList((Object[])new EditableSlot.SortedMenuItem[]{new PasteFrameOperation(this.editor).getMenuItem(contextMenu)}));
        if (!this.editor.getSelection().isEmpty()) {
            menuItems = EditableSlot.MenuItems.concat(this.editor.getSelection().getMenuItems(contextMenu), menuItems);
        }
        if (this.canInsert() && contextMenu) {
            Menu insertMenu = new Menu("Insert");
            insertMenu.getItems().addAll(this.getAcceptedFramesMenuItems());
            menuItems = EditableSlot.MenuItems.concat(new EditableSlot.MenuItems((ObservableList<EditableSlot.SortedMenuItem>)FXCollections.observableArrayList((Object[])new EditableSlot.SortedMenuItem[]{EditableSlot.MenuItemOrder.INSERT_FRAME.item((MenuItem)insertMenu)})), menuItems);
        }
        return menuItems;
    }

    private List<MenuItem> getAcceptedFramesMenuItems() {
        ArrayList<MenuItem> items = new ArrayList<MenuItem>();
        List entries = GreenfootFrameDictionary.getDictionary().getAllBlocks();
        for (FrameDictionary.Entry<GreenfootFrameCategory> entry : entries) {
            if (!this.check().canInsert((GreenfootFrameCategory)((Object)entry.getCategory()))) continue;
            items.add(this.createMenuItem(entry, this));
        }
        return items;
    }

    private MenuItem createMenuItem(final FrameDictionary.Entry<GreenfootFrameCategory> entry, final FrameCursor cursor) {
        Label d = new Label();
        d.textProperty().bind((ObservableValue)new SimpleStringProperty(entry.getShortcuts() + "\t  " + entry.getName()));
        d.setPrefWidth(250.0);
        MenuItem item = new MenuItem(entry.getName());
        item.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                FrameCursor.this.editor.beginRecordingState(FrameCursor.this);
                Frame newFrame = entry.getFactory().createBlock(FrameCursor.this.editor);
                cursor.insertBlockAfter(newFrame);
                newFrame.focusWhenJustAdded();
                FrameCursor.this.editor.endRecordingState(null);
                FrameCursor.this.editor.getSelection().clear();
                e.consume();
            }
        });
        return item;
    }

    @Override
    public boolean isFocused() {
        return this.node.isFocused();
    }

    @Override
    public int getFocusInfo() {
        return -1;
    }

    @Override
    public Node recallFocus(int info) {
        this.requestFocus();
        return this.node;
    }

    public void updateDragCopyState(boolean copying) {
        if (this.dragTargetOverlayFake == null) {
            return;
        }
        Pane dragTargetCursorPane = this.editor.getDragTargetCursorPane();
        if (copying && this.copyingPlus == null) {
            this.copyingPlus = new Canvas(12.0, 12.0);
            GraphicsContext gc = this.copyingPlus.getGraphicsContext2D();
            double middle = this.copyingPlus.getHeight() / 2.0;
            gc.setStroke((Paint)Color.BLACK);
            gc.setLineWidth(4.0);
            gc.strokeLine(middle, 0.0, middle, this.copyingPlus.getHeight());
            gc.strokeLine(0.0, middle, this.copyingPlus.getWidth(), middle);
            gc.setStroke((Paint)Color.WHITE);
            gc.setLineWidth(2.0);
            gc.strokeLine(middle, 2.0, middle, this.copyingPlus.getHeight() - 2.0);
            gc.strokeLine(2.0, middle, this.copyingPlus.getWidth() - 2.0, middle);
            dragTargetCursorPane.getChildren().add((Object)this.copyingPlus);
        } else if (!copying && this.copyingPlus != null) {
            dragTargetCursorPane.getChildren().remove((Object)this.copyingPlus);
            this.copyingPlus = null;
        }
        this.adjustDragTargetPosition();
    }

    public void setView(Frame.View view, SharedTransition animateProgress) {
        JavaFXUtil.setPseudoclass("bj-java-preview", view == Frame.View.JAVA_PREVIEW, new Node[]{this.node});
    }

    public boolean canInsert() {
        Frame f;
        CanvasParent cp = this.getParentCanvas().getParent();
        if (cp != null && (f = cp.getFrame()) != null) {
            return f.isFrameEnabled();
        }
        return true;
    }

    private static class TotalHeightBinding
    extends IntegerBinding {
        private static final Duration DEFAULT_DURATION = Duration.millis((double)100.0);
        private Set<NumberExpressionBase> shrinkingSpace = new HashSet<NumberExpressionBase>();
        private FrameCursor growing;

        private TotalHeightBinding() {
        }

        public synchronized void shrink(FrameCursor c, double target, boolean animate) {
            if (this.growing == c) {
                this.growing = null;
            }
            SimpleIntegerProperty heightProp = new SimpleIntegerProperty((int)c.node.getMaxHeight());
            c.node.maxHeightProperty().bind((ObservableValue)heightProp);
            if (animate) {
                c.animation = new Timeline(new KeyFrame[]{new KeyFrame(TotalHeightBinding.DEFAULT_DURATION, new KeyValue[]{new KeyValue((WritableValue)heightProp, (Object)target)})});
                c.animation.play();
            } else {
                heightProp.set((int)target);
            }
            this.shrinkingSpace.add((NumberExpressionBase)c.node.maxHeightProperty());
            this.bind(new Observable[]{c.node.maxHeightProperty()});
        }

        private synchronized void remove(FrameCursor c) {
            this.shrinkingSpace.remove(c.node.maxHeightProperty());
            this.unbind(new Observable[]{c.node.maxHeightProperty()});
            if (this.shrinkingSpace.isEmpty() && this.growing != null) {
                this.growing.node.maxHeightProperty().unbind();
                this.growing = null;
            }
        }

        protected int computeValue() {
            int height = 0;
            Iterator<NumberExpressionBase> it = this.shrinkingSpace.iterator();
            while (it.hasNext()) {
                NumberExpressionBase val = it.next();
                int h = (int)Math.ceil(val.doubleValue());
                height += h - 0;
                if (h != 0) continue;
                it.remove();
                this.unbind(new Observable[]{val});
            }
            return height;
        }

        public synchronized void grow(FrameCursor c, int target, boolean animate) {
            this.remove(c);
            this.growing = c;
            if (this.shrinkingSpace.isEmpty()) {
                SimpleIntegerProperty dummy = new SimpleIntegerProperty(target - (int)c.node.getMaxHeight() + 0);
                this.bind(new Observable[]{dummy});
                this.shrinkingSpace.add((NumberExpressionBase)dummy);
                if (animate) {
                    Timeline anim = new Timeline(new KeyFrame[]{new KeyFrame(DEFAULT_DURATION, new KeyValue[]{new KeyValue((WritableValue)dummy, (Object)0)})});
                    anim.play();
                } else {
                    dummy.set(0);
                }
            }
            this.growing.node.maxHeightProperty().bind((ObservableValue)Bindings.max((int)0, (ObservableNumberValue)new ReadOnlyIntegerWrapper(target).subtract((ObservableNumberValue)this)));
        }
    }
}

