/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.generic;

import bluej.parser.AssistContent;
import bluej.stride.generic.InteractionManager;
import bluej.utility.JavaUtils;
import bluej.utility.Utility;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.control.Label;
import javafx.scene.text.Font;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.Any)
public final class AssistContentThreadSafe {
    private final String name;
    private final List<AssistContent.ParamInfo> params;
    private final String type;
    private final AssistContent.Access access;
    private final String declaringClass;
    private final AssistContent.CompletionKind kind;
    private final InteractionManager.Kind typeKind;
    private final String javadoc;
    private final List<String> superTypes;
    private final String packageName;

    @OnThread(value=Tag.Swing)
    public AssistContentThreadSafe(AssistContent copyFrom) {
        this.name = copyFrom.getName();
        this.params = copyFrom.getParams();
        this.type = copyFrom.getType();
        this.access = copyFrom.getAccessPermission();
        this.declaringClass = copyFrom.getDeclaringClass();
        this.kind = copyFrom.getKind();
        this.javadoc = copyFrom.getJavadoc();
        this.superTypes = copyFrom.getSuperTypes();
        this.typeKind = copyFrom.getTypeKind();
        this.packageName = copyFrom.getPackage();
    }

    @OnThread(value=Tag.Swing)
    public static AssistContentThreadSafe copy(AssistContent copyFrom) {
        return new AssistContentThreadSafe(copyFrom);
    }

    @OnThread(value=Tag.Any)
    public AssistContentThreadSafe(AssistContent.Access access, String declaringClass, String javadoc, AssistContent.CompletionKind kind, String name, String packageName, List<AssistContent.ParamInfo> params, List<String> superTypes, String type, InteractionManager.Kind typeKind) {
        this.access = access;
        this.declaringClass = declaringClass;
        this.javadoc = javadoc;
        this.kind = kind;
        this.name = name;
        this.packageName = packageName;
        this.params = params;
        this.superTypes = superTypes;
        this.type = type;
        this.typeKind = typeKind;
    }

    public String getName() {
        return this.name;
    }

    public List<AssistContent.ParamInfo> getParams() {
        return this.params;
    }

    public String getType() {
        return this.type;
    }

    public AssistContent.Access getAccessPermission() {
        return this.access;
    }

    public String getDeclaringClass() {
        return this.declaringClass;
    }

    public AssistContent.CompletionKind getKind() {
        return this.kind;
    }

    public String getJavadoc() {
        return this.javadoc;
    }

    public String getPackage() {
        return this.packageName;
    }

    public static Comparator<AssistContentThreadSafe> getComparator(String targetType) {
        return (a, b) -> {
            int compareTypes;
            if (targetType != null && (compareTypes = Integer.compare(targetType.equals(a.getType()) ? 0 : 1, targetType.equals(b.getType()) ? 0 : 1)) != 0) {
                return compareTypes;
            }
            int compareNames = a.getName().toLowerCase().compareTo(b.getName().toLowerCase());
            if (compareNames != 0) {
                return compareNames;
            }
            int aParams = a.getParams() == null ? -1 : a.getParams().size();
            int bParams = b.getParams() == null ? -1 : b.getParams().size();
            return Integer.compare(aParams, bParams);
        };
    }

    public List<String> getSuperTypes() {
        return Collections.unmodifiableList(this.superTypes);
    }

    public InteractionManager.Kind getTypeKind() {
        return this.typeKind;
    }

    @OnThread(value=Tag.FX)
    public String getDocHTML() {
        String header = (this.getType() == null ? "" : Utility.escapeAngleBrackets(this.getType())) + " <b>" + this.getName() + "</b>";
        if (this.getParams() != null) {
            header = header + "(" + this.getParams().stream().map(p -> {
                String type = Utility.escapeAngleBrackets(p.getUnqualifiedType());
                if (p.getFormalName() != null) {
                    return type + "&nbsp;" + p.getFormalName();
                }
                return type;
            }).collect(Collectors.joining(", ")) + ")";
        }
        header = header + "<br><br>";
        Font font = new Label().getFont();
        String start = "<html><body style='font-family:" + font.getFamily() + ";font-size:" + font.getSize() + ";'>";
        String end = "</body></html>";
        String javadoc = this.getJavadoc() != null ? this.getJavadoc() : "";
        return start + header + JavaUtils.javadocToHtml(javadoc.replace("\n\n", "<br><br>")) + end;
    }

    public boolean accessibleFromPackage(String pkgName) {
        if (this.access == null) {
            return true;
        }
        switch (this.access) {
            case PRIVATE: {
                return false;
            }
            case PROTECTED: 
            case PACKAGE: {
                return pkgName.equals(this.packageName);
            }
            case PUBLIC: {
                return true;
            }
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssistContentThreadSafe that = (AssistContentThreadSafe)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.params != null ? !this.params.equals(that.params) : that.params != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        if (this.access != that.access) {
            return false;
        }
        if (this.declaringClass != null ? !this.declaringClass.equals(that.declaringClass) : that.declaringClass != null) {
            return false;
        }
        if (this.kind != that.kind) {
            return false;
        }
        if (this.typeKind != that.typeKind) {
            return false;
        }
        if (this.javadoc != null ? !this.javadoc.equals(that.javadoc) : that.javadoc != null) {
            return false;
        }
        if (this.superTypes != null ? !this.superTypes.equals(that.superTypes) : that.superTypes != null) {
            return false;
        }
        return !(this.packageName == null ? that.packageName != null : !this.packageName.equals(that.packageName));
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.params != null ? this.params.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.access != null ? this.access.hashCode() : 0);
        result = 31 * result + (this.declaringClass != null ? this.declaringClass.hashCode() : 0);
        result = 31 * result + (this.kind != null ? this.kind.hashCode() : 0);
        result = 31 * result + (this.typeKind != null ? this.typeKind.hashCode() : 0);
        result = 31 * result + (this.javadoc != null ? this.javadoc.hashCode() : 0);
        result = 31 * result + (this.superTypes != null ? this.superTypes.hashCode() : 0);
        result = 31 * result + (this.packageName != null ? this.packageName.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "AssistContentThreadSafe{access=" + (Object)((Object)this.access) + ", name='" + this.name + '\'' + ", params=(" + (this.params == null ? "<blank>" : this.params.stream().map(AssistContent.ParamInfo::toString).collect(Collectors.joining(","))) + "), type='" + this.type + '\'' + ", declaringClass='" + this.declaringClass + '\'' + ", kind=" + (Object)((Object)this.kind) + ", typeKind=" + (Object)((Object)this.typeKind) + ", javadoc='" + (this.javadoc == null ? "null" : Integer.valueOf(this.javadoc.hashCode())) + '\'' + ", superTypes=" + this.superTypes + ", packageName='" + this.packageName + '\'' + '}';
    }
}

