/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.slots;

import bluej.stride.framedjava.slots.CaretPos;
import bluej.stride.framedjava.slots.ExpressionSlot;
import bluej.stride.framedjava.slots.ExpressionSlotComponent;
import bluej.stride.framedjava.slots.ExpressionSlotField;
import bluej.stride.framedjava.slots.InfixExpression;
import bluej.stride.framedjava.slots.PosAndDist;
import bluej.stride.framedjava.slots.TextOverlayPosition;
import bluej.stride.generic.Frame;
import bluej.utility.javafx.HangingFlowPane;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.SharedTransition;
import java.util.List;
import java.util.stream.Stream;
import javafx.beans.binding.StringExpression;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ObservableStringValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Region;

class StringLiteralExpression
implements ExpressionSlotComponent {
    private final ExpressionSlotField field;
    private final ObservableList<Node> components = FXCollections.observableArrayList();
    private final StringExpression textProperty;
    private final Label openingQuote;
    private final Label closingQuote;

    public StringLiteralExpression(ExpressionSlotField f, InfixExpression parent) {
        this.field = f;
        this.openingQuote = ExpressionSlot.makeBracket("\u201c", true, parent);
        this.closingQuote = ExpressionSlot.makeBracket("\u201d", false, parent);
        this.components.add((Object)this.openingQuote);
        this.components.addAll(this.field.getComponents());
        this.components.add((Object)this.closingQuote);
        for (int i = 1; i < this.components.size(); ++i) {
            HangingFlowPane.setBreakBefore((Node)this.components.get(i), false);
        }
        JavaFXUtil.addStyleClass((Styleable)this.openingQuote, "expression-string-literal-quote");
        JavaFXUtil.addStyleClass((Styleable)this.closingQuote, "expression-string-literal-quote");
        this.textProperty = new ReadOnlyStringWrapper("\"").concat((Object)f.textProperty()).concat((Object)"\"");
    }

    @Override
    public void focusAtStart() {
        this.field.focusAtStart();
    }

    @Override
    public void focusAtEnd() {
        this.field.focusAtEnd();
    }

    @Override
    public Node focusAtPos(CaretPos caretPos) {
        return this.field.focusAtPos(caretPos);
    }

    @Override
    public TextOverlayPosition calculateOverlayPos(CaretPos pos) {
        return this.field.calculateOverlayPos(pos);
    }

    @Override
    public PosAndDist getNearest(double sceneX, double sceneY, boolean allowDescend, boolean anchorInItem) {
        if (allowDescend || anchorInItem) {
            return this.field.getNearest(sceneX, sceneY, allowDescend, anchorInItem);
        }
        return new PosAndDist();
    }

    @Override
    public CaretPos getSelectIntoPos(boolean atEnd) {
        return null;
    }

    @Override
    public CaretPos getStartPos() {
        return this.field.getStartPos();
    }

    @Override
    public CaretPos getEndPos() {
        return this.field.getEndPos();
    }

    @Override
    public String getCopyText(CaretPos from, CaretPos to) {
        StringBuilder b = new StringBuilder();
        if (from == null) {
            b.append("\"");
        }
        b.append(this.field.getCopyText(from, to));
        if (to == null) {
            b.append("\"");
        }
        return b.toString();
    }

    @Override
    public String getJavaCode() {
        StringBuilder b = new StringBuilder();
        b.append("\"");
        b.append(this.field.getText());
        b.append("\"");
        return b.toString();
    }

    @Override
    public CaretPos getCurrentPos() {
        return this.field.getCurrentPos();
    }

    public ObservableList<Node> getComponents() {
        return this.components;
    }

    @Override
    public List<InfixExpression.CaretPosMap> mapCaretPosStringPos(InfixExpression.IntCounter cur, boolean javaString) {
        ++cur.counter;
        List<InfixExpression.CaretPosMap> r = this.field.mapCaretPosStringPos(cur, false);
        ++cur.counter;
        return r;
    }

    @Override
    public Region getNodeForPos(CaretPos subPos) {
        return this.field.getNodeForPos(subPos);
    }

    ExpressionSlotField getField() {
        return this.field;
    }

    @Override
    public String testingGetState(CaretPos pos) {
        if (pos == null) {
            return "\"" + this.field.getText() + "\"";
        }
        return "\"" + this.field.getText().substring(0, pos.index) + "$" + this.field.getText().substring(pos.index) + "\"";
    }

    @Override
    public boolean isFocused() {
        return this.field.isFocused();
    }

    @Override
    public void insertSuggestion(CaretPos p, String name, List<String> params) {
        if (params != null) {
            throw new IllegalArgumentException();
        }
        this.getField().setText(name);
        this.getField().focusAtPos(new CaretPos(name.length(), null));
    }

    @Override
    public Stream<TextOverlayPosition> getAllStartEndPositionsBetween(CaretPos start, CaretPos end) {
        return this.field.getAllStartEndPositionsBetween(start, end);
    }

    @Override
    public Stream<InfixExpression> getAllExpressions() {
        return Stream.empty();
    }

    @Override
    public ObservableStringValue textProperty() {
        return this.textProperty;
    }

    @Override
    public void setView(Frame.View oldView, Frame.View newView, SharedTransition animate) {
        this.field.setView(oldView, newView, animate);
        JavaFXUtil.setPseudoclass("bj-java-preview", newView == Frame.View.JAVA_PREVIEW, new Node[]{this.openingQuote, this.closingQuote});
        this.openingQuote.setText(newView == Frame.View.JAVA_PREVIEW ? "\"" : "\u201c");
        this.closingQuote.setText(newView == Frame.View.JAVA_PREVIEW ? "\"" : "\u201d");
    }

    @Override
    public boolean isAlmostBlank() {
        return this.field.isAlmostBlank();
    }

    @Override
    public void notifyLostFocus(ExpressionSlotField except) {
        if (this.field != except) {
            this.field.notifyLostFocus(except);
        }
    }

    @Override
    public void setEditable(boolean editable) {
        this.field.setEditable(editable);
    }

    @Override
    public boolean isNumericLiteral() {
        return false;
    }
}

