/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.slots;

import bluej.stride.framedjava.ast.JavaFragment;
import bluej.stride.framedjava.ast.Parser;
import bluej.stride.framedjava.ast.links.PossibleLink;
import bluej.stride.framedjava.ast.links.PossibleMethodUseLink;
import bluej.stride.framedjava.ast.links.PossibleTypeLink;
import bluej.stride.framedjava.ast.links.PossibleVarLink;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.slots.BracketedExpression;
import bluej.stride.framedjava.slots.CaretPos;
import bluej.stride.framedjava.slots.ExpressionSlot;
import bluej.stride.framedjava.slots.ExpressionSlotComponent;
import bluej.stride.framedjava.slots.ExpressionSlotField;
import bluej.stride.framedjava.slots.Operator;
import bluej.stride.framedjava.slots.PosAndDist;
import bluej.stride.framedjava.slots.StringLiteralExpression;
import bluej.stride.framedjava.slots.TextOverlayPosition;
import bluej.stride.generic.Frame;
import bluej.stride.generic.InteractionManager;
import bluej.stride.slots.EditableSlot;
import bluej.utility.Debug;
import bluej.utility.Utility;
import bluej.utility.javafx.FXConsumer;
import bluej.utility.javafx.FXRunnable;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.MultiListener;
import bluej.utility.javafx.SharedTransition;
import bluej.utility.javafx.TextFieldDelegate;
import bluej.utility.javafx.binding.DeepListBinding;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.beans.binding.StringExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.input.Clipboard;
import javafx.scene.input.DataFormat;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;

class InfixExpression
implements TextFieldDelegate<ExpressionSlotField> {
    private static final String DIGITS_REGEX = "\\d([0-9_]*\\d)?";
    private static final String HEX_DIGITS_REGEX = "[0-9A-Fa-f]([0-9A-Fa-f_]*[0-9A-Fa-f])?";
    private final ObservableList<ExpressionSlotComponent> fields = FXCollections.observableArrayList();
    private final ObservableList<Operator> operators = FXCollections.observableArrayList();
    private final ObservableList<Node> components = FXCollections.observableArrayList();
    private final BracketedExpression parent;
    private final Set<Character> closingChars = new HashSet<Character>();
    private final InteractionManager editor;
    private final ExpressionSlot<?> slot;
    private final StringProperty textProperty = new SimpleStringProperty();
    private final BooleanProperty previewingJavaRange = new SimpleBooleanProperty(false);
    private final StringProperty startRangeText = new SimpleStringProperty(lang.stride.Utility.class.getName() + "(");
    private final StringProperty endRangeText = new SimpleStringProperty(")");
    private CaretPos anchorPos;
    private EditableSlot bindedSlot;
    private boolean queuedUpdatePrompts;

    InfixExpression(InteractionManager editor, ExpressionSlot slot, String stylePrefix) {
        this(editor, slot, "", null, new Character[0]);
    }

    InfixExpression(InteractionManager editor, ExpressionSlot slot, String initialContent, BracketedExpression wrapper, Character ... closingChars) {
        this.editor = editor;
        this.parent = wrapper;
        this.closingChars.addAll(Arrays.asList(closingChars));
        this.slot = slot;
        this.textProperty.set((Object)initialContent);
        this.fields.add((Object)this.makeNewField(initialContent, false));
        final ObservableList extraPrefix = FXCollections.observableArrayList();
        final ObservableList extraSuffix = FXCollections.observableArrayList();
        JavaFXUtil.addChangeListener(this.previewingJavaRange, previewing -> {
            if (previewing.booleanValue()) {
                Label start = new Label();
                start.textProperty().bind((ObservableValue)this.startRangeText);
                extraPrefix.setAll((Object[])new Node[]{start});
                Label end = new Label();
                end.textProperty().bind((ObservableValue)this.endRangeText);
                extraSuffix.setAll((Object[])new Node[]{end});
            } else {
                extraPrefix.clear();
                extraSuffix.clear();
            }
        });
        new DeepListBinding<Node>(this.components){

            @Override
            protected Stream<ObservableList<?>> getListenTargets() {
                return Stream.concat(Stream.of(InfixExpression.this.fields, InfixExpression.this.operators, extraPrefix, extraSuffix), InfixExpression.this.fields.stream().map(ExpressionSlotComponent::getComponents));
            }

            @Override
            protected Stream<Node> calculateValues() {
                return Utility.concat(extraPrefix.stream(), Utility.interleave(InfixExpression.this.fields.stream().map(c -> c.getComponents().stream()), InfixExpression.this.operators.stream().map(o -> o == null ? Stream.empty() : Stream.of(o.getNode()))).flatMap(x -> x), extraSuffix.stream());
            }
        }.startListening();
        ObservableList strings = FXCollections.observableArrayList();
        ChangeListener individualListener = (a, b, c) -> this.textProperty.set((Object)strings.stream().map(ObservableObjectValue::get).collect(Collectors.joining()));
        MultiListener<ObservableStringValue> stringListener = new MultiListener<ObservableStringValue>(s -> {
            s.addListener(individualListener);
            return () -> s.removeListener(individualListener);
        });
        strings.addListener(c -> {
            stringListener.listenOnlyTo(strings.stream());
            individualListener.changed(null, null, null);
        });
        new DeepListBinding<ObservableStringValue>(strings){

            @Override
            protected Stream<ObservableList<?>> getListenTargets() {
                return Stream.of(InfixExpression.this.fields, InfixExpression.this.operators);
            }

            @Override
            protected Stream<ObservableStringValue> calculateValues() {
                return Utility.interleave(InfixExpression.this.fields.stream().map(f -> f.textProperty()), InfixExpression.this.operators.stream().map(o -> o == null ? null : o.textProperty())).filter(x -> x != null);
            }
        }.startListening();
        this.fields.addListener(c -> {
            if (this.fields.size() != 1) {
                for (ExpressionSlotComponent comp : this.fields) {
                    if (!(comp instanceof ExpressionSlotField)) continue;
                    ((ExpressionSlotField)comp).setPromptText("");
                }
            }
        });
        this.components.addListener(c -> InfixExpression.calculatePrecedences(this.operators, this.fields.stream().map(ExpressionSlotComponent::isFieldAndEmpty).limit(this.operators.size()).collect(Collectors.toList())));
        this.updateBreaks();
        JavaFXUtil.addChangeListener(this.textProperty, value -> this.updateBreaks());
    }

    private void updateBreaks() {
        for (int i = 1; i < this.fields.size(); ++i) {
            if (!(this.fields.get(i) instanceof BracketedExpression)) continue;
            ((BracketedExpression)this.fields.get(i)).notifyIsMethodParams(this.fields.get(i - 1) instanceof ExpressionSlotField && !((ExpressionSlotComponent)this.fields.get(i - 1)).isFieldAndEmpty());
        }
    }

    static Operator.OpPrec calculatePrecedences(List<Operator> ops, List<Boolean> isUnary) {
        int lowestPrec = Integer.MAX_VALUE;
        int lowestIndex = -1;
        for (int i = 0; i < ops.size(); ++i) {
            if (ops.get(i) == null) continue;
            if (ops.get(i).get().equals(".")) {
                ops.get(i).setPrecedence(Operator.Precedence.DOT);
                continue;
            }
            if (ops.get(i).get().equals(",")) {
                ops.get(i).setPrecedence(Operator.Precedence.COMMA);
                continue;
            }
            if (ops.get(i).get().equals("new ")) {
                ops.get(i).setPrecedence(Operator.Precedence.NEW);
                continue;
            }
            int prec = Operator.getOperatorPrecedence(ops.get(i).get(), isUnary.get(i));
            if (prec >= lowestPrec) continue;
            lowestPrec = prec;
            lowestIndex = i;
        }
        if (lowestIndex != -1) {
            List<Operator> lhs = ops.subList(0, lowestIndex);
            List<Boolean> lhsUnary = isUnary.subList(0, lowestIndex);
            List<Operator> rhs = ops.subList(lowestIndex + 1, ops.size());
            List<Boolean> rhsUnary = isUnary.subList(lowestIndex + 1, ops.size());
            Operator.OpPrec lhsPrec = InfixExpression.calculatePrecedences(lhs, lhsUnary);
            Operator.OpPrec rhsPrec = InfixExpression.calculatePrecedences(rhs, rhsUnary);
            int ourLevel = lhsPrec.prec == lowestPrec || rhsPrec.prec == lowestPrec || lhsPrec.prec == -1 && rhsPrec.prec == -1 ? Math.max(lhsPrec.levels, rhsPrec.levels) : 1 + Math.max(lhsPrec.levels, rhsPrec.levels);
            ops.get(lowestIndex).setPrecedence(Operator.getPrecForLevel(ourLevel));
            return new Operator.OpPrec(lowestPrec, ourLevel);
        }
        return new Operator.OpPrec(-1, 0);
    }

    private static boolean precedesDotInFloatingPointLiteral(String before) {
        return before.matches("\\A\\s*[+-]?\\d([0-9_]*\\d)?\\z") || before.matches("\\A\\s*0x[0-9A-Fa-f]([0-9A-Fa-f_]*[0-9A-Fa-f])?\\z");
    }

    private ExpressionSlotField makeNewField(String content, boolean stringLiteral) {
        ExpressionSlotField f = new ExpressionSlotField(this, content, stringLiteral);
        if (this.editor != null) {
            this.editor.setupFocusableSlotComponent(this.slot, (Node)f.getNodeForPos(null), true, this.slot.getHints());
        }
        f.onKeyPressedProperty().set(event -> {
            switch (event.getCode()) {
                case ENTER: {
                    this.slot.enter();
                    event.consume();
                    break;
                }
                case UP: {
                    this.slot.up();
                    event.consume();
                    break;
                }
                case DOWN: {
                    this.slot.down();
                    event.consume();
                    break;
                }
                case SPACE: {
                    if (!event.isControlDown()) break;
                    this.slot.showSuggestionDisplay(f, f.getCurrentPos().index, stringLiteral);
                    event.consume();
                    break;
                }
                default: {
                    if (!this.slot.checkFilePreviewShortcut(event.getCode())) break;
                    event.consume();
                }
            }
        });
        f.addEventHandler((EventType<MouseEvent>)MouseEvent.MOUSE_MOVED, (EventHandler<? super MouseEvent>)((EventHandler)e -> {
            CaretPos relNearest = this.getNearest(e.getSceneX(), e.getSceneY(), false, Optional.empty()).getPos();
            CaretPos absNearest = this.absolutePos(relNearest);
            f.setPseudoclass("bj-hyperlink", e.isShortcutDown() && this.slot.getOverlay().hoverAtPos(this.slot.getTopLevel().caretPosToStringPos(absNearest, false)) != null);
        }));
        f.addEventHandler((EventType<MouseEvent>)MouseEvent.MOUSE_CLICKED, (EventHandler<? super MouseEvent>)((EventHandler)e -> {
            if (e.getClickCount() > 1) {
                return;
            }
            CaretPos relNearest = this.getNearest(e.getSceneX(), e.getSceneY(), false, Optional.empty()).getPos();
            CaretPos absNearest = this.absolutePos(relNearest);
            Utility.ifNotNull(this.slot.getOverlay().hoverAtPos(this.slot.getTopLevel().caretPosToStringPos(absNearest, false)), FXRunnable::runLater);
        }));
        return f;
    }

    Node positionCaret(CaretPos pos) {
        if (pos == null) {
            return null;
        }
        pos = pos.normalise();
        if (pos.index == -1) {
            return this.parent.positionParentPos(pos.subPos);
        }
        ExpressionSlotComponent foc = (ExpressionSlotComponent)this.fields.get(pos.index);
        return foc.focusAtPos(pos.subPos);
    }

    public void drawSelection(CaretPos cur) {
        if (this.anchorPos == null || this.anchorPos.equals(cur)) {
            this.slot.clearSelection(false);
        } else {
            CaretPos end;
            CaretPos start;
            if (this.anchorPos.before(cur)) {
                start = this.anchorPos;
                end = cur;
            } else {
                start = cur;
                end = this.anchorPos;
            }
            this.slot.drawSelection(this.getAllStartEndPositionsBetween(start, end).collect(Collectors.toList()));
        }
    }

    Stream<TextOverlayPosition> getAllStartEndPositionsBetween(CaretPos start, CaretPos end) {
        int endIndex;
        int startIndex;
        boolean useVeryEnd;
        if (start == null) {
            start = new CaretPos(0, this.getFirstField().getStartPos());
        }
        boolean bl = useVeryEnd = end == null;
        if (end == null) {
            end = new CaretPos(this.fields.size() - 1, this.getLastField().getEndPos());
        }
        if ((startIndex = start.index) == (endIndex = end.index)) {
            Stream<TextOverlayPosition> s = ((ExpressionSlotComponent)this.fields.get(startIndex)).getAllStartEndPositionsBetween(start.subPos, end.subPos);
            if (useVeryEnd) {
                s = Stream.concat(s, Stream.of(((ExpressionSlotField)this.fields.get(this.fields.size() - 1)).calculateOverlayEnd()));
            }
            return s;
        }
        Stream<TextOverlayPosition> s = ((ExpressionSlotComponent)this.fields.get(startIndex)).getAllStartEndPositionsBetween(start.subPos, null);
        for (int i = startIndex + 1; i < endIndex; ++i) {
            if (this.operators.get(i - 1) != null) {
                s = Stream.concat(s, ((Operator)this.operators.get(i - 1)).getStartEndPositions(this));
            }
            s = Stream.concat(s, ((ExpressionSlotComponent)this.fields.get(i)).getAllStartEndPositionsBetween(null, null));
        }
        if (this.operators.get(endIndex - 1) != null) {
            s = Stream.concat(s, ((Operator)this.operators.get(endIndex - 1)).getStartEndPositions(this));
        }
        s = Stream.concat(s, ((ExpressionSlotComponent)this.fields.get(endIndex)).getAllStartEndPositionsBetween(null, end.subPos));
        if (useVeryEnd) {
            s = Stream.concat(s, Stream.of(((ExpressionSlotField)this.fields.get(this.fields.size() - 1)).calculateOverlayEnd()));
        }
        return s;
    }

    public TextOverlayPosition calculateOverlayPos(CaretPos p) {
        ExpressionSlotComponent f = (ExpressionSlotComponent)this.fields.get(p.index);
        return f.calculateOverlayPos(p.subPos);
    }

    public double sceneToOverlayX(double sceneX) {
        return this.slot.sceneToOverlayX(sceneX);
    }

    public double sceneToOverlayY(double sceneY) {
        return this.slot.sceneToOverlayY(sceneY);
    }

    @Override
    public void deselect() {
        this.anchorPos = null;
        this.drawSelection(null);
    }

    @Override
    public void backwardAtStart(ExpressionSlotField f) {
        this.backwardAtStart((ExpressionSlotComponent)f);
    }

    @Override
    public void backwardAtStart(ExpressionSlotComponent f) {
        int i = this.findField(f);
        if (i == -1) {
            throw new IllegalStateException();
        }
        if (i > 0) {
            ((ExpressionSlotComponent)this.fields.get(i - 1)).focusAtEnd();
        } else if (this.parent != null) {
            this.parent.focusBefore();
        } else {
            this.slot.getSlotParent().focusLeft(this.slot);
        }
    }

    @Override
    public void forwardAtEnd(ExpressionSlotField f) {
        this.forwardAtEnd((ExpressionSlotComponent)f);
    }

    @Override
    public void forwardAtEnd(ExpressionSlotComponent f) {
        int i = this.findField(f);
        if (i == -1) {
            throw new IllegalStateException();
        }
        if (i < this.fields.size() - 1) {
            ((ExpressionSlotComponent)this.fields.get(i + 1)).focusAtStart();
        } else if (this.parent != null) {
            this.parent.focusAfter();
        } else {
            this.slot.getSlotParent().focusRight(this.slot);
        }
    }

    @Override
    public boolean home(ExpressionSlotField f) {
        this.getFirstField().focusAtStart();
        return true;
    }

    @Override
    public boolean end(ExpressionSlotField f, boolean asPartOfNextWordCommand) {
        if (asPartOfNextWordCommand) {
            f.focusAtEnd();
        } else {
            this.end();
        }
        return true;
    }

    @Override
    public boolean selectHome(ExpressionSlotField id, int caretPos) {
        int i = this.findField(id);
        this.setAnchorIfUnset(new CaretPos(i, new CaretPos(caretPos, null)));
        int dest = this.fields.get(i) instanceof StringLiteralExpression ? i : 0;
        ((ExpressionSlotComponent)this.fields.get(dest)).focusAtStart();
        this.drawSelection(new CaretPos(dest, new CaretPos(0, null)));
        return true;
    }

    @Override
    public boolean selectEnd(ExpressionSlotField id, int caretPos) {
        int i = this.findField(id);
        this.setAnchorIfUnset(new CaretPos(i, new CaretPos(caretPos, null)));
        int dest = this.fields.get(i) instanceof StringLiteralExpression ? i : this.fields.size() - 1;
        ((ExpressionSlotComponent)this.fields.get(dest)).focusAtEnd();
        this.drawSelection(new CaretPos(dest, ((ExpressionSlotComponent)this.fields.get(dest)).getEndPos()));
        return true;
    }

    ExpressionSlotField getFirstField() {
        return (ExpressionSlotField)this.fields.get(0);
    }

    private ExpressionSlotField getLastField() {
        return (ExpressionSlotField)this.fields.get(this.fields.size() - 1);
    }

    @Override
    public boolean previousWord(ExpressionSlotField f, boolean atStart) {
        if (atStart) {
            this.backwardAtStart(f);
            return true;
        }
        return false;
    }

    @Override
    public boolean nextWord(ExpressionSlotField f, boolean atEnd) {
        if (atEnd) {
            this.forwardAtEnd(f);
            return true;
        }
        return false;
    }

    @Override
    public boolean endOfNextWord(ExpressionSlotField f, boolean atEnd) {
        return this.nextWord(f, atEnd);
    }

    @Override
    public boolean selectAll(ExpressionSlotField f) {
        this.home(null);
        this.selectEnd(this.getFirstField(), 0);
        return true;
    }

    @Override
    public boolean selectNextWord(ExpressionSlotField f) {
        this.setAnchorIfUnset(this.getCurrentPos());
        if (f.getCurrentPos().equals(f.getEndPos())) {
            int i = this.findField(f);
            if (this.fields.get(i) instanceof StringLiteralExpression) {
                return false;
            }
            this.selectForward(f, f.getCurrentPos().index, true);
        } else {
            CaretPos anch = this.anchorPos;
            f.nextWord();
            this.anchorPos = anch;
            this.drawSelection(new CaretPos(this.findField(f), f.getCurrentPos()));
        }
        return true;
    }

    @Override
    public boolean selectPreviousWord(ExpressionSlotField f) {
        this.setAnchorIfUnset(this.getCurrentPos());
        if (f.getCurrentPos().equals(f.getStartPos())) {
            int i = this.findField(f);
            if (this.fields.get(i) instanceof StringLiteralExpression) {
                return false;
            }
            this.selectBackward(f, 0);
        } else {
            f.previousWord();
            this.drawSelection(new CaretPos(this.findField(f), f.getCurrentPos()));
        }
        return true;
    }

    @Override
    public boolean cut() {
        this.copy();
        this.deleteSelection();
        return true;
    }

    @Override
    public void moveTo(double sceneX, double sceneY, boolean setAnchor) {
        CaretPos pos = this.getNearest(sceneX, sceneY, true, Optional.empty()).getPos();
        this.positionCaret(pos);
        if (setAnchor) {
            this.anchorPos = pos;
        }
    }

    PosAndDist getNearest(double sceneX, double sceneY, boolean canDescend, Optional<Integer> restrictTo) {
        PosAndDist nearest = new PosAndDist();
        for (int i = 0; i < this.fields.size(); ++i) {
            int index = i;
            if (restrictTo.isPresent() && restrictTo.get() != i) continue;
            nearest = PosAndDist.nearest(nearest, ((ExpressionSlotComponent)this.fields.get(i)).getNearest(sceneX, sceneY, canDescend, this.anchorPos != null && this.anchorPos.index == i).copyAdjustPos(p -> new CaretPos(index, (CaretPos)p)));
        }
        return nearest;
    }

    @Override
    public void selectTo(double sceneX, double sceneY) {
        CaretPos pos = this.getNearest(sceneX, sceneY, false, this.anchorPos != null && this.fields.get(this.anchorPos.index) instanceof StringLiteralExpression ? Optional.of(this.anchorPos.index) : Optional.empty()).getPos();
        this.positionCaret(pos);
        this.drawSelection(pos);
    }

    @Override
    public void selected() {
        if (this.anchorPos == null || this.anchorPos.equals(this.getCurrentPos())) {
            this.anchorPos = null;
            this.drawSelection(null);
        }
    }

    private void setAnchorIfUnset(CaretPos caretPos) {
        if (this.anchorPos == null) {
            this.anchorPos = caretPos;
        }
    }

    @Override
    public boolean selectBackward(ExpressionSlotField f, int posInSlot) {
        int start = this.findField(f);
        if (posInSlot > 0) {
            this.setAnchorIfUnset(new CaretPos(start, new CaretPos(posInSlot, null)));
            CaretPos newPos = new CaretPos(start, new CaretPos(posInSlot - 1, null));
            this.drawSelection(newPos);
            this.positionCaret(newPos);
            return true;
        }
        if (this.fields.get(start) instanceof StringLiteralExpression) {
            return false;
        }
        for (int i = start - 1; i >= 0; --i) {
            CaretPos pos = ((ExpressionSlotComponent)this.fields.get(i)).getSelectIntoPos(true);
            if (pos == null) continue;
            pos = new CaretPos(i, pos);
            this.setAnchorIfUnset(new CaretPos(start, new CaretPos(posInSlot, null)));
            this.positionCaret(pos);
            this.drawSelection(pos);
            return true;
        }
        return false;
    }

    @Override
    public boolean selectForward(ExpressionSlotField f, int posInSlot, boolean atEnd) {
        int start = this.findField(f);
        if (!atEnd) {
            this.setAnchorIfUnset(new CaretPos(start, new CaretPos(posInSlot, null)));
            CaretPos newPos = new CaretPos(start, new CaretPos(posInSlot + 1, null));
            this.drawSelection(newPos);
            this.positionCaret(newPos);
            return true;
        }
        if (this.fields.get(start) instanceof StringLiteralExpression) {
            return false;
        }
        for (int i = start + 1; i < this.fields.size(); ++i) {
            CaretPos pos = ((ExpressionSlotComponent)this.fields.get(i)).getSelectIntoPos(false);
            if (pos == null) continue;
            pos = new CaretPos(i, pos);
            this.setAnchorIfUnset(new CaretPos(start, new CaretPos(posInSlot, null)));
            this.positionCaret(pos);
            this.drawSelection(pos);
            return true;
        }
        return false;
    }

    @Override
    public void delete(ExpressionSlotField f, int start, int end) {
        f.setText(f.getText().substring(0, start) + f.getText().substring(end));
    }

    @Override
    public boolean copy() {
        CaretPos end;
        CaretPos start;
        if (this.anchorPos == null) {
            return true;
        }
        CaretPos cur = this.getCurrentPos();
        if (this.anchorPos.before(cur)) {
            start = this.anchorPos;
            end = cur;
        } else {
            start = cur;
            end = this.anchorPos;
        }
        String s = this.getCopyText(start, end);
        Clipboard.getSystemClipboard().setContent(Collections.singletonMap(DataFormat.PLAIN_TEXT, s));
        return true;
    }

    public String getCopyText(CaretPos start, CaretPos end) {
        if (start == null) {
            start = new CaretPos(0, new CaretPos(0, null));
        }
        if (end == null) {
            end = new CaretPos(this.fields.size() - 1, this.getLastField().getEndPos());
        }
        if (start.index == end.index) {
            return ((ExpressionSlotComponent)this.fields.get(start.index)).getCopyText(start.subPos, end.subPos);
        }
        StringBuilder b = new StringBuilder();
        b.append(((ExpressionSlotComponent)this.fields.get(start.index)).getCopyText(start.subPos, null));
        if (this.operators.get(start.index) != null) {
            b.append(((Operator)this.operators.get(start.index)).getCopyText());
        }
        for (int i = start.index + 1; i < end.index; ++i) {
            b.append(((ExpressionSlotComponent)this.fields.get(i)).getCopyText(null, null));
            if (this.operators.get(i) == null) continue;
            b.append(((Operator)this.operators.get(i)).getCopyText());
        }
        b.append(((ExpressionSlotComponent)this.fields.get(end.index)).getCopyText(null, end.subPos));
        return b.toString();
    }

    private String getJavaCodeForFields(int start, int end) {
        StringBuilder b = new StringBuilder();
        for (int i = start; i < end; ++i) {
            b.append(((ExpressionSlotComponent)this.fields.get(i)).getJavaCode());
            if (i >= this.operators.size() || this.operators.get(i) == null || i >= end - 1) continue;
            b.append(((Operator)this.operators.get(i)).getJavaCode());
        }
        return b.toString();
    }

    public String getJavaCode() {
        StringBuilder b = new StringBuilder();
        int closing = 0;
        int last = 0;
        for (int i = 0; i < this.operators.size(); ++i) {
            if (this.operators.get(i) == null) continue;
            String op = ((Operator)this.operators.get(i)).get();
            if (op.equals("..")) {
                b.append(lang.stride.Utility.class.getName() + ".makeRange(");
                b.append(this.getJavaCodeForFields(last, i + 1));
                b.append(", ");
                last = i + 1;
                ++closing;
                continue;
            }
            if (!op.equals(",")) continue;
            b.append(this.getJavaCodeForFields(last, i + 1));
            while (closing > 0) {
                b.append(")");
                --closing;
            }
            b.append(", ");
            last = i + 1;
        }
        b.append(this.getJavaCodeForFields(last, this.fields.size()));
        while (closing > 0) {
            b.append(")");
            --closing;
        }
        return b.toString();
    }

    @Override
    public boolean deleteSelection() {
        return this.deleteSelection_(this.getCurrentPos()) != null;
    }

    CaretPos deleteSelection_(CaretPos cur) {
        CaretPos end;
        CaretPos start;
        if (this.anchorPos == null || this.anchorPos.equals(cur)) {
            this.anchorPos = null;
            return null;
        }
        if (this.anchorPos.before(cur)) {
            start = this.anchorPos;
            end = cur;
        } else {
            start = cur;
            end = this.anchorPos;
        }
        this.anchorPos = null;
        if (start.index == end.index) {
            if (this.fields.get(start.index) instanceof BracketedExpression) {
                InfixExpression nested = ((BracketedExpression)this.fields.get(start.index)).getContent();
                nested.setAnchorIfUnset(start.subPos);
                return new CaretPos(start.index, nested.deleteSelection_(end.subPos));
            }
            if (this.fields.get(start.index) instanceof StringLiteralExpression) {
                StringLiteralExpression s = (StringLiteralExpression)this.fields.get(start.index);
                ExpressionSlotField f = s.getField();
                f.setText(f.getText().substring(0, start.subPos.index) + f.getText().substring(end.subPos.index));
                return start;
            }
        }
        ExpressionSlotField startField = (ExpressionSlotField)this.fields.get(start.index);
        ExpressionSlotField endField = (ExpressionSlotField)this.fields.get(end.index);
        startField.setText(startField.getText().substring(0, start.subPos.index) + endField.getText().substring(end.subPos.index));
        for (int i = start.index + 1; i <= end.index; ++i) {
            this.operators.remove(start.index);
            this.fields.remove(start.index + 1);
        }
        CaretPos pos = this.checkFieldChange(start.index, start);
        this.positionCaret(pos);
        if (this.slot != null) {
            this.slot.clearSelection(true);
        }
        return pos;
    }

    @Override
    public boolean deletePrevious(ExpressionSlotField f, int posInField, boolean atStart) {
        this.positionCaret(this.deletePrevious_(f, posInField, atStart));
        return true;
    }

    public CaretPos deletePreviousAtPos(CaretPos p) {
        ExpressionSlotComponent c = (ExpressionSlotComponent)this.fields.get(p.index);
        if (c instanceof ExpressionSlotField) {
            return this.deletePrevious_((ExpressionSlotField)c, p.subPos.index, p.subPos.index == 0);
        }
        if (c instanceof StringLiteralExpression) {
            return this.deletePrevious_(((StringLiteralExpression)c).getField(), p.subPos.index, p.subPos.index == 0);
        }
        if (c instanceof BracketedExpression) {
            return new CaretPos(p.index, ((BracketedExpression)c).getContent().deletePreviousAtPos(p.subPos));
        }
        throw new IllegalStateException();
    }

    CaretPos deletePrevious_(ExpressionSlotField f, int posInField, boolean atStart) {
        int index = this.findField(f);
        if (atStart) {
            if (index > 0) {
                Operator prev = (Operator)this.operators.get(index - 1);
                if (prev == null) {
                    boolean inString = this.fields.get(index) instanceof StringLiteralExpression;
                    return this.flattenCompound(inString ? index : index - 1, !inString);
                }
                String op = prev.get();
                if (op.length() > 1 && !op.equals("new ")) {
                    prev.set(op.substring(0, op.length() - 1));
                    return this.checkFieldChange(index - 1, new CaretPos(index, new CaretPos(0, null)));
                }
                this.operators.remove(index - 1);
                ExpressionSlotField prevField = (ExpressionSlotField)this.fields.get(index - 1);
                String opRemaining = "";
                if (op.equals("new ")) {
                    opRemaining = "new";
                }
                int newPos = prevField.getText().length() + opRemaining.length();
                prevField.setText(prevField.getText() + opRemaining + f.getText());
                this.fields.remove(index);
                return this.checkFieldChange(index - 1, new CaretPos(index - 1, new CaretPos(newPos, null)));
            }
            if (this.parent != null) {
                return new CaretPos(-1, this.parent.flatten(false));
            }
            if (this.slot != null) {
                if (this.slot.backspaceAtStart()) {
                    return null;
                }
                return new CaretPos(0, new CaretPos(0, null));
            }
            if (this.editor != null) {
                throw new IllegalStateException("No parent nor slot");
            }
            return new CaretPos(0, new CaretPos(0, null));
        }
        String s = f.getText();
        f.setText(s.substring(0, posInField - 1) + s.substring(posInField));
        CaretPos p = this.checkFieldChange(index, new CaretPos(index, new CaretPos(posInField - 1, null)));
        return p;
    }

    CaretPos flattenCompound(ExpressionSlotComponent item, boolean caretAtEnd) {
        return this.flattenCompound(this.fields.indexOf((Object)item), caretAtEnd);
    }

    private CaretPos flattenCompound(int index, boolean atEnd) {
        ExpressionSlotField fieldBefore = (ExpressionSlotField)this.fields.get(index - 1);
        String after = ((ExpressionSlotComponent)this.fields.get(index + 1)).getCopyText(null, null);
        String content = ((ExpressionSlotComponent)this.fields.get(index)).getCopyText(((ExpressionSlotComponent)this.fields.get(index)).getStartPos(), ((ExpressionSlotComponent)this.fields.get(index)).getEndPos());
        this.fields.remove(index + 1);
        if (this.operators.remove(index) != null) {
            throw new IllegalStateException();
        }
        this.fields.remove(index);
        if (this.operators.remove(index - 1) != null) {
            throw new IllegalStateException();
        }
        int len = fieldBefore.getText().length();
        CaretPos mid = this.insert_(fieldBefore, len, content, false);
        this.testingInsert(mid, after);
        if (atEnd) {
            return mid;
        }
        return new CaretPos(index - 1, new CaretPos(len, null));
    }

    @Override
    public boolean deleteNext(ExpressionSlotField f, int posInField, boolean atEnd) {
        this.positionCaret(this.deleteNext_(f, posInField, atEnd));
        return true;
    }

    CaretPos deleteNext_(ExpressionSlotField f, int posInField, boolean atEnd) {
        int index = this.findField(f);
        if (atEnd) {
            if (index < this.fields.size() - 1) {
                Operator next = (Operator)this.operators.get(index);
                if (next == null) {
                    return this.flattenCompound(index + 1, false);
                }
                String op = next.get();
                if (op.length() > 1 && Operator.isOperator(op.substring(1))) {
                    next.set(op.substring(1));
                    return this.checkFieldChange(index, new CaretPos(index, new CaretPos(posInField, null)));
                }
                String opRemaining = "";
                if (op.equals("new ")) {
                    opRemaining = "ew";
                }
                this.operators.remove(index);
                int newPos = f.getText().length();
                f.setText(f.getText() + opRemaining + ((ExpressionSlotField)this.fields.get(index + 1)).getText());
                this.fields.remove(index + 1);
                return this.checkFieldChange(index, new CaretPos(index, new CaretPos(newPos, null)));
            }
            if (this.parent != null) {
                return new CaretPos(-1, this.parent.flatten(true));
            }
            if (this.slot != null && this.slot.deleteAtEnd()) {
                return null;
            }
            return new CaretPos(index, new CaretPos(posInField, null));
        }
        String s = f.getText();
        f.setText(s.substring(0, posInField) + s.substring(posInField + 1));
        return this.checkFieldChange(index, new CaretPos(index, new CaretPos(posInField, null)));
    }

    public CaretPos getCurrentPos() {
        for (int i = 0; i < this.fields.size(); ++i) {
            CaretPos pos = ((ExpressionSlotComponent)this.fields.get(i)).getCurrentPos();
            if (pos == null) continue;
            return new CaretPos(i, pos);
        }
        return null;
    }

    private int findField(ExpressionSlotComponent f) {
        for (int i = 0; i < this.fields.size(); ++i) {
            if (this.fields.get(i) == f) {
                return i;
            }
            if (!(this.fields.get(i) instanceof StringLiteralExpression) || f != ((StringLiteralExpression)this.fields.get(i)).getField()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void insert(ExpressionSlotField f, int posInField, String text) {
        this.insert_(f, posInField, text, true);
    }

    CaretPos insert_(ExpressionSlotField f, int posInField, String text, boolean user) {
        CaretPos postDeletion;
        if (this.parent == null && !text.isEmpty() && text.length() > 0 && this.closingChars.contains(Character.valueOf(text.charAt(0)))) {
            this.bindedSlot.requestFocus();
            return null;
        }
        int index = this.findField(f);
        if (index == -1) {
            return null;
        }
        CaretPos pos = new CaretPos(index, new CaretPos(posInField, null));
        if (text.length() > 0 && text.charAt(0) != '(' && text.charAt(0) != '[' && text.charAt(0) != '\"' && (postDeletion = this.deleteSelection_(pos)) != null) {
            pos = postDeletion;
        }
        for (int i = 0; i < text.length(); ++i) {
            pos = this.insertChar(pos, text.charAt(i), user);
            this.anchorPos = null;
            if (pos.index != Integer.MAX_VALUE) continue;
            if (this.parent == null) {
                throw new IllegalStateException();
            }
            this.parent.insertAfter(text.substring(i + 1));
            return null;
        }
        this.positionCaret(pos);
        if (this.slot != null) {
            this.slot.clearSelection(true);
        }
        return pos;
    }

    CaretPos insertAtPos(CaretPos p, String after) {
        ExpressionSlotComponent f = (ExpressionSlotComponent)this.fields.get(p.index);
        if (f instanceof ExpressionSlotField) {
            return this.insert_((ExpressionSlotField)this.fields.get(p.index), p.subPos.index, after, false);
        }
        if (f instanceof StringLiteralExpression) {
            return this.insert_(((StringLiteralExpression)this.fields.get(p.index)).getField(), p.subPos.index, after, false);
        }
        return new CaretPos(p.index, ((BracketedExpression)this.fields.get(p.index)).testingContent().insertAtPos(p.subPos, after));
    }

    private CaretPos insertChar(CaretPos pos, char c, boolean user) {
        ExpressionSlotComponent slot = (ExpressionSlotComponent)this.fields.get(pos.index);
        if (slot instanceof ExpressionSlotField) {
            ExpressionSlotField f = (ExpressionSlotField)slot;
            Operator prev = pos.index == 0 ? null : (Operator)this.operators.get(pos.index - 1);
            Operator next = pos.index >= this.operators.size() ? null : (Operator)this.operators.get(pos.index);
            int posInField = pos.subPos.index;
            if (c == ';') {
                return pos;
            }
            if (Character.isWhitespace(c) && !f.getText().substring(0, posInField).equals("new")) {
                return pos;
            }
            if (posInField == 0 && prev != null && Operator.isOperator(prev.get() + c)) {
                prev.set(prev.get() + c);
                return pos;
            }
            if (posInField == f.getText().length() && next != null && Operator.isOperator("" + c + next.get())) {
                next.set("" + c + next.get());
                return pos;
            }
            if (c == ',' && posInField == f.getText().length() && next != null && next.get().equals(",") && pos.index + 1 < this.fields.size() && ((ExpressionSlotComponent)this.fields.get(pos.index + 1)).getCopyText(null, null).isEmpty()) {
                return new CaretPos(pos.index + 1, new CaretPos(0, null));
            }
            if (Operator.beginsOperator(c) && c != '.' && c != '+' && c != '-') {
                String before = f.getText().substring(0, posInField);
                String following = f.getText().substring(posInField);
                f.setText(before);
                this.operators.add(pos.index, (Object)new Operator("" + c, this));
                this.fields.add(pos.index + 1, (Object)this.makeNewField(following, false));
                return new CaretPos(pos.index + 1, new CaretPos(0, null));
            }
            if (this.anchorPos != null && (c == '(' || c == '[' || c == '{' || c == '\"')) {
                String content = this.anchorPos.before(pos) ? this.getCopyText(this.anchorPos, pos) : this.getCopyText(pos, this.anchorPos);
                pos = this.deleteSelection_(pos);
                pos = this.insertChar(pos, c, false);
                this.insertAtPos(pos, content);
                return new CaretPos(pos.index + 1, new CaretPos(0, null));
            }
            if (c == '(' || c == '[' || c == '{') {
                Object following;
                if (posInField == f.getText().length() && pos.index + 1 < this.fields.size() && this.fields.get(pos.index + 1) instanceof BracketedExpression && ((BracketedExpression)(following = (BracketedExpression)this.fields.get(pos.index + 1))).getOpening() == c) {
                    return new CaretPos(pos.index + 1, new CaretPos(0, new CaretPos(0, null)));
                }
                following = f.getText().substring(posInField);
                f.setText(f.getText().substring(0, posInField));
                this.operators.add(pos.index, null);
                this.fields.add(pos.index + 1, (Object)new BracketedExpression(this.editor, this, this.slot, c, ""));
                if (pos.index + 1 >= this.operators.size() || this.operators.get(pos.index + 1) != null || !(this.fields.get(pos.index + 2) instanceof ExpressionSlotField)) {
                    this.operators.add(pos.index + 1, null);
                    this.fields.add(pos.index + 2, (Object)this.makeNewField((String)following, false));
                } else {
                    ExpressionSlotField follow = (ExpressionSlotField)this.fields.get(pos.index + 2);
                    follow.setText((String)following + follow.getText());
                }
                return new CaretPos(pos.index + 1, new CaretPos(0, new CaretPos(0, null)));
            }
            if (c == ')' || c == ']' || c == '}') {
                if (this.closingChars.contains(Character.valueOf(c)) && posInField == f.getText().length()) {
                    return new CaretPos(Integer.MAX_VALUE, null);
                }
                return pos;
            }
            if (c == '\"') {
                String following = f.getText().substring(posInField);
                f.setText(f.getText().substring(0, posInField));
                this.operators.add(pos.index, null);
                this.fields.add(pos.index + 1, (Object)new StringLiteralExpression(this.makeNewField("", true), this));
                if (pos.index + 1 >= this.operators.size() || this.operators.get(pos.index + 1) != null) {
                    this.operators.add(pos.index + 1, null);
                    this.fields.add(pos.index + 2, (Object)this.makeNewField(following, false));
                } else {
                    ExpressionSlotField follow = (ExpressionSlotField)this.fields.get(pos.index + 2);
                    follow.setText(following + follow.getText());
                }
                return new CaretPos(pos.index + 1, new CaretPos(0, new CaretPos(0, null)));
            }
            if (f.getText().substring(0, posInField).equals("new") && Character.isWhitespace(c)) {
                String following = f.getText().substring(posInField);
                f.setText("");
                this.operators.add(pos.index, (Object)new Operator("new ", this));
                this.fields.add(pos.index + 1, (Object)this.makeNewField(following, false));
                return new CaretPos(pos.index + 1, new CaretPos(0, null));
            }
            f.setText(f.getText().substring(0, posInField) + c + f.getText().substring(posInField));
            CaretPos overridePos = this.checkFieldChange(pos.index, new CaretPos(pos.index, new CaretPos(posInField + 1, null)), c == '.', user);
            return overridePos;
        }
        if (slot instanceof BracketedExpression) {
            CaretPos newSubPos = ((BracketedExpression)slot).getContent().insertChar(pos.subPos, c, false);
            if (newSubPos.index == Integer.MAX_VALUE) {
                return new CaretPos(pos.index + 1, new CaretPos(0, null));
            }
            return new CaretPos(pos.index, newSubPos);
        }
        if (slot instanceof StringLiteralExpression) {
            ExpressionSlotField f = ((StringLiteralExpression)slot).getField();
            int posInField = pos.subPos.index;
            if (c == '\"' && this.getEscapeStatus(f.getText().substring(0, posInField)) == EscapeStatus.NORMAL) {
                if (posInField == f.getText().length()) {
                    return new CaretPos(pos.index + 1, new CaretPos(0, null));
                }
                return pos;
            }
            f.setText(f.getText().substring(0, posInField) + c + f.getText().substring(posInField));
            return new CaretPos(pos.index, new CaretPos(posInField + 1, null));
        }
        return null;
    }

    public List<? extends PossibleLink> findLinks(Optional<Character> surroundingBracket, Map<String, CodeElement> vars, Function<Integer, JavaFragment.PosInSourceDoc> posCalculator, int offset) {
        int cur;
        ArrayList<? extends PossibleLink> r = new ArrayList<PossibleLink>();
        int beginningSlot = cur = 0;
        int endSlot = cur;
        int endLength = -1;
        String curOperand = "";
        while (cur < this.fields.size()) {
            if (this.fields.get(cur) instanceof ExpressionSlotField) {
                ExpressionSlotField expressionSlotField = (ExpressionSlotField)this.fields.get(cur);
                if (expressionSlotField.getText().equals("class") && curOperand.endsWith(".")) {
                    r.add(new PossibleTypeLink(curOperand.substring(0, curOperand.length() - 1), offset + this.caretPosToStringPos(new CaretPos(beginningSlot, new CaretPos(0, null)), false), offset + this.caretPosToStringPos(new CaretPos(endSlot, new CaretPos(endLength, null)), false), this.getSlot()));
                }
                if (curOperand.equals("")) {
                    beginningSlot = cur;
                }
                curOperand = curOperand + expressionSlotField.getText();
                endSlot = cur;
                endLength = expressionSlotField.getText().length();
                if (cur >= this.operators.size() || this.operators.get(cur) != null) {
                    if (cur < this.operators.size() && ((Operator)this.operators.get(cur)).get().equals(".")) {
                        curOperand = curOperand + ".";
                    } else {
                        CodeElement el;
                        if (cur == this.operators.size() && beginningSlot == 0 && surroundingBracket.isPresent() && surroundingBracket.get().charValue() == '(') {
                            r.add(new PossibleTypeLink(curOperand, offset + this.caretPosToStringPos(new CaretPos(beginningSlot, new CaretPos(0, null)), false), offset + this.caretPosToStringPos(new CaretPos(endSlot, new CaretPos(endLength, null)), false), this.getSlot()));
                        }
                        if (cur == beginningSlot && vars != null && (el = vars.get(curOperand)) != null) {
                            r.add(new PossibleVarLink(curOperand, el, offset + this.caretPosToStringPos(new CaretPos(beginningSlot, new CaretPos(0, null)), false), offset + this.caretPosToStringPos(new CaretPos(endSlot, new CaretPos(endLength, null)), false), this.getSlot()));
                        }
                        curOperand = "";
                    }
                }
            } else if (this.fields.get(cur) instanceof BracketedExpression) {
                ExpressionSlotField prev = (ExpressionSlotField)this.fields.get(cur - 1);
                int innerOffset = 1 + offset + this.caretPosToStringPos(new CaretPos(cur - 1, new CaretPos(prev.getText().length(), null)), false);
                BracketedExpression be = (BracketedExpression)this.fields.get(cur);
                r.addAll(be.getContent().findLinks(Optional.of(Character.valueOf(be.getOpening())), vars, posCalculator, innerOffset));
                if (!curOperand.equals("") && be.getOpening() == '(') {
                    int endSlotFinal = endSlot;
                    r.add(new PossibleMethodUseLink(curOperand.substring(curOperand.indexOf(".") + 1), be.getContent().getSimpleParameters().size(), () -> (JavaFragment.PosInSourceDoc)posCalculator.apply(offset + this.caretPosToStringPos(new CaretPos(endSlotFinal, new CaretPos(0, null)), true)), offset + this.caretPosToStringPos(new CaretPos(endSlot, new CaretPos(0, null)), false), offset + this.caretPosToStringPos(new CaretPos(endSlot, new CaretPos(endLength, null)), false), this.getSlot()));
                }
            }
            ++cur;
        }
        return r;
    }

    public void setEditable(boolean editable) {
        this.fields.forEach(c -> c.setEditable(editable));
    }

    public boolean isNumericLiteral() {
        return this.fields.stream().allMatch(ExpressionSlotComponent::isNumericLiteral);
    }

    private EscapeStatus getEscapeStatus(String text) {
        EscapeStatus status = EscapeStatus.NORMAL;
        for (char c : text.toCharArray()) {
            if (status == EscapeStatus.NORMAL) {
                if (c != '\\') continue;
                status = EscapeStatus.AFTER_BACKSLASH;
                continue;
            }
            if (status != EscapeStatus.AFTER_BACKSLASH) continue;
            status = EscapeStatus.NORMAL;
        }
        return status;
    }

    private CaretPos checkFieldChange(int index, CaretPos pos) {
        return this.checkFieldChange(index, pos, false, false);
    }

    private CaretPos checkFieldChange(int index, CaretPos pos, boolean addedDot, boolean user) {
        if (this.fields.get(index) instanceof StringLiteralExpression) {
            return pos;
        }
        ExpressionSlotField f = (ExpressionSlotField)this.fields.get(index);
        String prevOp = index > 0 && this.operators.get(index - 1) != null ? ((Operator)this.operators.get(index - 1)).get() : "";
        String nextOp = index < this.operators.size() && this.operators.get(index) != null ? ((Operator)this.operators.get(index)).get() : "";
        ExpressionSlotField prevField = index > 0 && this.fields.get(index - 1) instanceof ExpressionSlotField ? (ExpressionSlotField)this.fields.get(index - 1) : null;
        boolean precedingBracket = index > 0 && this.operators.get(index - 1) == null;
        boolean bracketBeforePrevField = index > 1 && prevField != null && this.operators.get(index - 2) == null;
        int dotIndex = -1;
        while ((dotIndex = f.getText().indexOf(46, dotIndex + 1)) != -1) {
            String beforeDot = f.getText().substring(0, dotIndex);
            String afterDot = f.getText().substring(dotIndex + 1);
            boolean isDoubleDot = afterDot.startsWith(".");
            if (InfixExpression.precedesDotInFloatingPointLiteral(beforeDot) && !isDoubleDot) continue;
            f.setText(beforeDot);
            if (isDoubleDot) {
                this.operators.add(index, (Object)new Operator("..", this));
                this.fields.add(index + 1, (Object)this.makeNewField(afterDot.substring(1), false));
            } else {
                boolean wasShowingSuggestions = this.slot != null && this.slot.isShowingSuggestions();
                this.operators.add(index, (Object)new Operator(".", this));
                this.fields.add(index + 1, (Object)this.makeNewField(afterDot, false));
                if (!(beforeDot.equals("") && afterDot.equals("") && addedDot && index >= 2 && this.fields.get(index - 1) instanceof BracketedExpression && this.fields.get(index - 2) instanceof ExpressionSlotField && !((ExpressionSlotField)this.fields.get(index - 2)).getText().equals("") && this.operators.get(index - 2) == null && this.operators.get(index - 1) != null)) {
                    // empty if block
                }
                if (wasShowingSuggestions && user && addedDot) {
                    Platform.runLater(() -> this.slot.showSuggestionDisplay((ExpressionSlotField)this.fields.get(index + 1), 0, false));
                }
            }
            if (pos.index > index) {
                pos = new CaretPos(pos.index + (isDoubleDot ? 2 : 1), pos.subPos);
            } else if (pos.index == index && pos.subPos.index > beforeDot.length()) {
                pos = new CaretPos(index + 1, new CaretPos(pos.subPos.index - (beforeDot.length() + (isDoubleDot ? 2 : 1)), null));
            }
            pos = this.checkFieldChange(index, pos);
            return this.checkFieldChange(index + 1, pos);
        }
        if (InfixExpression.precedesDotInFloatingPointLiteral(f.getText()) && nextOp.equals(".")) {
            int prevLen = f.getText().length();
            f.setText(f.getText() + nextOp + ((ExpressionSlotField)this.fields.get(index + 1)).getText());
            this.operators.remove(index);
            this.fields.remove(index + 1);
            if (pos.index > index + 1) {
                pos = new CaretPos(pos.index - 1, pos.subPos);
            } else if (pos.index == index + 1) {
                pos = new CaretPos(index, new CaretPos(pos.subPos.index + prevLen + 1, null));
            }
            nextOp = index < this.operators.size() && this.operators.get(index) != null ? ((Operator)this.operators.get(index)).get() : "";
        }
        Function<Integer, Integer> findPlusMinus = prev -> {
            int plusIndex = f.getText().indexOf(43, prev + 1);
            int minusIndex = f.getText().indexOf(45, prev + 1);
            if (plusIndex == -1) {
                return minusIndex;
            }
            if (minusIndex == -1) {
                return plusIndex;
            }
            return Math.min(plusIndex, minusIndex);
        };
        int plusMinusIndex = -1;
        while ((plusMinusIndex = findPlusMinus.apply(plusMinusIndex).intValue()) != -1) {
            String before = f.getText().substring(0, plusMinusIndex);
            String after = f.getText().substring(plusMinusIndex + 1);
            boolean atBeginningAndUnary = before.equals("") && !precedingBracket && (!prevOp.equals("") || prevField == null || prevField.getText().equals("")) && this.succeedsOpeningPlusMinusInFloatingPointLiteral(after);
            boolean midwayAfterEorP = this.precedesPlusMinusInFloatingPointLiteral(before);
            if (atBeginningAndUnary || midwayAfterEorP) continue;
            this.operators.add(index, (Object)new Operator(f.getText().substring(plusMinusIndex, plusMinusIndex + 1), this));
            f.setText(before);
            this.fields.add(index + 1, (Object)this.makeNewField(after, false));
            if (pos.index > index) {
                return new CaretPos(pos.index + 1, pos.subPos);
            }
            if (pos.index == index) {
                if (pos.subPos.index <= before.length()) {
                    return pos;
                }
                return new CaretPos(index + 1, new CaretPos(pos.subPos.index - (before.length() + 1), null));
            }
            return pos;
        }
        if (this.precedesPlusMinusInFloatingPointLiteral(f.getText()) && (nextOp.equals("+") || nextOp.equals("-"))) {
            int prevLen = f.getText().length();
            f.setText(f.getText() + nextOp + ((ExpressionSlotField)this.fields.get(index + 1)).getText());
            this.operators.remove(index);
            this.fields.remove(index + 1);
            if (pos.index > index + 1) {
                pos = new CaretPos(pos.index - 1, pos.subPos);
            } else if (pos.index == index + 1) {
                pos = new CaretPos(index, new CaretPos(pos.subPos.index + prevLen + 1, null));
            }
        }
        if ((prevOp.equals("+") || prevOp.equals("-")) && this.succeedsOpeningPlusMinusInFloatingPointLiteral(f.getText()) && prevField != null && prevField.getText().equals("") && !bracketBeforePrevField) {
            this.operators.remove(index - 1);
            this.fields.remove(index - 1);
            f.setText(prevOp + f.getText());
            pos = new CaretPos(pos.index - 1, new CaretPos(pos.subPos.index + 1, null));
        }
        return pos;
    }

    private boolean precedesPlusMinusInFloatingPointLiteral(String before) {
        return before.matches("\\A\\s*0x[0-9A-Fa-f]([0-9A-Fa-f_]*[0-9A-Fa-f])?(\\.([0-9A-Fa-f]([0-9A-Fa-f_]*[0-9A-Fa-f])?)?)?[pP]\\z") || before.matches("\\A\\s*[+-]?\\d([0-9_]*\\d)?(\\.(\\d([0-9_]*\\d)?)?)?[eE]\\z");
    }

    private boolean succeedsOpeningPlusMinusInFloatingPointLiteral(String after) {
        return after.matches("\\A\\d.*");
    }

    public void focusAtStart() {
        this.getFirstField().focusAtStart();
    }

    public void focusAtEnd() {
        this.getLastField().focusAtEnd();
    }

    public CaretPos getStartPos() {
        return new CaretPos(0, this.getFirstField().getStartPos());
    }

    public CaretPos getEndPos() {
        return new CaretPos(this.fields.size() - 1, this.getLastField().getEndPos());
    }

    public void end() {
        this.getLastField().focusAtEnd();
    }

    public ObservableList<Node> getComponents() {
        return this.components;
    }

    public boolean isEmpty() {
        return this.fields.size() == 1 && this.getFirstField().isEmpty();
    }

    public void requestFocus() {
        this.getFirstField().requestFocus();
    }

    void setPromptText(BiConsumer<List<ExpressionSlotComponent>, List<Operator>> setPrompts) {
        ListChangeListener listener = a -> Platform.runLater(() -> setPrompts.accept((List<ExpressionSlotComponent>)this.fields, (List<Operator>)this.operators));
        this.fields.addListener(listener);
        this.operators.addListener(listener);
        setPrompts.accept((List<ExpressionSlotComponent>)this.fields, (List<Operator>)this.operators);
    }

    Region getNodeForPos(CaretPos pos) {
        ExpressionSlotComponent f = (ExpressionSlotComponent)this.fields.get(pos.index);
        return f.getNodeForPos(pos.subPos);
    }

    List<CaretPosMap> mapCaretPosStringPos(IntCounter cur, boolean javaString) {
        ArrayList<CaretPosMap> r = new ArrayList<CaretPosMap>();
        BiConsumer<Integer, Integer> addForRange = (startIncl, endExcl) -> {
            for (int i = startIncl.intValue(); i < endExcl; ++i) {
                Operator op;
                for (CaretPosMap cpm : ((ExpressionSlotComponent)this.fields.get(i)).mapCaretPosStringPos(cur, javaString)) {
                    r.add(cpm.wrap(i));
                }
                if (i >= this.operators.size() || i >= endExcl - 1 || (op = (Operator)this.operators.get(i)) == null) continue;
                cur.counter = cur.counter + (javaString ? op.getJavaCode().length() : op.get().length());
            }
        };
        if (!javaString) {
            addForRange.accept(0, this.fields.size());
        } else {
            int closing = 0;
            int last = 0;
            for (int i = 0; i < this.fields.size(); ++i) {
                if (i >= this.operators.size() || this.operators.get(i) == null) continue;
                String op = ((Operator)this.operators.get(i)).get();
                int commaLength = ", ".length();
                if (op.equals("..")) {
                    cur.counter += (lang.stride.Utility.class.getName() + ".makeRange(").length();
                    addForRange.accept(last, i + 1);
                    cur.counter += commaLength;
                    last = i + 1;
                    ++closing;
                    continue;
                }
                if (!op.equals(",")) continue;
                addForRange.accept(last, i + 1);
                cur.counter += closing + commaLength;
                closing = 0;
                last = i + 1;
            }
            addForRange.accept(last, this.fields.size());
            cur.counter += closing;
        }
        return r;
    }

    CaretPos stringPosToCaretPos(int pos, boolean javaString) {
        List<CaretPosMap> mapping = this.mapCaretPosStringPos(new IntCounter(), javaString);
        for (CaretPosMap cpm : mapping) {
            if (pos > cpm.endIndex) continue;
            if (pos >= cpm.startIndex || javaString) {
                return cpm.posOuter.append(new CaretPos(Math.max(0, pos - cpm.startIndex), null));
            }
            return null;
        }
        Debug.message("Could not find position for: " + pos);
        return null;
    }

    int caretPosToStringPos(CaretPos pos, boolean javaString) {
        List<CaretPosMap> mapping = this.mapCaretPosStringPos(new IntCounter(), javaString);
        for (CaretPosMap cpm : mapping) {
            Optional<Integer> i = pos.getFollowing(cpm.posOuter);
            if (!i.isPresent()) continue;
            return i.get() + cpm.startIndex;
        }
        throw new IllegalStateException();
    }

    double getBaseline() {
        TextField field = (TextField)this.components.get(0);
        double height = field.getHeight() - 3.0 - field.getPadding().getBottom();
        if (field.getBorder() != null && field.getBorder().getInsets() != null) {
            height -= field.getBorder().getInsets().getBottom();
        }
        return height;
    }

    public void blank() {
        this.operators.clear();
        this.fields.clear();
        this.fields.add((Object)this.makeNewField("", false));
        this.anchorPos = null;
    }

    public boolean isFocused() {
        return this.fields.stream().anyMatch(ExpressionSlotComponent::isFocused);
    }

    public boolean isCollapsible(ExpressionSlotField f) {
        boolean unaryAfter;
        int index = this.findField(f);
        if (index == -1) {
            return false;
        }
        boolean opBefore = index == 0 || this.operators.get(index - 1) != null;
        boolean opAfter = index == this.operators.size() || this.operators.get(index) != null;
        boolean bl = unaryAfter = index < this.operators.size() && Operator.canBeUnary(Utility.orNull(this.operators.get(index), Operator::get));
        if (this.fields.size() == 1 && this.parent == null) {
            return this.slot != null && this.slot.isConstructorParams();
        }
        if (this.fields.size() == 1 && this.parent != null) {
            return true;
        }
        if (opBefore && opAfter) {
            return unaryAfter;
        }
        return true;
    }

    public void insertNext(BracketedExpression bracketedExpression, String text) {
        int index = this.fields.indexOf((Object)bracketedExpression);
        this.insert((ExpressionSlotField)this.fields.get(index + 1), 0, text);
    }

    public void replaceContent(CaretPos start, CaretPos end, String insertion) {
        this.anchorPos = end;
        this.deleteSelection_(start);
        this.insertAtPos(start, insertion);
    }

    String testingGetState(CaretPos caret) {
        caret = Utility.orNull(caret, CaretPos::normalise);
        StringBuilder r = new StringBuilder();
        for (int i = 0; i < this.fields.size(); ++i) {
            r.append(((ExpressionSlotComponent)this.fields.get(i)).testingGetState(caret != null && i == caret.index ? caret.subPos : null));
            if (i >= this.operators.size()) continue;
            if (this.operators.get(i) == null) {
                r.append("_");
                continue;
            }
            r.append(((Operator)this.operators.get(i)).get());
        }
        return r.toString();
    }

    CaretPos testingInsert(String text, char rememberPos) {
        int index = text.indexOf(rememberPos);
        if (rememberPos != '\u0000' && index != -1) {
            String before = text.substring(0, index);
            String after = text.substring(index + 1);
            CaretPos p = this.insert_((ExpressionSlotField)this.fields.get(0), 0, before, false);
            this.testingInsert(p, after);
            return p;
        }
        return this.insert_((ExpressionSlotField)this.fields.get(0), 0, text, false);
    }

    CaretPos testingInsert(CaretPos p, String after) {
        return this.insertAtPos(p, after);
    }

    CaretPos testingBackspace(CaretPos p) {
        ExpressionSlotComponent f = (ExpressionSlotComponent)this.fields.get(p.index);
        if (f instanceof ExpressionSlotField) {
            return this.deletePrevious_((ExpressionSlotField)this.fields.get(p.index), p.subPos.index, p.subPos.index == 0);
        }
        if (f instanceof StringLiteralExpression) {
            return this.deletePrevious_(((StringLiteralExpression)this.fields.get(p.index)).getField(), p.subPos.index, p.subPos.index == 0);
        }
        return new CaretPos(p.index, ((BracketedExpression)this.fields.get(p.index)).testingContent().testingBackspace(p.subPos));
    }

    CaretPos testingDelete(CaretPos p) {
        ExpressionSlotField f;
        ExpressionSlotComponent s = (ExpressionSlotComponent)this.fields.get(p.index);
        if (s instanceof ExpressionSlotField) {
            f = (ExpressionSlotField)this.fields.get(p.index);
        } else if (s instanceof StringLiteralExpression) {
            f = ((StringLiteralExpression)this.fields.get(p.index)).getField();
        } else {
            return new CaretPos(p.index, ((BracketedExpression)this.fields.get(p.index)).testingContent().testingDelete(p.subPos));
        }
        return this.deleteNext_(f, p.subPos.index, p.subPos.index == f.getText().length());
    }

    CaretPos testingDeleteSelection(CaretPos start, CaretPos end) {
        this.anchorPos = start;
        return this.deleteSelection_(end);
    }

    CaretPos testingInsertWithSelection(CaretPos start, CaretPos end, char c) {
        this.anchorPos = start;
        return this.insertAtPos(end, "" + c);
    }

    public void insertSuggestion(CaretPos p, String name, List<String> params) {
        ExpressionSlotComponent f = (ExpressionSlotComponent)this.fields.get(p.index);
        if (f instanceof ExpressionSlotField) {
            ((ExpressionSlotField)f).setText("");
            p = this.insert_((ExpressionSlotField)f, 0, name, false);
            if (params != null) {
                StringBuilder commas = new StringBuilder();
                for (int i = 0; i < params.size() - 1; ++i) {
                    commas.append(',');
                }
                if (p.index + 1 < this.fields.size() && this.fields.get(p.index + 1) instanceof BracketedExpression) {
                    BracketedExpression b = (BracketedExpression)this.fields.get(p.index + 1);
                    if (b.getContent().isEmpty()) {
                        b.getContent().insertAtPos(new CaretPos(0, new CaretPos(0, null)), commas.toString());
                    }
                    Platform.runLater(() -> b.focusAtStart());
                } else {
                    this.insertAtPos(new CaretPos(p.index, new CaretPos(p.subPos.index, null)), "(" + commas.toString() + ")");
                    ExpressionSlotComponent focusField = (ExpressionSlotComponent)this.fields.get(params.isEmpty() ? p.index + 2 : p.index + 1);
                    Platform.runLater(() -> focusField.focusAtStart());
                }
            }
        } else {
            f.insertSuggestion(p.subPos, name, params);
        }
    }

    public void withTooltipFor(ExpressionSlotField expressionSlotField, FXConsumer<String> handler) {
        int slotIndex = this.fields.indexOf((Object)expressionSlotField);
        if (!expressionSlotField.getText().equals("") && slotIndex + 1 < this.fields.size() && this.fields.get(slotIndex + 1) instanceof BracketedExpression) {
            CaretPos relPos = new CaretPos(slotIndex, new CaretPos(0, null));
            this.slot.withMethodHint(this.absolutePos(relPos), ((ExpressionSlotComponent)this.fields.get(slotIndex)).getCopyText(null, null), methodHints -> {
                if (methodHints.size() == 1) {
                    handler.accept((String)methodHints.get(0));
                } else {
                    handler.accept("");
                }
            });
        } else if (this.parent != null || this.slot.isConstructorParams()) {
            int paramIndex = 0;
            int totalParams = 1;
            for (int i = 0; i < this.operators.size(); ++i) {
                if (this.operators.get(i) == null || !((Operator)this.operators.get(i)).getCopyText().equals(",")) continue;
                ++totalParams;
                if (i >= slotIndex) continue;
                ++paramIndex;
            }
            if (this.parent != null) {
                this.parent.withTooltipAtPos(paramIndex, handler);
            } else {
                int finalParamIndex = paramIndex;
                this.slot.withParamHintsForConstructor(totalParams, conHints -> {
                    if (conHints.size() == 1 && finalParamIndex < ((List)conHints.get(0)).size()) {
                        handler.accept((String)((List)conHints.get(0)).get(finalParamIndex));
                    }
                });
            }
        } else {
            handler.accept("");
        }
    }

    public void withTooltipForParam(BracketedExpression bracketedExpression, int paramPos, FXConsumer<String> handler) {
        int expIndex = this.fields.indexOf((Object)bracketedExpression);
        if (((ExpressionSlotComponent)this.fields.get(expIndex - 1)).getCopyText(null, null).equals("")) {
            handler.accept("");
        } else {
            CaretPos relPos = new CaretPos(expIndex - 1, new CaretPos(0, null));
            this.slot.withParamHintsForPos(this.absolutePos(relPos), ((ExpressionSlotComponent)this.fields.get(expIndex - 1)).getCopyText(null, null), paramHints -> {
                if (paramHints.size() == 1 && paramPos < ((List)paramHints.get(0)).size()) {
                    handler.accept((String)((List)paramHints.get(0)).get(paramPos));
                    return;
                }
                handler.accept("");
            });
        }
    }

    private CaretPos absolutePos(CaretPos p) {
        if (this.parent == null) {
            return p;
        }
        return this.parent.absolutePos(p);
    }

    public CaretPos absolutePos(BracketedExpression bracketedExpression, CaretPos p) {
        return this.absolutePos(new CaretPos(this.fields.indexOf((Object)bracketedExpression), p));
    }

    InteractionManager getEditor() {
        return this.editor;
    }

    void queueUpdatePromptsInMethodCalls() {
        if (!this.queuedUpdatePrompts) {
            this.queuedUpdatePrompts = true;
            Platform.runLater(this::updatePromptsInMethodCalls);
        }
    }

    private void updatePromptsInMethodCalls() {
        this.queuedUpdatePrompts = false;
        for (int i = 0; i < this.fields.size(); ++i) {
            if (i >= this.fields.size() - 1 || !(this.fields.get(i) instanceof ExpressionSlotField) || ((ExpressionSlotComponent)this.fields.get(i)).isFieldAndEmpty() || !(this.fields.get(i + 1) instanceof BracketedExpression)) continue;
            BracketedExpression bracketedParams = (BracketedExpression)this.fields.get(i + 1);
            CaretPos absPos = this.absolutePos(new CaretPos(i, new CaretPos(0, null)));
            bracketedParams.getContent().treatAsParams_updatePrompts(((ExpressionSlotComponent)this.fields.get(i)).getCopyText(null, null), absPos);
        }
    }

    void treatAsParams_updatePrompts(String methodName, CaretPos absPosOfMethodName) {
        List<ExpressionSlotField> params = this.getSimpleParameters();
        if (params.stream().allMatch(p -> p == null)) {
            return;
        }
        if (this.slot == null) {
            return;
        }
        this.slot.withParamNamesForPos(absPosOfMethodName, methodName, poss -> this.setPromptsFromParamNames((List<List<String>>)poss, methodName));
    }

    void treatAsConstructorParams_updatePrompts() {
        List<ExpressionSlotField> params = this.getSimpleParameters();
        if (params.stream().allMatch(p -> p == null)) {
            return;
        }
        this.slot.withParamNamesForConstructor(poss -> this.setPromptsFromParamNames((List<List<String>>)poss, "<con>"));
    }

    private void setPromptsFromParamNames(List<List<String>> possibilities, String debugName) {
        List<ExpressionSlotField> curParams = this.getSimpleParameters();
        int curArity = curParams.size() == 1 && curParams.get(0).isEmpty() ? 0 : curParams.size();
        boolean arityFlexible = curParams.stream().allMatch(f -> f != null && f.isEmpty());
        List matchedPoss = possibilities.stream().filter(ps -> arityFlexible || ps.size() == curArity).sorted(Comparator.comparing(List::size)).collect(Collectors.toList());
        if (matchedPoss.size() != 1) {
            if (arityFlexible && !this.isEmpty()) {
                this.blank();
            }
            curParams.stream().filter(f -> f != null).forEach(f -> f.setPromptText(""));
        } else {
            List match = (List)matchedPoss.get(0);
            if (arityFlexible && match.size() != curArity) {
                boolean wasFocused = this.isFocused();
                this.blank();
                for (int i = 0; i < match.size() - 1; ++i) {
                    this.insertChar(this.getEndPos(), ',', false);
                }
                curParams = this.getSimpleParameters();
                if (wasFocused) {
                    this.getFirstField().requestFocus();
                }
            }
            for (int i = 0; i < match.size(); ++i) {
                String prompt = (String)match.get(i);
                if (prompt == null || Parser.isDummyName(prompt)) {
                    prompt = "";
                }
                if (i >= curParams.size() || curParams.get(i) == null) continue;
                curParams.get(i).setPromptText(prompt);
            }
        }
    }

    public List<ExpressionSlotField> getSimpleParameters() {
        ArrayList<ExpressionSlotField> r = new ArrayList<ExpressionSlotField>();
        int lastComma = -1;
        for (int i = 0; i < this.fields.size(); ++i) {
            ExpressionSlotField f;
            ExpressionSlotField expressionSlotField = f = this.fields.get(i) instanceof ExpressionSlotField ? (ExpressionSlotField)this.fields.get(i) : null;
            if (i != this.fields.size() - 1 && (this.operators.get(i) == null || !((Operator)this.operators.get(i)).getCopyText().equals(","))) continue;
            if (lastComma == i - 1 && f != null) {
                r.add(f);
            } else {
                r.add(null);
            }
            lastComma = i;
        }
        return r;
    }

    @Override
    public void clicked() {
        this.slot.hideSuggestionDisplay();
    }

    @Override
    public void caretMoved() {
        if (this.slot != null) {
            this.slot.caretMoved();
        }
    }

    @Override
    public void escape() {
        this.slot.escape();
    }

    public void bindClosingChar(EditableSlot anotherSlot, char closingChar) {
        this.closingChars.add(Character.valueOf(closingChar));
        this.bindedSlot = anotherSlot;
    }

    public Stream<InfixExpression> getAllExpressions() {
        return Stream.concat(Stream.of(this), this.fields.stream().flatMap(ExpressionSlotComponent::getAllExpressions));
    }

    public StringExpression textProperty() {
        return this.textProperty;
    }

    public TextOverlayPosition calculateOverlayEnd() {
        return this.getLastField().calculateOverlayEnd();
    }

    List<ExpressionSlot.PlainVarReference> findPlainVarUse(String name) {
        ArrayList<ExpressionSlot.PlainVarReference> refs = new ArrayList<ExpressionSlot.PlainVarReference>();
        for (int i = 0; i < this.fields.size(); ++i) {
            if (this.fields.get(i) instanceof ExpressionSlotField) {
                ExpressionSlotField f = (ExpressionSlotField)this.fields.get(i);
                if (!f.getText().equals(name) || i != 0 && this.operators.get(i - 1) != null && ((Operator)this.operators.get(i - 1)).get().equals(".") || i != this.fields.size() - 1 && this.fields.get(i) instanceof BracketedExpression && ((BracketedExpression)this.fields.get(i)).getOpening() == '(') continue;
                refs.add(new ExpressionSlot.PlainVarReference(f::setText, f.getNodeForPos(null)));
                continue;
            }
            if (!(this.fields.get(i) instanceof BracketedExpression)) continue;
            refs.addAll(((BracketedExpression)this.fields.get(i)).getContent().findPlainVarUse(name));
        }
        return refs;
    }

    public boolean isCurlyLiteral() {
        if (this.fields.size() != 3) {
            return false;
        }
        if (this.operators.get(0) != null || this.operators.get(1) != null) {
            return false;
        }
        if (!((ExpressionSlotComponent)this.fields.get(0)).isFieldAndEmpty() || !((ExpressionSlotComponent)this.fields.get(2)).isFieldAndEmpty()) {
            return false;
        }
        if (!(this.fields.get(1) instanceof BracketedExpression)) {
            return false;
        }
        BracketedExpression e = (BracketedExpression)this.fields.get(1);
        return e.getOpening() == '{';
    }

    void showHighlightedBrackets(BracketedExpression wrapper, CaretPos pos) {
        if (wrapper != null && pos != null && pos.index == 0 && ((ExpressionSlotComponent)this.fields.get(0)).getStartPos().equals(pos.subPos)) {
            wrapper.highlightBrackets(true);
        } else if (wrapper != null && pos != null && pos.index == this.fields.size() - 1 && ((ExpressionSlotComponent)this.fields.get(this.fields.size() - 1)).getEndPos().equals(pos.subPos)) {
            wrapper.highlightBrackets(true);
        }
        for (int i = 0; i < this.fields.size(); ++i) {
            ExpressionSlotComponent f = (ExpressionSlotComponent)this.fields.get(i);
            if (!(f instanceof BracketedExpression)) continue;
            boolean cursorBefore = i > 0 && pos != null && pos.index == i - 1 && this.fields.get(i - 1) instanceof ExpressionSlotField && ((ExpressionSlotComponent)this.fields.get(i - 1)).getEndPos().equals(pos.subPos);
            boolean cursorAfter = i < this.fields.size() - 1 && pos != null && pos.index == i + 1 && this.fields.get(i + 1) instanceof ExpressionSlotField && ((ExpressionSlotComponent)this.fields.get(i + 1)).getStartPos().equals(pos.subPos);
            BracketedExpression e = (BracketedExpression)f;
            e.highlightBrackets(cursorBefore || cursorAfter);
            e.getContent().showHighlightedBrackets(e, pos != null && pos.index == i ? pos.subPos : null);
        }
    }

    public void setView(Frame.View oldView, Frame.View newView, SharedTransition animate, Optional<String> forLoopVarName) {
        this.fields.forEach(f -> f.setView(oldView, newView, animate));
        this.operators.forEach(o -> {
            if (o != null) {
                o.setView(newView, animate);
            }
        });
        if (newView == Frame.View.NORMAL) {
            this.previewingJavaRange.set(false);
        } else {
            switch (this.checkRangeExpression()) {
                case RANGE_CONSTANT: {
                    if (forLoopVarName.isPresent()) {
                        Operator rangeOp = this.operators.stream().filter(op -> op != null && op.get().equals("..")).findFirst().get();
                        this.previewingJavaRange.set(true);
                        this.startRangeText.set((Object)"");
                        this.endRangeText.set((Object)("; " + forLoopVarName.get() + "++"));
                        rangeOp.setJavaPreviewRangeOverride("; " + forLoopVarName.get() + " <=");
                        break;
                    }
                }
                case RANGE_NON_CONSTANT: {
                    this.previewingJavaRange.set(true);
                    this.startRangeText.set((Object)(lang.stride.Utility.class.getName() + "("));
                    this.endRangeText.set((Object)")");
                    break;
                }
                default: {
                    this.previewingJavaRange.set(false);
                }
            }
        }
    }

    RangeType checkRangeExpression() {
        if (this.operators.stream().anyMatch(op -> op != null && op.get().equals(","))) {
            return RangeType.NOT_RANGE;
        }
        Optional<Operator> rangeOp = this.operators.stream().filter(op -> op != null && op.get().equals("..")).findFirst();
        if (!rangeOp.isPresent()) {
            return RangeType.NOT_RANGE;
        }
        if (this.fields.stream().allMatch(ExpressionSlotComponent::isNumericLiteral)) {
            return RangeType.RANGE_CONSTANT;
        }
        return RangeType.RANGE_NON_CONSTANT;
    }

    void paste() {
        ExpressionSlotField focused = this.fields.stream().filter(f -> f instanceof ExpressionSlotField && f.isFocused()).map(f -> (ExpressionSlotField)f).findFirst().orElse(null);
        if (focused != null) {
            focused.paste();
        }
    }

    ExpressionSlot<?> getSlot() {
        return this.slot;
    }

    public boolean suggestingFor(ExpressionSlotField f) {
        if (this.slot == null) {
            return false;
        }
        int index = this.findField(f);
        CaretPos fieldPos = this.absolutePos(new CaretPos(index, null));
        return this.slot.suggestingFor(fieldPos);
    }

    public ExpressionSlot.SplitInfo trySplitOn(String target) {
        for (int i = 0; i < this.operators.size(); ++i) {
            Operator op = (Operator)this.operators.get(i);
            if (op == null || !op.get().equals(target)) continue;
            return new ExpressionSlot.SplitInfo(this.getCopyText(null, new CaretPos(i, ((ExpressionSlotComponent)this.fields.get(i)).getEndPos())), this.getCopyText(new CaretPos(i + 1, ((ExpressionSlotComponent)this.fields.get(i + 1)).getStartPos()), null));
        }
        return null;
    }

    public boolean isAlmostBlank() {
        return this.fields.stream().allMatch(ExpressionSlotComponent::isAlmostBlank);
    }

    public void notifyLostFocus(ExpressionSlotField except) {
        this.fields.forEach(f -> {
            if (f != except) {
                f.notifyLostFocus(except);
            }
        });
    }

    boolean isInSelection() {
        return this.anchorPos != null || this.parent != null && this.parent.isInSelection();
    }

    static class IntCounter {
        public int counter = 0;

        IntCounter() {
        }
    }

    static class CaretPosMap {
        private final CaretPos posOuter;
        private final int startIndex;
        private final int endIndex;

        CaretPosMap(CaretPos posOuter, int startIndex, int endIndex) {
            this.posOuter = posOuter;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }

        public CaretPosMap wrap(int index) {
            return new CaretPosMap(new CaretPos(index, this.posOuter), this.startIndex, this.endIndex);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CaretPosMap other = (CaretPosMap)obj;
            if (this.endIndex != other.endIndex) {
                return false;
            }
            if (this.posOuter == null ? other.posOuter != null : !this.posOuter.equals(other.posOuter)) {
                return false;
            }
            return this.startIndex == other.startIndex;
        }

        public String toString() {
            return "CaretPosMap [posOuter=" + this.posOuter + ", startIndex=" + this.startIndex + ", endIndex=" + this.endIndex + "]";
        }
    }

    static enum RangeType {
        RANGE_CONSTANT,
        RANGE_NON_CONSTANT,
        NOT_RANGE;

    }

    private static enum EscapeStatus {
        NORMAL,
        AFTER_BACKSLASH;

    }
}

