/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.slots;

import bluej.Config;
import bluej.editor.stride.CodeOverlayPane;
import bluej.editor.stride.FrameCatalogue;
import bluej.stride.framedjava.ast.ExpressionSlotFragment;
import bluej.stride.framedjava.ast.JavaFragment;
import bluej.stride.framedjava.ast.SuperThis;
import bluej.stride.framedjava.ast.links.PossibleLink;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.errors.CodeError;
import bluej.stride.framedjava.errors.ErrorAndFixDisplay;
import bluej.stride.framedjava.frames.CodeFrame;
import bluej.stride.framedjava.slots.BracketedExpression;
import bluej.stride.framedjava.slots.CaretPos;
import bluej.stride.framedjava.slots.ExpressionCompletionCalculator;
import bluej.stride.framedjava.slots.ExpressionSlotField;
import bluej.stride.framedjava.slots.InfixExpression;
import bluej.stride.framedjava.slots.Operator;
import bluej.stride.framedjava.slots.TextOverlayPosition;
import bluej.stride.framedjava.slots.UnderlineContainer;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameContentRow;
import bluej.stride.generic.InteractionManager;
import bluej.stride.slots.ChoiceSlot;
import bluej.stride.slots.EditableSlot;
import bluej.stride.slots.Focus;
import bluej.stride.slots.FocusParent;
import bluej.stride.slots.HeaderItem;
import bluej.stride.slots.SlotLabel;
import bluej.stride.slots.SuggestionList;
import bluej.utility.Debug;
import bluej.utility.Utility;
import bluej.utility.javafx.ErrorUnderlineCanvas;
import bluej.utility.javafx.FXConsumer;
import bluej.utility.javafx.FXRunnable;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.SharedTransition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.binding.StringExpression;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.input.Clipboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;

public abstract class ExpressionSlot<SLOT_FRAGMENT extends ExpressionSlotFragment>
implements EditableSlot,
ErrorAndFixDisplay.ErrorFixListener,
SuggestionList.SuggestionListListener {
    private final ErrorUnderlineCanvas overlay;
    private final Frame parentFrame;
    private final CodeFrame<?> parentCodeFrame;
    private final FrameContentRow row;
    private final List<CodeError> allErrors = new ArrayList<CodeError>();
    private final List<CodeError> shownErrors = new ArrayList<CodeError>();
    private ErrorAndFixDisplay errorAndFixDisplay;
    private CodeError hoverErrorCurrentlyShown;
    private SLOT_FRAGMENT slotElement;
    private final InfixExpression topLevel;
    private final InteractionManager editor;
    private final List<UnderlineContainer.Underline> underlines = new ArrayList<UnderlineContainer.Underline>();
    private final ExpressionCompletionCalculator completionCalculator;
    private SuggestionList suggestionDisplay;
    private Region suggestionNode;
    private List<InteractionManager.FileCompletion> fileCompletions;
    private Map<KeyCode, Runnable> fileCompletionShortcuts;
    private StringExpression targetType;
    private boolean beenModified = false;
    private final StringProperty textMirror = new SimpleStringProperty("");
    private List<TextOverlayPosition> selectionDrawPositions;
    private boolean modifyQueued = false;
    private final List<FXRunnable> lostFocusActions = new ArrayList<FXRunnable>();
    private CaretPos suggestionLocation;
    private ExpressionSlotField suggestionField;
    private final SimpleBooleanProperty fakeCaretShowing = new SimpleBooleanProperty(false);
    private final List<FrameCatalogue.Hint> hints;
    private final ObservableList<String> recentValues = FXCollections.observableArrayList();
    private CaretPos mostRecentPos;
    private boolean hadFocus;
    private String valueOnGain;
    private boolean editable = true;
    private ChoiceSlot<SuperThis> paramsToConstructor;

    public ExpressionSlot(InteractionManager editor, Frame parentFrame, CodeFrame<?> parentCodeFrame, FrameContentRow row, String stylePrefix, List<FrameCatalogue.Hint> hints) {
        this.editor = editor;
        this.parentFrame = parentFrame;
        this.parentCodeFrame = parentCodeFrame;
        this.row = row;
        this.completionCalculator = new ExpressionCompletionCalculator(editor);
        this.hints = hints;
        this.topLevel = new InfixExpression(editor, this, stylePrefix);
        this.textMirror.bind((ObservableValue)this.topLevel.textProperty());
        this.textMirror.addListener((a, b, c) -> {
            if (!this.modifyQueued && !editor.isLoading()) {
                this.modifyQueued = true;
                Platform.runLater(() -> {
                    this.modified();
                    this.modifyQueued = false;
                });
            } else if (editor.isLoading()) {
                parentFrame.trackBlank();
            }
        });
        this.overlay = row.getOverlay();
        this.overlay.addExtraRedraw(gc -> {
            gc.save();
            if (this.selectionDrawPositions != null && !this.selectionDrawPositions.isEmpty()) {
                gc.setFill(editor.getHighlightColor());
                for (TextOverlayPosition.Line l : TextOverlayPosition.groupIntoLines(this.selectionDrawPositions)) {
                    l.transform(this.overlay::sceneToLocal);
                    gc.fillRect(l.startX + 1.0, l.topY, l.endX - l.startX, l.bottomY - l.topY);
                }
            }
            if (this.fakeCaretShowing.get()) {
                gc.setStroke((Paint)Color.BLACK);
                double x = this.overlay.sceneToLocal(this.topLevel.calculateOverlayPos(this.suggestionLocation).getSceneX(), 0.0).getX();
                gc.strokeLine(x, 0.0, x, this.suggestionField.heightProperty().get());
            }
            gc.restore();
        });
        JavaFXUtil.addChangeListener(this.fakeCaretShowing, b -> this.overlay.redraw());
    }

    @Override
    public void flagErrorsAsOld() {
        this.allErrors.forEach(CodeError::flagAsOld);
    }

    @Override
    public void removeOldErrors() {
        this.allErrors.removeIf(CodeError::isFlaggedAsOld);
        this.recalculateShownErrors();
    }

    private void recalculateShownErrors() {
        this.shownErrors.clear();
        List<CodeError> sortedErrors = this.allErrors.stream().sorted((a, b) -> CodeError.compareErrors(a, b)).collect(Collectors.toList());
        sortedErrors.forEach(e -> {
            if (this.shownErrors.stream().allMatch(shown -> !shown.overlaps((CodeError)e))) {
                this.shownErrors.add((CodeError)e);
            }
        });
        this.clearErrorMarkers();
        this.shownErrors.forEach(e -> this.drawErrorMarker(e.getStartPosition(), e.getEndPosition(), e.isJavaPos(), b -> this.showErrorHover(b != false ? e : null), e.visibleProperty()));
        CaretPos curPos = this.topLevel.getCurrentPos();
        if (curPos != null) {
            this.showErrorAtCaret(curPos);
        }
    }

    private void showErrorHover(CodeError error) {
        if (this.errorAndFixDisplay != null) {
            if (error != null && this.errorAndFixDisplay.getError().equals(error)) {
                this.hoverErrorCurrentlyShown = error;
                return;
            }
            CaretPos caretPos = this.topLevel.getCurrentPos();
            if (caretPos != null) {
                int caretPosition = this.topLevel.caretPosToStringPos(caretPos, true);
                Optional<CodeError> errorAtCaret = this.shownErrors.stream().filter(e -> e.getStartPosition() <= caretPosition && caretPosition <= e.getEndPosition()).findFirst();
                if (error == null && errorAtCaret.isPresent() && errorAtCaret.get().equals(this.errorAndFixDisplay.getError())) {
                    this.hoverErrorCurrentlyShown = null;
                    return;
                }
            }
            this.errorAndFixDisplay.hide();
            this.errorAndFixDisplay = null;
        }
        if (error != null && error.visibleProperty().get()) {
            this.hoverErrorCurrentlyShown = error;
            this.errorAndFixDisplay = new ErrorAndFixDisplay(this.editor, error, this);
            this.errorAndFixDisplay.showBelow((Region)error.getRelevantNode(), Duration.ZERO);
        }
    }

    private void showErrorAtCaret(CaretPos curPos) {
        if (curPos == null) {
            if (this.errorAndFixDisplay != null) {
                this.errorAndFixDisplay.hide();
                this.errorAndFixDisplay = null;
            }
            return;
        }
        int caretPosition = this.topLevel.caretPosToStringPos(curPos, true);
        Optional<CodeError> errorAtCaret = this.shownErrors.stream().filter(e -> e.getStartPosition() <= caretPosition && caretPosition <= e.getEndPosition()).findFirst();
        if (errorAtCaret.isPresent() && this.errorAndFixDisplay != null && this.errorAndFixDisplay.getError().equals(errorAtCaret.get())) {
            return;
        }
        if (this.errorAndFixDisplay != null) {
            this.errorAndFixDisplay.hide();
            this.errorAndFixDisplay = null;
        }
        if (errorAtCaret.isPresent() && errorAtCaret.get().visibleProperty().get()) {
            this.errorAndFixDisplay = new ErrorAndFixDisplay(this.editor, errorAtCaret.get(), this);
            this.errorAndFixDisplay.showBelow(this.topLevel.getNodeForPos(curPos));
        }
    }

    @Override
    public void addError(CodeError err) {
        this.allErrors.add(err);
        err.bindFresh(this.getParentFrame().freshProperty());
        this.recalculateShownErrors();
    }

    @Override
    public void fixedError(CodeError err) {
        this.allErrors.remove(err);
        this.recalculateShownErrors();
    }

    public void drawErrorMarker(int startPos, int endPos, boolean javaPos, FXConsumer<Boolean> onHover, ObservableBooleanValue visible) {
        if (startPos == 0 && endPos == 0 || this.getText().length() == 0) {
            this.overlay.addErrorMarker(this, 0, Integer.MAX_VALUE, false, onHover, visible);
        } else {
            this.overlay.addErrorMarker(this, startPos, endPos, javaPos, onHover, visible);
        }
    }

    public void setText(ExpressionSlotFragment rhs) {
        rhs.registerSlot(this);
        this.setText(rhs.getContent());
    }

    protected abstract SLOT_FRAGMENT makeSlotFragment(String var1, String var2);

    public SLOT_FRAGMENT getSlotElement() {
        if (this.slotElement == null || this.beenModified) {
            this.slotElement = this.makeSlotFragment(this.getText(), this.getJavaCode());
            this.beenModified = false;
        }
        return this.slotElement;
    }

    public void clearErrorMarkers() {
        this.overlay.clearErrorMarkers(this);
    }

    public void setSimplePromptText(String t) {
        this.topLevel.setPromptText((fields, ops) -> {
            if (ops.isEmpty() && fields.size() == 1 && fields.get(0) instanceof ExpressionSlotField) {
                ((ExpressionSlotField)fields.get(0)).setPromptText(t);
            } else if (fields.size() > 0) {
                ((ExpressionSlotField)fields.get(0)).setPromptText("");
            }
        });
    }

    public void setMethodCallPromptText(String t) {
        this.topLevel.setPromptText((fields, ops) -> {
            if (ops.size() == 0 || fields.size() == 0) {
                return;
            }
            for (int i = 0; i < fields.size() - 1; ++i) {
                if (!(fields.get(i) instanceof ExpressionSlotField)) continue;
                ExpressionSlotField f = (ExpressionSlotField)fields.get(i);
                if (ops.get(i) != null || !(fields.get(i + 1) instanceof BracketedExpression) || i != 0 && (ops.get(i - 1) == null || !((Operator)ops.get(i - 1)).get().equals("."))) continue;
                f.setPromptText(t);
            }
        });
    }

    public void onTextPropertyChange(FXConsumer<String> listener) {
        JavaFXUtil.addChangeListener(this.textMirror, s -> Platform.runLater(() -> listener.accept((String)this.textMirror.get())));
    }

    public String getText() {
        return this.topLevel.getCopyText(null, null);
    }

    @Override
    public boolean isFocused() {
        return this.topLevel.isFocused();
    }

    @Override
    public int getFocusInfo() {
        CaretPos pos = this.topLevel.getCurrentPos();
        if (pos == null) {
            pos = this.mostRecentPos;
        }
        if (pos == null) {
            return 0;
        }
        return this.topLevel.caretPosToStringPos(pos, false);
    }

    @Override
    public Node recallFocus(int info) {
        return this.topLevel.positionCaret(this.topLevel.stringPosToCaretPos(info, false));
    }

    @Override
    public Stream<CodeError> getCurrentErrors() {
        return this.shownErrors.stream();
    }

    public void setText(String text) {
        this.topLevel.blank();
        if (!"".equals(text)) {
            this.topLevel.insert(this.topLevel.getFirstField(), 0, text);
        }
    }

    @Override
    public void focusAndPositionAtError(CodeError err) {
        this.requestFocus();
        this.topLevel.positionCaret(this.javaPosToCaretPos(err.getStartPosition()));
    }

    @Override
    public void addUnderline(UnderlineContainer.Underline u) {
        this.underlines.add(u);
        this.drawUnderlines();
    }

    @Override
    public void removeAllUnderlines() {
        this.underlines.clear();
        this.drawUnderlines();
    }

    private void drawUnderlines() {
        this.overlay.clearUnderlines();
        this.underlines.forEach(u -> this.overlay.addUnderline(this, u.getStartPosition(), u.getEndPosition(), u.getOnClick()));
    }

    @Override
    public void cleanup() {
        if (this.suggestionDisplay != null) {
            this.hideSuggestionDisplay();
        }
        if (this.errorAndFixDisplay != null) {
            this.errorAndFixDisplay.hide();
            this.errorAndFixDisplay = null;
        }
    }

    public void replace(int startPosInSlot, int endPosInSlot, boolean javaPos, String s) {
        if (javaPos) {
            startPosInSlot = this.topLevel.caretPosToStringPos(this.javaPosToCaretPos(startPosInSlot), false);
            endPosInSlot = this.topLevel.caretPosToStringPos(this.javaPosToCaretPos(endPosInSlot), false);
        }
        String prev = this.getText();
        String updated = prev.substring(0, startPosInSlot) + s + prev.substring(endPosInSlot);
        this.setText(updated);
    }

    @Override
    public void requestFocus(Focus on) {
        this.topLevel.requestFocus();
        if (on == Focus.LEFT) {
            this.topLevel.home(null);
        } else if (on == Focus.RIGHT) {
            this.topLevel.end();
        } else if (on == Focus.SELECT_ALL) {
            this.topLevel.selectAll(null);
        }
    }

    public boolean isEmpty() {
        return this.topLevel.isEmpty();
    }

    protected void modified() {
        this.beenModified = true;
        this.editor.modifiedFrame(this.parentFrame);
        this.editor.regenerateAndReparse(null);
    }

    private double overlayToSceneX(double overlayX) {
        return this.overlay.localToScene(overlayX, 0.0).getX();
    }

    private double overlayToSceneY(double overlayY) {
        return this.overlay.localToScene(0.0, overlayY).getX();
    }

    double sceneToOverlayX(double sceneX) {
        return this.overlay.sceneToLocal(sceneX, 0.0).getX();
    }

    double sceneToOverlayY(double sceneY) {
        return this.overlay.sceneToLocal(0.0, sceneY).getY();
    }

    void clearSelection(boolean invalidateErrors) {
        if (invalidateErrors) {
            this.clearErrorMarkers();
        }
        this.selectionDrawPositions = null;
        this.overlay.redraw();
    }

    void drawSelection(List<TextOverlayPosition> positions) {
        this.selectionDrawPositions = positions;
        this.overlay.redraw();
    }

    public void bindTargetType(StringExpression targetTypeBinding) {
        this.targetType = targetTypeBinding;
    }

    public void setTargetType(String targetType) {
        this.targetType = new SimpleStringProperty(targetType);
    }

    public static Label makeBracket(String content, boolean opening, InfixExpression parent) {
        Label l = new Label(content);
        JavaFXUtil.addStyleClass((Styleable)l, "expression-bracket", opening ? "expression-bracket-opening" : "expression-bracket-closing");
        l.setOnMousePressed(e -> {
            if (parent != null) {
                parent.moveTo(e.getSceneX(), e.getSceneY(), true);
            }
            e.consume();
        });
        l.setOnMouseMoved(e -> {
            if (e.isShortcutDown()) {
                parent.getSlot().getOverlay().hoverAtPos(-1);
            }
        });
        l.setOnMouseReleased(Event::consume);
        l.setOnMouseClicked(Event::consume);
        l.setOnMouseDragged(Event::consume);
        l.setOnDragDetected(Event::consume);
        return l;
    }

    public static SlotLabel makeBracketSlot(String content, boolean opening, InfixExpression parent) {
        SlotLabel l = new SlotLabel(content, new String[0]);
        JavaFXUtil.addStyleClass(l, "expression-bracket", opening ? "expression-bracket-opening" : "expression-bracket-closing");
        l.setOnMousePressed((EventHandler<? super MouseEvent>)((EventHandler)e -> {
            if (parent != null) {
                parent.moveTo(e.getSceneX(), e.getSceneY(), true);
            }
            e.consume();
        }));
        l.setOnMouseReleased((EventHandler<? super MouseEvent>)((EventHandler)Event::consume));
        l.setOnMouseClicked((EventHandler<? super MouseEvent>)((EventHandler)Event::consume));
        l.setOnMouseDragged((EventHandler<? super MouseEvent>)((EventHandler)Event::consume));
        l.setOnDragDetected((EventHandler<? super MouseEvent>)((EventHandler)Event::consume));
        return l;
    }

    void hideSuggestionDisplay() {
        if (this.suggestionDisplay != null) {
            this.suggestionDisplay = null;
        }
        this.fileCompletions = null;
    }

    void showSuggestionDisplay(ExpressionSlotField field, int caretPosition, boolean stringLiteral) {
        if (this.suggestionDisplay != null) {
            this.hideSuggestionDisplay();
        }
        this.suggestionField = field;
        this.suggestionNode = (Region)field.getComponents().get(0);
        FXConsumer<SuggestionList> withSuggList = suggList -> {
            this.suggestionDisplay = suggList;
            this.updateSuggestions(true);
            this.suggestionDisplay.highlightFirstEligible();
            this.suggestionDisplay.show((Node)this.suggestionNode, (DoubleExpression)new ReadOnlyDoubleWrapper(0.0), field.heightProperty());
            this.fakeCaretShowing.set(true);
        };
        this.suggestionLocation = this.topLevel.getCurrentPos();
        if (Config.isGreenfoot() && stringLiteral) {
            this.fileCompletions = this.editor.getAvailableFilenames();
            Function<InteractionManager.FileCompletion, SuggestionList.SuggestionDetails> func = f -> new SuggestionList.SuggestionDetailsWithCustomDoc(f.getFile().getName(), null, f.getType(), SuggestionList.SuggestionShown.COMMON, () -> this.makeFileCompletionPreview((InteractionManager.FileCompletion)f));
            withSuggList.accept(new SuggestionList(this.editor, Utility.mapList(this.fileCompletions, func), null, SuggestionList.SuggestionShown.RARE, null, this));
        } else {
            this.editor.regenerateAndReparse(this);
            JavaFragment.PosInSourceDoc posInFile = this.getSlotElement().getPosInSourceDoc(this.topLevel.caretPosToStringPos(this.topLevel.getCurrentPos(), true));
            this.completionCalculator.withCalculatedSuggestionList(posInFile, this, (CodeElement)this.parentCodeFrame.getCode(), this, this.targetType == null ? null : (String)this.targetType.get(), withSuggList);
        }
    }

    void withParamNamesForConstructor(FXConsumer<List<List<String>>> handler) {
        this.editor.regenerateAndReparse(this);
        this.completionCalculator.withConstructorParamNames(this.paramsToConstructor.getValue(SuperThis.EMPTY), handler);
    }

    void withParamNamesForPos(CaretPos pos, String methodName, FXConsumer<List<List<String>>> handler) {
        this.editor.regenerateAndReparse(this);
        JavaFragment.PosInSourceDoc posJava = this.getSlotElement().getPosInSourceDoc(this.topLevel.caretPosToStringPos(pos, true));
        this.completionCalculator.withParamNames(posJava, this, methodName, (CodeElement)this.parentCodeFrame.getCode(), handler);
    }

    void withParamHintsForPos(CaretPos pos, String methodName, FXConsumer<List<List<String>>> handler) {
        this.editor.regenerateAndReparse(this);
        JavaFragment.PosInSourceDoc posJava = this.getSlotElement().getPosInSourceDoc(this.topLevel.caretPosToStringPos(pos, true));
        this.completionCalculator.withParamHints(posJava, this, methodName, (CodeElement)this.parentCodeFrame.getCode(), handler);
    }

    void withParamHintsForConstructor(int totalParams, FXConsumer<List<List<String>>> handler) {
        this.editor.regenerateAndReparse(this);
        this.completionCalculator.withConstructorParamHints(this.paramsToConstructor.getValue(SuperThis.EMPTY), totalParams, handler);
    }

    void withMethodHint(CaretPos pos, String methodName, FXConsumer<List<String>> handler) {
        this.editor.regenerateAndReparse(this);
        JavaFragment.PosInSourceDoc posJava = this.getSlotElement().getPosInSourceDoc(this.topLevel.caretPosToStringPos(pos, true));
        this.completionCalculator.withMethodHints(posJava, this, methodName, (CodeElement)this.parentCodeFrame.getCode(), handler);
    }

    private Pane makeFileCompletionPreview(InteractionManager.FileCompletion fc) {
        BorderPane javadocDisplay = new BorderPane(fc.getPreview(300.0, 250.0));
        JavaFXUtil.addStyleClass((Styleable)javadocDisplay, "suggestion-file-preview");
        CodeOverlayPane.setDropShadow((Node)javadocDisplay);
        this.fileCompletionShortcuts = fc.getShortcuts();
        return javadocDisplay;
    }

    private String getCurSuggestionWord() {
        if (this.suggestionLocation == null) {
            return null;
        }
        return this.topLevel.getCopyText(ExpressionSlot.replaceLastWithZero(this.suggestionLocation), this.suggestionLocation);
    }

    private static CaretPos replaceLastWithZero(CaretPos p) {
        if (p.subPos == null) {
            return new CaretPos(0, null);
        }
        return new CaretPos(p.index, ExpressionSlot.replaceLastWithZero(p.subPos));
    }

    private void updateSuggestions(boolean initialState) {
        if (this.suggestionDisplay != null) {
            String prefix = this.getCurSuggestionWord();
            if (prefix == null) {
                this.hideSuggestionDisplay();
            } else {
                this.suggestionDisplay.calculateEligible(prefix, true, initialState);
                this.suggestionDisplay.updateVisual(prefix, false);
            }
        }
    }

    private void executeSuggestion(int selected) {
        if (this.fileCompletions != null && selected != -1) {
            InteractionManager.FileCompletion fc = this.fileCompletions.get(selected);
            this.topLevel.insertSuggestion(this.suggestionLocation, fc.getFile().getName(), null);
        } else {
            this.topLevel.insertSuggestion(this.suggestionLocation, this.completionCalculator.getName(selected), this.completionCalculator.getParams(selected));
        }
        this.modified();
    }

    void up() {
        if (this.errorAndFixDisplay != null && this.errorAndFixDisplay.hasFixes()) {
            this.errorAndFixDisplay.up();
        } else {
            List<TextOverlayPosition> overlayPositions = this.topLevel.getAllStartEndPositionsBetween(null, null).collect(Collectors.toList());
            TextOverlayPosition cur = this.topLevel.calculateOverlayPos(this.topLevel.getCurrentPos());
            LinkedList<TextOverlayPosition.Line> lines = TextOverlayPosition.groupIntoLines(overlayPositions);
            int curLine = -1;
            for (int i = 0; i < lines.size(); ++i) {
                if (!(((TextOverlayPosition.Line)lines.get((int)i)).topY <= cur.getSceneTopY()) || !(((TextOverlayPosition.Line)lines.get((int)i)).bottomY >= cur.getSceneBottomY())) continue;
                curLine = i;
                break;
            }
            if (curLine > 0) {
                double nearestDist = 9999.0;
                ExpressionSlotField nearest = null;
                for (int i = 0; i < ((TextOverlayPosition.Line)lines.get((int)(curLine - 1))).positions.size(); ++i) {
                    TextOverlayPosition p = ((TextOverlayPosition.Line)lines.get((int)(curLine - 1))).positions.get(i);
                    double dist = Math.abs(p.getSceneX() - cur.getSceneX());
                    if (!(dist < nearestDist) || p.getSource() == null) continue;
                    nearestDist = dist;
                    nearest = p.getSource();
                }
                if (nearest != null) {
                    nearest.focusAtPos(nearest.getNearest(cur.getSceneX(), cur.getSceneTopY(), false, false).getPos());
                    return;
                }
            }
            this.row.focusUp(this, false);
        }
    }

    void down() {
        if (this.errorAndFixDisplay != null && this.errorAndFixDisplay.hasFixes()) {
            this.errorAndFixDisplay.down();
        } else {
            List<TextOverlayPosition> overlayPositions = this.topLevel.getAllStartEndPositionsBetween(null, null).collect(Collectors.toList());
            TextOverlayPosition cur = this.topLevel.calculateOverlayPos(this.topLevel.getCurrentPos());
            LinkedList<TextOverlayPosition.Line> lines = TextOverlayPosition.groupIntoLines(overlayPositions);
            int curLine = -1;
            for (int i = 0; i < lines.size(); ++i) {
                if (!(((TextOverlayPosition.Line)lines.get((int)i)).topY <= cur.getSceneTopY()) || !(((TextOverlayPosition.Line)lines.get((int)i)).bottomY >= cur.getSceneBottomY())) continue;
                curLine = i;
                break;
            }
            if (curLine < lines.size() - 1) {
                double nearestDist = 9999.0;
                ExpressionSlotField nearest = null;
                for (int i = 0; i < ((TextOverlayPosition.Line)lines.get((int)(curLine + 1))).positions.size(); ++i) {
                    TextOverlayPosition p = ((TextOverlayPosition.Line)lines.get((int)(curLine + 1))).positions.get(i);
                    double dist = Math.abs(p.getSceneX() - cur.getSceneX());
                    if (!(dist < nearestDist) || p.getSource() == null) continue;
                    nearestDist = dist;
                    nearest = p.getSource();
                }
                if (nearest != null) {
                    nearest.focusAtPos(nearest.getNearest(cur.getSceneX(), cur.getSceneBottomY(), false, false).getPos());
                    return;
                }
            }
            this.row.focusDown(this);
        }
    }

    void enter() {
        if (this.errorAndFixDisplay != null && this.errorAndFixDisplay.hasFixes()) {
            this.errorAndFixDisplay.executeSelected();
        } else {
            this.row.focusEnter(this);
        }
    }

    public String getJavaCode() {
        if (this.topLevel.isCurlyLiteral()) {
            return this.getCurlyLiteralPrefix() + this.topLevel.getJavaCode();
        }
        return this.topLevel.getJavaCode();
    }

    @Override
    public void saved() {
        if (this.getParentFrame().isFrameEnabled() && this.paramsToConstructor != null) {
            this.topLevel.treatAsConstructorParams_updatePrompts();
        }
    }

    public void caretMoved() {
        CaretPos pos = this.topLevel.getCurrentPos();
        this.showErrorAtCaret(pos);
        this.topLevel.showHighlightedBrackets(null, pos);
        if (pos != null) {
            this.mostRecentPos = pos;
        }
    }

    public void escape() {
        if (this.errorAndFixDisplay != null) {
            this.errorAndFixDisplay.hide();
        } else {
            this.row.escape(this);
        }
    }

    public ObservableList<Node> getComponents() {
        return this.topLevel.getComponents();
    }

    @Override
    public TextOverlayPosition getOverlayLocation(int stringCaretPos, boolean javaPos) {
        CaretPos p;
        if (stringCaretPos == Integer.MAX_VALUE) {
            return this.topLevel.calculateOverlayEnd();
        }
        if (stringCaretPos < 0) {
            p = this.topLevel.getStartPos();
        } else {
            CaretPos caretPos = p = javaPos ? this.javaPosToCaretPos(stringCaretPos) : this.topLevel.stringPosToCaretPos(stringCaretPos, false);
            if (p == null) {
                p = this.topLevel.getEndPos();
            }
        }
        return this.topLevel.calculateOverlayPos(p);
    }

    @Override
    public List<TextOverlayPosition.Line> getAllLines(int start, int end, boolean javaPos) {
        CaretPos startPos = this.topLevel.stringPosToCaretPos(start, javaPos);
        CaretPos endPos = end == Integer.MAX_VALUE ? null : this.topLevel.stringPosToCaretPos(end, javaPos);
        return TextOverlayPosition.groupIntoLines(this.topLevel.getAllStartEndPositionsBetween(startPos, endPos).collect(Collectors.toList()));
    }

    CaretPos javaPosToCaretPos(int pos) {
        if (this.topLevel.isCurlyLiteral()) {
            pos -= this.getCurlyLiteralPrefix().length();
        }
        return this.topLevel.stringPosToCaretPos(Math.max(0, pos), true);
    }

    public InfixExpression getTopLevel() {
        return this.topLevel;
    }

    FocusParent<HeaderItem> getSlotParent() {
        return this.row;
    }

    public boolean backspaceAtStart() {
        return this.row.backspaceAtStart(this);
    }

    public void bindClosingChar(EditableSlot anotherSlot, char c) {
        this.topLevel.bindClosingChar(anotherSlot, c);
    }

    public boolean checkFilePreviewShortcut(KeyCode code) {
        if (this.fileCompletionShortcuts != null && this.fileCompletionShortcuts.containsKey(code)) {
            this.fileCompletionShortcuts.get(code).run();
            return true;
        }
        return false;
    }

    public boolean isShowingSuggestions() {
        return this.suggestionDisplay != null && this.suggestionDisplay.isShowing() && !this.suggestionDisplay.isInMiddleOfHiding();
    }

    @Override
    public List<? extends PossibleLink> findLinks() {
        return this.topLevel.findLinks(Optional.empty(), ((ExpressionSlotFragment)this.getSlotElement()).getVars(), offset -> this.getSlotElement().getPosInSourceDoc((int)offset), 0);
    }

    @Override
    public void lostFocus() {
        if (this.hadFocus) {
            this.recentValues.removeAll((Object[])new String[]{this.getText()});
            this.recentValues.removeAll((Object[])new String[]{this.valueOnGain});
            this.recentValues.add(0, (Object)this.valueOnGain);
            while (this.recentValues.size() > 3) {
                this.recentValues.remove(3);
            }
            this.editor.endRecordingState(this);
        }
        this.hadFocus = false;
        this.topLevel.getAllExpressions().forEach(InfixExpression::deselect);
        this.notifyLostFocusExcept(null);
        this.lostFocusActions.forEach(FXRunnable::run);
    }

    void notifyGainFocus(ExpressionSlotField focus) {
        this.notifyLostFocusExcept(focus);
        if (!this.hadFocus) {
            this.valueOnGain = this.getText();
            this.editor.beginRecordingState(this);
        }
        this.hadFocus = true;
    }

    private void notifyLostFocusExcept(ExpressionSlotField except) {
        this.topLevel.getAllExpressions().forEach(e -> e.notifyLostFocus(except));
    }

    public void onLostFocus(FXRunnable action) {
        this.lostFocusActions.add(action);
    }

    ErrorUnderlineCanvas getOverlay() {
        return this.overlay;
    }

    @Override
    public Frame getParentFrame() {
        return this.parentFrame;
    }

    @Override
    public ExpressionSlot asExpressionSlot() {
        return this;
    }

    public List<PlainVarReference> findPlainVarReferences(String name) {
        return this.topLevel.findPlainVarUse(name);
    }

    public String getCurlyLiteralPrefix() {
        return "";
    }

    @Override
    public void setView(Frame.View oldView, Frame.View newView, SharedTransition animate) {
        this.topLevel.setView(oldView, newView, animate, Optional.empty());
    }

    public boolean isConstantRange() {
        return this.topLevel.checkRangeExpression() == InfixExpression.RangeType.RANGE_CONSTANT;
    }

    @Override
    public Map<EditableSlot.TopLevelMenu, EditableSlot.MenuItems> getMenuItems(boolean contextMenu) {
        HashMap<EditableSlot.TopLevelMenu, EditableSlot.MenuItems> itemMap = new HashMap<EditableSlot.TopLevelMenu, EditableSlot.MenuItems>();
        Menu recentMenu = new Menu(Config.getString("frame.slot.recent"));
        recentMenu.setDisable(true);
        this.recentValues.addListener(c -> {
            recentMenu.getItems().clear();
            if (this.recentValues.isEmpty()) {
                recentMenu.setDisable(true);
            } else {
                recentMenu.setDisable(false);
                this.recentValues.forEach(v -> {
                    MenuItem item = new MenuItem(v);
                    item.setOnAction(e -> this.setText((String)v));
                    recentMenu.getItems().add((Object)item);
                });
            }
        });
        ObservableList originalItems = FXCollections.observableArrayList();
        final FXConsumer<ObservableList> setToOriginal = l -> {
            if (contextMenu) {
                l.setAll((Object[])new EditableSlot.SortedMenuItem[]{EditableSlot.MenuItemOrder.RECENT_VALUES.item((MenuItem)recentMenu)});
            } else {
                l.clear();
            }
        };
        setToOriginal.accept(originalItems);
        itemMap.put(EditableSlot.TopLevelMenu.EDIT, new EditableSlot.MenuItems(originalItems){

            @Override
            public void onShowing() {
                InfixExpression exp = ExpressionSlot.this.getTopLevel().getAllExpressions().filter(InfixExpression::isFocused).findFirst().orElse(null);
                if (exp == null) {
                    setToOriginal.accept(this.items);
                } else {
                    MenuItem cut = JavaFXUtil.makeMenuItem(Config.getString("frame.slot.cut"), exp::cut, (KeyCombination)new KeyCodeCombination(KeyCode.X, new KeyCombination.Modifier[]{KeyCodeCombination.SHORTCUT_DOWN}));
                    MenuItem copy = JavaFXUtil.makeMenuItem(Config.getString("frame.slot.copy"), exp::copy, (KeyCombination)new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCodeCombination.SHORTCUT_DOWN}));
                    MenuItem paste = JavaFXUtil.makeMenuItem(Config.getString("frame.slot.paste"), exp::paste, (KeyCombination)new KeyCodeCombination(KeyCode.V, new KeyCombination.Modifier[]{KeyCodeCombination.SHORTCUT_DOWN}));
                    boolean inSelection = exp.isInSelection();
                    cut.setDisable(!inSelection);
                    copy.setDisable(!inSelection);
                    paste.setDisable(!Clipboard.getSystemClipboard().hasString());
                    setToOriginal.accept(this.items);
                    this.items.addAll((Object[])new EditableSlot.SortedMenuItem[]{EditableSlot.MenuItemOrder.CUT.item(cut), EditableSlot.MenuItemOrder.COPY.item(copy), EditableSlot.MenuItemOrder.PASTE.item(paste)});
                }
                if (ExpressionSlot.this.hoverErrorCurrentlyShown != null) {
                    ExpressionSlot.this.errorAndFixDisplay.hide();
                }
            }
        });
        if (contextMenu) {
            final EditableSlot.SortedMenuItem scanningItem = EditableSlot.MenuItemOrder.GOTO_DEFINITION.item(new MenuItem("Scanning..."));
            scanningItem.getItem().setDisable(true);
            itemMap.put(EditableSlot.TopLevelMenu.VIEW, new EditableSlot.MenuItems(FXCollections.observableArrayList()){

                private void removeScanning() {
                    if (this.items.size() == 1 && this.items.get(0) == scanningItem) {
                        this.items.clear();
                    }
                }

                @Override
                public void onShowing() {
                    this.items.setAll((Object[])new EditableSlot.SortedMenuItem[]{scanningItem});
                    CaretPos caretPos = ExpressionSlot.this.getTopLevel().getCurrentPos();
                    Debug.message("Scanning position: " + caretPos);
                    List<PossibleLink> possibleLinks = ExpressionSlot.this.findLinks();
                    possibleLinks.removeIf(possLink -> {
                        CaretPos endCaretPos;
                        CaretPos startCaretPos = ExpressionSlot.this.javaPosToCaretPos(possLink.getStartPosition());
                        return !CaretPos.between(startCaretPos, endCaretPos = ExpressionSlot.this.javaPosToCaretPos(possLink.getEndPosition()), caretPos);
                    });
                    possibleLinks.forEach(possLink -> ExpressionSlot.this.editor.searchLink((PossibleLink)possLink, optLink -> {
                        this.removeScanning();
                        optLink.ifPresent(defLink -> this.items.add((Object)EditableSlot.MenuItemOrder.GOTO_DEFINITION.item(JavaFXUtil.makeMenuItem("Go to definition of \"" + defLink.getName() + "\"", defLink.getOnClick(), null))));
                    }));
                    JavaFXUtil.runAfter(Duration.millis((double)1000.0), this::removeScanning);
                }

                @Override
                public void onHidden() {
                    this.items.clear();
                }
            });
        }
        return itemMap;
    }

    @Override
    public SuggestionList.SuggestionListListener.Response suggestionListKeyPressed(KeyEvent event, int highlighted) {
        switch (event.getCode()) {
            case ENTER: {
                if (highlighted != -1) {
                    this.executeSuggestion(highlighted);
                    return SuggestionList.SuggestionListListener.Response.DISMISS;
                }
            }
            case ESCAPE: {
                return SuggestionList.SuggestionListListener.Response.DISMISS;
            }
            case BACK_SPACE: {
                CaretPos updatedLocation = this.topLevel.deletePreviousAtPos(this.suggestionLocation);
                if (!updatedLocation.init().equals(this.suggestionLocation.init())) {
                    return SuggestionList.SuggestionListListener.Response.DISMISS;
                }
                this.suggestionLocation = updatedLocation;
                this.overlay.redraw();
                this.updateSuggestions(false);
                return SuggestionList.SuggestionListListener.Response.CONTINUE;
            }
            case TAB: {
                if (event.isShiftDown()) {
                    this.row.focusLeft(this);
                } else {
                    this.row.focusRight(this);
                    this.completeIfPossible(highlighted);
                }
                return SuggestionList.SuggestionListListener.Response.DISMISS;
            }
        }
        return SuggestionList.SuggestionListListener.Response.CONTINUE;
    }

    private void completeIfPossible(int highlighted) {
        if (highlighted != -1) {
            this.executeSuggestion(highlighted);
        } else if (this.suggestionDisplay.eligibleCount() == 1 && this.getText().length() > 0) {
            this.executeSuggestion(this.suggestionDisplay.getFirstEligible());
        }
    }

    @Override
    public SuggestionList.SuggestionListListener.Response suggestionListKeyTyped(KeyEvent event, int highlighted) {
        CaretPos updatedLocation = null;
        if ("\b".equals(event.getCharacter())) {
            return SuggestionList.SuggestionListListener.Response.CONTINUE;
        }
        updatedLocation = this.topLevel.insertAtPos(this.suggestionLocation, event.getCharacter());
        if (!updatedLocation.init().equals(this.suggestionLocation.init())) {
            return SuggestionList.SuggestionListListener.Response.DISMISS;
        }
        this.suggestionLocation = updatedLocation;
        this.overlay.redraw();
        this.updateSuggestions(true);
        return SuggestionList.SuggestionListListener.Response.CONTINUE;
    }

    @Override
    public void suggestionListChoiceClicked(int highlighted) {
        this.executeSuggestion(highlighted);
    }

    @Override
    public void hidden() {
        this.fakeCaretShowing.set(false);
    }

    boolean suggestingFor(CaretPos fieldPos) {
        return fieldPos != null && this.suggestionLocation != null && fieldPos.equals(this.suggestionLocation.init()) && this.suggestionDisplay != null && this.suggestionDisplay.isShowing();
    }

    public boolean deleteAtEnd() {
        if (this.row != null) {
            return this.row.deleteAtEnd(this);
        }
        return false;
    }

    public void setSplitText(String beforeCursor, String afterCursor) {
        this.topLevel.blank();
        CaretPos p = this.topLevel.insert_(this.topLevel.getFirstField(), 0, beforeCursor, false);
        this.topLevel.insertAtPos(p, afterCursor);
        Platform.runLater(() -> this.topLevel.positionCaret(p));
    }

    public SplitInfo trySplitOnEquals() {
        return this.topLevel.trySplitOn("=");
    }

    public List<FrameCatalogue.Hint> getHints() {
        return this.hints;
    }

    @Override
    public boolean isAlmostBlank() {
        return this.topLevel.isAlmostBlank();
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public void setEditable(boolean editable) {
        this.editable = editable;
        this.topLevel.setEditable(editable);
    }

    public void setParamsToConstructor(ChoiceSlot<SuperThis> paramsToConstructor) {
        this.paramsToConstructor = paramsToConstructor;
    }

    boolean isConstructorParams() {
        return this.paramsToConstructor != null;
    }

    public static class SplitInfo {
        public final String lhs;
        public final String rhs;

        public SplitInfo(String lhs, String rhs) {
            this.lhs = lhs;
            this.rhs = rhs;
        }
    }

    public static class PlainVarReference {
        public final FXConsumer<String> rename;
        public final Region refNode;

        PlainVarReference(FXConsumer<String> rename, Region refNode) {
            this.rename = rename;
            this.refNode = refNode;
        }
    }
}

