/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.frames;

import bluej.stride.framedjava.ast.Loader;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.frames.CodeFrame;
import bluej.stride.generic.Frame;
import bluej.stride.generic.InteractionManager;
import bluej.stride.operations.CopyFrameOperation;
import bluej.stride.operations.CutFrameOperation;
import bluej.stride.operations.FrameOperation;
import bluej.utility.Debug;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParsingException;

public class GreenfootFrameUtil {
    public static List<FrameOperation> cutCopyPasteOperations(InteractionManager editor) {
        return Arrays.asList(new CutFrameOperation(editor), new CopyFrameOperation(editor));
    }

    public static List<CodeElement> getClipboardElements() {
        Clipboard clipboard = Clipboard.getSystemClipboard();
        if (clipboard.hasString()) {
            return GreenfootFrameUtil.getElements(clipboard.getString());
        }
        return null;
    }

    public static List<CodeElement> getElements(String xmlString) {
        Builder parser = new Builder();
        Document doc = null;
        try {
            doc = parser.build(xmlString, null);
        }
        catch (IOException | ParsingException e) {
            Debug.reportError(e);
        }
        if (doc == null) {
            return null;
        }
        Element root = doc.getRootElement();
        if (!root.getLocalName().equals("frames")) {
            return null;
        }
        ArrayList<CodeElement> elements = new ArrayList<CodeElement>();
        for (int i = 0; i < root.getChildElements().size(); ++i) {
            elements.add(Loader.loadElement(root.getChildElements().get(i)));
        }
        return elements;
    }

    public static String getXmlForMultipleFrames(List<Frame> frames) {
        Element framesEl = new Element("frames");
        for (Frame f : frames) {
            if (!(f instanceof CodeFrame)) continue;
            Object c = ((CodeFrame)((Object)f)).getCode();
            framesEl.appendChild((Node)((CodeElement)c).toXML());
        }
        return framesEl.toXML();
    }

    public static List<CodeElement> getElementsForMultipleFrames(List<Frame> frames) {
        return GreenfootFrameUtil.getElements(GreenfootFrameUtil.getXmlForMultipleFrames(frames));
    }

    public static void doCopy(List<Frame> frames) {
        if (frames.size() == 0) {
            return;
        }
        Clipboard clipboard = Clipboard.getSystemClipboard();
        ClipboardContent content = new ClipboardContent();
        content.putString(GreenfootFrameUtil.getXmlForMultipleFrames(frames));
        content.putImage(Frame.takeShot(frames, null));
        clipboard.setContent((Map)content);
    }
}

