/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.frames;

import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCanvas;
import bluej.stride.generic.FrameCursor;
import bluej.utility.Utility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

public class FrameHelper {
    public static void flagErrorsAsOld(FrameCanvas canvas) {
        canvas.getBlockContents().forEach(f -> f.flagErrorsAsOld());
    }

    public static void removeOldErrors(FrameCanvas canvas) {
        canvas.getBlockContents().forEach(f -> f.removeOldErrors());
    }

    static void pullUpContents(Frame f, FrameCanvas innerCanvas) {
        FrameCursor cursorBefore = f.getCursorBefore();
        ArrayList<Frame> contents = new ArrayList<Frame>((Collection<Frame>)innerCanvas.getBlockContents());
        contents.forEach(c -> innerCanvas.removeBlock((Frame)c));
        cursorBefore.insertFramesAfter(contents);
        f.getParentCanvas().removeBlock(f);
    }

    public static void processVarScopesAfter(FrameCanvas parentCanvas, Frame afterFrame, BiConsumer<Map<String, List<Frame>>, Frame> process) {
        FrameHelper.processVarScopesAfter(parentCanvas, afterFrame, new HashMap<String, List<Frame>>(), process);
    }

    private static void processVarScopesAfter(FrameCanvas parentCanvas, Frame afterFrame, Map<String, List<Frame>> parentVars, BiConsumer<Map<String, List<Frame>>, Frame> process) {
        HashMap<String, List<Frame>> vars = new HashMap<String, List<Frame>>(parentVars);
        for (Frame f : Utility.iterableStream(parentCanvas.getFramesAfter(afterFrame))) {
            process.accept(vars, f);
            for (FrameCanvas c : Utility.iterableStream(f.getCanvases())) {
                HashMap<String, List<Frame>> extraVarsWithin = new HashMap<String, List<Frame>>();
                for (String v : f.getDeclaredVariablesWithin(c)) {
                    extraVarsWithin.put(v, Arrays.asList(f));
                }
                Map<String, List<Frame>> varsInside = Utility.mergeMaps(vars, extraVarsWithin, (xva$0, xva$1) -> Utility.concat(xva$0, xva$1));
                FrameHelper.processVarScopesAfter(c, null, varsInside, process);
            }
            for (String var : f.getDeclaredVariablesAfter()) {
                vars.merge(var, new ArrayList<Frame>(Arrays.asList(f)), (xva$0, xva$1) -> Utility.concat(xva$0, xva$1));
            }
        }
    }
}

