/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.frames;

import bluej.stride.framedjava.ast.CallExpressionSlotFragment;
import bluej.stride.framedjava.ast.ExpressionSlotFragment;
import bluej.stride.framedjava.ast.HighlightedBreakpoint;
import bluej.stride.framedjava.canvases.JavaCanvas;
import bluej.stride.framedjava.elements.CallElement;
import bluej.stride.framedjava.frames.AssignFrame;
import bluej.stride.framedjava.frames.CodeFrame;
import bluej.stride.framedjava.frames.DebugInfo;
import bluej.stride.framedjava.frames.DebuggableFrame;
import bluej.stride.framedjava.frames.GreenfootFrameUtil;
import bluej.stride.framedjava.slots.CallExpressionSlot;
import bluej.stride.framedjava.slots.ExpressionSlot;
import bluej.stride.generic.FrameFactory;
import bluej.stride.generic.InteractionManager;
import bluej.stride.generic.SingleLineFrame;
import bluej.stride.operations.FrameOperation;
import java.util.List;

public class CallFrame
extends SingleLineFrame
implements CodeFrame<CallElement>,
DebuggableFrame {
    private final ExpressionSlot<CallExpressionSlotFragment> content;
    private CallElement element;

    private CallFrame(InteractionManager editor) {
        super(editor, null, "do-");
        this.content = new CallExpressionSlot(editor, this, this, this.getHeaderRow(), "do-method-name-", CallExpressionSlot.CALL_HINTS);
        this.content.setText("()");
        this.content.setMethodCallPromptText("method-name");
        this.setHeaderRow(this.content, this.previewSemi);
        this.content.onTextPropertyChange(s -> this.checkForTopLevelEquals());
    }

    CallFrame(InteractionManager editor, String beforeCursor, String afterCursor) {
        this(editor);
        this.content.setSplitText(beforeCursor, afterCursor);
    }

    public CallFrame(InteractionManager editor, ExpressionSlotFragment e, boolean enabled) {
        this(editor);
        this.content.setText(e);
        this.frameEnabledProperty.set(enabled);
    }

    @Override
    public void regenerateCode() {
        this.element = new CallElement(this, (CallExpressionSlotFragment)this.content.getSlotElement(), this.frameEnabledProperty.get());
    }

    @Override
    public CallElement getCode() {
        return this.element;
    }

    public static FrameFactory<CallFrame> getFactory() {
        return new FrameFactory<CallFrame>(){

            @Override
            public CallFrame createBlock(InteractionManager editor) {
                return new CallFrame(editor);
            }

            @Override
            public Class<CallFrame> getBlockClass() {
                return CallFrame.class;
            }
        };
    }

    @Override
    public List<FrameOperation> getCutCopyPasteOperations(InteractionManager editor) {
        return GreenfootFrameUtil.cutCopyPasteOperations(editor);
    }

    @Override
    public HighlightedBreakpoint showDebugBefore(DebugInfo debug) {
        return ((JavaCanvas)this.getParentCanvas()).showDebugBefore(this, debug);
    }

    private void checkForTopLevelEquals() {
        ExpressionSlot.SplitInfo info = this.content.trySplitOnEquals();
        if (info != null && this.getParentCanvas() != null) {
            this.getParentCanvas().replaceBlock(this, new AssignFrame(this.getEditor(), info.lhs, info.rhs));
        }
    }
}

