/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.frames;

import bluej.stride.framedjava.ast.FilledExpressionSlotFragment;
import bluej.stride.framedjava.ast.HighlightedBreakpoint;
import bluej.stride.framedjava.canvases.JavaCanvas;
import bluej.stride.framedjava.elements.AssignElement;
import bluej.stride.framedjava.frames.CallFrame;
import bluej.stride.framedjava.frames.CodeFrame;
import bluej.stride.framedjava.frames.DebugInfo;
import bluej.stride.framedjava.frames.DebuggableFrame;
import bluej.stride.framedjava.frames.GreenfootFrameUtil;
import bluej.stride.framedjava.slots.ExpressionSlot;
import bluej.stride.framedjava.slots.FilledExpressionSlot;
import bluej.stride.generic.FrameContentItem;
import bluej.stride.generic.FrameFactory;
import bluej.stride.generic.InteractionManager;
import bluej.stride.generic.SingleLineFrame;
import bluej.stride.operations.FrameOperation;
import bluej.stride.slots.Focus;
import bluej.stride.slots.HeaderItem;
import bluej.stride.slots.SlotLabel;
import java.util.List;
import javafx.application.Platform;

public class AssignFrame
extends SingleLineFrame
implements CodeFrame<AssignElement>,
DebuggableFrame {
    private final ExpressionSlot<FilledExpressionSlotFragment> slotLHS;
    private final ExpressionSlot<FilledExpressionSlotFragment> slotRHS;
    private AssignElement element;

    private AssignFrame(InteractionManager editor) {
        super(editor, null, "set-");
        this.slotRHS = new FilledExpressionSlot(editor, this, this, this.getHeaderRow(), "", FilledExpressionSlot.SRC_HINTS);
        this.slotRHS.setSimplePromptText("new-value");
        this.slotLHS = new FilledExpressionSlot(editor, this, this, this.getHeaderRow(), "assign-lhs-");
        this.slotLHS.setSimplePromptText("variable");
        this.setHeaderRow(this.slotLHS, new SlotLabel("=", new String[0]), this.slotRHS, this.previewSemi);
        this.slotLHS.bindClosingChar(this.slotRHS, '=');
        this.slotLHS.bindClosingChar(this.slotRHS, ' ');
    }

    AssignFrame(InteractionManager editor, String lhs, String rhs) {
        this(editor);
        this.slotLHS.setText(lhs);
        this.slotRHS.setText(rhs);
        Platform.runLater(() -> this.slotRHS.requestFocus(Focus.LEFT));
    }

    public AssignFrame(InteractionManager editor, FilledExpressionSlotFragment lhs, FilledExpressionSlotFragment rhs, boolean enabled) {
        this(editor);
        this.slotLHS.setText(lhs);
        this.slotRHS.setText(rhs);
        this.frameEnabledProperty.set(enabled);
    }

    @Override
    public void regenerateCode() {
        this.element = new AssignElement(this, (FilledExpressionSlotFragment)this.slotLHS.getSlotElement(), (FilledExpressionSlotFragment)this.slotRHS.getSlotElement(), this.frameEnabledProperty.get());
    }

    @Override
    public AssignElement getCode() {
        return this.element;
    }

    public static FrameFactory<AssignFrame> getFactory() {
        return new FrameFactory<AssignFrame>(){

            @Override
            public AssignFrame createBlock(InteractionManager editor) {
                return new AssignFrame(editor);
            }

            @Override
            public Class<AssignFrame> getBlockClass() {
                return AssignFrame.class;
            }
        };
    }

    @Override
    public List<FrameOperation> getCutCopyPasteOperations(InteractionManager editor) {
        return GreenfootFrameUtil.cutCopyPasteOperations(editor);
    }

    @Override
    public HighlightedBreakpoint showDebugBefore(DebugInfo debug) {
        return ((JavaCanvas)this.getParentCanvas()).showDebugBefore(this, debug);
    }

    public ExpressionSlot getLHS() {
        return this.slotLHS;
    }

    public ExpressionSlot getRHS() {
        return this.slotRHS;
    }

    @Override
    public boolean backspaceAtStart(FrameContentItem row, HeaderItem src) {
        if (src == this.slotRHS) {
            this.collapseIntoMethodCall();
            return true;
        }
        return super.backspaceAtStart(row, src);
    }

    @Override
    public boolean deleteAtEnd(FrameContentItem row, HeaderItem src) {
        if (src == this.slotLHS) {
            this.collapseIntoMethodCall();
            return true;
        }
        return false;
    }

    private void collapseIntoMethodCall() {
        this.getParentCanvas().replaceBlock(this, new CallFrame(this.getEditor(), this.slotLHS.getText(), this.slotRHS.getText()));
    }
}

