/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.errors;

import bluej.stride.framedjava.ast.TypeSlotFragment;
import bluej.stride.framedjava.errors.Correction;
import bluej.stride.framedjava.errors.DirectSlotError;
import bluej.stride.framedjava.errors.FixSuggestion;
import bluej.stride.generic.AssistContentThreadSafe;
import bluej.stride.generic.InteractionManager;
import bluej.stride.slots.TypeTextSlot;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class UnknownTypeError
extends DirectSlotError {
    private final String typeName;
    private final InteractionManager editor;
    private List<FixSuggestion> corrections;

    public UnknownTypeError(TypeSlotFragment slotFragment, String typeName, TypeTextSlot slot, InteractionManager editor, Stream<AssistContentThreadSafe> possibleCorrections, Stream<AssistContentThreadSafe> possibleImports) {
        super(slotFragment);
        this.typeName = typeName;
        this.editor = editor;
        this.corrections = new ArrayList<Correction>(Correction.winnowAndCreateCorrections(typeName, possibleCorrections.map(TypeCorrectionInfo::new), s -> slot.setText((String)s)));
        this.corrections.addAll(possibleImports.filter(ac -> ac.getPackage() != null && ac.getName().equals(typeName)).flatMap(ac -> Stream.of(new ImportSingleFix((AssistContentThreadSafe)ac), new ImportPackageFix((AssistContentThreadSafe)ac))).collect(Collectors.toList()));
    }

    @Override
    public String getMessage() {
        return "Unknown type: " + this.typeName;
    }

    @Override
    public List<? extends FixSuggestion> getFixSuggestions() {
        return this.corrections;
    }

    @Override
    public boolean isJavaPos() {
        return true;
    }

    private class ImportPackageFix
    extends FixSuggestion {
        private final AssistContentThreadSafe classInfo;

        public ImportPackageFix(AssistContentThreadSafe ac) {
            this.classInfo = ac;
        }

        @Override
        public String getDescription() {
            return "Import package " + this.classInfo.getPackage() + " (for " + this.classInfo.getName() + " class)";
        }

        @Override
        public void execute() {
            UnknownTypeError.this.editor.addImport(this.classInfo.getPackage() + ".*");
        }
    }

    private class ImportSingleFix
    extends FixSuggestion {
        private final AssistContentThreadSafe classInfo;

        public ImportSingleFix(AssistContentThreadSafe ac) {
            this.classInfo = ac;
        }

        @Override
        public String getDescription() {
            return "Import class " + this.classInfo.getPackage() + "." + this.classInfo.getName();
        }

        @Override
        public void execute() {
            UnknownTypeError.this.editor.addImport(this.classInfo.getPackage() + "." + this.classInfo.getName());
        }
    }

    private static class TypeCorrectionInfo
    implements Correction.CorrectionInfo {
        private AssistContentThreadSafe ac;

        public TypeCorrectionInfo(AssistContentThreadSafe ac) {
            this.ac = ac;
        }

        @Override
        public String getCorrection() {
            return this.ac.getName();
        }

        @Override
        public String getDisplay() {
            String pkg = this.ac.getPackage();
            if (pkg == null) {
                return this.ac.getName();
            }
            return this.ac.getName() + " (" + this.ac.getPackage() + " package)";
        }
    }
}

