/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.elements;

import bluej.stride.framedjava.ast.AccessPermission;
import bluej.stride.framedjava.ast.AccessPermissionFragment;
import bluej.stride.framedjava.ast.FilledExpressionSlotFragment;
import bluej.stride.framedjava.ast.HighlightedBreakpoint;
import bluej.stride.framedjava.ast.JavaFragment;
import bluej.stride.framedjava.ast.JavaSingleLineDebugHandler;
import bluej.stride.framedjava.ast.JavaSource;
import bluej.stride.framedjava.ast.NameDefSlotFragment;
import bluej.stride.framedjava.ast.SlotFragment;
import bluej.stride.framedjava.ast.TypeSlotFragment;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.frames.DebugInfo;
import bluej.stride.framedjava.frames.VarFrame;
import bluej.stride.generic.Frame;
import bluej.stride.generic.InteractionManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import nu.xom.Attribute;
import nu.xom.Element;

public class VarElement
extends CodeElement
implements JavaSingleLineDebugHandler {
    public static final String ELEMENT = "variable";
    private final AccessPermissionFragment varAccess;
    private boolean staticModifier = false;
    private boolean finalModifier = false;
    private final TypeSlotFragment varType;
    private final NameDefSlotFragment varName;
    private final FilledExpressionSlotFragment varValue;
    private VarFrame frame;

    public VarElement(VarFrame frame, AccessPermissionFragment varAccess, boolean staticModifier, boolean finalModifier, TypeSlotFragment varType, NameDefSlotFragment varName, FilledExpressionSlotFragment varValue, boolean enabled) {
        this.frame = frame;
        this.varAccess = varAccess;
        this.staticModifier = staticModifier;
        this.finalModifier = finalModifier;
        this.varType = varType;
        this.varName = varName;
        this.varValue = varValue;
        this.enable = enabled;
    }

    public VarElement(Element el) {
        Attribute accessAttribute = el.getAttribute("access");
        this.varAccess = accessAttribute == null ? null : new AccessPermissionFragment(AccessPermission.fromString(accessAttribute.getValue()));
        Attribute staticAttribute = el.getAttribute("static");
        this.staticModifier = staticAttribute == null ? false : Boolean.valueOf(staticAttribute.getValue());
        Attribute finalAttribute = el.getAttribute("final");
        this.finalModifier = finalAttribute == null ? false : Boolean.valueOf(finalAttribute.getValue());
        this.varType = new TypeSlotFragment(el.getAttributeValue("type"));
        this.varName = new NameDefSlotFragment(el.getAttributeValue("name"));
        Attribute valueAttribute = el.getAttribute("value");
        this.varValue = valueAttribute == null ? null : new FilledExpressionSlotFragment(valueAttribute.getValue(), el.getAttributeValue("value-java"));
        this.enable = new Boolean(el.getAttributeValue("enable"));
    }

    public VarElement(String access, String type, String name, String value) {
        this.varAccess = access == null ? null : new AccessPermissionFragment(AccessPermission.fromString(access));
        this.varType = new TypeSlotFragment(type);
        this.varName = new NameDefSlotFragment(name);
        this.varValue = value == null ? null : new FilledExpressionSlotFragment(value, value);
    }

    @Override
    public JavaSource toJavaSource() {
        ArrayList<JavaFragment> fragments = new ArrayList<JavaFragment>();
        if (this.varAccess != null) {
            fragments.addAll(Arrays.asList(this.varAccess, VarElement.space()));
        }
        if (this.staticModifier) {
            fragments.add(VarElement.f(this.frame, "static "));
        }
        if (this.finalModifier) {
            fragments.add(VarElement.f(this.frame, "final "));
        }
        fragments.addAll(Arrays.asList(this.varType, VarElement.space(), this.varName));
        if (this.varValue != null) {
            fragments.addAll(Arrays.asList(VarElement.f(null, " = "), this.varValue));
        }
        fragments.add(VarElement.f(this.frame, ";"));
        return new JavaSource((JavaSingleLineDebugHandler)this, fragments);
    }

    @Override
    public Element toXML() {
        Element varEl = new Element(ELEMENT);
        if (this.varAccess != null) {
            varEl.addAttribute(new Attribute("access", this.varAccess.getContent()));
        }
        if (this.staticModifier) {
            varEl.addAttribute(new Attribute("static", "true"));
        }
        if (this.finalModifier) {
            varEl.addAttribute(new Attribute("final", "true"));
        }
        varEl.addAttribute(new Attribute("type", this.varType.getContent()));
        varEl.addAttribute(new Attribute("name", this.varName.getContent()));
        if (this.varValue != null) {
            varEl.addAttribute(new Attribute("value", this.varValue.getContent()));
            varEl.addAttribute(new Attribute("value-java", this.varValue.getJavaCode()));
        }
        this.addEnableAttribute(varEl);
        return varEl;
    }

    @Override
    public Frame createFrame(InteractionManager editor) {
        this.frame = new VarFrame(editor, this.varAccess, this.staticModifier, this.finalModifier, this.varType, this.varName, this.varValue, this.isEnable());
        return this.frame;
    }

    @Override
    public List<CodeElement.LocalParamInfo> getDeclaredVariablesAfter() {
        return Collections.singletonList(new CodeElement.LocalParamInfo(this.varType.getContent(), this.varName.getContent(), false, this));
    }

    @Override
    public HighlightedBreakpoint showDebugBefore(DebugInfo debug) {
        return this.frame.showDebugBefore(debug);
    }

    @Override
    public void show(Frame.ShowReason reason) {
        this.frame.show(reason);
    }

    @Override
    protected Stream<SlotFragment> getDirectSlotFragments() {
        return Stream.of(this.varType, this.varName, this.varValue).filter(s -> s != null);
    }

    public boolean isStatic() {
        return this.staticModifier;
    }

    public boolean isFinal() {
        return this.finalModifier;
    }

    public String getType() {
        return this.varType.getContent();
    }

    public String getName() {
        return this.varName.getContent();
    }

    public String getValue() {
        return this.varValue != null ? this.varValue.getContent() : null;
    }
}

