/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.elements;

import bluej.stride.framedjava.ast.HighlightedBreakpoint;
import bluej.stride.framedjava.ast.JavaFragment;
import bluej.stride.framedjava.ast.JavaSingleLineDebugHandler;
import bluej.stride.framedjava.ast.JavaSource;
import bluej.stride.framedjava.ast.OptionalExpressionSlotFragment;
import bluej.stride.framedjava.ast.SlotFragment;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.frames.DebugInfo;
import bluej.stride.framedjava.frames.ReturnFrame;
import bluej.stride.generic.Frame;
import bluej.stride.generic.InteractionManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Stream;
import nu.xom.Attribute;
import nu.xom.Element;

public class ReturnElement
extends CodeElement
implements JavaSingleLineDebugHandler {
    public static final String ELEMENT = "return";
    private final OptionalExpressionSlotFragment val;
    private ReturnFrame frame;

    public ReturnElement(ReturnFrame frame, OptionalExpressionSlotFragment val, boolean enabled) {
        this.frame = frame;
        this.val = val;
        this.enable = enabled;
    }

    @Override
    public JavaSource toJavaSource() {
        ArrayList<JavaFragment> fragments = new ArrayList<JavaFragment>();
        fragments.add(ReturnElement.f(this.frame, ELEMENT));
        if (this.val != null) {
            fragments.addAll(Arrays.asList(ReturnElement.space(), this.val));
        }
        fragments.add(ReturnElement.f(this.frame, ";"));
        return new JavaSource((JavaSingleLineDebugHandler)this, fragments);
    }

    @Override
    public Element toXML() {
        Element retEl = new Element(ELEMENT);
        if (this.val != null) {
            retEl.addAttribute(new Attribute("value", this.val.getContent()));
            retEl.addAttribute(new Attribute("value-java", this.val.getJavaCode()));
        }
        this.addEnableAttribute(retEl);
        return retEl;
    }

    public ReturnElement(Element el) {
        Attribute valueAttribute = el.getAttribute("value");
        this.val = valueAttribute == null ? null : new OptionalExpressionSlotFragment(valueAttribute.getValue(), el.getAttributeValue("value-java"));
        this.enable = Boolean.valueOf(el.getAttributeValue("enable"));
    }

    @Override
    public Frame createFrame(InteractionManager editor) {
        this.frame = new ReturnFrame(editor, this.val, this.isEnable());
        return this.frame;
    }

    @Override
    public HighlightedBreakpoint showDebugBefore(DebugInfo debug) {
        return this.frame.showDebugBefore(debug);
    }

    @Override
    public void show(Frame.ShowReason reason) {
        this.frame.show(reason);
    }

    @Override
    protected Stream<SlotFragment> getDirectSlotFragments() {
        return this.val == null ? Stream.empty() : Stream.of(this.val);
    }
}

