/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.elements;

import bluej.debugger.gentype.ConstructorReflective;
import bluej.editor.moe.MoeSyntaxDocument;
import bluej.parser.CodeSuggestions;
import bluej.parser.entity.EntityResolver;
import bluej.stride.framedjava.ast.JavaFragment;
import bluej.stride.framedjava.ast.JavaSource;
import bluej.stride.framedjava.ast.JavadocUnit;
import bluej.stride.framedjava.ast.NameDefSlotFragment;
import bluej.stride.framedjava.ast.SlotFragment;
import bluej.stride.framedjava.ast.StringSlotFragment;
import bluej.stride.framedjava.ast.TypeSlotFragment;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.DocumentContainerCodeElement;
import bluej.stride.framedjava.elements.ImportElement;
import bluej.stride.framedjava.elements.TopLevelCodeElement;
import bluej.stride.framedjava.frames.InterfaceFrame;
import bluej.stride.framedjava.frames.TopLevelFrame;
import bluej.stride.framedjava.slots.ExpressionSlot;
import bluej.stride.generic.AssistContentThreadSafe;
import bluej.stride.generic.Frame;
import bluej.stride.generic.InteractionManager;
import bluej.utility.Debug;
import bluej.utility.Utility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import threadchecker.OnThread;
import threadchecker.Tag;

public class InterfaceElement
extends DocumentContainerCodeElement
implements TopLevelCodeElement {
    public static final String ELEMENT = "interface";
    private final NameDefSlotFragment interfaceName;
    private final List<TypeSlotFragment> extendsTypes;
    private JavadocUnit documentation;
    private final List<ImportElement> imports;
    private final List<CodeElement> members;
    private InterfaceFrame frame;
    private JavaFragment openingCurly;
    private final EntityResolver projectResolver;
    private MoeSyntaxDocument sourceDocument;
    private ExpressionSlot<?> sourceDocumentCompleting;

    public InterfaceElement(InterfaceFrame frame, EntityResolver projectResolver, NameDefSlotFragment interfaceName, List<TypeSlotFragment> extendsTypes, List<CodeElement> members, JavadocUnit documentation, List<ImportElement> imports, boolean enabled) {
        this.frame = frame;
        this.interfaceName = interfaceName;
        this.extendsTypes = new ArrayList<TypeSlotFragment>(extendsTypes);
        this.documentation = documentation;
        this.imports = new ArrayList<ImportElement>(imports);
        this.members = new ArrayList<CodeElement>(members);
        for (CodeElement member : members) {
            member.setParent(this);
        }
        this.enable = enabled;
        if (documentation == null) {
            documentation = new JavadocUnit("");
        }
        this.projectResolver = projectResolver;
    }

    public InterfaceElement(Element el, EntityResolver projectResolver) {
        this.projectResolver = projectResolver;
        this.interfaceName = new NameDefSlotFragment(el.getAttributeValue("name"));
        this.imports = Utility.mapList(TopLevelCodeElement.fillChildrenElements(this, el, "imports"), e -> (ImportElement)e);
        this.members = TopLevelCodeElement.fillChildrenElements(this, el, "methods");
        Element javadocEL = el.getFirstChildElement("javadoc");
        if (javadocEL != null) {
            this.documentation = new JavadocUnit(javadocEL);
        }
        if (this.documentation == null) {
            this.documentation = new JavadocUnit("");
        }
        this.extendsTypes = Utility.mapList(TopLevelCodeElement.xmlToStringList(el, "extends", "extendstype", "type"), TypeSlotFragment::new);
        this.enable = Boolean.valueOf(el.getAttributeValue("enable"));
        if (this.documentation == null) {
            this.documentation = new JavadocUnit("");
        }
    }

    @Override
    public CodeSuggestions getCodeSuggestions(JavaFragment.PosInSourceDoc pos, ExpressionSlot<?> completing) {
        MoeSyntaxDocument doc = this.getSourceDocument(completing);
        return doc.getParser().getExpressionType(0, (Document)this.getSourceDocument(completing));
    }

    @Override
    public Element toXML() {
        Element interfaceEl = new Element(ELEMENT);
        interfaceEl.addAttribute(new Attribute("name", this.interfaceName.getContent()));
        if (!this.extendsTypes.isEmpty()) {
            interfaceEl.appendChild((Node)TopLevelCodeElement.stringListToXML(Utility.mapList(this.extendsTypes, StringSlotFragment::getContent), "extends", "extendstype", "type"));
        }
        this.addEnableAttribute(interfaceEl);
        if (this.documentation != null) {
            interfaceEl.appendChild((Node)this.documentation.toXML());
        }
        Element importsEl = new Element("imports");
        this.imports.forEach(imp -> importsEl.appendChild((Node)imp.toXML()));
        interfaceEl.appendChild((Node)importsEl);
        this.members.forEach(e -> interfaceEl.appendChild((Node)e.toXML()));
        return interfaceEl;
    }

    @Override
    public JavaSource toJavaSource() {
        JavaSource java;
        this.openingCurly = InterfaceElement.f(this.frame, "{");
        if (this.extendsTypes.isEmpty()) {
            java = new JavaSource(null, InterfaceElement.f(this.frame, "public interface "), this.interfaceName, this.openingCurly);
        } else {
            ArrayList<JavaFragment> line = new ArrayList<JavaFragment>();
            line.addAll(Arrays.asList(InterfaceElement.f(this.frame, "public interface "), this.interfaceName, InterfaceElement.f(this.frame, " extends ")));
            line.addAll((Collection)this.extendsTypes.stream().collect(Utility.intersperse(() -> InterfaceElement.f(this.frame, ", "))));
            line.add(this.openingCurly);
            java = new JavaSource(null, line);
        }
        java.prependJavadoc(this.documentation.getJavaCode());
        this.imports.forEach(imp -> java.prependLine(Arrays.asList(InterfaceElement.f(this.frame, "import " + imp + ";")), null));
        java.prependLine(Arrays.asList(InterfaceElement.f(this.frame, "// WARNING: This file is auto-generated and any changes to it will be overwritten")), null);
        this.members.forEach(c -> {
            if (c.isEnable()) {
                java.addIndented(c.toJavaSource());
            }
        });
        java.appendLine(Arrays.asList(InterfaceElement.f(this.frame, "}")), null);
        return java;
    }

    @Override
    public InterfaceFrame createFrame(InteractionManager editor) {
        this.frame = new InterfaceFrame(editor, this.interfaceName, this.extendsTypes, this.projectResolver, this.documentation, this.enable);
        this.members.forEach(member -> this.frame.getCanvas().insertBlockAfter(member.createFrame(editor), null));
        return this.frame;
    }

    public InterfaceFrame createTopLevelFrame(InteractionManager editor) {
        return this.createFrame(editor);
    }

    @Override
    public List<ImportElement> getImports() {
        return Collections.unmodifiableList(this.imports);
    }

    @Override
    public String getName() {
        return this.interfaceName.getContent();
    }

    @Override
    public List<CodeElement> childrenUpTo(CodeElement c) {
        return this.members.subList(0, this.members.indexOf(c));
    }

    @Override
    public String getStylePrefix() {
        return "interface-";
    }

    @Override
    public EntityResolver getResolver() {
        return this.getSourceDocument(null).getParser();
    }

    @Override
    public TopLevelFrame getFrame() {
        return this.frame;
    }

    @Override
    public InteractionManager getEditor() {
        return this.frame.getEditor();
    }

    @Override
    public void show(Frame.ShowReason reason) {
        this.frame.show(reason);
    }

    @OnThread(value=Tag.Swing)
    private MoeSyntaxDocument getSourceDocument(ExpressionSlot<?> completing) {
        if (this.sourceDocument == null || this.sourceDocumentCompleting != completing) {
            this.sourceDocument = new MoeSyntaxDocument(this.projectResolver);
            this.sourceDocumentCompleting = completing;
            try {
                String src = this.toJavaSource().toMemoryJavaCodeString(null, completing);
                this.sourceDocument.insertString(0, src, null);
                this.sourceDocument.enableParser(true);
            }
            catch (BadLocationException e) {
                Debug.reportError(e);
            }
        }
        return this.sourceDocument;
    }

    @Override
    public Stream<CodeElement> streamContained() {
        return InterfaceElement.streamContained(this.members);
    }

    @Override
    protected Stream<SlotFragment> getDirectSlotFragments() {
        return Stream.concat(Stream.of(this.interfaceName), this.extendsTypes.stream()).filter(s -> s != null);
    }

    @Override
    public void updateSourcePositions() {
        SwingUtilities.invokeLater(() -> this.getSourceDocument(null));
    }

    @Override
    public List<ConstructorReflective> getSuperConstructors() {
        return Collections.emptyList();
    }

    @Override
    public List<AssistContentThreadSafe> getThisConstructors() {
        return Collections.emptyList();
    }
}

