/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.elements;

import bluej.stride.framedjava.ast.JavaFragment;
import bluej.stride.framedjava.ast.JavaSource;
import bluej.stride.framedjava.ast.SlotFragment;
import bluej.stride.framedjava.ast.TextSlotFragment;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.errors.CodeError;
import bluej.stride.framedjava.errors.SyntaxCodeError;
import bluej.stride.framedjava.frames.ImportFrame;
import bluej.stride.framedjava.slots.ExpressionSlot;
import bluej.stride.generic.Frame;
import bluej.stride.generic.InteractionManager;
import bluej.stride.slots.EditableSlot;
import bluej.stride.slots.TextSlot;
import java.util.List;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import nu.xom.Attribute;
import nu.xom.Element;

public class ImportElement
extends CodeElement {
    public static final String ELEMENT = "import";
    private ImportFrame frame;
    private final ImportFragment importValue;

    public ImportElement(Element el) {
        this.importValue = new ImportFragment(el.getAttributeValue("target"), null);
        this.enable = Boolean.valueOf(el.getAttributeValue("enable"));
    }

    public ImportElement(String src, TextSlot<ImportFragment> slot, boolean enabled) {
        this.importValue = new ImportFragment(src, slot);
        this.enable = enabled;
    }

    @Override
    public JavaSource toJavaSource() {
        return new JavaSource(null, ImportElement.f(this.frame, "import "), this.importValue, ImportElement.f(this.frame, ";"));
    }

    @Override
    public Element toXML() {
        Element importEl = new Element(ELEMENT);
        importEl.addAttribute(new Attribute("target", this.importValue.getContent()));
        this.addEnableAttribute(importEl);
        return importEl;
    }

    @Override
    public ImportFrame createFrame(InteractionManager editor) {
        this.frame = new ImportFrame(editor, this, this.isEnable());
        return this.frame;
    }

    @Override
    public void show(Frame.ShowReason reason) {
        this.frame.show(reason);
    }

    @Override
    protected Stream<SlotFragment> getDirectSlotFragments() {
        return Stream.of(this.importValue);
    }

    public ImportFragment getImport() {
        return this.importValue;
    }

    public static class ImportFragment
    extends TextSlotFragment {
        private TextSlot<ImportFragment> slot;

        public ImportFragment(String content, TextSlot slot) {
            super(content);
            this.slot = slot;
        }

        @Override
        public void registerSlot(TextSlot slot) {
            this.slot = slot;
        }

        @Override
        public Future<List<CodeError>> findLateErrors(InteractionManager editor, CodeElement parent) {
            return null;
        }

        @Override
        protected String getJavaCode(JavaFragment.Destination dest, ExpressionSlot<?> completing) {
            return this.getContent();
        }

        @Override
        public EditableSlot getSlot() {
            return this.slot;
        }

        @Override
        public Stream<SyntaxCodeError> findEarlyErrors() {
            return Stream.empty();
        }
    }
}

