/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.elements;

import bluej.stride.framedjava.ast.HighlightedBreakpoint;
import bluej.stride.framedjava.ast.JavaSingleLineDebugHandler;
import bluej.stride.framedjava.ast.JavaSource;
import bluej.stride.framedjava.ast.SlotFragment;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.frames.BreakpointFrame;
import bluej.stride.framedjava.frames.DebugInfo;
import bluej.stride.generic.Frame;
import bluej.stride.generic.InteractionManager;
import java.util.stream.Stream;
import nu.xom.Element;

public class BreakpointElement
extends CodeElement
implements JavaSingleLineDebugHandler {
    public static final String ELEMENT = "breakpoint";
    private BreakpointFrame frame;

    public BreakpointElement(BreakpointFrame frame, boolean enabled) {
        this.frame = frame;
        this.enable = enabled;
    }

    @Override
    public JavaSource toJavaSource() {
        return JavaSource.createBreakpoint(this.frame, this);
    }

    @Override
    public Element toXML() {
        Element breakpointEl = new Element(ELEMENT);
        this.addEnableAttribute(breakpointEl);
        return breakpointEl;
    }

    public BreakpointElement(Element el) {
        this.enable = Boolean.valueOf(el.getAttributeValue("enable"));
    }

    @Override
    public Frame createFrame(InteractionManager editor) {
        this.frame = new BreakpointFrame(editor, this.isEnable());
        return this.frame;
    }

    @Override
    public HighlightedBreakpoint showDebugBefore(DebugInfo debug) {
        return this.frame.showDebugBefore(debug);
    }

    @Override
    public void show(Frame.ShowReason reason) {
        this.frame.show(reason);
    }

    @Override
    protected Stream<SlotFragment> getDirectSlotFragments() {
        return Stream.empty();
    }
}

