/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.ast;

import bluej.stride.framedjava.ast.JavaFragment;
import bluej.stride.framedjava.ast.Parser;
import bluej.stride.framedjava.ast.TextSlotFragment;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.errors.CodeError;
import bluej.stride.framedjava.errors.EmptyError;
import bluej.stride.framedjava.errors.SyntaxCodeError;
import bluej.stride.framedjava.errors.UnknownTypeError;
import bluej.stride.framedjava.errors.UnneededSemiColonError;
import bluej.stride.framedjava.slots.ExpressionSlot;
import bluej.stride.generic.AssistContentThreadSafe;
import bluej.stride.generic.InteractionManager;
import bluej.stride.slots.TextSlot;
import bluej.stride.slots.TypeTextSlot;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.stream.Stream;

public class TypeSlotFragment
extends TextSlotFragment {
    private TypeTextSlot slot;

    public TypeSlotFragment(String content, TypeTextSlot slot) {
        super(content);
        this.slot = slot;
    }

    public TypeSlotFragment(String content) {
        this(content, null);
    }

    @Override
    public String getJavaCode(JavaFragment.Destination dest, ExpressionSlot<?> completing) {
        if (!dest.substitute() || this.content != null && Parser.parseableAsType(this.content)) {
            return this.content;
        }
        return "int";
    }

    @Override
    public Stream<SyntaxCodeError> findEarlyErrors() {
        if (this.content != null && this.content.isEmpty()) {
            return Stream.of(new EmptyError(this, "Type cannot be empty"));
        }
        if (this.content != null && this.content.endsWith(";")) {
            return Stream.of(new UnneededSemiColonError(this, () -> ((TextSlot)this.getSlot()).setText(this.content.substring(0, this.content.length() - 1))));
        }
        if (this.content == null || !Parser.parseableAsType(this.content)) {
            return Stream.of(new SyntaxCodeError(this, "Invalid type"));
        }
        return Stream.empty();
    }

    @Override
    public Future<List<CodeError>> findLateErrors(InteractionManager editor, CodeElement parent) {
        CompletableFuture<List<CodeError>> f = new CompletableFuture<List<CodeError>>();
        if (this.findEarlyErrors().count() > 0L || this.content.contains("[") || this.content.contains("<")) {
            f.complete(Collections.emptyList());
            return f;
        }
        editor.withTypes(types -> {
            for (AssistContentThreadSafe t : types) {
                if (!t.getName().equals(this.content)) continue;
                f.complete(Collections.emptyList());
                return;
            }
            f.complete(Arrays.asList(new UnknownTypeError(this, this.content, this.slot, editor, types.stream(), editor.getOtherPopularImports().stream())));
        });
        return f;
    }

    @Override
    public TextSlot<TypeSlotFragment> getSlot() {
        return this.slot;
    }

    @Override
    public void registerSlot(TextSlot slot) {
        if (this.slot == null) {
            this.slot = (TypeTextSlot)slot;
        }
    }
}

