/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.ast;

import bluej.editor.Editor;
import bluej.editor.EditorWatcher;
import bluej.stride.framedjava.ast.FrameFragment;
import bluej.stride.framedjava.ast.HighlightedBreakpoint;
import bluej.stride.framedjava.ast.JavaContainerDebugHandler;
import bluej.stride.framedjava.ast.JavaFragment;
import bluej.stride.framedjava.ast.JavaSingleLineDebugHandler;
import bluej.stride.framedjava.ast.JavadocUnit;
import bluej.stride.framedjava.frames.DebugInfo;
import bluej.stride.framedjava.slots.ExpressionSlot;
import bluej.stride.generic.Frame;
import bluej.utility.Debug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import threadchecker.OnThread;
import threadchecker.Tag;

public class JavaSource {
    private final List<SourceLine> lines = new ArrayList<SourceLine>();

    public JavaSource(JavaSource copyFrom) {
        this.lines.addAll(copyFrom.lines);
    }

    public JavaSource(JavaSingleLineDebugHandler debugHandler, JavaFragment ... line) {
        this.appendLine(Arrays.asList(line), debugHandler);
    }

    public JavaSource(JavaSingleLineDebugHandler debugHandler, List<JavaFragment> line) {
        this.appendLine(line, debugHandler);
    }

    public void appendLine(List<JavaFragment> line, JavaSingleLineDebugHandler debugHandler) {
        this.addLine(this.lines.size(), line, debugHandler);
    }

    public void prependLine(List<JavaFragment> line, JavaSingleLineDebugHandler debugHandler) {
        this.addLine(0, line, debugHandler);
    }

    public void prepend(JavaSource src) {
        this.lines.addAll(0, src.lines);
    }

    public void appened(JavaSource javaCode) {
        this.lines.addAll(javaCode.lines);
    }

    private void addLine(int position, List<JavaFragment> line, JavaSingleLineDebugHandler debugHandler) {
        this.lines.add(position, new SourceLine("", line, debugHandler, false));
    }

    public void addIndented(JavaSource javaCode) {
        Iterator<SourceLine> iterator = javaCode.lines.iterator();
        while (iterator.hasNext()) {
            SourceLine line;
            SourceLine sourceLine = line = iterator.next();
            sourceLine.indent = sourceLine.indent + "    ";
        }
        this.appened(javaCode);
    }

    @OnThread(value=Tag.FX)
    public String toDiskJavaCodeString() {
        return this.toJavaCodeString(JavaFragment.Destination.JAVA_FILE_TO_COMPILE, null, (frag, pos, lineNumber, columnNumber, len) -> frag.recordDiskPosition(lineNumber, columnNumber, len));
    }

    public String toMemoryJavaCodeString(IdentityHashMap<JavaFragment, Integer> positions, ExpressionSlot<?> completing) {
        return this.toJavaCodeString(JavaFragment.Destination.SOURCE_DOC_TO_ANALYSE, completing, (frag, pos, a, b, c) -> positions.put(frag, pos));
    }

    @OnThread(value=Tag.Any)
    public String toTemporaryJavaCodeString() {
        return this.toJavaCodeString(JavaFragment.Destination.TEMPORARY, null, (frag, pos, a, b, c) -> {});
    }

    @OnThread(value=Tag.Any)
    private String toJavaCodeString(JavaFragment.Destination dest, ExpressionSlot<?> completing, Recorder recorder) {
        StringBuilder sourceString = new StringBuilder();
        int lineNumber = 1;
        for (SourceLine line : this.lines) {
            int sourceLength = sourceString.length();
            StringBuilder oneLineString = new StringBuilder(100);
            oneLineString.append(line.indent);
            for (JavaFragment fragment : line.content) {
                int lineLength = oneLineString.length();
                String codeLine = fragment.getJavaCode(dest, completing);
                recorder.recordPosition(fragment, sourceLength + lineLength, lineNumber, lineLength + 1, codeLine.length());
                if (codeLine.contains("\n") || codeLine.contains("\r")) {
                    throw new IllegalStateException("Source line contains \\n or \\r! Line: " + codeLine);
                }
                oneLineString.append(codeLine);
            }
            sourceString.append(oneLineString.toString()).append("\n");
            ++lineNumber;
        }
        return sourceString.toString();
    }

    @OnThread(value=Tag.FX)
    public boolean handleError(int startLine, int startColumn, int endLine, int endColumn, String message, boolean force) {
        if (startLine == this.lines.size() + 1) {
            --startLine;
        }
        if (startLine >= this.lines.size() || startLine == -1) {
            if (!force) {
                return false;
            }
            for (int i = this.lines.size() - 1; i >= 0; --i) {
                List frags = this.lines.get(i).content;
                for (int j = frags.size() - 1; j >= 0; --j) {
                    JavaFragment f = (JavaFragment)frags.get(j);
                    if (f.checkCompileError(startLine, startColumn, endLine, endColumn) == JavaFragment.ErrorRelation.CANNOT_SHOW) continue;
                    f.showCompileError(startLine, startColumn, endLine, endColumn, "Error at unexpected position: " + message);
                    return true;
                }
            }
            Debug.message("No fragments found capable of showing error (shouldn't happen): " + message);
            return false;
        }
        JavaFragment last = null;
        for (JavaFragment f : this.lines.get(startLine - 1).content) {
            JavaFragment.ErrorRelation r = f.checkCompileError(startLine, startColumn, endLine, endColumn);
            if (r == JavaFragment.ErrorRelation.CANNOT_SHOW) continue;
            if (r == JavaFragment.ErrorRelation.BEFORE_FRAGMENT && last != null) {
                last.showCompileError(startLine, startColumn, endLine, endColumn, message);
                return true;
            }
            if (r != JavaFragment.ErrorRelation.AFTER_FRAGMENT) {
                f.showCompileError(startLine, startColumn, endLine, endColumn, message);
                return true;
            }
            last = f;
        }
        if (last != null) {
            last.showCompileError(startLine, startColumn, endLine, endColumn, message);
            return true;
        }
        Debug.reportError("No slots found to show compile error: (" + startLine + "," + startColumn + ")->(" + endLine + "," + endColumn + "): " + message);
        return false;
    }

    @OnThread(value=Tag.FX)
    public HighlightedBreakpoint handleStop(int line, DebugInfo debug) {
        JavaSingleLineDebugHandler handler = this.lines.get(line - 1).debugHandler;
        if (handler != null) {
            return handler.showDebugBefore(debug);
        }
        Debug.message("Cannot debug line: " + this.lines.get(line - 1).content);
        return null;
    }

    @OnThread(value=Tag.FX)
    public void handleException(int lineNumber) {
        Debug.message("Handling " + lineNumber);
        JavaSingleLineDebugHandler handler = this.lines.get(lineNumber - 1).debugHandler;
        if (handler != null) {
            handler.showException();
        } else {
            Debug.message("Cannot show exception for line: " + this.lines.get(lineNumber - 1).content);
        }
    }

    @OnThread(value=Tag.Swing)
    public void registerBreakpoints(Editor editor, EditorWatcher watcher) {
        for (int i = 0; i < this.lines.size(); ++i) {
            if (!this.lines.get(i).breakpoint) continue;
            watcher.breakpointToggleEvent(editor, i + 1, true);
        }
    }

    public static JavaSource createMethod(Frame frame, JavaSingleLineDebugHandler debugHandler, JavadocUnit documentation, List<JavaFragment> header, List<JavaSource> contents) {
        JavaSource parent = new JavaSource(debugHandler, header);
        parent.prependJavadoc(documentation.getJavaCode());
        parent.appendLine(Arrays.asList(new FrameFragment(frame, "{")), null);
        for (JavaSource src : contents) {
            parent.addIndented(src);
        }
        parent.appendLine(Arrays.asList(new FrameFragment(frame, "}")), debugHandler);
        return parent;
    }

    public static JavaSource createCompoundStatement(Frame frame, JavaSingleLineDebugHandler headerDebugHandler, JavaContainerDebugHandler endDebugHandler, List<JavaFragment> header, List<JavaSource> contents) {
        return JavaSource.createCompoundStatement(frame, headerDebugHandler, endDebugHandler, header, contents, null);
    }

    public static JavaSource createCompoundStatement(Frame frame, JavaSingleLineDebugHandler headerDebugHandler, JavaContainerDebugHandler endDebugHandler, List<JavaFragment> header, List<JavaSource> contents, JavaFragment footer) {
        ArrayList<JavaFragment> headerAndBrace = new ArrayList<JavaFragment>(header);
        headerAndBrace.add(new FrameFragment(frame, " {"));
        JavaSource parent = new JavaSource(headerDebugHandler, headerAndBrace);
        for (JavaSource src : contents) {
            parent.addIndented(src);
        }
        parent.appendLine(Arrays.asList(new FrameFragment(frame, "}")), null);
        if (footer != null) {
            parent.addIndented(new JavaSource(headerDebugHandler, footer));
        }
        return parent;
    }

    public static JavaSource createBreakpoint(Frame frame, JavaSingleLineDebugHandler handler) {
        JavaSource r = new JavaSource(handler, new JavaFragment[0]);
        r.lines.add(new SourceLine("", Arrays.asList(new FrameFragment(frame, "{ int org_greenfoot_debug_frame = 7; } /* dummy code for breakpoint */")), handler, true));
        return r;
    }

    public JavaSingleLineDebugHandler internalGetDebugHandler(int i) {
        return this.lines.get(i).debugHandler;
    }

    public void prependJavadoc(List<String> javadocLines) {
        for (int i = javadocLines.size() - 1; i >= 0; --i) {
            this.prependLine(Arrays.asList(new FrameFragment(null, javadocLines.get(i))), null);
        }
    }

    public Stream<JavaFragment> getAllFragments() {
        return this.lines.stream().flatMap(l -> ((SourceLine)l).content.stream());
    }

    private static interface Recorder {
        public void recordPosition(JavaFragment var1, int var2, int var3, int var4, int var5);
    }

    private static class SourceLine {
        private String indent;
        private final List<JavaFragment> content;
        private final JavaSingleLineDebugHandler debugHandler;
        private final boolean breakpoint;

        public SourceLine(String indent, List<JavaFragment> content, JavaSingleLineDebugHandler debugHandler, boolean breakpoint) {
            if (indent == null || content == null) {
                throw new IllegalArgumentException("Null argument to SourceLine");
            }
            this.indent = indent;
            this.content = content;
            this.debugHandler = debugHandler;
            this.breakpoint = breakpoint;
            for (JavaFragment f : content) {
                if (f != null) continue;
                throw new IllegalArgumentException("Cannot have null Java fragment in sourceLine");
            }
        }
    }
}

