/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.ast;

import bluej.parser.JavaParser;
import bluej.parser.lexer.LocatableToken;
import bluej.stride.framedjava.ast.ASTUtility;
import bluej.stride.framedjava.ast.JavaFragment;
import bluej.stride.framedjava.ast.Parser;
import bluej.stride.framedjava.ast.StringSlotFragment;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.errors.CodeError;
import bluej.stride.framedjava.errors.SyntaxCodeError;
import bluej.stride.framedjava.errors.UndeclaredVariableInExpressionError;
import bluej.stride.framedjava.errors.UndeclaredVariableLvalueError;
import bluej.stride.framedjava.errors.UnneededSemiColonError;
import bluej.stride.framedjava.frames.AssignFrame;
import bluej.stride.framedjava.slots.ExpressionSlot;
import bluej.stride.generic.InteractionManager;
import bluej.utility.Utility;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.application.Platform;

public abstract class ExpressionSlotFragment
extends StringSlotFragment {
    private ExpressionSlot slot;
    private String javaCode;
    private final List<LocatableToken> plains = new ArrayList<LocatableToken>();
    private List<LocatableToken> curCompound = null;
    private final List<List<LocatableToken>> compounds = new ArrayList<List<LocatableToken>>();
    private final List<List<LocatableToken>> types = new ArrayList<List<LocatableToken>>();
    private Map<String, CodeElement> vars;
    private AssignFrame assignmentLHSParent;

    public ExpressionSlotFragment(String content, String javaCode, ExpressionSlot slot) {
        super(content);
        this.javaCode = javaCode;
        this.slot = slot;
        if (javaCode == null) {
            this.javaCode = content;
        }
        Parser.parseAsExpression(new JavaParser(new StringReader(this.wrapForParse(this.javaCode)), false){

            @Override
            protected void gotIdentifier(LocatableToken token) {
                ExpressionSlotFragment.this.plains.add(ExpressionSlotFragment.this.unwrapForParse(token));
            }

            @Override
            protected void gotIdentifierEOF(LocatableToken token) {
                ExpressionSlotFragment.this.plains.add(ExpressionSlotFragment.this.unwrapForParse(token));
            }

            @Override
            protected void gotArrayTypeIdentifier(LocatableToken token) {
            }

            @Override
            protected void gotParentIdentifier(LocatableToken token) {
            }

            @Override
            protected void gotCompoundIdent(LocatableToken token) {
                if (ExpressionSlotFragment.this.curCompound != null) {
                    throw new IllegalStateException();
                }
                ExpressionSlotFragment.this.curCompound = new ArrayList();
                ExpressionSlotFragment.this.curCompound.add(token);
            }

            @Override
            protected void gotCompoundComponent(LocatableToken token) {
                if (ExpressionSlotFragment.this.curCompound == null || ExpressionSlotFragment.this.curCompound.isEmpty()) {
                    throw new IllegalStateException();
                }
                ExpressionSlotFragment.this.curCompound.add(token);
            }

            @Override
            protected void gotMemberAccess(LocatableToken token) {
            }

            @Override
            protected void completeCompoundValue(LocatableToken token) {
                ExpressionSlotFragment.this.compounds.add(this.finishCompound(token));
            }

            private List<LocatableToken> finishCompound(LocatableToken token) {
                if (ExpressionSlotFragment.this.curCompound == null || ExpressionSlotFragment.this.curCompound.isEmpty()) {
                    throw new IllegalStateException();
                }
                ExpressionSlotFragment.this.curCompound.add(token);
                List<LocatableToken> r = Utility.mapList(ExpressionSlotFragment.this.curCompound, ExpressionSlotFragment.this::unwrapForParse);
                ExpressionSlotFragment.this.curCompound = null;
                return r;
            }

            @Override
            protected void completeCompoundClass(LocatableToken token) {
                ExpressionSlotFragment.this.types.add(this.finishCompound(token));
            }

            @Override
            protected void gotTypeSpec(List<LocatableToken> tokens) {
                ExpressionSlotFragment.this.types.add(Utility.mapList(tokens, ExpressionSlotFragment.this::unwrapForParse));
            }
        });
    }

    public ExpressionSlotFragment(String content, String javaCode) {
        this(content, javaCode, null);
    }

    public ExpressionSlotFragment(ExpressionSlotFragment f) {
        this(f.content, f.javaCode);
    }

    public String getJavaCode() {
        return this.javaCode;
    }

    @Override
    public String getJavaCode(JavaFragment.Destination dest, ExpressionSlot<?> completing) {
        if (!dest.substitute() || this.slot == completing || this.javaCode != null && Parser.parseableAsExpression(this.wrapForParse(this.javaCode))) {
            return this.javaCode;
        }
        return "true";
    }

    @Override
    public ExpressionSlot getSlot() {
        return this.slot;
    }

    public void registerSlot(ExpressionSlot slot) {
        if (this.slot == null) {
            this.slot = slot;
        }
    }

    protected abstract boolean isRequired();

    protected String wrapForParse(String orig) {
        return orig;
    }

    protected LocatableToken unwrapForParse(LocatableToken token) {
        return token;
    }

    @Override
    public Stream<SyntaxCodeError> findEarlyErrors() {
        if (this.content != null && this.content.endsWith(";")) {
            return Stream.of(new UnneededSemiColonError(this, () -> this.getSlot().setText(this.content.substring(0, this.content.length() - 1))));
        }
        if (this.content != null && this.content.isEmpty() && this.isRequired()) {
            return Stream.of(new SyntaxCodeError(this, "Expression cannot be empty"));
        }
        if (this.content == null || !Parser.parseableAsExpression(this.wrapForParse(this.getJavaCode()))) {
            return Stream.of(new SyntaxCodeError(this, "Invalid expression"));
        }
        return Stream.empty();
    }

    @Override
    public Future<List<CodeError>> findLateErrors(InteractionManager editor, CodeElement parent) {
        CompletableFuture<List<CodeError>> f = new CompletableFuture<List<CodeError>>();
        Platform.runLater(() -> ASTUtility.withLocalsParamsAndFields(parent, editor, this.getPosInSourceDoc(), this.includeDirectDecl(), vars -> {
            this.vars = vars;
            f.complete(this.plains.stream().map(identToken -> {
                if (!vars.containsKey(identToken.getText())) {
                    if (this.assignmentLHSParent != null && identToken.getText().equals(this.getJavaCode())) {
                        return new UndeclaredVariableLvalueError(this, this.assignmentLHSParent, vars.keySet());
                    }
                    return new UndeclaredVariableInExpressionError(this, identToken.getText(), identToken.getColumn() - 1, identToken.getColumn() - 1 + identToken.getLength(), this.slot, vars.keySet());
                }
                return null;
            }).filter(x -> x != null).collect(Collectors.toList()));
        }));
        return f;
    }

    protected boolean includeDirectDecl() {
        return false;
    }

    public void markAssignmentLHS(AssignFrame parent) {
        this.assignmentLHSParent = parent;
    }

    public Map<String, CodeElement> getVars() {
        return this.vars;
    }
}

