/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.target;

import bluej.Config;
import bluej.editor.Editor;
import bluej.editor.EditorManager;
import bluej.graph.GraphEditor;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.graphPainter.ReadmeTargetPainter;
import bluej.pkgmgr.target.EditableTarget;
import bluej.prefmgr.PrefMgr;
import bluej.utility.Debug;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class ReadmeTarget
extends EditableTarget {
    private static final int WIDTH = ReadmeTargetPainter.getMaxImageWidth();
    private static final int HEIGHT = ReadmeTargetPainter.getMaxImageHeight();
    private static String openStr = Config.getString("pkgmgr.packagemenu.open");
    private static final Color envOpColour = Config.ENV_COLOUR;
    public static final String README_ID = "@README";

    public ReadmeTarget(Package pkg) {
        super(pkg, README_ID);
        this.setPos(10, 10);
        this.setSize(WIDTH, HEIGHT);
    }

    @Override
    public void load(Properties props, String prefix) throws NumberFormatException {
        if (props.getProperty(prefix + ".editor.x") != null) {
            this.editorBounds = new Rectangle(Integer.parseInt(props.getProperty(prefix + ".editor.x")), Integer.parseInt(props.getProperty(prefix + ".editor.y")), Integer.parseInt(props.getProperty(prefix + ".editor.width")), Integer.parseInt(props.getProperty(prefix + ".editor.height")));
        }
    }

    @Override
    public File getSourceFile() {
        return new File(this.getPackage().getPath(), "README.TXT");
    }

    @Override
    public boolean isResizable() {
        return false;
    }

    @Override
    public boolean isSaveable() {
        return false;
    }

    @Override
    public Editor getEditor() {
        if (this.editor == null) {
            this.editor = EditorManager.getEditorManager().openText(this.getSourceFile().getPath(), this.getPackage().getProject().getProjectCharset(), "README.TXT", this.getPackage().getProject()::getDefaultSwingTabbedEditor);
        }
        return this.editor;
    }

    private void openEditor() {
        if (this.editor == null && !this.getSourceFile().exists()) {
            try {
                this.getSourceFile().createNewFile();
            }
            catch (IOException ioe) {
                Debug.reportError("Couldn't open README", ioe);
            }
        }
        if (this.getEditor() != null) {
            this.editor.setVisible(true);
        }
    }

    @Override
    public void doubleClick(MouseEvent evt) {
        this.openEditor();
    }

    @Override
    public void popupMenu(int x, int y, GraphEditor editor) {
        JPopupMenu menu = this.createMenu(null);
        if (menu != null) {
            menu.show(editor, x, y);
        }
    }

    private JPopupMenu createMenu(Class<?> cl) {
        JPopupMenu menu = new JPopupMenu();
        OpenAction openAction = new OpenAction(openStr);
        JMenuItem item = menu.add(openAction);
        item.setFont(PrefMgr.getPopupMenuFont());
        item.setForeground(envOpColour);
        return menu;
    }

    @Override
    public void remove() {
    }

    public void generateDoc() {
    }

    public String getProperty(String key) {
        return null;
    }

    public void setProperty(String key, String value) {
    }

    public void recordEdit(String curSource, boolean includeOneLineEdits) {
    }

    @Override
    public String getTooltipText() {
        return "README";
    }

    private class OpenAction
    extends AbstractAction {
        public OpenAction(String menu) {
            super(menu);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ReadmeTarget.this.openEditor();
        }
    }
}

