/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.target;

import bluej.Config;
import bluej.collect.DataCollector;
import bluej.compiler.CompileObserver;
import bluej.compiler.Diagnostic;
import bluej.debugger.DebuggerClass;
import bluej.debugger.gentype.Reflective;
import bluej.debugmgr.objectbench.InvokeListener;
import bluej.editor.Editor;
import bluej.editor.EditorManager;
import bluej.editor.EditorWatcher;
import bluej.editor.TextEditor;
import bluej.editor.stride.FrameEditor;
import bluej.extensions.BClass;
import bluej.extensions.BClassTarget;
import bluej.extensions.BDependency;
import bluej.extensions.ExtensionBridge;
import bluej.extensions.SourceType;
import bluej.extensions.event.ClassEvent;
import bluej.extensions.event.ClassTargetEvent;
import bluej.extensions.event.ExtensionEvent;
import bluej.extmgr.ClassExtensionMenu;
import bluej.extmgr.ExtensionsManager;
import bluej.extmgr.MenuManager;
import bluej.graph.GraphEditor;
import bluej.graph.Moveable;
import bluej.parser.entity.EntityResolver;
import bluej.parser.entity.PackageResolver;
import bluej.parser.entity.ParsedReflective;
import bluej.parser.nodes.JavaParentNode;
import bluej.parser.nodes.ParsedTypeNode;
import bluej.parser.symtab.ClassInfo;
import bluej.parser.symtab.Selection;
import bluej.pkgmgr.JavadocResolver;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.SourceInfo;
import bluej.pkgmgr.dependency.Dependency;
import bluej.pkgmgr.dependency.ExtendsDependency;
import bluej.pkgmgr.dependency.ImplementsDependency;
import bluej.pkgmgr.dependency.UsesDependency;
import bluej.pkgmgr.target.DependentTarget;
import bluej.pkgmgr.target.Target;
import bluej.pkgmgr.target.role.AbstractClassRole;
import bluej.pkgmgr.target.role.AppletClassRole;
import bluej.pkgmgr.target.role.ClassRole;
import bluej.pkgmgr.target.role.EnumClassRole;
import bluej.pkgmgr.target.role.InterfaceClassRole;
import bluej.pkgmgr.target.role.MIDletClassRole;
import bluej.pkgmgr.target.role.StdClassRole;
import bluej.pkgmgr.target.role.UnitTestClassRole;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.FileEditor;
import bluej.utility.FileUtility;
import bluej.utility.JavaNames;
import bluej.utility.JavaReflective;
import bluej.utility.JavaUtils;
import bluej.views.ConstructorView;
import bluej.views.MethodView;
import java.applet.Applet;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javafx.application.Platform;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import junit.framework.TestCase;
import threadchecker.OnThread;
import threadchecker.Tag;

public class ClassTarget
extends DependentTarget
implements Moveable,
InvokeListener {
    static final int MIN_WIDTH = 60;
    static final int MIN_HEIGHT = 30;
    private static final String editStr = Config.getString("pkgmgr.classmenu.edit");
    private static final String compileStr = Config.getString("pkgmgr.classmenu.compile");
    private static final String inspectStr = Config.getString("pkgmgr.classmenu.inspect");
    private static final String removeStr = Config.getString("pkgmgr.classmenu.remove");
    private static final String createTestStr = Config.getString("pkgmgr.classmenu.createTest");
    private static final Color compbg = new Color(200, 150, 100);
    private static String usesArrowMsg = Config.getString("pkgmgr.usesArrowMsg");
    private static String TEMP_FILE_EXTENSION = "-temp";
    private ClassRole role = new StdClassRole();
    private boolean openWithInterface = false;
    private SourceInfo sourceInfo = new SourceInfo();
    private boolean isAbstract;
    private Boolean isNaviviewExpanded = null;
    private boolean analysing = false;
    private int ghostX;
    private int ghostY;
    private int ghostWidth;
    private int ghostHeight;
    private boolean isDragging = false;
    private boolean isMoveable = true;
    private SourceType sourceAvailable;
    private boolean hasBeenOpened = false;
    private boolean modifiedSinceCompile = true;
    private String typeParameters = "";
    private Map<String, String> properties = new HashMap<String, String>();
    private BClass singleBClass;
    private BClassTarget singleBClassTarget;
    private boolean knownError;
    protected JPopupMenu menu = null;
    boolean compiledMenu = false;

    public ClassTarget(Package pkg, String baseName) {
        this(pkg, baseName, null);
    }

    public ClassTarget(Package pkg, String baseName, String template) {
        super(pkg, baseName);
        this.calcSourceAvailable();
        if (template != null) {
            if (template.startsWith("applet")) {
                this.role = new AppletClassRole();
            } else if (template.startsWith("unittest")) {
                this.role = new UnitTestClassRole(true);
            } else if (template.startsWith("abstract")) {
                this.role = new AbstractClassRole();
            } else if (template.startsWith("interface")) {
                this.role = new InterfaceClassRole();
            } else if (template.startsWith("enum")) {
                this.role = new EnumClassRole();
            } else if (template.startsWith("midlet")) {
                this.role = new MIDletClassRole();
            }
        }
        this.setGhostPosition(0, 0);
        this.setGhostSize(0, 0);
    }

    private void calcSourceAvailable() {
        this.sourceAvailable = this.getFrameSourceFile().canRead() ? SourceType.Stride : (this.getJavaSourceFile().canRead() ? SourceType.Java : SourceType.NONE);
    }

    public final synchronized BClass getBClass() {
        if (this.singleBClass == null) {
            this.singleBClass = ExtensionBridge.newBClass((ClassTarget)this);
        }
        return this.singleBClass;
    }

    public final synchronized BClassTarget getBClassTarget() {
        if (this.singleBClassTarget == null) {
            this.singleBClassTarget = ExtensionBridge.newBClassTarget((ClassTarget)this);
        }
        return this.singleBClassTarget;
    }

    public String getQualifiedName() {
        return this.getPackage().getQualifiedName(this.getBaseName());
    }

    public String getBaseName() {
        return this.getIdentifierName();
    }

    public SourceInfo getSourceInfo() {
        return this.sourceInfo;
    }

    public Reflective getTypeRefelective() {
        ParsedTypeNode ptn;
        TextEditor textEditor;
        if (this.isCompiled()) {
            Class<?> cl = this.getPackage().loadClass(this.getQualifiedName());
            if (cl != null) {
                return new JavaReflective(cl);
            }
            return null;
        }
        JavaParentNode node = null;
        if (this.getEditor() != null && (textEditor = this.editor.assumeText()) != null) {
            node = textEditor.getParsedNode();
        }
        if (node != null && (ptn = (ParsedTypeNode)node.getTypeNode(this.getBaseName())) != null) {
            return new ParsedReflective(ptn);
        }
        return null;
    }

    @Override
    public String getDisplayName() {
        return super.getDisplayName() + this.getTypeParameters();
    }

    private String getTypeParameters() {
        return this.typeParameters;
    }

    @Override
    public void setState(int newState) {
        if (this.state != newState) {
            this.getPackage().getProject().removeInspectorInstance(this.getQualifiedName());
            if (newState == 2) {
                this.knownError = false;
                if (this.getSourceType() == SourceType.Stride) {
                    this.getEditor();
                }
                if (this.editor != null && this.editor.compileStarted()) {
                    this.markKnownError();
                }
            } else if (this.editor != null) {
                this.editor.compileFinished(newState == 0);
            }
            if (newState == 0) {
                this.modifiedSinceCompile = false;
                if (this.editor != null) {
                    this.editor.reInitBreakpoints();
                }
                ClassEvent event = new ClassEvent(0, this.getPackage(), this.getBClass(), true, false);
                ExtensionsManager.getInstance().delegateEvent((ExtensionEvent)event);
            } else if (this.state == 0 || newState == 1) {
                ClassEvent event = new ClassEvent(0, this.getPackage(), this.getBClass(), false, this.hasKnownError());
                ExtensionsManager.getInstance().delegateEvent((ExtensionEvent)event);
            }
            this.state = newState;
            this.repaint();
        }
    }

    public ClassRole getRole() {
        return this.role;
    }

    protected void setRole(ClassRole newRole) {
        if (this.role.getRoleName() != newRole.getRoleName()) {
            this.role = newRole;
        }
    }

    public static boolean isJunit4TestClass(Class<?> cl) {
        ClassLoader clLoader = cl.getClassLoader();
        try {
            Class<?> beforeClass = Class.forName("org.junit.Before", false, clLoader);
            Class<?> afterClass = Class.forName("org.junit.After", false, clLoader);
            Class<?> testClass = Class.forName("org.junit.Test", false, clLoader);
            Method[] methods = cl.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (methods[i].getAnnotation(beforeClass) != null) {
                    return true;
                }
                if (methods[i].getAnnotation(afterClass) != null) {
                    return true;
                }
                if (methods[i].getAnnotation(testClass) == null) continue;
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        return false;
    }

    public void determineRole(Class<?> cl) {
        this.isAbstract = false;
        if (cl != null) {
            this.isAbstract = Modifier.isAbstract(cl.getModifiers());
            ClassLoader clLoader = cl.getClassLoader();
            Class junitClass = null;
            Class appletClass = null;
            Class<?> midletClass = null;
            if (clLoader != null) {
                try {
                    junitClass = clLoader.loadClass("junit.framework.TestCase");
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (LinkageError linkageError) {
                    // empty catch block
                }
                try {
                    appletClass = clLoader.loadClass("java.applet.Applet");
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (LinkageError linkageError) {
                    // empty catch block
                }
                try {
                    midletClass = clLoader.loadClass("javax.microedition.midlet.MIDlet");
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (LinkageError linkageError) {
                    // empty catch block
                }
            }
            if (junitClass == null) {
                junitClass = TestCase.class;
            }
            if (appletClass == null) {
                appletClass = Applet.class;
            }
            if (appletClass.isAssignableFrom(cl)) {
                this.setRole(new AppletClassRole());
            } else if (junitClass.isAssignableFrom(cl)) {
                this.setRole(new UnitTestClassRole(false));
            } else if (Modifier.isInterface(cl.getModifiers())) {
                this.setRole(new InterfaceClassRole());
            } else if (JavaUtils.getJavaUtils().isEnum(cl)) {
                this.setRole(new EnumClassRole());
            } else if (this.isAbstract) {
                this.setRole(new AbstractClassRole());
            } else if (midletClass != null && midletClass.isAssignableFrom(cl)) {
                this.setRole(new MIDletClassRole());
            } else if (ClassTarget.isJunit4TestClass(cl)) {
                this.setRole(new UnitTestClassRole(true));
            } else {
                this.setRole(new StdClassRole());
            }
        } else {
            ClassInfo classInfo = this.sourceInfo.getInfoIfAvailable();
            if (classInfo != null) {
                if (classInfo.isApplet()) {
                    this.setRole(new AppletClassRole());
                } else if (classInfo.isMIDlet()) {
                    this.setRole(new MIDletClassRole());
                } else if (classInfo.isUnitTest()) {
                    this.setRole(new UnitTestClassRole(false));
                } else if (classInfo.isInterface()) {
                    this.setRole(new InterfaceClassRole());
                } else if (classInfo.isEnum()) {
                    this.setRole(new EnumClassRole());
                } else if (classInfo.isAbstract()) {
                    this.setRole(new AbstractClassRole());
                } else if (!(this.role instanceof AppletClassRole) && !(this.role instanceof UnitTestClassRole)) {
                    this.setRole(new StdClassRole());
                }
            }
        }
    }

    @Override
    public void load(Properties props, String prefix) {
        String typeParams;
        super.load(props, prefix);
        String type = props.getProperty(prefix + ".type");
        String intf = props.getProperty(prefix + ".showInterface");
        this.openWithInterface = Boolean.valueOf(intf);
        if ("AppletTarget".equals(type)) {
            this.setRole(new AppletClassRole());
        } else if ("MIDletTarget".equals(type)) {
            this.setRole(new MIDletClassRole());
        } else if ("UnitTestTarget".equals(type)) {
            this.setRole(new UnitTestClassRole(false));
        } else if ("UnitTestTargetJunit4".equals(type)) {
            this.setRole(new UnitTestClassRole(true));
        } else if ("AbstractTarget".equals(type)) {
            this.setRole(new AbstractClassRole());
        } else if ("InterfaceTarget".equals(type)) {
            this.setRole(new InterfaceClassRole());
        } else if ("EnumTarget".equals(type)) {
            this.setRole(new EnumClassRole());
        }
        this.getRole().load(props, prefix);
        String value = props.getProperty(prefix + ".naviview.expanded");
        if (value != null) {
            this.setNaviviewExpanded(Boolean.parseBoolean(value));
            this.setProperty("naviviewExpandedProperty", String.valueOf(value));
        }
        if ((typeParams = props.getProperty(prefix + ".typeParameters")) == null) {
            this.analyseSource();
        } else {
            this.typeParameters = typeParams;
        }
    }

    @Override
    public void save(Properties props, String prefix) {
        super.save(props, prefix);
        if (this.getRole().getRoleName() != null) {
            props.put(prefix + ".type", this.getRole().getRoleName());
        }
        if (this.editorOpen()) {
            this.openWithInterface = this.getEditor().isShowingInterface();
        }
        if (this.editorOpen() && this.getProperty("naviviewExpandedProperty") != null) {
            props.put(prefix + ".naviview.expanded", String.valueOf(this.getProperty("naviviewExpandedProperty")));
        } else if (this.isNaviviewExpanded != null) {
            props.put(prefix + ".naviview.expanded", String.valueOf(this.isNaviviewExpanded()));
        }
        props.put(prefix + ".showInterface", Boolean.valueOf(this.openWithInterface).toString());
        props.put(prefix + ".typeParameters", this.getTypeParameters());
        this.getRole().save(props, 0, prefix);
    }

    public void reload() {
        this.calcSourceAvailable();
        if (this.sourceAvailable != SourceType.NONE) {
            if (this.editor != null) {
                this.editor.reloadFile();
            } else {
                this.analyseSource();
            }
        }
    }

    public boolean upToDate() {
        File src = this.getSourceFile();
        File clss = this.getClassFile();
        if (this.sourceAvailable == SourceType.NONE) {
            return true;
        }
        return clss.exists() && (!src.exists() || src.lastModified() <= clss.lastModified());
    }

    public void invalidate() {
        this.setState(1);
        Iterator<? extends Dependency> it = this.dependents();
        while (it.hasNext()) {
            Dependency d = it.next();
            ClassTarget dependent = (ClassTarget)d.getFrom();
            if (dependent.isInvalidState()) continue;
            dependent.invalidate();
        }
    }

    public boolean isInterface() {
        return this.getRole() instanceof InterfaceClassRole;
    }

    public boolean isUnitTest() {
        return this.getRole() instanceof UnitTestClassRole;
    }

    public boolean isEnum() {
        return this.getRole() instanceof EnumClassRole;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public Paint getBackgroundPaint(int width, int height) {
        if (this.state == 2) {
            return compbg;
        }
        return this.getRole().getBackgroundPaint(width, height);
    }

    public boolean hasSourceCode() {
        return this.sourceAvailable != SourceType.NONE;
    }

    public SourceType getSourceType() {
        return this.sourceAvailable;
    }

    public File getJavaSourceFile() {
        return new File(this.getPackage().getPath(), this.getBaseName() + "." + SourceType.Java.toString().toLowerCase());
    }

    public File getFrameSourceFile() {
        return new File(this.getPackage().getPath(), this.getBaseName() + "." + SourceType.Stride.toString().toLowerCase());
    }

    @Override
    public File getSourceFile() {
        switch (this.sourceAvailable) {
            case Java: {
                return this.getJavaSourceFile();
            }
            case Stride: {
                return this.getFrameSourceFile();
            }
        }
        return null;
    }

    public Collection<File> getAllSourceFiles() {
        ArrayList<File> list = new ArrayList<File>();
        list.add(this.getJavaSourceFile());
        if (this.sourceAvailable.equals((Object)SourceType.Stride)) {
            list.add(this.getFrameSourceFile());
        }
        return list;
    }

    public File getContextFile() {
        return new File(this.getPackage().getPath(), this.getBaseName() + ".ctxt");
    }

    public File getClassFile() {
        return new File(this.getPackage().getPath(), this.getBaseName() + ".class");
    }

    public File getDocumentationFile() {
        String filename = this.getSourceFile().getPath();
        String docFilename = this.getPackage().getProject().getDocumentationFile(filename);
        return new File(docFilename);
    }

    public File[] getInnerClassFiles() {
        File[] files = this.getPackage().getPath().listFiles(new InnerClassFileFilter());
        return files;
    }

    @Override
    @OnThread(value=Tag.Swing)
    public Editor getEditor() {
        return this.getEditor(this.openWithInterface);
    }

    @OnThread(value=Tag.Swing)
    private Editor getEditor(boolean showInterface) {
        if (this.editor == null) {
            PkgMgrFrame frame;
            String filename = this.getSourceFile().getPath();
            String docFilename = this.getPackage().getProject().getDocumentationFile(filename);
            if (this.sourceAvailable == SourceType.NONE) {
                filename = null;
                showInterface = true;
                if (!new File(docFilename).exists()) {
                    return null;
                }
            }
            Project project = this.getPackage().getProject();
            PackageResolver resolver = new PackageResolver(project.getEntityResolver(), this.getPackage().getQualifiedName());
            if (this.editorBounds == null && (frame = PkgMgrFrame.findFrame(this.getPackage())) != null) {
                this.editorBounds = new Rectangle();
                this.editorBounds.x = frame.getX() + 40;
                this.editorBounds.y = frame.getY() + 20;
            }
            if (this.sourceAvailable == SourceType.Java) {
                this.editor = EditorManager.getEditorManager().openClass(filename, docFilename, project.getProjectCharset(), this.getBaseName(), project::getDefaultSwingTabbedEditor, (EditorWatcher)this, this.isCompiled(), (EntityResolver)resolver, project.getJavadocResolver(), this::recordEditorOpen);
            } else if (this.sourceAvailable == SourceType.Stride) {
                CompletableFuture q = new CompletableFuture();
                File frameSourceFile = this.getFrameSourceFile();
                File javaSourceFile = this.getJavaSourceFile();
                JavadocResolver javadocResolver = project.getJavadocResolver();
                Package pkg = this.getPackage();
                Runnable openCallback = this::recordEditorOpen;
                Platform.runLater(() -> q.complete(new FrameEditor(frameSourceFile, javaSourceFile, (EditorWatcher)this, resolver, javadocResolver, pkg, openCallback)));
                try {
                    this.editor = (Editor)q.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    Debug.reportError(e);
                }
            }
            if (this.editor != null) {
                this.editor.showInterface(showInterface);
            }
        }
        return this.editor;
    }

    private void recordEditorOpen() {
        if (!this.hasBeenOpened) {
            this.hasBeenOpened = true;
            switch (this.sourceAvailable) {
                case Java: {
                    Config.recordEditorOpen(Config.SourceType.Java);
                    break;
                }
                case Stride: {
                    Config.recordEditorOpen(Config.SourceType.Stride);
                    break;
                }
            }
        }
    }

    @Override
    public void ensureSaved() throws IOException {
        if (this.editor != null) {
            this.editor.save();
        }
    }

    private void inspect() {
        new Thread(){
            int state = 0;
            DebuggerClass clss;

            @Override
            public void run() {
                switch (this.state) {
                    case 0: {
                        try {
                            this.clss = ClassTarget.this.getPackage().getDebugger().getClass(ClassTarget.this.getQualifiedName(), true);
                            this.state = 1;
                            EventQueue.invokeLater(this);
                        }
                        catch (ClassNotFoundException classNotFoundException) {}
                        break;
                    }
                    case 1: {
                        ClassTarget.this.getPackage().getProject().getClassInspectorInstance(this.clss, ClassTarget.this.getPackage(), PkgMgrFrame.findFrame(ClassTarget.this.getPackage()));
                    }
                }
            }
        }.start();
    }

    @Override
    public void modificationEvent(Editor editor) {
        this.invalidate();
        if (!this.modifiedSinceCompile) {
            this.removeBreakpoints();
            if (this.getPackage().getProject().getDebugger() != null) {
                this.getPackage().getProject().getDebugger().removeBreakpointsForClass(this.getQualifiedName());
            }
            this.modifiedSinceCompile = true;
        }
        this.sourceInfo.setSourceModified();
    }

    @Override
    public void saveEvent(Editor editor) {
        ClassInfo info = this.analyseSource();
        if (info != null) {
            this.updateTargetFile(info);
        }
        this.determineRole(null);
    }

    @Override
    public String breakpointToggleEvent(Editor editor, int lineNo, boolean set) {
        if (this.isCompiled() || !this.modifiedSinceCompile) {
            String possibleError = this.getPackage().getDebugger().toggleBreakpoint(this.getQualifiedName(), lineNo, set, null);
            Debug.message("Setting breakpoint: " + this.getQualifiedName() + ":" + lineNo);
            if (possibleError == null && this.getPackage() != null) {
                DataCollector.debuggerBreakpointToggle(this.getPackage(), this.getSourceFile(), lineNo, set);
            }
            return possibleError;
        }
        return Config.getString("pkgmgr.breakpointMsg");
    }

    @Override
    public void clearAllBreakpoints() {
        this.getPackage().getDebugger().removeBreakpointsForClass(this.getQualifiedName());
    }

    public void removeBreakpoints() {
        if (this.editor != null) {
            this.editor.removeBreakpoints();
        }
    }

    public void reInitBreakpoints() {
        if (this.editor != null && this.isCompiled()) {
            this.editor.reInitBreakpoints();
        }
    }

    public void removeStepMark() {
        if (this.editor != null) {
            this.editor.removeStepMark();
        }
    }

    public boolean isCompiled() {
        return this.state == 0;
    }

    @Override
    public void compile(final Editor editor) {
        if (Config.isGreenfoot()) {
            this.setState(1);
            this.getPackage().compile(new CompileObserver(){

                @Override
                public void startCompile(File[] sources) {
                }

                @Override
                public void endCompile(File[] sources, boolean successful) {
                    editor.compileFinished(successful);
                }

                @Override
                public boolean compilerMessage(Diagnostic diagnostic) {
                    return false;
                }
            });
        } else {
            this.getPackage().compile(this, false, new CompileObserver(){

                @Override
                public void startCompile(File[] sources) {
                }

                @Override
                public boolean compilerMessage(Diagnostic diagnostic) {
                    return false;
                }

                @Override
                public void endCompile(File[] sources, boolean succesful) {
                    editor.compileFinished(succesful);
                }
            });
        }
    }

    public void endCompile() {
        Class<?> cl = this.getPackage().loadClass(this.getQualifiedName());
        this.determineRole(cl);
        this.analyseDependencies(cl);
    }

    public boolean generateSkeleton(String template) {
        if (template == null) {
            Debug.reportError("generate class skeleton error");
            return false;
        }
        boolean success = this.role.generateSkeleton(template, this.getPackage(), this.getBaseName(), this.getJavaSourceFile().getPath());
        if (success) {
            this.setState(1);
            this.sourceAvailable = SourceType.Java;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void enforcePackage(String packageName) throws IOException {
        if (!JavaNames.isQualifiedIdentifier(packageName)) {
            throw new IllegalArgumentException();
        }
        ClassInfo info = this.sourceInfo.getInfo(this.getSourceFile(), this.getPackage());
        if (info == null) {
            return;
        }
        String semiReplacement = null;
        String nameReplacement = null;
        String pkgStatementReplacement = null;
        if (packageName.length() == 0) {
            if (!info.hasPackageStatement()) return;
            semiReplacement = "";
            nameReplacement = "";
            pkgStatementReplacement = "";
        } else if (info.hasPackageStatement()) {
            if (info.getPackage().equals(packageName)) {
                return;
            }
            nameReplacement = packageName;
        } else {
            semiReplacement = ";\n\n";
            nameReplacement = packageName;
            pkgStatementReplacement = "package ";
        }
        FileEditor fed = new FileEditor(this.getSourceFile());
        if (semiReplacement != null) {
            Selection selSemi = info.getPackageSemiSelection();
            fed.replaceSelection(selSemi, semiReplacement);
        }
        if (nameReplacement != null) {
            Selection selName = info.getPackageNameSelection();
            fed.replaceSelection(selName, nameReplacement);
        }
        if (pkgStatementReplacement != null) {
            Selection selStatement = info.getPackageStatementSelection();
            fed.replaceSelection(selStatement, pkgStatementReplacement);
        }
        fed.save();
    }

    public ClassInfo analyseSource() {
        if (this.analysing) {
            return null;
        }
        this.analysing = true;
        ClassInfo info = this.sourceInfo.getInfo(this.getJavaSourceFile(), this.getPackage());
        if (info != null) {
            this.determineRole(null);
            this.setTypeParameters(info);
            this.analyseDependencies(info);
        }
        this.analysing = false;
        return info;
    }

    private void updateTargetFile(ClassInfo info) {
        if (this.analyseClassName(info)) {
            if (this.nameEqualsIgnoreCase(info.getName())) {
                this.doClassNameChange(info.getName() + TEMP_FILE_EXTENSION);
            }
            this.doClassNameChange(info.getName());
        }
        if (this.analysePackageName(info)) {
            this.doPackageNameChange(info.getPackage());
        }
    }

    public void setTypeParameters(ClassInfo info) {
        String newTypeParameters = "";
        if (info.hasTypeParameter()) {
            Iterator<String> i = info.getTypeParameterTexts().iterator();
            newTypeParameters = "<" + i.next();
            while (i.hasNext()) {
                newTypeParameters = newTypeParameters + "," + i.next();
            }
            newTypeParameters = newTypeParameters + ">";
        }
        if (!newTypeParameters.equals(this.typeParameters)) {
            this.typeParameters = newTypeParameters;
            this.updateSize();
        }
    }

    public boolean analyseClassName(ClassInfo info) {
        String newName = info.getName();
        if (newName == null || newName.length() == 0) {
            return false;
        }
        return !this.getBaseName().equals(newName);
    }

    public boolean analysePackageName(ClassInfo info) {
        String newName = info.getPackage();
        return !this.getPackage().getQualifiedName().equals(newName);
    }

    public void analyseDependencies(ClassInfo info) {
        this.removeInheritDependencies();
        this.unflagAllOutDependencies();
        String pkgPrefix = this.getPackage().getQualifiedName();
        String string = pkgPrefix = pkgPrefix.length() == 0 ? pkgPrefix : pkgPrefix + ".";
        if (info.getSuperclass() != null) {
            this.setSuperClass(info.getSuperclass());
        }
        List<String> vect = info.getImplements();
        for (String name : vect) {
            this.addInterface(name);
        }
        vect = info.getUsed();
        for (String name : vect) {
            DependentTarget used = this.getPackage().getDependentTarget(name);
            if (used == null || used.getAssociation() == this || this.getAssociation() == used) continue;
            this.getPackage().addDependency(new UsesDependency(this.getPackage(), this, used), true);
        }
        Iterator<Object> it = this.usesDependencies();
        while (it.hasNext()) {
            UsesDependency usesDep = (UsesDependency)it.next();
            if (usesDep.isFlagged()) continue;
            this.getPackage().setStatus(usesArrowMsg + usesDep);
        }
    }

    public void analyseDependencies(Class<?> cl) {
        if (cl != null) {
            this.removeInheritDependencies();
            Class<?> superClass = cl.getSuperclass();
            if (superClass != null) {
                this.setSuperClass(superClass.getName());
            }
            Class<?>[] interfaces = cl.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                this.addInterface(interfaces[i].getName());
            }
        }
    }

    private void setSuperClass(String superName) {
        String pkgPrefix = this.getPackage().getQualifiedName();
        if (superName.startsWith(pkgPrefix)) {
            int prefixLen = pkgPrefix.length();
            prefixLen = prefixLen == 0 ? 0 : prefixLen + 1;
            superName = superName.substring(prefixLen);
            DependentTarget superclass = this.getPackage().getDependentTarget(superName);
            if (superclass != null) {
                this.getPackage().addDependency(new ExtendsDependency(this.getPackage(), this, superclass), false);
                if (superclass.getState() != 0) {
                    this.setState(1);
                }
            }
        }
    }

    private void addInterface(String interfaceName) {
        String pkgPrefix = this.getPackage().getQualifiedName();
        if (interfaceName.startsWith(pkgPrefix)) {
            int dotlen = pkgPrefix.length();
            dotlen = dotlen == 0 ? 0 : dotlen + 1;
            interfaceName = interfaceName.substring(dotlen);
            DependentTarget interfce = this.getPackage().getDependentTarget(interfaceName);
            if (interfce != null) {
                this.getPackage().addDependency(new ImplementsDependency(this.getPackage(), this, interfce), false);
                if (interfce.getState() != 0) {
                    this.setState(1);
                }
            }
        }
    }

    private boolean doClassNameChange(String newName) {
        if (this.getPackage().getTarget(newName) != null) {
            this.getPackage().showError("duplicate-name");
            return false;
        }
        File newSourceFile = new File(this.getPackage().getPath(), newName + "." + this.getSourceType().toString().toLowerCase());
        File oldSourceFile = this.getSourceFile();
        try {
            BDependency bDependency;
            String javaFilename;
            FileUtility.copyFile(oldSourceFile, newSourceFile);
            this.getPackage().updateTargetIdentifier(this, this.getIdentifierName(), newName);
            String filename = newSourceFile.getAbsolutePath();
            if (this.getSourceType().equals((Object)SourceType.Stride)) {
                File javaFile = new File(this.getPackage().getPath(), newName + "." + SourceType.Java.toString().toLowerCase());
                javaFilename = javaFile.getAbsolutePath();
                FileUtility.copyFile(this.getJavaSourceFile(), javaFile);
            } else {
                javaFilename = filename;
            }
            String docFilename = this.getPackage().getProject().getDocumentationFile(javaFilename);
            this.getEditor().changeName(newName, filename, javaFilename, docFilename);
            this.deleteSourceFiles();
            this.getClassFile().delete();
            this.getContextFile().delete();
            this.getDocumentationFile().delete();
            String oldName = this.getIdentifierName();
            this.setIdentifierName(newName);
            this.setDisplayName(newName);
            this.updateSize();
            BClass bClass = this.getBClass();
            ExtensionBridge.ChangeBClassName((BClass)bClass, (String)this.getQualifiedName());
            BClassTarget bClassTarget = this.getBClassTarget();
            ExtensionBridge.changeBClassTargetName((BClassTarget)bClassTarget, (String)this.getQualifiedName());
            Iterator<? extends Dependency> iterator = this.dependencies();
            while (iterator.hasNext()) {
                Dependency outgoingDependency = iterator.next();
                bDependency = outgoingDependency.getBDependency();
                ExtensionBridge.changeBDependencyOriginName((BDependency)bDependency, (String)this.getQualifiedName());
            }
            iterator = this.dependents();
            while (iterator.hasNext()) {
                Dependency incomingDependency = iterator.next();
                bDependency = incomingDependency.getBDependency();
                ExtensionBridge.changeBDependencyTargetName((BDependency)bDependency, (String)this.getQualifiedName());
            }
            DataCollector.renamedClass(this.getPackage(), oldSourceFile, newSourceFile);
            ClassEvent event = new ClassEvent(1, this.getPackage(), this.getBClass(), oldName);
            ExtensionsManager.getInstance().delegateEvent((ExtensionEvent)event);
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    private void deleteSourceFiles() {
        if (this.getSourceType().equals((Object)SourceType.Stride)) {
            this.getJavaSourceFile().delete();
        }
        this.getSourceFile().delete();
    }

    private boolean nameEqualsIgnoreCase(String newName) {
        return this.getBaseName().equalsIgnoreCase(newName);
    }

    private void doPackageNameChange(String newName) {
        Project proj = this.getPackage().getProject();
        Package dstPkg = proj.getPackage(newName);
        if (dstPkg == null) {
            DialogManager.showError(null, "package-name-invalid");
        } else if (dstPkg.getTarget(this.getBaseName()) != null) {
            DialogManager.showError(null, "package-name-clash");
        } else if (DialogManager.askQuestion(null, "package-name-changed") == 0) {
            dstPkg.importFile(this.getSourceFile());
            this.prepareForRemoval();
            this.getPackage().removeTarget(this);
            this.close();
            return;
        }
        try {
            this.enforcePackage(this.getPackage().getQualifiedName());
            this.getEditor().reloadFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void updateSize() {
        int width = ClassTarget.calculateWidth(this.getDisplayName());
        this.setSize(width, this.getHeight());
        this.repaint();
    }

    @Override
    public void popupMenu(int x, int y, GraphEditor graphEditor) {
        Class<?> cl = null;
        if (this.state == 0 && (cl = this.getPackage().loadClass(this.getQualifiedName())) == null && this.sourceAvailable != SourceType.NONE) {
            this.getClassFile().delete();
            this.invalidate();
        }
        this.menu = this.state == 0 ? this.createMenu(cl) : this.createMenu(null);
        if (this.menu != null) {
            this.menu.show(graphEditor, x, y);
        }
    }

    protected JPopupMenu createMenu(Class<?> cl) {
        JPopupMenu menu = new JPopupMenu(this.getBaseName() + " operations");
        this.role.createRoleMenu(menu, this, cl, this.state);
        if (cl != null && this.role.createClassConstructorMenu(menu, this, cl)) {
            menu.addSeparator();
        }
        if (cl != null && this.role.createClassStaticMenu(menu, this, cl)) {
            menu.addSeparator();
        }
        boolean sourceOrDocExists = this.sourceAvailable != SourceType.NONE || this.getDocumentationFile().exists();
        this.role.addMenuItem(menu, new EditAction(), sourceOrDocExists);
        this.role.addMenuItem(menu, new InspectAction(), cl != null);
        this.role.addMenuItem(menu, new RemoveAction(), true);
        this.role.createRoleMenuEnd(menu, this, this.state);
        MenuManager menuManager = new MenuManager(menu);
        menuManager.setMenuGenerator(new ClassExtensionMenu(this));
        menuManager.addExtensionMenu(this.getPackage().getProject());
        return menu;
    }

    @Override
    public void doubleClick(MouseEvent evt) {
        this.open();
    }

    @Override
    public int getGhostX() {
        return this.ghostX;
    }

    @Override
    public int getGhostY() {
        return this.ghostY;
    }

    public int getGhostWidth() {
        return this.ghostWidth;
    }

    public int getGhostHeight() {
        return this.ghostHeight;
    }

    @Override
    public void setGhostPosition(int deltaX, int deltaY) {
        this.ghostX = this.getX() + deltaX;
        this.ghostY = this.getY() + deltaY;
    }

    @Override
    public void setGhostSize(int deltaX, int deltaY) {
        this.ghostWidth = Math.max(this.getWidth() + deltaX, 60);
        this.ghostHeight = Math.max(this.getHeight() + deltaY, 30);
    }

    @Override
    public void setPositionToGhost() {
        super.setPos(this.ghostX, this.ghostY);
        this.setSize(this.ghostWidth, this.ghostHeight);
        this.isDragging = false;
    }

    @Override
    public boolean isDragging() {
        return this.isDragging;
    }

    @Override
    public void setDragging(boolean isDragging) {
        this.isDragging = isDragging;
    }

    @Override
    public void setPos(int x, int y) {
        super.setPos(x, y);
        this.setGhostPosition(0, 0);
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(Math.max(width, 60), Math.max(height, 30));
        this.setGhostSize(0, 0);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible != this.isVisible()) {
            super.setVisible(visible);
            ClassTargetEvent event = new ClassTargetEvent(this, this.getPackage(), visible);
            ExtensionsManager.getInstance().delegateEvent((ExtensionEvent)event);
        }
    }

    private void prepareForRemoval() {
        if (this.editor != null) {
            this.editor.close();
        }
        Iterator<Target> it = this.getPackage().getVertices();
        while (it.hasNext()) {
            DependentTarget d;
            Target o = it.next();
            if (!(o instanceof DependentTarget) || !this.equals((d = (DependentTarget)o).getAssociation())) continue;
            d.setAssociation(null);
        }
        this.invalidate();
        this.removeAllInDependencies();
        this.removeAllOutDependencies();
        this.prepareFilesForRemoval();
    }

    public void prepareFilesForRemoval() {
        File[] files;
        if (this.getSourceFile().exists() && (files = this.getPackage().getPath().listFiles(new InnerClassFileFilter())) != null) {
            for (int i = 0; i < files.length; ++i) {
                files[i].delete();
            }
        }
        List<File> allFiles = this.getRole().getAllFiles(this);
        Iterator<File> i = allFiles.iterator();
        while (i.hasNext()) {
            i.next().delete();
        }
    }

    public void generateDoc() {
        this.getPackage().generateDocumentation(this);
    }

    @Override
    public void remove() {
        File srcFile = this.getSourceFile();
        this.prepareForRemoval();
        Package pkg = this.getPackage();
        pkg.removeTarget(this);
        DataCollector.removeClass(pkg, srcFile);
    }

    public void removeStride() {
        File srcFile;
        if (this.editor != null) {
            this.editor.close();
            try {
                this.editor.saveJavaWithoutWarning();
            }
            catch (IOException e) {
                Debug.reportError(e);
            }
            this.editor = null;
        }
        if ((srcFile = this.getSourceFile()).exists()) {
            srcFile.delete();
        }
        this.sourceAvailable = SourceType.Java;
        DataCollector.ConvertStrideToJava(this.getPackage(), srcFile);
    }

    @Override
    public boolean isMoveable() {
        return this.isMoveable;
    }

    @Override
    public void setIsMoveable(boolean isMoveable) {
        this.isMoveable = isMoveable;
    }

    @Override
    public void executeMethod(MethodView mv) {
        this.getPackage().getEditor().raiseMethodCallEvent(this, mv);
    }

    @Override
    public void callConstructor(ConstructorView cv) {
        this.getPackage().getEditor().raiseMethodCallEvent(this, cv);
    }

    private boolean checkDebuggerState() {
        return PkgMgrFrame.createFrame(this.getPackage()).checkDebuggerState();
    }

    public boolean isNaviviewExpanded() {
        return this.isNaviviewExpanded;
    }

    public void setNaviviewExpanded(boolean isNaviviewExpanded) {
        this.isNaviviewExpanded = isNaviviewExpanded;
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    @Override
    public String getTooltipText() {
        if (!this.getSourceInfo().isValid()) {
            return Config.getString("graph.tooltip.classBroken");
        }
        return null;
    }

    public void recordEdit(String latest, boolean includeOneLineEdits) {
        DataCollector.edit(this.getPackage(), this.getSourceFile(), latest, includeOneLineEdits);
    }

    public File getCompileInputFile() {
        return this.getJavaSourceFile();
    }

    public void markKnownError() {
        this.knownError = true;
    }

    public boolean hasKnownError() {
        return this.knownError;
    }

    private class InspectAction
    extends AbstractAction {
        public InspectAction() {
            this.putValue("Name", inspectStr);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ClassTarget.this.checkDebuggerState()) {
                ClassTarget.this.inspect();
            }
        }
    }

    private class RemoveAction
    extends AbstractAction {
        public RemoveAction() {
            this.putValue("Name", removeStr);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PkgMgrFrame pmf = PkgMgrFrame.findFrame(ClassTarget.this.getPackage());
            if (pmf.askRemoveClass()) {
                ClassTarget.this.getPackage().getEditor().raiseRemoveTargetEvent(ClassTarget.this);
            }
        }
    }

    private class EditAction
    extends AbstractAction {
        public EditAction() {
            this.putValue("Name", editStr);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ClassTarget.this.open();
        }
    }

    public class CreateTestAction
    extends AbstractAction {
        public CreateTestAction() {
            this.putValue("Name", createTestStr);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PkgMgrFrame pmf = PkgMgrFrame.findFrame(ClassTarget.this.getPackage());
            if (pmf != null) {
                String testClassName = ClassTarget.this.getIdentifierName() + "Test";
                pmf.createNewClass(testClassName, "unittest", true);
                Target target = ClassTarget.this.getPackage().getTarget(testClassName);
                ClassTarget ct = null;
                if (target instanceof ClassTarget && (ct = (ClassTarget)target) != null && ct.isUnitTest()) {
                    ClassTarget.this.setAssociation((DependentTarget)ClassTarget.this.getPackage().getTarget(ClassTarget.this.getIdentifierName() + "Test"));
                }
                ClassTarget.this.updateAssociatePosition();
                ClassTarget.this.getPackage().getEditor().revalidate();
                ClassTarget.this.getPackage().getEditor().repaint();
            }
        }
    }

    @OnThread(value=Tag.Swing, ignoreParent=true)
    class InnerClassFileFilter
    implements FileFilter {
        InnerClassFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.getName().startsWith(ClassTarget.this.getBaseName() + "$");
        }
    }
}

