/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.print;

import bluej.Config;
import bluej.editor.Editor;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.ProjectPrintDialog;
import bluej.pkgmgr.print.ClassDiagramPrinter;
import bluej.pkgmgr.target.ClassTarget;
import bluej.pkgmgr.target.ReadmeTarget;
import java.awt.Dimension;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import threadchecker.OnThread;
import threadchecker.Tag;

public class PackagePrintManager
extends Thread {
    private PageFormat pageFormat;
    private Package pkg;
    private ProjectPrintDialog dialog;
    private List<Editor> editorsToPrint = new ArrayList<Editor>();
    private Dimension pkgSize;

    @OnThread(value=Tag.Swing)
    public PackagePrintManager(Package pkg, PageFormat pageFormat, ProjectPrintDialog dialog) {
        ReadmeTarget readmeTgt;
        this.pkg = pkg;
        this.pkgSize = pkg.getMinimumSize();
        this.pageFormat = pageFormat;
        this.dialog = dialog;
        if (dialog.printSource()) {
            this.editorsToPrint.addAll(pkg.getAllClassnamesWithSource().stream().map(className -> ((ClassTarget)pkg.getTarget((String)className)).getEditor()).collect(Collectors.toList()));
        }
        if (dialog.printReadme() && (readmeTgt = pkg.getReadmeTarget()) != null) {
            this.editorsToPrint.add(readmeTgt.getEditor());
        }
    }

    @Override
    public void run() {
        PrinterJob printer = PrinterJob.getPrinterJob();
        if (printer.printDialog()) {
            if (this.dialog.printDiagram()) {
                this.printClassDiagram(printer);
            }
            for (Editor e : this.editorsToPrint) {
                e.printTo(printer, this.dialog.printLineNumbers(), this.dialog.printHighlighting());
            }
        }
    }

    public void printClassDiagram(PrinterJob printJob) {
        ClassDiagramPrinter diagramPrinter = new ClassDiagramPrinter(printJob, this.pkg, this.pkgSize, this.pageFormat);
        SwingUtilities.invokeLater(() -> this.pkg.setStatus(Config.getString("pkgmgr.info.printing")));
        diagramPrinter.printPackage();
    }
}

