/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.graphPainter;

import bluej.Config;
import bluej.extmgr.ExtensionsManager;
import bluej.pkgmgr.graphPainter.GraphPainterStdImpl;
import bluej.pkgmgr.target.ClassTarget;
import bluej.pkgmgr.target.Target;
import bluej.prefmgr.PrefMgr;
import bluej.utility.Utility;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;

public class ClassTargetPainter {
    private static final int HANDLE_SIZE = 20;
    private static final String STEREOTYPE_OPEN = "<<";
    private static final String STEREOTYPE_CLOSE = ">>";
    private static final Color textcolor = Color.BLACK;
    private static final Color borderColor = Color.BLACK;
    private static final Color stripeColor = new Color(158, 139, 116);
    private static final Image brokenImage = Config.getFixedImageAsIcon("broken-symbol.png").getImage();
    private static final Font targetFont = PrefMgr.getTargetFont();
    private static final int TEXT_HEIGHT = GraphPainterStdImpl.TEXT_HEIGHT;
    private static final int TEXT_BORDER = 4;
    private static final AlphaComposite alphaComposite = GraphPainterStdImpl.alphaComposite;

    public void paint(Graphics2D g, ClassTarget classTarget, boolean hasFocus) {
        g.translate(classTarget.getX(), classTarget.getY());
        int width = classTarget.getWidth();
        int height = classTarget.getHeight();
        if (!Config.isRaspberryPi()) {
            this.drawShadow(g, width, height);
        }
        this.drawSkeleton(g, classTarget, width, height);
        this.drawUMLStyle(g, classTarget, hasFocus, width, height);
        g.translate(-classTarget.getX(), -classTarget.getY());
    }

    public void paintGhost(Graphics2D g, Target target, boolean hasFocus) {
        ClassTarget classTarget = (ClassTarget)target;
        Composite oldComposite = g.getComposite();
        g.translate(classTarget.getGhostX(), classTarget.getGhostY());
        int width = classTarget.getGhostWidth();
        int height = classTarget.getGhostHeight();
        if (!Config.isRaspberryPi()) {
            g.setComposite(alphaComposite);
        }
        this.drawSkeleton(g, classTarget, width, height);
        this.drawUMLStyle(g, classTarget, hasFocus, width, height);
        if (!Config.isRaspberryPi()) {
            g.setComposite(oldComposite);
        }
        g.translate(-classTarget.getGhostX(), -classTarget.getGhostY());
    }

    private void drawSkeleton(Graphics2D g, ClassTarget classTarget, int width, int height) {
        g.setPaint(classTarget.getBackgroundPaint(width, height));
        g.fillRect(0, 0, width, height);
    }

    private void drawUMLStyle(Graphics2D g, ClassTarget classTarget, boolean hasFocus, int width, int height) {
        ExtensionsManager extensionsManager = ExtensionsManager.getInstance();
        String stereotype = classTarget.getRole().getStereotypeLabel();
        g.setColor(textcolor);
        int currentTextPosY = 2;
        if (stereotype != null) {
            String stereotypeLabel = STEREOTYPE_OPEN + stereotype + STEREOTYPE_CLOSE;
            Font stereotypeFont = targetFont.deriveFont((float)(targetFont.getSize() - 2));
            g.setFont(stereotypeFont);
            Utility.drawCentredText(g, stereotypeLabel, 4, currentTextPosY, width - 8, TEXT_HEIGHT);
            currentTextPosY += TEXT_HEIGHT - 2;
        }
        g.setFont(targetFont);
        Utility.drawCentredText(g, classTarget.getDisplayName(), 4, currentTextPosY, width - 8, TEXT_HEIGHT);
        g.setColor(borderColor);
        g.drawLine(0, currentTextPosY += TEXT_HEIGHT, width, currentTextPosY);
        int extensionGraphicsX = 1;
        int extensionGraphicsY = currentTextPosY + 1;
        int extensionGraphicsWidth = width - 1;
        int extensionGraphicsHeight = height - currentTextPosY - 1;
        Graphics2D backgroundGraphics = (Graphics2D)g.create(extensionGraphicsX, extensionGraphicsY, extensionGraphicsWidth, extensionGraphicsHeight);
        extensionsManager.drawExtensionClassTarget(Layer.BACKGROUND, classTarget.getBClassTarget(), backgroundGraphics, extensionGraphicsWidth, extensionGraphicsHeight);
        Graphics2D foregroundGraphics = (Graphics2D)g.create(extensionGraphicsX, extensionGraphicsY, extensionGraphicsWidth, extensionGraphicsHeight);
        extensionsManager.drawExtensionClassTarget(Layer.FOREGROUND, classTarget.getBClassTarget(), foregroundGraphics, extensionGraphicsWidth, extensionGraphicsHeight);
        this.drawWarnings(g, classTarget, width, height);
        g.setColor(borderColor);
        boolean drawSelected = classTarget.isSelected() && hasFocus;
        this.drawBorder(g, drawSelected, width, height);
    }

    private void drawWarnings(Graphics2D g, ClassTarget classTarget, int width, int height) {
        String stereotype = classTarget.getRole().getStereotypeLabel();
        if (classTarget.getState() != 0) {
            int divider = stereotype == null ? 19 : 33;
            Utility.stripeRect(g, 0, divider, width, height - divider, 8, 3, stripeColor);
        }
        if (!classTarget.hasSourceCode()) {
            g.setColor(textcolor);
            g.setFont(targetFont.deriveFont((float)(targetFont.getSize() - 2)));
            Utility.drawCentredText(g, "(no source)", 4, height - 18, width - 8, TEXT_HEIGHT);
        } else if (!classTarget.getSourceInfo().isValid()) {
            g.drawImage(brokenImage, 4, height - 22, null);
        }
    }

    private void drawBorder(Graphics2D g, boolean selected, int width, int height) {
        int thickness = 1;
        if (selected) {
            thickness = 2;
            g.drawLine(width - 20 - 2, height, width, height - 20 - 2);
            g.drawLine(width - 20 + 2, height, width, height - 20 + 2);
        }
        Utility.drawThickRect(g, 0, 0, width, height, thickness);
    }

    private void drawShadow(Graphics2D g, int width, int height) {
        int[] shadowAlphas = new int[]{20, 15, 10, 5, 5};
        for (int i = 0; i < 5; ++i) {
            g.setColor(new Color(0, 0, 0, shadowAlphas[i]));
            g.fillRoundRect(2 - i, 4 - i, width + 2 * i - 1, height + 2 * i - 1, 8, 8);
        }
    }

    public static enum Layer {
        BACKGROUND,
        FOREGROUND;

    }
}

