/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.utility.DialogManager;
import bluej.utility.EscapeDialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import threadchecker.OnThread;
import threadchecker.Tag;

public class ProjectPrintDialog
extends EscapeDialog {
    private boolean ok;
    private JCheckBox printDiagram;
    private JCheckBox printSource;
    private JCheckBox printReadme;
    private JCheckBox printLineNumbers;
    private JCheckBox printHighlighting;
    private boolean printDiagramSelected;
    private boolean printSourceSelected;
    private boolean printReadmeSelected;
    private boolean printLineNumbersSelected;
    private boolean printHighlightingSelected;

    public ProjectPrintDialog(PkgMgrFrame parent) {
        super(parent, Config.getString("pkgmgr.printDialog.title"), true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent E) {
                ProjectPrintDialog.this.ok = false;
                ProjectPrintDialog.this.setVisible(false);
            }
        });
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setBorder(BlueJTheme.dialogBorder);
        mainPanel.add(Box.createVerticalStrut(17));
        this.printDiagram = new JCheckBox(Config.getString("pkgmgr.printDialog.printDiagram"));
        this.printDiagram.setSelected(true);
        mainPanel.add(this.printDiagram);
        this.printSource = new JCheckBox(Config.getString("pkgmgr.printDialog.printSource"));
        mainPanel.add(this.printSource);
        if (parent.getPackage().isUnnamedPackage()) {
            this.printReadme = new JCheckBox(Config.getString("pkgmgr.printDialog.printReadme"));
            mainPanel.add(this.printReadme);
        }
        mainPanel.add(Box.createVerticalStrut(5));
        this.printLineNumbers = new JCheckBox(Config.getString("editor.printDialog.printLineNumbers"));
        this.printLineNumbers.setSelected(true);
        mainPanel.add(this.printLineNumbers);
        this.printHighlighting = new JCheckBox(Config.getString("editor.printDialog.printHighlighting"));
        mainPanel.add(this.printHighlighting);
        mainPanel.add(Box.createVerticalStrut(5));
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.setAlignmentX(0.0f);
        JButton okButton = BlueJTheme.getOkButton();
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPrintDialog.this.doOK();
            }
        });
        JButton cancelButton = BlueJTheme.getCancelButton();
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPrintDialog.this.doCancel();
            }
        });
        DialogManager.addOKCancelButtons(buttonPanel, okButton, cancelButton);
        this.getRootPane().setDefaultButton(okButton);
        mainPanel.add(buttonPanel);
        this.getContentPane().add(mainPanel);
        this.pack();
        DialogManager.centreDialog(this);
    }

    public boolean display() {
        this.ok = false;
        this.setVisible(true);
        return this.ok;
    }

    public void doOK() {
        this.ok = this.printDiagram() || this.printSource() || this.printReadme();
        this.storeValues();
        this.setVisible(false);
    }

    public void doCancel() {
        this.ok = false;
        this.setVisible(false);
    }

    @OnThread(value=Tag.Any)
    public boolean printDiagram() {
        return this.printDiagramSelected;
    }

    @OnThread(value=Tag.Any)
    public boolean printSource() {
        return this.printSourceSelected;
    }

    @OnThread(value=Tag.Any)
    public boolean printReadme() {
        return this.printReadmeSelected;
    }

    private void storeValues() {
        this.printDiagramSelected = this.printDiagram.isSelected();
        this.printSourceSelected = this.printSource.isSelected();
        this.printReadmeSelected = this.printReadme != null && this.printReadme.isSelected();
        this.printLineNumbersSelected = this.printLineNumbers.isSelected();
        this.printHighlightingSelected = this.printHighlighting.isSelected();
    }

    @OnThread(value=Tag.Any)
    public boolean printLineNumbers() {
        return this.printLineNumbersSelected;
    }

    @OnThread(value=Tag.Any)
    public boolean printHighlighting() {
        return this.printHighlightingSelected;
    }
}

