/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser.entity;

import bluej.debugger.gentype.ConstructorReflective;
import bluej.debugger.gentype.FieldReflective;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.GenTypeDeclTpar;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.gentype.MethodReflective;
import bluej.debugger.gentype.Reflective;
import bluej.parser.entity.JavaEntity;
import bluej.parser.entity.ParsedArrayReflective;
import bluej.parser.entity.TparEntity;
import bluej.parser.entity.TypeEntity;
import bluej.parser.nodes.FieldNode;
import bluej.parser.nodes.MethodNode;
import bluej.parser.nodes.ParsedNode;
import bluej.parser.nodes.ParsedTypeNode;
import bluej.parser.nodes.TypeInnerNode;
import bluej.utility.JavaUtils;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ParsedReflective
extends Reflective {
    private ParsedTypeNode pnode;

    public ParsedReflective(ParsedTypeNode pnode) {
        this.pnode = pnode;
    }

    @Override
    public String getName() {
        return this.pnode.getPrefix() + this.pnode.getName();
    }

    @Override
    public Reflective getArrayOf() {
        return new ParsedArrayReflective(this, "L" + this.getName() + ";");
    }

    @Override
    public Reflective getRelativeClass(String name) {
        GenTypeClass ctype;
        TypeEntity tent = this.pnode.resolveQualifiedClass(name);
        if (tent != null && (ctype = tent.getType().asClass()) != null) {
            return ctype.getReflective();
        }
        return null;
    }

    @Override
    public List<GenTypeClass> getSuperTypes() {
        GenTypeClass ct;
        TypeEntity tent;
        GenTypeClass ct2;
        TypeEntity tent2;
        LinkedList<GenTypeClass> rval = new LinkedList<GenTypeClass>();
        for (JavaEntity etype : this.pnode.getExtendedTypes()) {
            tent2 = etype.resolveAsType();
            if (tent2 == null || (ct2 = tent2.getType().asClass()) == null) continue;
            rval.add(ct2);
        }
        if (!this.isInterface() && rval.isEmpty() && (tent = this.pnode.resolveQualifiedClass("java.lang.Object")) != null && (ct = tent.getType().asClass()) != null) {
            rval.add(ct);
        }
        for (JavaEntity etype : this.pnode.getImplementedTypes()) {
            tent2 = etype.resolveAsType();
            if (tent2 == null || (ct2 = tent2.getType().asClass()) == null) continue;
            rval.add(ct2);
        }
        return rval;
    }

    @Override
    public List<Reflective> getSuperTypesR() {
        GenTypeClass superGTC;
        TypeEntity objEntity;
        GenTypeClass superGTC2;
        TypeEntity etypeTEnt;
        ArrayList<Reflective> rlist = new ArrayList<Reflective>();
        List<JavaEntity> extendedTypes = this.pnode.getExtendedTypes();
        if (extendedTypes != null && !extendedTypes.isEmpty()) {
            for (JavaEntity etype : extendedTypes) {
                etypeTEnt = etype.resolveAsType();
                if (etypeTEnt == null || (superGTC2 = etypeTEnt.getType().asClass()) == null) continue;
                rlist.add(superGTC2.getReflective());
            }
        }
        if (rlist.isEmpty() && !this.isInterface() && (objEntity = this.pnode.resolveQualifiedClass("java.lang.Object")) != null && (superGTC = objEntity.getType().asClass()) != null) {
            rlist.add(superGTC.getReflective());
        }
        if ((extendedTypes = this.pnode.getImplementedTypes()) != null && !extendedTypes.isEmpty()) {
            for (JavaEntity etype : extendedTypes) {
                etypeTEnt = etype.resolveAsType();
                if (etypeTEnt == null || (superGTC2 = etypeTEnt.getType().asClass()) == null) continue;
                rlist.add(superGTC2.getReflective());
            }
        }
        return rlist;
    }

    @Override
    public List<GenTypeDeclTpar> getTypeParams() {
        List<TparEntity> tparEntList = this.pnode.getTypeParams();
        if (tparEntList == null) {
            return Collections.emptyList();
        }
        ArrayList<GenTypeDeclTpar> tparList = new ArrayList<GenTypeDeclTpar>(tparEntList.size());
        for (TparEntity tpar : tparEntList) {
            GenTypeDeclTpar tparType = tpar.getType();
            if (tparType == null) continue;
            tparList.add(tparType);
        }
        return tparList;
    }

    @Override
    public boolean isAssignableFrom(Reflective r) {
        HashSet<String> done = new HashSet<String>();
        LinkedList<Reflective> todo = new LinkedList<Reflective>();
        while (r != null) {
            String rname = r.getName();
            if (rname.equals(this.getName())) {
                return true;
            }
            if (done.add(r.getName())) {
                todo.addAll(r.getSuperTypesR());
            }
            r = (Reflective)todo.poll();
        }
        return false;
    }

    @Override
    public boolean isInterface() {
        return this.pnode.getTypeKind() == 1;
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.pnode.getModifiers());
    }

    @Override
    public boolean isPublic() {
        return Modifier.isPublic(this.pnode.getModifiers());
    }

    @Override
    public Map<String, FieldReflective> getDeclaredFields() {
        Map<String, FieldNode> fields = this.pnode.getInner().getFields();
        HashMap<String, FieldReflective> rmap = new HashMap<String, FieldReflective>();
        for (String fieldName : fields.keySet()) {
            FieldNode fieldNode = fields.get(fieldName);
            TypeEntity ftypeEnt = fieldNode.getFieldType().resolveAsType();
            if (ftypeEnt == null) continue;
            FieldReflective fref = new FieldReflective(fieldName, ((JavaEntity)ftypeEnt).getType(), fieldNode.getModifiers(), this);
            rmap.put(fieldName, fref);
        }
        return rmap;
    }

    @Override
    public Map<String, Set<MethodReflective>> getDeclaredMethods() {
        TypeInnerNode pnodeInner = this.pnode.getInner();
        if (pnodeInner == null) {
            return Collections.emptyMap();
        }
        Map<String, Set<MethodNode>> methods = pnodeInner.getMethods();
        HashMap<String, Set<MethodReflective>> rmap = new HashMap<String, Set<MethodReflective>>();
        for (String name : methods.keySet()) {
            Set<MethodNode> mset = methods.get(name);
            HashSet<MethodReflective> rset = new HashSet<MethodReflective>();
            block1: for (MethodNode method : mset) {
                JavaEntity rtypeEnt = method.getReturnType();
                if (rtypeEnt == null || (rtypeEnt = rtypeEnt.resolveAsType()) == null) continue;
                JavaType rtype = rtypeEnt.getType();
                ArrayList<JavaType> paramTypes = new ArrayList<JavaType>();
                List<JavaEntity> mparamTypes = method.getParamTypes();
                for (JavaEntity mparam : mparamTypes) {
                    TypeEntity mtent = mparam.resolveAsType();
                    if (mtent == null) continue block1;
                    paramTypes.add(mtent.getType());
                }
                List<GenTypeDeclTpar> tparTypes = method.getTypeParams();
                MethodReflective mref = new MethodReflective(name, rtype, tparTypes, paramTypes, this, method.isVarArgs(), method.getModifiers());
                mref.setJavaDoc(JavaUtils.javadocToString(method.getJavadoc()));
                mref.setParamNames(method.getParamNames());
                rset.add(mref);
            }
            if (rset.isEmpty()) continue;
            rmap.put(name, rset);
        }
        return rmap;
    }

    @Override
    public List<ConstructorReflective> getDeclaredConstructors() {
        return Collections.emptyList();
    }

    @Override
    public Reflective getOuterClass() {
        ParsedTypeNode containing = this.pnode.getContainingClass();
        if (containing != null) {
            return new ParsedReflective(containing);
        }
        return null;
    }

    @Override
    public ParsedReflective getInnerClass(String name) {
        Map<String, ParsedNode> contained = this.pnode.getInner().getContainedClasses();
        ParsedNode innerParsedNode = contained.get(name);
        if (innerParsedNode instanceof ParsedTypeNode) {
            return new ParsedReflective((ParsedTypeNode)innerParsedNode);
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ParsedReflective) {
            ParsedReflective other = (ParsedReflective)obj;
            return this.pnode == other.pnode;
        }
        return false;
    }

    public int hashCode() {
        return this.pnode.hashCode();
    }
}

