/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser;

import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.GenTypeDeclTpar;
import bluej.debugger.gentype.GenTypeParameter;
import bluej.debugger.gentype.GenTypeSolid;
import bluej.debugger.gentype.JavaPrimitiveType;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.gentype.Reflective;
import bluej.parser.JavaParser;
import bluej.parser.TextAnalyzer;
import bluej.parser.entity.ConstantBoolValue;
import bluej.parser.entity.ConstantFloatValue;
import bluej.parser.entity.ConstantIntValue;
import bluej.parser.entity.ConstantStringEntity;
import bluej.parser.entity.EntityResolver;
import bluej.parser.entity.ErrorEntity;
import bluej.parser.entity.JavaEntity;
import bluej.parser.entity.NullEntity;
import bluej.parser.entity.PackageOrClass;
import bluej.parser.entity.SolidTargEntity;
import bluej.parser.entity.TypeArgumentEntity;
import bluej.parser.entity.TypeEntity;
import bluej.parser.entity.UnboundedWildcardEntity;
import bluej.parser.entity.UnresolvedEntity;
import bluej.parser.entity.ValueEntity;
import bluej.parser.entity.WildcardExtendsEntity;
import bluej.parser.entity.WildcardSuperEntity;
import bluej.parser.lexer.LocatableToken;
import bluej.utility.JavaReflective;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;

public class TextParser
extends JavaParser {
    private EntityResolver resolver;
    private JavaEntity accessType;
    private boolean staticAccess;
    protected Stack<JavaEntity> valueStack = new Stack();
    private int arrayCount = 0;
    protected Stack<Operator> operatorStack = new Stack();
    protected Stack<List<LocatableToken>> typeArgStack = new Stack();
    private static final int CAST_OPERATOR = 175;
    private static final int BAD_CAST_OPERATOR = 176;
    private static final int PAREN_OPERATOR = 177;
    private static final int MEMBER_CALL_OP = 178;
    private static final int METHOD_CALL_OP = 179;
    private static final int CONSTRUCTOR_CALL_OP = 180;
    private static final int UNARY_PLUS_OP = 181;
    private static final int UNARY_MINUS_OP = 182;
    private static final int STATE_NONE = 0;
    private static final int STATE_NEW = 1;
    private static final int STATE_NEW_ARGS = 2;
    private static final int STATE_INSTANCEOF = 3;
    private int state = 0;
    private Stack<List<JavaEntity>> argumentStack = new Stack();

    public TextParser(EntityResolver resolver, Reader r, JavaEntity accessType, boolean staticAccess) {
        super(r);
        this.resolver = resolver;
        this.accessType = accessType;
        this.staticAccess = staticAccess;
    }

    public TextParser(EntityResolver resolver, Reader r, JavaEntity accessType, boolean staticAccess, int line, int col, int pos) {
        super(r, line, col, pos);
        this.resolver = resolver;
        this.accessType = accessType;
        this.staticAccess = staticAccess;
    }

    public TextParser(EntityResolver resolver, String s, JavaEntity accessType, boolean staticAccess) {
        this(resolver, new StringReader(s), accessType, staticAccess);
    }

    public boolean atEnd() {
        return this.tokenStream.LA(1).getType() == 1;
    }

    public JavaEntity getExpressionType() {
        this.processHigherPrecedence(this.getPrecedence(1) - 1);
        if (this.valueStack.isEmpty()) {
            return null;
        }
        return this.valueStack.pop();
    }

    protected JavaEntity popValueStack() {
        if (!this.valueStack.isEmpty()) {
            return this.valueStack.pop();
        }
        return new ErrorEntity();
    }

    private int getPrecedence(int tokenType) {
        switch (tokenType) {
            case 99: {
                return -10;
            }
            case 177: {
                return -2;
            }
            case 158: {
                return -1;
            }
            case 98: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: {
                return 0;
            }
            case 70: {
                return 1;
            }
            case 73: 
            case 75: 
            case 143: 
            case 144: 
            case 145: {
                return 8;
            }
            case 141: 
            case 142: {
                return 9;
            }
            case 76: 
            case 77: 
            case 146: {
                return 10;
            }
            case 147: 
            case 148: {
                return 11;
            }
            case 87: 
            case 149: {
                return 12;
            }
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 175: 
            case 176: 
            case 181: 
            case 182: {
                return 13;
            }
            case 68: 
            case 178: 
            case 179: 
            case 180: {
                return 20;
            }
        }
        return -1;
    }

    private void processHigherPrecedence(int precedence) {
        Operator top;
        while (!this.operatorStack.isEmpty() && this.getPrecedence((top = this.operatorStack.peek()).getType()) > precedence) {
            this.operatorStack.pop();
            this.processOperator(top);
        }
    }

    private void processOperator(Operator operator) {
        int tokenType = operator.getType();
        switch (tokenType) {
            case 73: 
            case 75: 
            case 76: 
            case 77: 
            case 87: 
            case 98: 
            case 104: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: {
                JavaEntity arg2 = this.popValueStack();
                JavaEntity arg1 = this.popValueStack();
                this.doBinaryOp(arg1, arg2, operator);
                break;
            }
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 181: 
            case 182: {
                JavaEntity arg1 = this.popValueStack();
                this.checkArg(arg1, operator);
                break;
            }
            case 175: {
                this.doCast();
                break;
            }
            case 176: {
                this.popValueStack();
                this.valueStack.push(new ErrorEntity());
                break;
            }
            case 70: {
                this.processQuestionOperator();
            }
        }
    }

    private strictfp void doCast() {
        ValueEntity varg1 = this.popValueStack().resolveAsValue();
        TypeEntity castType = this.popValueStack().resolveAsType();
        if (varg1 == null || castType == null) {
            this.valueStack.push(new ErrorEntity());
            return;
        }
        if (ValueEntity.isConstant(varg1)) {
            JavaType jctype = castType.getType();
            if (jctype.isIntegralType()) {
                long ival;
                if (varg1.hasConstantIntValue()) {
                    ival = varg1.getConstantIntValue();
                    if (jctype.typeIs(JavaType.JT_BYTE)) {
                        ival = (byte)ival;
                    } else if (jctype.typeIs(JavaType.JT_CHAR)) {
                        ival = (char)ival;
                    } else if (jctype.typeIs(JavaType.JT_INT)) {
                        ival = (int)ival;
                    } else if (jctype.typeIs(JavaType.JT_SHORT)) {
                        ival = (short)ival;
                    }
                } else if (varg1.hasConstantFloatValue()) {
                    ival = jctype.typeIs(JavaType.JT_BYTE) ? (long)((byte)varg1.getConstantFloatValue()) : (jctype.typeIs(JavaType.JT_CHAR) ? (long)((char)varg1.getConstantFloatValue()) : (jctype.typeIs(JavaType.JT_INT) ? (long)((int)varg1.getConstantFloatValue()) : (jctype.typeIs(JavaType.JT_SHORT) ? (long)((short)varg1.getConstantFloatValue()) : (long)varg1.getConstantFloatValue())));
                } else {
                    this.valueStack.push(new ErrorEntity());
                    return;
                }
                this.valueStack.push(new ConstantIntValue(null, jctype, ival));
                return;
            }
            if (jctype.typeIs(JavaType.JT_FLOAT) || jctype.typeIs(JavaType.JT_DOUBLE)) {
                double dval;
                if (varg1.hasConstantIntValue()) {
                    dval = varg1.getConstantIntValue();
                } else if (varg1.hasConstantFloatValue()) {
                    dval = varg1.getConstantFloatValue();
                } else {
                    this.valueStack.push(new ErrorEntity());
                    return;
                }
                if (jctype.typeIs(JavaType.JT_FLOAT)) {
                    dval = (float)dval;
                }
                this.valueStack.push(new ConstantFloatValue(jctype, dval));
                return;
            }
            if (jctype.toString().equals("java.lang.String")) {
                if (varg1.isConstantString()) {
                    this.valueStack.push(varg1);
                } else {
                    this.valueStack.push(new ErrorEntity());
                }
                return;
            }
        }
        JavaType argType = varg1.getType();
        JavaType jctype = castType.getType();
        if (argType.isPrimitive() && !jctype.isPrimitive()) {
            if (argType.typeIs(JavaType.JT_NULL)) {
                this.valueStack.push(new ValueEntity(jctype));
                return;
            }
            String jctypeStr = jctype.toString();
            if (argType.typeIs(JavaType.JT_BOOLEAN) && jctypeStr.equals("java.lang.Boolean") || argType.typeIs(JavaType.JT_CHAR) && jctypeStr.equals("java.lang.Character") || argType.typeIs(JavaType.JT_BYTE) && jctypeStr.equals("java.lang.Byte") || argType.typeIs(JavaType.JT_SHORT) && jctypeStr.equals("java.lang.Short") || argType.typeIs(JavaType.JT_INT) && jctypeStr.equals("java.lang.Integer") || argType.typeIs(JavaType.JT_LONG) && jctypeStr.equals("java.lang.Long") || argType.typeIs(JavaType.JT_FLOAT) && jctypeStr.equals("java.lang.Float") || argType.typeIs(JavaType.JT_DOUBLE) && jctypeStr.equals("java.lang.Double")) {
                this.valueStack.push(new ValueEntity(jctype));
            } else {
                this.valueStack.push(new ErrorEntity());
            }
            return;
        }
        JavaType argUnboxed = TextAnalyzer.unBox(argType);
        if (argUnboxed.isNumeric() && jctype.isNumeric()) {
            this.valueStack.push(new ValueEntity(jctype));
            return;
        }
        if (jctype.isPrimitive()) {
            if (jctype.typeIs(JavaType.JT_BOOLEAN) && argUnboxed.typeIs(JavaType.JT_BOOLEAN)) {
                this.valueStack.push(new ValueEntity(jctype));
            } else {
                this.valueStack.push(new ErrorEntity());
            }
            return;
        }
        this.valueStack.push(new ValueEntity(jctype));
    }

    @Override
    protected void gotArrayElementAccess() {
        JavaEntity index = this.popValueStack();
        this.processHigherPrecedence(this.getPrecedence(68) - 1);
        JavaEntity array = this.popValueStack();
        index = index.resolveAsValue();
        array = array.resolveAsValue();
        if (index == null || array == null) {
            this.valueStack.push(new ErrorEntity());
            return;
        }
        JavaType componentType = array.getType().getArrayComponent();
        if (componentType == null) {
            this.valueStack.push(new ErrorEntity());
        } else {
            this.valueStack.push(new ValueEntity(componentType));
        }
    }

    private void processNewOperator(Operator token) {
        if (!this.argumentStack.isEmpty()) {
            this.argumentStack.pop();
        } else {
            this.popValueStack();
            this.valueStack.push(new ErrorEntity());
        }
    }

    private void processMemberCall(Operator op) {
        GenTypeSolid targetType;
        JavaEntity target = this.popValueStack();
        ValueEntity vtarget = target.resolveAsValue();
        if (vtarget != null) {
            GenTypeSolid stype = ((JavaEntity)vtarget).getType().asSolid();
            if (stype == null) {
                this.valueStack.push(new ErrorEntity());
                return;
            }
            targetType = stype;
        } else {
            if ((target = target.resolveAsType()) == null) {
                this.valueStack.push(new ErrorEntity());
                return;
            }
            GenTypeSolid stype = target.getType().getCapture().asSolid();
            if (stype == null) {
                this.valueStack.push(new ErrorEntity());
                return;
            }
            targetType = stype;
        }
        if (op.getToken().getType() == 69) {
            this.processMethodCall(targetType, op.getToken().getText(), this.typeArgStack.pop());
        } else {
            this.valueStack.push(new ErrorEntity());
        }
    }

    private void processMethodCall(Operator op) {
        if (op.getToken().getType() == 69) {
            this.processMethodCall(this.accessType.getType().asClass(), op.getToken().getText(), Collections.emptyList());
        } else {
            this.valueStack.push(new ErrorEntity());
        }
    }

    private void processMethodCall(GenTypeSolid targetType, String methodName, List<LocatableToken> typeArgTokens) {
        ArrayList<TextAnalyzer.MethodCallDesc> suitable;
        List<GenTypeParameter> typeArgs;
        GenTypeClass accessClass = this.accessType.getType().asClass();
        if (accessClass == null) {
            this.valueStack.push(new ErrorEntity());
            return;
        }
        List<JavaEntity> argList = this.argumentStack.pop();
        JavaType[] argTypes = new JavaType[argList.size()];
        for (int i = 0; i < argTypes.length; ++i) {
            ValueEntity cent = argList.get(i).resolveAsValue();
            if (cent == null) {
                this.valueStack.push(new ErrorEntity());
                return;
            }
            argTypes[i] = ((JavaEntity)cent).getType();
        }
        if (!typeArgTokens.isEmpty()) {
            DepthRef depthRef = new DepthRef();
            ListIterator<LocatableToken> i = typeArgTokens.listIterator(1);
            List<TypeArgumentEntity> typeArgEnts = this.readTypeArguments(i, depthRef);
            if (typeArgEnts == null) {
                this.valueStack.push(new ErrorEntity());
                return;
            }
            typeArgs = new ArrayList<GenTypeParameter>(typeArgEnts.size());
            for (TypeArgumentEntity typeArgEnt : typeArgEnts) {
                GenTypeParameter targType = typeArgEnt.getType();
                if (targType == null || targType.isPrimitive() || targType.isWildcard()) {
                    this.valueStack.push(new ErrorEntity());
                    return;
                }
                typeArgs.add(targType);
            }
        } else {
            typeArgs = Collections.emptyList();
        }
        if ((suitable = TextAnalyzer.getSuitableMethods(methodName, targetType, argTypes, typeArgs, accessClass.getReflective())).size() == 0) {
            this.valueStack.push(new ErrorEntity());
            return;
        }
        int nonAbstractCount = 0;
        TextAnalyzer.MethodCallDesc nonAbstractMethod = null;
        TextAnalyzer.MethodCallDesc mostSpecificMethod = null;
        Iterator<TextAnalyzer.MethodCallDesc> i = suitable.iterator();
        TextAnalyzer.MethodCallDesc first = i.next();
        if (!first.method.isAbstract()) {
            ++nonAbstractCount;
            nonAbstractMethod = first;
        }
        mostSpecificMethod = first;
        if (suitable.size() > 1) {
            List<GenTypeDeclTpar> tpars = first.method.getTparTypes();
            List<JavaType> paramTypes = first.method.getParamTypes();
            while (i.hasNext()) {
                TextAnalyzer.MethodCallDesc next = i.next();
                if (!TextParser.checkOverrideEquivalence(tpars, paramTypes, next.method.getTparTypes(), next.method.getParamTypes())) {
                    this.valueStack.push(new ErrorEntity());
                    return;
                }
                if (!next.method.isAbstract()) {
                    ++nonAbstractCount;
                    nonAbstractMethod = next;
                }
                if (!mostSpecificMethod.retType.isAssignableFrom(next.retType)) continue;
                mostSpecificMethod = next;
            }
        }
        TextAnalyzer.MethodCallDesc chosenMethod = nonAbstractMethod;
        if (nonAbstractCount != 1) {
            chosenMethod = mostSpecificMethod;
        }
        this.valueStack.push(new ValueEntity(chosenMethod.retType));
    }

    private static boolean checkOverrideEquivalence(List<GenTypeDeclTpar> firstTpars, List<JavaType> firstParamTypes, List<GenTypeDeclTpar> secondTpars, List<JavaType> secondParamTypes) {
        Iterator<JavaType> l;
        Iterator<JavaType> k;
        boolean doMatch;
        if (firstTpars.size() != 0 && secondTpars.size() != 0) {
            if (firstTpars.size() != secondTpars.size()) {
                return false;
            }
            HashMap<String, GenTypeDeclTpar> tparMap = new HashMap<String, GenTypeDeclTpar>();
            Iterator<GenTypeDeclTpar> i = firstTpars.iterator();
            Iterator<GenTypeDeclTpar> j = secondTpars.iterator();
            while (i.hasNext()) {
                GenTypeDeclTpar firstTpar = i.next();
                GenTypeDeclTpar secondTpar = j.next();
                tparMap.put(secondTpar.getTparName(), firstTpar);
                if (secondTpar.getUpperBound().mapTparsToTypes(tparMap).equals(firstTpar.getUpperBound())) continue;
                return false;
            }
            Iterator<JavaType> k2 = firstParamTypes.iterator();
            Iterator<JavaType> l2 = secondParamTypes.iterator();
            while (k2.hasNext()) {
                if (l2.next().mapTparsToTypes(tparMap).equals(k2.next())) continue;
                return false;
            }
            return true;
        }
        if (firstTpars.isEmpty() && secondTpars.isEmpty()) {
            doMatch = true;
            k = firstParamTypes.iterator();
            l = secondParamTypes.iterator();
            while (k.hasNext()) {
                if (l.next().equals(k.next())) continue;
                doMatch = false;
                break;
            }
            if (doMatch) {
                return true;
            }
        }
        if (firstTpars.isEmpty()) {
            doMatch = true;
            k = firstParamTypes.iterator();
            l = secondParamTypes.iterator();
            while (k.hasNext()) {
                if (l.next().getErasedType().equals(k.next())) continue;
                doMatch = false;
                break;
            }
            if (doMatch) {
                return true;
            }
        }
        if (secondTpars.isEmpty()) {
            doMatch = true;
            k = firstParamTypes.iterator();
            l = secondParamTypes.iterator();
            while (k.hasNext()) {
                if (l.next().equals(k.next().getErasedType())) continue;
                doMatch = false;
                break;
            }
            return doMatch;
        }
        return false;
    }

    private void checkArg(JavaEntity arg1, Operator op) {
        ValueEntity rarg1 = arg1.resolveAsValue();
        if (rarg1 == null) {
            this.valueStack.push(new ErrorEntity());
            return;
        }
        this.doUnaryOp(rarg1, op);
    }

    private void doUnaryPlus(ValueEntity arg) {
        JavaType argType = arg.getType();
        if (arg.hasConstantIntValue()) {
            long value = arg.getConstantIntValue();
            JavaType rtype = TextAnalyzer.unaryNumericPromotion(argType);
            this.valueStack.push(new ConstantIntValue(null, rtype, value));
        } else if (arg.hasConstantFloatValue()) {
            double value = arg.getConstantFloatValue();
            this.valueStack.push(new ConstantFloatValue(argType, value));
        } else {
            JavaType rtype = TextAnalyzer.unaryNumericPromotion(argType);
            if (rtype != null) {
                this.valueStack.push(new ValueEntity(rtype));
            } else {
                this.valueStack.push(new ErrorEntity());
            }
        }
    }

    private void doUnaryMinus(ValueEntity arg) {
        JavaType argType = arg.getType();
        if (arg.hasConstantIntValue()) {
            long value = -arg.getConstantIntValue();
            JavaType rtype = TextAnalyzer.unaryNumericPromotion(argType);
            this.valueStack.push(new ConstantIntValue(null, rtype, value));
        } else if (arg.hasConstantFloatValue()) {
            double value = -arg.getConstantFloatValue();
            this.valueStack.push(new ConstantFloatValue(argType, value));
        } else {
            JavaType rtype = TextAnalyzer.unaryNumericPromotion(argType);
            if (rtype != null) {
                this.valueStack.push(new ValueEntity(rtype));
            } else {
                this.valueStack.push(new ErrorEntity());
            }
        }
    }

    private void doUnaryOp(JavaEntity arg, Operator op) {
        ValueEntity varg = arg.resolveAsValue();
        if (varg == null) {
            this.valueStack.push(new ErrorEntity());
            return;
        }
        JavaType argType = varg.getType();
        int ttype = op.getType();
        switch (ttype) {
            case 154: {
                if (varg.hasConstantBooleanValue()) {
                    boolean rval = !varg.getConstantBooleanValue();
                    this.valueStack.push(new ConstantBoolValue(rval));
                    break;
                }
                if (argType.typeIs(JavaType.JT_BOOLEAN) || argType.toString().equals("java.lang.Boolean")) {
                    this.valueStack.push(new ValueEntity(JavaPrimitiveType.getBoolean()));
                    break;
                }
                this.valueStack.push(new ErrorEntity());
                break;
            }
            case 153: {
                if (varg.hasConstantIntValue()) {
                    long rval = varg.getConstantIntValue() ^ 0xFFFFFFFFFFFFFFFFL;
                    JavaType rtype = TextAnalyzer.unaryNumericPromotion(argType);
                    this.valueStack.push(new ConstantIntValue(null, rtype, rval));
                    break;
                }
                JavaType argTypeUnboxed = TextAnalyzer.unBox(argType);
                if (argTypeUnboxed.isIntegralType()) {
                    this.valueStack.push(new ValueEntity(TextAnalyzer.unaryNumericPromotion(argTypeUnboxed)));
                    break;
                }
                this.valueStack.push(new ErrorEntity());
                break;
            }
            case 151: 
            case 152: {
                JavaType argTypeUnboxed = TextAnalyzer.unBox(argType);
                if (argTypeUnboxed.isIntegralType()) {
                    this.valueStack.push(new ValueEntity(argType));
                    break;
                }
                this.valueStack.push(new ErrorEntity());
                break;
            }
            case 181: {
                this.doUnaryPlus(varg);
                break;
            }
            case 182: {
                this.doUnaryMinus(varg);
            }
        }
    }

    private long limitResult(JavaType type, long value) {
        if (type.typeIs(JavaType.JT_BYTE)) {
            return (byte)value;
        }
        if (type.typeIs(JavaType.JT_CHAR)) {
            return (char)value;
        }
        if (type.typeIs(JavaType.JT_SHORT)) {
            return (short)value;
        }
        if (type.typeIs(JavaType.JT_INT)) {
            return (int)value;
        }
        return value;
    }

    private float promoteToFloat(ValueEntity arg1) {
        if (arg1.hasConstantFloatValue()) {
            return (float)arg1.getConstantFloatValue();
        }
        return arg1.getConstantIntValue();
    }

    private double promoteToDouble(ValueEntity arg1) {
        if (arg1.hasConstantFloatValue()) {
            return (float)arg1.getConstantFloatValue();
        }
        return arg1.getConstantIntValue();
    }

    private void doOpPlus(Operator op, ValueEntity arg1, ValueEntity arg2) {
        GenTypeClass[] stypes;
        JavaType a1type = arg1.getType();
        JavaType a2type = arg2.getType();
        GenTypeSolid a1solid = a1type.asSolid();
        GenTypeSolid a2solid = a2type.asSolid();
        GenTypeSolid a1class = null;
        GenTypeSolid a2class = null;
        if (a1solid != null && (stypes = a1solid.getReferenceSupertypes()).length > 0) {
            a1class = a1solid.getReferenceSupertypes()[0];
        }
        if (a2solid != null && (stypes = a2solid.getReferenceSupertypes()).length > 0) {
            a2class = a2solid.getReferenceSupertypes()[0];
        }
        if (a1class != null && a1class.toString().equals("java.lang.String")) {
            this.valueStack.push(new ValueEntity(a1class));
            return;
        }
        if (a2class != null && a2class.toString().equals("java.lang.String")) {
            this.valueStack.push(new ValueEntity(a2class));
            return;
        }
        this.doBnpOp(op, arg1, arg2);
    }

    private strictfp void doBnpOp(Operator op, ValueEntity arg1, ValueEntity arg2) {
        JavaType a2type;
        JavaType a1type = arg1.getType();
        JavaType resultType = TextAnalyzer.binaryNumericPromotion(a1type, a2type = arg2.getType());
        if (resultType == null) {
            this.valueStack.push(new ErrorEntity());
            return;
        }
        if ((arg1.hasConstantIntValue() || arg1.hasConstantFloatValue()) && (arg2.hasConstantIntValue() || arg2.hasConstantFloatValue())) {
            if (resultType.isIntegralType()) {
                long rval;
                long a1 = arg1.getConstantIntValue();
                long a2 = arg2.getConstantIntValue();
                switch (op.type) {
                    case 147: {
                        rval = a1 + a2;
                        break;
                    }
                    case 148: {
                        rval = a1 - a2;
                        break;
                    }
                    case 87: {
                        rval = a1 * a2;
                        break;
                    }
                    case 149: {
                        if (a2 == 0L) {
                            this.valueStack.push(new ValueEntity(resultType));
                            return;
                        }
                        rval = a1 / a2;
                        break;
                    }
                    case 150: {
                        if (a2 == 0L) {
                            this.valueStack.push(new ValueEntity(resultType));
                            return;
                        }
                        rval = a1 % a2;
                        break;
                    }
                    case 104: {
                        rval = a1 & a2;
                        break;
                    }
                    case 139: {
                        rval = a1 | a2;
                        break;
                    }
                    case 140: {
                        rval = a1 ^ a2;
                        break;
                    }
                    default: {
                        rval = 0L;
                    }
                }
                rval = this.limitResult(resultType, rval);
                this.valueStack.push(new ConstantIntValue(null, resultType, rval));
            } else if (resultType.typeIs(JavaType.JT_FLOAT)) {
                float rval;
                float a1 = this.promoteToFloat(arg1);
                float a2 = this.promoteToFloat(arg2);
                switch (op.type) {
                    case 147: {
                        rval = a1 + a2;
                        break;
                    }
                    case 148: {
                        rval = a1 - a2;
                        break;
                    }
                    case 87: {
                        rval = a1 * a2;
                        break;
                    }
                    case 149: {
                        rval = a1 / a2;
                        break;
                    }
                    case 150: {
                        rval = a1 % a2;
                        break;
                    }
                    default: {
                        this.valueStack.push(new ErrorEntity());
                        return;
                    }
                }
                this.valueStack.push(new ConstantFloatValue(resultType, rval));
            } else {
                double rval;
                double a1 = this.promoteToDouble(arg1);
                double a2 = this.promoteToDouble(arg2);
                switch (op.type) {
                    case 147: {
                        rval = a1 + a2;
                        break;
                    }
                    case 148: {
                        rval = a1 - a2;
                        break;
                    }
                    case 87: {
                        rval = a1 * a2;
                        break;
                    }
                    case 149: {
                        rval = a1 / a2;
                        break;
                    }
                    case 150: {
                        rval = a1 % a2;
                        break;
                    }
                    default: {
                        this.valueStack.push(new ErrorEntity());
                        return;
                    }
                }
                this.valueStack.push(new ConstantFloatValue(resultType, rval));
            }
            return;
        }
        this.valueStack.push(new ValueEntity(null, resultType));
    }

    private void doEqualityOp(Operator op, ValueEntity arg1, ValueEntity arg2) {
        JavaType a1type = arg1.getType();
        JavaType a2type = arg2.getType();
        if (ValueEntity.isConstant(arg1) && ValueEntity.isConstant(arg2)) {
            if (a1type.isNumeric()) {
                if (!a2type.isNumeric()) {
                    this.valueStack.push(new ErrorEntity());
                    return;
                }
                JavaType promotedType = TextAnalyzer.binaryNumericPromotion(a1type, a2type);
                if (promotedType.isIntegralType()) {
                    long a2;
                    long a1 = arg1.getConstantIntValue();
                    boolean rval = a1 == (a2 = arg2.getConstantIntValue()) ^ op.type != 142;
                    this.valueStack.push(new ConstantBoolValue(rval));
                } else if (promotedType.typeIs(JavaType.JT_FLOAT)) {
                    float a2;
                    float a1 = this.promoteToFloat(arg1);
                    boolean rval = a1 == (a2 = this.promoteToFloat(arg2)) ^ op.type != 142;
                    this.valueStack.push(new ConstantBoolValue(rval));
                } else {
                    double a2;
                    double a1 = this.promoteToDouble(arg1);
                    boolean rval = a1 == (a2 = this.promoteToDouble(arg2)) ^ op.type != 142;
                    this.valueStack.push(new ConstantBoolValue(rval));
                }
                return;
            }
            if (arg1.hasConstantBooleanValue() && arg2.hasConstantBooleanValue()) {
                boolean a1 = arg1.getConstantBooleanValue();
                boolean a2 = arg2.getConstantBooleanValue();
                boolean rval = op.type == 142 ? a1 == a2 : a1 != a2;
                this.valueStack.push(new ConstantBoolValue(rval));
                return;
            }
            if (arg1.isConstantString() && arg2.isConstantString()) {
                String a1 = arg1.getConstantString();
                String a2 = arg2.getConstantString();
                boolean rval = op.type != 142 ^ a1.equals(a2);
                this.valueStack.push(new ConstantBoolValue(rval));
                return;
            }
            this.valueStack.push(new ErrorEntity());
        }
        if (a1type.isNumeric() || a2type.isNumeric()) {
            JavaType promotedType = TextAnalyzer.binaryNumericPromotion(a1type, a2type);
            if (promotedType == null) {
                this.valueStack.push(new ErrorEntity());
            } else {
                this.valueStack.push(new ValueEntity("", JavaPrimitiveType.getBoolean()));
            }
        } else if (a1type.isNull() && a2type.isNull() || a1type.isNull() && a2type.asSolid() != null || a1type.asSolid() != null && a2type.isNull()) {
            this.valueStack.push(new ValueEntity(JavaPrimitiveType.getBoolean()));
        } else if (a1type.asSolid() != null && a2type.asSolid() != null) {
            this.valueStack.push(new ValueEntity(JavaPrimitiveType.getBoolean()));
        } else {
            this.valueStack.push(new ErrorEntity());
        }
    }

    private void doRelationshipOp(Operator op, ValueEntity arg1, ValueEntity arg2) {
        JavaType a2type;
        JavaType a1type = arg1.getType();
        JavaType promotedType = TextAnalyzer.binaryNumericPromotion(a1type, a2type = arg2.getType());
        if (promotedType == null) {
            this.valueStack.push(new ErrorEntity());
        } else {
            if (ValueEntity.isConstant(arg1) && ValueEntity.isConstant(arg2)) {
                if (promotedType.isIntegralType()) {
                    boolean rval;
                    long a1 = arg1.getConstantIntValue();
                    long a2 = arg2.getConstantIntValue();
                    switch (op.type) {
                        case 73: {
                            rval = a1 < a2;
                            break;
                        }
                        case 143: {
                            rval = a1 <= a2;
                            break;
                        }
                        case 75: {
                            rval = a1 > a2;
                            break;
                        }
                        default: {
                            rval = a1 >= a2;
                        }
                    }
                    this.valueStack.push(new ConstantBoolValue(rval));
                } else if (promotedType.typeIs(JavaType.JT_FLOAT)) {
                    boolean rval;
                    float a1 = this.promoteToFloat(arg1);
                    float a2 = this.promoteToFloat(arg2);
                    switch (op.type) {
                        case 73: {
                            rval = a1 < a2;
                            break;
                        }
                        case 143: {
                            rval = a1 <= a2;
                            break;
                        }
                        case 75: {
                            rval = a1 > a2;
                            break;
                        }
                        default: {
                            rval = a1 >= a2;
                        }
                    }
                    this.valueStack.push(new ConstantBoolValue(rval));
                } else {
                    boolean rval;
                    double a1 = this.promoteToDouble(arg1);
                    double a2 = this.promoteToDouble(arg2);
                    switch (op.type) {
                        case 73: {
                            rval = a1 < a2;
                            break;
                        }
                        case 143: {
                            rval = a1 <= a2;
                            break;
                        }
                        case 75: {
                            rval = a1 > a2;
                            break;
                        }
                        default: {
                            rval = a1 >= a2;
                        }
                    }
                    this.valueStack.push(new ConstantBoolValue(rval));
                }
                return;
            }
            this.valueStack.push(new ValueEntity("", JavaPrimitiveType.getBoolean()));
        }
    }

    private void doBitwiseOp(Operator op, ValueEntity arg1, ValueEntity arg2) {
        JavaType a2type;
        JavaType a1type = arg1.getType();
        if ((a1type.typeIs(JavaType.JT_BOOLEAN) || a1type.toString().equals("java.lang.Boolean")) && ((a2type = arg2.getType()).typeIs(JavaType.JT_BOOLEAN) || a2type.toString().equals("java.lang.Boolean"))) {
            if (arg1.hasConstantBooleanValue() && arg2.hasConstantBooleanValue()) {
                boolean rval;
                boolean a1 = arg1.getConstantBooleanValue();
                boolean a2 = arg2.getConstantBooleanValue();
                switch (op.type) {
                    case 104: {
                        rval = a1 & a2;
                        break;
                    }
                    case 139: {
                        rval = a1 | a2;
                        break;
                    }
                    default: {
                        rval = a1 ^ a2;
                    }
                }
                this.valueStack.push(new ConstantBoolValue(rval));
            } else {
                this.valueStack.push(new ValueEntity(JavaPrimitiveType.getBoolean()));
            }
            return;
        }
        this.doBnpOp(op, arg1, arg2);
    }

    private void doLogicalOp(Operator op, ValueEntity arg1, ValueEntity arg2) {
        JavaType a2type;
        JavaType a1type = arg1.getType();
        if ((a1type.typeIs(JavaType.JT_BOOLEAN) || a1type.toString().equals("java.lang.Boolean")) && ((a2type = arg2.getType()).typeIs(JavaType.JT_BOOLEAN) || a2type.toString().equals("java.lang.Boolean"))) {
            if (arg1.hasConstantBooleanValue() && arg2.hasConstantBooleanValue()) {
                boolean a1 = arg1.getConstantBooleanValue();
                boolean a2 = arg2.getConstantBooleanValue();
                switch (op.type) {
                    case 138: {
                        boolean bl = a1 && a2;
                    }
                }
                boolean rval = a1 || a2;
                this.valueStack.push(new ConstantBoolValue(rval));
            } else {
                this.valueStack.push(new ValueEntity(JavaPrimitiveType.getBoolean()));
            }
            return;
        }
        this.valueStack.push(new ErrorEntity());
    }

    private void doBinaryOp(JavaEntity uarg1, JavaEntity uarg2, Operator op) {
        ValueEntity arg1 = uarg1.resolveAsValue();
        ValueEntity arg2 = uarg2.resolveAsValue();
        if (arg1 == null || arg2 == null) {
            this.valueStack.push(new ErrorEntity());
            return;
        }
        JavaType a1type = arg1.getType().getCapture();
        int ttype = op.getType();
        switch (ttype) {
            case 147: {
                this.doOpPlus(op, arg1, arg2);
                return;
            }
            case 87: 
            case 148: 
            case 149: 
            case 150: {
                this.doBnpOp(op, arg1, arg2);
                break;
            }
            case 104: 
            case 139: 
            case 140: {
                this.doBitwiseOp(op, arg1, arg2);
                break;
            }
            case 137: 
            case 138: {
                this.doLogicalOp(op, arg1, arg2);
                break;
            }
            case 76: 
            case 77: 
            case 146: {
                JavaType a1typeP = TextAnalyzer.unaryNumericPromotion(a1type);
                JavaType a2typeP = TextAnalyzer.unaryNumericPromotion(a1type);
                if (a1typeP == null || a2typeP == null || !a1typeP.isIntegralType() || !a2typeP.isIntegralType()) {
                    this.valueStack.push(new ErrorEntity());
                    break;
                }
                if (arg1.hasConstantIntValue() && arg2.hasConstantIntValue()) {
                    long a1 = arg1.getConstantIntValue();
                    long a2 = arg2.getConstantIntValue();
                    long rval = ttype == 146 ? a1 << (int)a2 : (ttype == 76 ? a1 >> (int)a2 : a1 >>> (int)a2);
                    rval = this.limitResult(a1typeP, rval);
                    this.valueStack.push(new ConstantIntValue(null, a1typeP, rval));
                    break;
                }
                this.valueStack.push(new ValueEntity("", a1typeP));
                break;
            }
            case 73: 
            case 75: 
            case 143: 
            case 144: {
                this.doRelationshipOp(op, arg1, arg2);
                break;
            }
            case 141: 
            case 142: {
                this.doEqualityOp(op, arg1, arg2);
                break;
            }
            case 98: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: {
                this.valueStack.push(arg1);
                break;
            }
            case 68: {
                this.valueStack.push(new ErrorEntity());
            }
        }
    }

    private void processQuestionOperator() {
        JavaEntity rhs = this.popValueStack();
        JavaEntity lhs = this.popValueStack();
        JavaEntity condition = this.popValueStack();
        ValueEntity conditionv = condition.resolveAsValue();
        if (conditionv == null) {
            this.valueStack.push(new ErrorEntity());
            return;
        }
        JavaType ctype = conditionv.getType();
        if (!ctype.typeIs(JavaType.JT_BOOLEAN) && !ctype.toString().equals("java.lang.Boolean")) {
            this.valueStack.push(new ErrorEntity());
            return;
        }
        ValueEntity rhsv = rhs.resolveAsValue();
        ValueEntity lhsv = lhs.resolveAsValue();
        if (rhsv == null || lhsv == null) {
            this.valueStack.push(new ErrorEntity());
            return;
        }
        ValueEntity rent = TextAnalyzer.questionOperator15(conditionv, lhsv, rhsv);
        this.valueStack.push(rent);
    }

    @Override
    protected void beginExpression(LocatableToken token) {
        this.operatorStack.push(new Operator(177, token));
    }

    @Override
    protected void endExpression(LocatableToken token, boolean isEmpty) {
        if (isEmpty) {
            this.valueStack.push(new ErrorEntity());
        }
        this.processHigherPrecedence(this.getPrecedence(177));
        this.operatorStack.pop();
        if (!this.operatorStack.isEmpty() && this.operatorStack.peek().type == 99) {
            this.popValueStack();
        }
    }

    private void gotStringLiteral(LocatableToken token) {
        int c;
        String ctext = token.getText();
        StringBuffer sb = new StringBuffer(ctext.length());
        for (int pos = 1; pos < ctext.length() && (c = ctext.charAt(pos)) != 34; ++pos) {
            if (c == 92) {
                c = ctext.charAt(2);
                if (c == 98) {
                    c = 8;
                } else if (c == 116) {
                    c = 9;
                } else if (c == 110) {
                    c = 10;
                } else if (c == 102) {
                    c = 12;
                } else if (c == 114) {
                    c = 13;
                } else if (c == 39) {
                    c = 39;
                } else if (c == 34) {
                    c = 34;
                } else if (c == 92) {
                    c = 92;
                } else if (c >= 48 && c <= 55) {
                    char d;
                    int val = c - 48;
                    while (++pos < ctext.length() && (d = ctext.charAt(pos)) != '\'') {
                        if (d < '0' || d > '7') {
                            this.valueStack.push(new ErrorEntity());
                            return;
                        }
                        if ((val = val * 8 + (d - 48)) <= 255) continue;
                        this.valueStack.push(new ErrorEntity());
                        return;
                    }
                    c = (char)val;
                } else {
                    this.valueStack.push(new ErrorEntity());
                    return;
                }
            }
            sb.append((char)c);
        }
        GenTypeClass stringType = new GenTypeClass(new JavaReflective(String.class));
        ConstantStringEntity ent = new ConstantStringEntity(stringType, sb.toString());
        this.valueStack.push(ent);
    }

    @Override
    protected void gotLiteral(LocatableToken token) {
        if (token.getType() == 160) {
            String ctext = token.getText();
            int c = ctext.charAt(1);
            if (c == 92) {
                c = ctext.charAt(2);
                if (c == 98) {
                    c = 8;
                } else if (c == 116) {
                    c = 9;
                } else if (c == 110) {
                    c = 10;
                } else if (c == 102) {
                    c = 12;
                } else if (c == 114) {
                    c = 13;
                } else if (c == 39) {
                    c = 39;
                } else if (c == 34) {
                    c = 34;
                } else if (c == 92) {
                    c = 92;
                } else if (c >= 48 && c <= 55) {
                    char d;
                    int val = c - 48;
                    int pos = 3;
                    while (pos < ctext.length() && (d = ctext.charAt(pos++)) != '\'') {
                        if (d < '0' || d > '7') {
                            this.valueStack.push(new ErrorEntity());
                            return;
                        }
                        if ((val = val * 8 + (d - 48)) <= 255) continue;
                        this.valueStack.push(new ErrorEntity());
                        return;
                    }
                    c = (char)val;
                } else {
                    this.valueStack.push(new ErrorEntity());
                    return;
                }
            }
            this.valueStack.push(new ConstantIntValue(null, JavaPrimitiveType.getChar(), c));
        } else if (token.getType() == 159) {
            try {
                this.valueStack.push(new ConstantIntValue(null, JavaPrimitiveType.getInt(), Integer.decode(token.getText()).intValue()));
            }
            catch (NumberFormatException nfe) {
                this.valueStack.push(new ErrorEntity());
            }
        } else if (token.getType() == 163) {
            try {
                String text = token.getText();
                text = text.substring(0, text.length() - 1);
                this.valueStack.push(new ConstantIntValue(null, JavaPrimitiveType.getLong(), Long.decode(text)));
            }
            catch (NumberFormatException nfe) {
                this.valueStack.push(new ErrorEntity());
            }
        } else if (token.getType() == 162) {
            try {
                this.valueStack.push(new ConstantFloatValue(JavaPrimitiveType.getFloat(), Float.parseFloat(token.getText())));
            }
            catch (NumberFormatException nfe) {
                this.valueStack.push(new ErrorEntity());
            }
        } else if (token.getType() == 164) {
            try {
                this.valueStack.push(new ConstantFloatValue(JavaPrimitiveType.getDouble(), Double.parseDouble(token.getText())));
            }
            catch (NumberFormatException nfe) {
                this.valueStack.push(new ErrorEntity());
            }
        } else if (token.getType() == 157) {
            this.valueStack.push(new NullEntity());
        } else if (token.getType() == 161) {
            this.gotStringLiteral(token);
        } else if (token.getType() == 155 || token.getType() == 156) {
            this.valueStack.push(new ConstantBoolValue(token.getType() == 155));
        } else if (token.getType() == 107) {
            if (this.staticAccess) {
                this.valueStack.push(new ErrorEntity());
            } else {
                JavaType type = this.accessType.getType();
                if (type != null) {
                    this.valueStack.push(new ValueEntity(type));
                } else {
                    this.valueStack.push(new ErrorEntity());
                }
            }
        } else {
            this.valueStack.push(new ErrorEntity());
        }
    }

    @Override
    protected void gotIdentifier(LocatableToken token) {
        String ident = token.getText();
        Reflective accessSource = this.getAccessSource();
        this.valueStack.push(UnresolvedEntity.getEntity(this.resolver, ident, accessSource));
        this.arrayCount = 0;
    }

    private Reflective getAccessSource() {
        GenTypeClass accessClass;
        if (this.accessType != null && (accessClass = this.accessType.getType().asClass()) != null) {
            return accessClass.getReflective();
        }
        return null;
    }

    @Override
    protected void gotMemberAccess(LocatableToken token) {
        ValueEntity topVal;
        String ident = token.getText();
        JavaEntity top = this.valueStack.pop();
        if (token.getText().equals("length") && (topVal = top.resolveAsValue()) != null && ((JavaEntity)topVal).getType().getArrayComponent() != null) {
            this.valueStack.push(new ValueEntity(JavaPrimitiveType.getInt()));
            return;
        }
        JavaEntity newTop = top.getSubentity(ident, this.getAccessSource());
        if (newTop != null) {
            this.valueStack.push(newTop);
        } else {
            this.valueStack.push(new ErrorEntity());
        }
    }

    @Override
    protected void gotMemberCall(LocatableToken token, List<LocatableToken> typeArgs) {
        this.operatorStack.push(new Operator(178, token));
        this.typeArgStack.push(typeArgs);
    }

    @Override
    protected void gotMethodCall(LocatableToken token) {
        this.operatorStack.push(new Operator(179, token));
    }

    @Override
    protected void gotConstructorCall(LocatableToken token) {
        this.operatorStack.push(new Operator(179, token));
    }

    @Override
    protected void gotUnaryOperator(LocatableToken token) {
        int ttype = token.getType();
        if (ttype == 147) {
            ttype = 181;
        } else if (ttype == 148) {
            ttype = 182;
        }
        this.processHigherPrecedence(this.getPrecedence(ttype));
        this.operatorStack.push(new Operator(ttype, token));
    }

    @Override
    protected void gotBinaryOperator(LocatableToken token) {
        this.processHigherPrecedence(this.getPrecedence(token.getType()) - 1);
        this.operatorStack.push(new Operator(token.getType(), token));
    }

    @Override
    protected void gotInstanceOfOperator(LocatableToken token) {
        this.processHigherPrecedence(this.getPrecedence(token.getType()) - 1);
        this.operatorStack.push(new Operator(token.getType(), token));
        this.state = 3;
    }

    @Override
    protected void gotQuestionOperator(LocatableToken token) {
        this.processHigherPrecedence(this.getPrecedence(token.getType()) - 1);
        this.operatorStack.push(new Operator(token.getType(), token));
    }

    @Override
    protected void gotTypeSpec(List<LocatableToken> tokens) {
        if (this.state == 1) {
            TypeEntity entity = this.resolveTypeSpec(tokens);
            this.state = 2;
            if (entity != null) {
                this.valueStack.push(new ValueEntity(((JavaEntity)entity).getType()));
            } else {
                this.valueStack.push(new ErrorEntity());
            }
        } else if (this.state == 3) {
            TypeEntity entity = this.resolveTypeSpec(tokens);
            if (entity != null) {
                this.popValueStack();
                this.valueStack.push(new ValueEntity(JavaPrimitiveType.getBoolean()));
            } else {
                this.popValueStack();
                this.valueStack.push(new ErrorEntity());
            }
        }
    }

    @Override
    protected void gotTypeCast(List<LocatableToken> tokens) {
        TypeEntity entity = this.resolveTypeSpec(tokens);
        if (entity != null) {
            this.valueStack.push(entity);
            this.operatorStack.push(new Operator(175, null));
        } else {
            this.operatorStack.push(new Operator(176, null));
        }
    }

    @Override
    protected void gotArrayDeclarator() {
        ++this.arrayCount;
    }

    @Override
    protected void gotNewArrayDeclarator(boolean withDimension) {
        JavaEntity top;
        ValueEntity ttop;
        if (this.state != 0) {
            this.state = 0;
            this.operatorStack.pop();
        }
        if (withDimension) {
            this.valueStack.pop();
        }
        if ((ttop = (top = this.valueStack.pop()).resolveAsValue()) != null) {
            this.valueStack.push(new ValueEntity(((JavaEntity)ttop).getType().getArray()));
        } else {
            this.valueStack.push(new ErrorEntity());
        }
    }

    @Override
    protected void gotPrimitiveTypeLiteral(LocatableToken token) {
        ArrayList<LocatableToken> ltokens = new ArrayList<LocatableToken>(1);
        ltokens.add(token);
        TypeEntity tent = this.resolveTypeSpec(ltokens);
        this.valueStack.push(tent);
        this.arrayCount = 0;
    }

    @Override
    protected void gotClassLiteral(LocatableToken token) {
        JavaEntity ent = this.popValueStack();
        TypeEntity tent = ent.resolveAsType();
        if (tent != null) {
            JavaType ttype = tent.getType();
            if (this.arrayCount > 0) {
                while (this.arrayCount-- > 0) {
                    ttype = ttype.getArray();
                }
                tent = new TypeEntity(ttype);
            }
            if (!ttype.isPrimitive()) {
                JavaEntity jlcEnt = this.resolver.resolveQualifiedClass("java.lang.Class");
                if (jlcEnt != null) {
                    ArrayList<SolidTargEntity> targs = new ArrayList<SolidTargEntity>(1);
                    targs.add(new SolidTargEntity(tent));
                    jlcEnt = ((TypeEntity)jlcEnt).setTypeArgs(targs);
                    if (jlcEnt != null) {
                        this.valueStack.push(new ValueEntity(((TypeEntity)jlcEnt).getType()));
                        return;
                    }
                }
            } else {
                String repClass = null;
                if (ttype.typeIs(JavaType.JT_BOOLEAN)) {
                    repClass = "java.lang.Boolean";
                } else if (ttype.typeIs(JavaType.JT_BYTE)) {
                    repClass = "java.lang.Byte";
                } else if (ttype.typeIs(JavaType.JT_CHAR)) {
                    repClass = "java.lang.Char";
                } else if (ttype.typeIs(JavaType.JT_DOUBLE)) {
                    repClass = "java.lang.Double";
                } else if (ttype.typeIs(JavaType.JT_FLOAT)) {
                    repClass = "java.lang.Float";
                } else if (ttype.typeIs(JavaType.JT_INT)) {
                    repClass = "java.lang.Integer";
                } else if (ttype.typeIs(JavaType.JT_LONG)) {
                    repClass = "java.lang.Long";
                } else if (ttype.typeIs(JavaType.JT_VOID)) {
                    repClass = "java.lang.Void";
                }
                if (repClass != null) {
                    JavaEntity jlcEnt = this.resolver.resolveQualifiedClass("java.lang.Class");
                    TypeEntity repEnt = this.resolver.resolveQualifiedClass(repClass);
                    if (jlcEnt != null && repEnt != null) {
                        ArrayList<SolidTargEntity> targs = new ArrayList<SolidTargEntity>(1);
                        targs.add(new SolidTargEntity(repEnt));
                        jlcEnt = ((TypeEntity)jlcEnt).setTypeArgs(targs);
                        if (jlcEnt != null) {
                            this.valueStack.push(new ValueEntity(((TypeEntity)jlcEnt).getType()));
                            return;
                        }
                    }
                }
            }
        }
        this.valueStack.push(new ErrorEntity());
    }

    private TypeEntity resolveTypeSpec(List<LocatableToken> tokens) {
        DepthRef dr = new DepthRef();
        return this.resolveTypeSpec(tokens.listIterator(), dr);
    }

    private TypeEntity resolveTypeSpec(ListIterator<LocatableToken> i, DepthRef depthRef) {
        PackageOrClass poc;
        LocatableToken token = i.next();
        if (TextParser.isPrimitiveType(token)) {
            if (token.getType() == 78) {
                return new TypeEntity(JavaPrimitiveType.getVoid());
            }
            JavaType type = null;
            switch (token.getType()) {
                case 83: {
                    type = JavaPrimitiveType.getInt();
                    break;
                }
                case 82: {
                    type = JavaPrimitiveType.getShort();
                    break;
                }
                case 81: {
                    type = JavaPrimitiveType.getChar();
                    break;
                }
                case 80: {
                    type = JavaPrimitiveType.getByte();
                    break;
                }
                case 79: {
                    type = JavaPrimitiveType.getBoolean();
                    break;
                }
                case 85: {
                    type = JavaPrimitiveType.getLong();
                    break;
                }
                case 86: {
                    type = JavaPrimitiveType.getDouble();
                    break;
                }
                case 84: {
                    type = JavaPrimitiveType.getFloat();
                }
            }
            while (i.hasNext()) {
                token = i.next();
                if (token.getType() == 66) {
                    type = ((JavaType)type).getArray();
                    i.next();
                    continue;
                }
                return null;
            }
            return new TypeEntity(type);
        }
        String text = token.getText();
        for (poc = this.resolver.resolvePackageOrClass(text, this.getAccessSource()); poc != null && i.hasNext(); poc = poc.getPackageOrClassMember(token.getText())) {
            token = i.next();
            if (token.getType() == 73) {
                TypeEntity classEnt = poc.resolveAsType();
                if (classEnt != null) {
                    classEnt = this.processTypeArgs(classEnt, i, depthRef);
                }
                if ((poc = classEnt) == null) {
                    return null;
                }
                if (!i.hasNext()) {
                    return classEnt;
                }
                token = i.next();
            }
            if (token.getType() != 68) {
                if ((poc = poc.resolveAsType()) == null) {
                    return null;
                }
                while (token.getType() == 66) {
                    poc = new TypeEntity(poc.getType().getArray());
                    if (i.hasNext()) {
                        token = i.next();
                    }
                    if (!i.hasNext()) {
                        return poc.resolveAsType();
                    }
                    token = i.next();
                }
                i.previous();
                return poc.resolveAsType();
            }
            token = i.next();
            if (token.getType() != 69) break;
        }
        if (poc != null) {
            return poc.resolveAsType();
        }
        return null;
    }

    private TypeEntity processTypeArgs(TypeEntity base, ListIterator<LocatableToken> i, DepthRef depthRef) {
        List<TypeArgumentEntity> taList = this.readTypeArguments(i, depthRef);
        if (taList == null) {
            return null;
        }
        return base.setTypeArgs((List)taList);
    }

    private List<TypeArgumentEntity> readTypeArguments(ListIterator<LocatableToken> i, DepthRef depthRef) {
        int startDepth = depthRef.depth++;
        LinkedList<TypeArgumentEntity> taList = new LinkedList<TypeArgumentEntity>();
        block4: while (i.hasNext() && depthRef.depth > startDepth) {
            LocatableToken token = i.next();
            if (token.getType() == 70) {
                if (!i.hasNext()) {
                    return null;
                }
                token = i.next();
                if (token.getType() == 72) {
                    TypeEntity taEnt = this.resolveTypeSpec(i, depthRef);
                    if (taEnt == null) {
                        return null;
                    }
                    taList.add(new WildcardSuperEntity(taEnt));
                } else if (token.getType() == 71) {
                    TypeEntity taEnt = this.resolveTypeSpec(i, depthRef);
                    if (taEnt == null) {
                        return null;
                    }
                    taList.add(new WildcardExtendsEntity(taEnt));
                } else {
                    taList.add(new UnboundedWildcardEntity(this.resolver));
                    i.previous();
                }
            } else {
                i.previous();
                TypeEntity taEnt = this.resolveTypeSpec(i, depthRef);
                if (taEnt == null) {
                    return null;
                }
                JavaType taType = taEnt.getType();
                if (taType.isPrimitive()) {
                    return null;
                }
                taList.add(new SolidTargEntity(new TypeEntity(taType)));
            }
            if (!i.hasNext()) {
                return null;
            }
            token = i.next();
            int ttype = token.getType();
            while (ttype == 75 || ttype == 76 || ttype == 77) {
                switch (ttype) {
                    case 77: {
                        --depthRef.depth;
                    }
                    case 76: {
                        --depthRef.depth;
                    }
                }
                --depthRef.depth;
                if (!i.hasNext()) break block4;
                token = i.next();
                ttype = token.getType();
            }
            if (ttype == 74) continue;
            i.previous();
            break;
        }
        return taList;
    }

    @Override
    protected void beginArgumentList(LocatableToken token) {
        this.state = 0;
        this.argumentStack.push(new ArrayList());
    }

    @Override
    protected void endArgument() {
        if (!this.valueStack.isEmpty()) {
            this.argumentStack.peek().add(this.valueStack.pop());
        }
    }

    @Override
    protected void endArgumentList(LocatableToken token) {
        if (!this.operatorStack.isEmpty()) {
            Operator top = this.operatorStack.pop();
            if (top.getType() == 158) {
                this.processNewOperator(top);
            } else if (top.getType() == 178) {
                this.processMemberCall(top);
            } else if (top.getType() == 179) {
                this.processMethodCall(top);
            } else {
                this.argumentStack.pop();
            }
        }
    }

    @Override
    protected void gotExprNew(LocatableToken token) {
        this.state = 1;
        this.operatorStack.push(new Operator(token.getType(), token));
    }

    @Override
    protected void endExprNew(LocatableToken token, boolean included) {
        if (this.state != 0) {
            if (this.state == 2) {
                this.popValueStack();
            }
            this.operatorStack.pop();
            this.valueStack.push(new ErrorEntity());
            this.state = 0;
        }
    }

    @Override
    protected void beginAnonClassBody(LocatableToken token, boolean isEnumMember) {
        this.operatorStack.push(new Operator(token.getType(), token));
    }

    @Override
    protected void beginArrayInitList(LocatableToken token) {
        this.operatorStack.push(new Operator(token.getType(), token));
    }

    private class DepthRef {
        int depth = 0;

        private DepthRef() {
        }
    }

    protected class Operator {
        int type;
        LocatableToken token;

        Operator(int type, LocatableToken token) {
            this.type = type;
            this.token = token;
        }

        int getType() {
            return this.type;
        }

        LocatableToken getToken() {
            return this.token;
        }
    }
}

