/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.git;

import bluej.groupwork.StatusListener;
import bluej.groupwork.TeamStatusInfo;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.git.GitCommand;
import bluej.groupwork.git.GitRepository;
import bluej.groupwork.git.GitStatusHandle;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.NoWorkTreeException;

public class GitStatusCommand
extends GitCommand {
    StatusListener listener;
    FileFilter filter;
    boolean includeRemote;

    public GitStatusCommand(GitRepository repository, StatusListener listener, FileFilter filter, boolean includeRemote) {
        super(repository);
        this.listener = listener;
        this.filter = filter;
        this.includeRemote = includeRemote;
    }

    @Override
    public TeamworkCommandResult getResult() {
        LinkedList returnInfo = new LinkedList();
        try (Git repo = Git.open((File)this.getRepository().getProjectPath().getParentFile());){
            Status s = repo.status().call();
            File gitPath = new File(this.getRepository().getProjectPath().getParent());
            s.getMissing().stream().map(item -> new TeamStatusInfo(new File(gitPath, (String)item), "", null, 1)).forEach(teamInfo -> returnInfo.add(teamInfo));
            s.getUncommittedChanges().stream().map(item -> new TeamStatusInfo(new File(gitPath, (String)item), "", null, 4)).forEach(teamInfo -> returnInfo.add(teamInfo));
            s.getConflicting().stream().map(item -> new TeamStatusInfo(new File(gitPath, (String)item), "", null, 5)).forEach(teamInfo -> returnInfo.add(teamInfo));
            s.getUntracked().stream().map(item -> new TeamStatusInfo(new File(gitPath, (String)item), "", null, 6)).forEach(teamInfo -> returnInfo.add(teamInfo));
            s.getUntrackedFolders().stream().map(item -> new TeamStatusInfo(new File(gitPath, (String)item), "", null, 6)).forEach(teamInfo -> returnInfo.add(teamInfo));
            s.getRemoved().stream().map(item -> new TeamStatusInfo(new File(gitPath, (String)item), "", null, 7)).forEach(teamInfo -> returnInfo.add(teamInfo));
        }
        catch (IOException | GitAPIException | NoWorkTreeException ex) {
            Logger.getLogger(GitStatusCommand.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.listener != null) {
            while (!returnInfo.isEmpty()) {
                TeamStatusInfo teamInfo2 = (TeamStatusInfo)returnInfo.removeFirst();
                this.listener.gotStatus(teamInfo2);
            }
            this.listener.statusComplete(new GitStatusHandle(this.getRepository()));
        }
        return new TeamworkCommandResult();
    }
}

