/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.git;

import bluej.groupwork.LogHistoryListener;
import bluej.groupwork.Repository;
import bluej.groupwork.StatusListener;
import bluej.groupwork.TeamSettings;
import bluej.groupwork.TeamworkCommand;
import bluej.groupwork.git.GitCloneCommand;
import bluej.groupwork.git.GitStatusCommand;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;

public class GitRepository
implements Repository {
    private final File projectPath;
    private final String protocol;
    private String reposUrl;
    private final FileRepositoryBuilder fileRepoBuilder;
    private final String userName;
    private String password;
    private String yourName;
    private String yourEmail;

    public GitRepository(File projectPath, String protocol, String reposUrl, FileRepositoryBuilder fileRepoBuilder, String userName, String password, String yourName, String yourEmail) {
        this.projectPath = projectPath;
        this.protocol = protocol;
        this.reposUrl = reposUrl;
        this.fileRepoBuilder = fileRepoBuilder;
        this.userName = userName;
        this.password = password;
        this.yourName = yourName;
        this.yourEmail = yourEmail;
    }

    public static String getYourNameFromRepo(File projectPath) {
        String result = null;
        try (Git repo = Git.open((File)projectPath.getParentFile());){
            StoredConfig repoConfig = repo.getRepository().getConfig();
            result = repoConfig.getString("user", null, "name");
            repo.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static String getYourEmailFromRepo(File projectPath) {
        String result = null;
        try (Git repo = Git.open((File)projectPath.getParentFile());){
            StoredConfig repoConfig = repo.getRepository().getConfig();
            result = repoConfig.getString("user", null, "email");
            repo.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public void setReposUrl(String url) {
        this.reposUrl = url;
    }

    public String getReposUrl() {
        return this.reposUrl;
    }

    @Override
    public void setPassword(TeamSettings newSettings) {
        this.password = newSettings.getPassword();
    }

    @Override
    public boolean versionsDirectories() {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public TeamworkCommand checkout(File projectPath) {
        return new GitCloneCommand(this, projectPath);
    }

    @Override
    public TeamworkCommand commitAll(Set<File> newFiles, Set<File> binaryNewFiles, Set<File> deletedFiles, Set<File> files, String commitComment) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public TeamworkCommand shareProject() {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public TeamworkCommand getStatus(StatusListener listener, FileFilter filter, boolean includeRemote) {
        return new GitStatusCommand(this, listener, filter, includeRemote);
    }

    @Override
    public TeamworkCommand getModules(List<String> modules) {
        return null;
    }

    @Override
    public TeamworkCommand getLogHistory(LogHistoryListener listener) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public boolean prepareDeleteDir(File dir) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public void prepareCreateDir(File dir) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public FileFilter getMetadataFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return !pathname.getName().equals(".git");
            }
        };
    }

    @Override
    public void getAllLocallyDeletedFiles(Set<File> files) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public String getVCSType() {
        return "Git";
    }

    @Override
    public String getVCSProtocol() {
        return this.protocol;
    }

    public UsernamePasswordCredentialsProvider getCredentialsProvider() {
        UsernamePasswordCredentialsProvider cp = new UsernamePasswordCredentialsProvider(this.userName, this.password);
        return cp;
    }

    public String getYourName() {
        return this.yourName;
    }

    public String getYourEmail() {
        return this.yourEmail;
    }

    protected File getProjectPath() {
        return this.projectPath;
    }
}

