/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.git;

import bluej.groupwork.Repository;
import bluej.groupwork.TeamSettings;
import bluej.groupwork.TeamworkCommandError;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.TeamworkCommandUnsupportedSetting;
import bluej.groupwork.TeamworkProvider;
import bluej.groupwork.UnsupportedSettingException;
import bluej.groupwork.git.GitRepository;
import bluej.utility.Debug;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import java.util.Properties;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.util.FS;

public class GitProvider
implements TeamworkProvider {
    @Override
    public String getProviderName() {
        return "Git";
    }

    @Override
    public String[] getProtocols() {
        return new String[]{"https", "http", "ssh", "git"};
    }

    @Override
    public String getProtocolKey(int protocol) {
        return this.getProtocols()[protocol];
    }

    @Override
    public String getProtocolLabel(String protocolKey) {
        return protocolKey;
    }

    @Override
    public TeamworkCommandResult checkConnection(TeamSettings settings) {
        try {
            String gitUrl = this.makeGitUrl(settings);
            LsRemoteCommand lsRemoteCommand = Git.lsRemoteRepository();
            UsernamePasswordCredentialsProvider cp = new UsernamePasswordCredentialsProvider(settings.getUserName(), settings.getPassword());
            lsRemoteCommand.setRemote(gitUrl);
            lsRemoteCommand.setCredentialsProvider((CredentialsProvider)cp);
            lsRemoteCommand.setTags(false);
            lsRemoteCommand.setHeads(false);
            if (gitUrl.startsWith("ssh")) {
                JschConfigSessionFactory sshSessionFactory = new JschConfigSessionFactory(){

                    protected void configure(OpenSshConfig.Host host, Session sn) {
                        Properties config = new Properties();
                        config.put("StrictHostKeyChecking", "no");
                        sn.setConfig(config);
                    }

                    protected JSch createDefaultJSch(FS fs) throws JSchException {
                        return super.createDefaultJSch(fs);
                    }
                };
                lsRemoteCommand.setTransportConfigCallback(arg_0 -> GitProvider.lambda$checkConnection$807((SshSessionFactory)sshSessionFactory, arg_0));
            }
            lsRemoteCommand.call();
        }
        catch (GitAPIException ex) {
            return new TeamworkCommandError(ex.getMessage(), ex.getLocalizedMessage());
        }
        catch (UnsupportedSettingException ex) {
            return new TeamworkCommandUnsupportedSetting(ex.getMessage());
        }
        return new TeamworkCommandResult();
    }

    @Override
    public Repository getRepository(File projectDir, TeamSettings settings) {
        try {
            FileRepositoryBuilder builder = new FileRepositoryBuilder();
            return new GitRepository(projectDir, settings.getProtocol(), this.makeGitUrl(settings), builder, settings.getUserName(), settings.getPassword(), settings.getYourName(), settings.getYourEmail());
        }
        catch (UnsupportedSettingException e) {
            Debug.reportError("GitProvider.getRepository", e);
            return null;
        }
    }

    protected String makeGitUrl(TeamSettings settings) throws UnsupportedSettingException {
        String protocol = settings.getProtocol();
        String server = settings.getServer();
        String prefix = settings.getPrefix();
        String gitUrl = protocol + "://" + server;
        if (prefix.length() != 0 && !prefix.startsWith("/")) {
            gitUrl = gitUrl + "/";
        }
        gitUrl = gitUrl + prefix;
        return gitUrl;
    }

    @Override
    public boolean needsEmail() {
        return true;
    }

    @Override
    public boolean needsName() {
        return true;
    }

    private static /* synthetic */ void lambda$checkConnection$807(SshSessionFactory sshSessionFactory, Transport t) {
        SshTransport sshTransport = (SshTransport)t;
        sshTransport.setSshSessionFactory(sshSessionFactory);
    }
}

