/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.git;

import bluej.groupwork.TeamworkCommandAborted;
import bluej.groupwork.TeamworkCommandError;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.git.GitCommand;
import bluej.groupwork.git.GitRepository;
import java.io.File;
import java.io.IOException;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.StoredConfig;

public class GitCloneCommand
extends GitCommand {
    private File clonePath;

    public GitCloneCommand(GitRepository repository, File projectPath) {
        super(repository);
        this.clonePath = projectPath;
    }

    @Override
    public TeamworkCommandResult getResult() {
        try {
            String reposUrl = this.getRepository().getReposUrl();
            CloneCommand cloneCommand = Git.cloneRepository();
            this.disableFingerprintCheck((TransportCommand)cloneCommand);
            cloneCommand.setDirectory(this.clonePath);
            cloneCommand.setURI(reposUrl);
            StoredConfig repoConfig = cloneCommand.call().getRepository().getConfig();
            repoConfig.setString("user", null, "name", this.getRepository().getYourName());
            repoConfig.setString("user", null, "email", this.getRepository().getYourEmail());
            repoConfig.save();
            if (!this.isCancelled()) {
                return new TeamworkCommandResult();
            }
            return new TeamworkCommandAborted();
        }
        catch (IOException | GitAPIException ex) {
            return new TeamworkCommandError(ex.getMessage(), ex.getLocalizedMessage());
        }
    }
}

