/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.cvsnb;

import bluej.Config;
import bluej.groupwork.Repository;
import bluej.groupwork.TeamSettings;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.TeamworkCommandUnsupportedSetting;
import bluej.groupwork.TeamworkProvider;
import bluej.groupwork.UnsupportedSettingException;
import bluej.groupwork.cvsnb.BlueJAdminHandler;
import bluej.groupwork.cvsnb.CvsRepository;
import bluej.utility.Debug;
import java.io.File;

public class CvsProvider
implements TeamworkProvider {
    static final String pserverLabel = Config.getString("team.settings.pserver");
    static final String extLabel = Config.getString("team.settings.ext");
    static final String[] protocols = new String[]{pserverLabel, extLabel};
    static final String[] protocolKeys = new String[]{"pserver", "ext"};

    @Override
    public String getProviderName() {
        return "CVS";
    }

    @Override
    public TeamworkCommandResult checkConnection(TeamSettings settings) {
        try {
            String cvsRoot = CvsProvider.makeCvsRoot(settings);
            return CvsRepository.validateConnection(cvsRoot);
        }
        catch (UnsupportedSettingException e) {
            return new TeamworkCommandUnsupportedSetting(e.getLocalizedMessage());
        }
    }

    public static String makeCvsRoot(TeamSettings settings) throws UnsupportedSettingException {
        String protocol = settings.getProtocol();
        String userName = settings.getUserName();
        String password = settings.getPassword();
        String server = settings.getServer();
        String prefix = settings.getPrefix();
        String group = settings.getGroup();
        if (password != null && password.contains("@")) {
            throw new UnsupportedSettingException(Config.getString("team.error.password.at"));
        }
        if (userName.contains(":")) {
            throw new UnsupportedSettingException(Config.getString("team.error.username.colon"));
        }
        String cvsRoot = ":" + protocol + ":" + userName + ":" + password + "@" + server + ":" + prefix;
        if (group != null && group.length() != 0) {
            if (!cvsRoot.endsWith("/")) {
                cvsRoot = cvsRoot + "/";
            }
            cvsRoot = cvsRoot + group;
        } else if (cvsRoot.endsWith("/")) {
            cvsRoot = cvsRoot.substring(0, cvsRoot.length() - 1);
        }
        return cvsRoot;
    }

    @Override
    public String[] getProtocols() {
        return protocols;
    }

    @Override
    public String getProtocolKey(int protocol) {
        return protocolKeys[protocol];
    }

    @Override
    public String getProtocolLabel(String protocolKey) {
        int i = 0;
        while (!protocolKeys[i].equals(protocolKey)) {
            ++i;
        }
        return protocols[i];
    }

    @Override
    public Repository getRepository(File projectDir, TeamSettings settings) {
        try {
            String cvsRoot = CvsProvider.makeCvsRoot(settings);
            BlueJAdminHandler adminHandler = new BlueJAdminHandler(projectDir);
            return new CvsRepository(projectDir, settings.getProtocol(), cvsRoot, adminHandler);
        }
        catch (UnsupportedSettingException e) {
            Debug.reportError("CvsProvider.getRepository", e);
            return null;
        }
    }

    @Override
    public boolean needsEmail() {
        return false;
    }

    @Override
    public boolean needsName() {
        return false;
    }
}

