/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork;

import bluej.pkgmgr.BlueJPackageFile;
import bluej.utility.Debug;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class CodeFileFilter
implements FileFilter,
FilenameFilter {
    private boolean includePkgFiles;
    private List<Pattern> patterns = null;
    private FileFilter parentFilter = null;

    public CodeFileFilter(List<String> ignore, boolean includePkgFiles, FileFilter parent) {
        this.includePkgFiles = includePkgFiles;
        this.patterns = this.makePatterns(ignore);
        this.parentFilter = parent;
    }

    private List<Pattern> makePatterns(List<String> ignore) {
        LinkedList<Pattern> patterns = new LinkedList<Pattern>();
        for (String patternString : ignore) {
            try {
                Pattern p = Pattern.compile(patternString);
                patterns.add(p);
            }
            catch (PatternSyntaxException pse) {
                Debug.message("Couldn't parse ignore pattern: " + patternString);
            }
        }
        return patterns;
    }

    private boolean matchesPatterns(String input) {
        for (Pattern pattern : this.patterns) {
            Matcher matcher = pattern.matcher(input);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean accept(File dir, String name) {
        boolean result = true;
        if (name.equals("doc") || dir.getName().equals("doc")) {
            result = false;
        }
        if (name.equals("CVS") || dir.getName().equals("CVS")) {
            result = false;
        }
        if (name.equals("CVSROOT") || dir.getName().equalsIgnoreCase("CVSROOT")) {
            result = false;
        }
        if (!this.includePkgFiles && BlueJPackageFile.isPackageFileName(name)) {
            result = false;
        }
        if (name.equals("bluej.pkh")) {
            result = false;
        }
        if (name.equals("team.defs")) {
            result = false;
        }
        if (name.equals(".DS_Store")) {
            result = false;
        }
        if (this.getFileType(name).equals("ctxt")) {
            result = false;
        }
        if (name.charAt(name.length() - 1) == '~') {
            result = false;
        }
        if (name.charAt(name.length() - 1) == '#') {
            result = false;
        }
        if (name.endsWith("#backup")) {
            result = false;
        }
        if (name.startsWith(".#")) {
            result = false;
        }
        if (this.matchesPatterns(name)) {
            result = false;
        }
        if (result && this.parentFilter != null) {
            result = this.parentFilter.accept(new File(dir, name));
        }
        return result;
    }

    @Override
    public boolean accept(File pathname) {
        File parent = pathname.getParentFile();
        return this.accept(parent, pathname.getName());
    }

    private String getFileType(String filename) {
        int lastDotIndex = filename.lastIndexOf(46);
        if (lastDotIndex > -1 && lastDotIndex < filename.length()) {
            return filename.substring(lastDotIndex + 1);
        }
        return "";
    }
}

