/*
 * Decompiled with CFR 0.152.
 */
package bluej.graph;

import bluej.graph.GraphEditor;
import bluej.graph.SelectableGraphElement;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;

public abstract class Vertex
implements SelectableGraphElement {
    private final JComponent component = new VertexJComponent();

    public Vertex(int x, int y, int width, int height) {
        this.component.setFocusable(true);
        this.component.setBounds(x, y, width, height);
        this.component.setVisible(true);
    }

    public void setPos(int x, int y) {
        this.component.setLocation(x, y);
    }

    @Override
    public boolean contains(int x, int y) {
        return this.component.getX() <= x && x < this.component.getX() + this.component.getWidth() && this.component.getY() <= y && y < this.component.getY() + this.component.getHeight();
    }

    @Override
    public void remove() {
    }

    @Override
    public void doubleClick(MouseEvent evt) {
    }

    @Override
    public void popupMenu(int x, int y, GraphEditor graphEditor) {
    }

    @Override
    public String getTooltipText() {
        return null;
    }

    @Override
    public void setSelected(boolean selected) {
    }

    @Override
    public boolean isSelected() {
        return false;
    }

    @Override
    public boolean isHandle(int x, int y) {
        return false;
    }

    @Override
    public boolean isResizable() {
        return false;
    }

    public int getX() {
        return this.component.getX();
    }

    public int getY() {
        return this.component.getY();
    }

    public int getWidth() {
        return this.component.getWidth();
    }

    public int getHeight() {
        return this.component.getHeight();
    }

    @Override
    public boolean isVisible() {
        return this.component.isVisible();
    }

    @Override
    public void setVisible(boolean aFlag) {
        this.component.setVisible(aFlag);
    }

    public void setSize(int width, int height) {
        this.component.setSize(width, height);
    }

    public JComponent getComponent() {
        return this.component;
    }

    public Rectangle getBounds() {
        return this.component.getBounds();
    }

    protected abstract String getDisplayName();

    @Override
    public void singleSelected() {
        if (!this.component.hasFocus()) {
            this.component.requestFocusInWindow();
        }
    }

    private class VertexJComponent
    extends JComponent
    implements Accessible {
        private VertexJComponent() {
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new JComponent.AccessibleJComponent(){

                    @Override
                    public String getAccessibleName() {
                        return Vertex.this.getDisplayName();
                    }

                    @Override
                    public AccessibleRole getAccessibleRole() {
                        return AccessibleRole.LIST_ITEM;
                    }
                };
            }
            return this.accessibleContext;
        }
    }
}

