/*
 * Decompiled with CFR 0.152.
 */
package bluej.collect;

import bluej.collect.DataCollector;
import bluej.collect.DiagnosticWithShown;
import bluej.compiler.Diagnostic;
import bluej.compiler.EDTCompileObserver;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.Project;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class DataCollectionCompileObserverWrapper
implements EDTCompileObserver {
    private EDTCompileObserver wrapped;
    private List<DiagnosticWithShown> diagnostics = new ArrayList<DiagnosticWithShown>();
    private Project project;

    public DataCollectionCompileObserverWrapper(Project project, EDTCompileObserver wrapped) {
        this.project = project;
        this.wrapped = wrapped;
    }

    @Override
    public void startCompile(File[] sources) {
        this.diagnostics.clear();
        this.wrapped.startCompile(sources);
    }

    @Override
    public boolean compilerMessage(Diagnostic diagnostic) {
        boolean shownToUser = this.wrapped.compilerMessage(diagnostic);
        this.diagnostics.add(new DiagnosticWithShown(diagnostic, shownToUser));
        return shownToUser;
    }

    @Override
    public void endCompile(File[] sources, boolean succesful) {
        HashSet<String> packages = new HashSet<String>();
        for (File f : sources) {
            packages.add(this.project.getPackageForFile(f));
        }
        Package pkg = packages.size() == 1 ? this.project.getPackage((String)packages.iterator().next()) : null;
        DataCollector.compiled(this.project, pkg, sources, this.diagnostics, succesful);
        this.wrapped.endCompile(sources, succesful);
    }
}

