/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.image.BufferedImage;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.SpinnerModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.explorer.propertysheet.Boolean3WayEditor;
import org.openide.explorer.propertysheet.ButtonPanel;
import org.openide.explorer.propertysheet.CleanComboUI;
import org.openide.explorer.propertysheet.DefaultPropertyModel;
import org.openide.explorer.propertysheet.DescriptionComponent;
import org.openide.explorer.propertysheet.EnumPropertyEditor;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.IconPanel;
import org.openide.explorer.propertysheet.IncrementPropertyValueSupport;
import org.openide.explorer.propertysheet.IndexedPropertyEditor;
import org.openide.explorer.propertysheet.InplaceEditor;
import org.openide.explorer.propertysheet.NodePropertyModel;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.explorer.propertysheet.PropertySetModel;
import org.openide.explorer.propertysheet.PropertySheet;
import org.openide.explorer.propertysheet.ProxyNode;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

final class PropUtils {
    static final boolean noCustomButtons = Boolean.getBoolean("netbeans.ps.noCustomButtons");
    static boolean forceRadioButtons = Boolean.getBoolean("netbeans.ps.forceRadioButtons");
    static final boolean noCheckboxCaption = !Boolean.getBoolean("netbeans.ps.checkboxCaption");
    static final boolean hideSingleExpansion = Boolean.getBoolean("netbeans.ps.hideSingleExpansion");
    static final boolean neverMargin = true;
    static final boolean psCommitOnFocusLoss = !Boolean.getBoolean("netbeans.ps.NoCommitOnFocusLoss");
    static final boolean psNoHelpButton = Boolean.getBoolean("netbeans.ps.noHelpButton");
    private static final String KEY_ALTBG = "Tree.altbackground";
    private static final String KEY_SETBG = "PropSheet.setBackground";
    private static final String KEY_SELSETBG = "PropSheet.selectedSetBackground";
    private static final String KEY_SETFG = "PropSheet.setForeground";
    private static final String KEY_SELSETFG = "PropSheet.selectedSetForeground";
    private static final String KEY_ICONMARGIN = "netbeans.ps.iconmargin";
    static final String KEY_ROWHEIGHT = "netbeans.ps.rowheight";
    private static final String PREF_KEY_SHOWDESCRIPTION = "showDescriptionArea";
    private static final String PREF_KEY_CLOSEDSETNAMES = "closedSetNames";
    private static final String PREF_KEY_SORTORDER = "sortOrder";
    static Color disFg = null;
    static float fsfactor = -1.0f;
    static int minW = -1;
    static int minH = -1;
    private static Color tfFg = null;
    private static Color tfBg = null;
    static Boolean noAltBg = null;
    static int marginWidth = -1;
    private static int iconMargin = -1;
    static Color selectedSetRendererColor = null;
    static Color setRendererColor = null;
    static int spinnerHeight = -1;
    static Color controlColor = null;
    static Color shadowColor = null;
    static Color altBg = null;
    private static String bptn = null;
    private static Comparator comp = null;
    private static int textMargin = -1;
    private static Color setForegroundColor = null;
    private static Color selectedSetForegroundColor = null;
    private static final Logger LOG = Logger.getLogger(PropUtils.class.getName());
    private static Boolean useOptimizedCustomButtonPainting = null;
    static final boolean isAqua = "Aqua".equals(UIManager.getLookAndFeel().getID());
    static final boolean isGtk = "GTK".equals(UIManager.getLookAndFeel().getID());
    private static Graphics scratchGraphics = null;
    private static final Comparator<Node.Property> SORTER_TYPE = new Comparator<Node.Property>(){

        @Override
        public int compare(Node.Property property, Node.Property property2) {
            Class clazz;
            String string;
            Class clazz2 = property.getValueType();
            String string2 = clazz2 != null ? clazz2.getName() : "";
            int n = string2.compareToIgnoreCase(string = (clazz = property2.getValueType()) != null ? clazz.getName() : "");
            if (n != 0) {
                return n;
            }
            string2 = property.getDisplayName();
            string = property2.getDisplayName();
            return string2.compareToIgnoreCase(string);
        }

        public String toString() {
            return "Type comparator";
        }
    };
    private static final Comparator<Node.Property> SORTER_NAME = new Comparator<Node.Property>(){

        @Override
        public int compare(Node.Property property, Node.Property property2) {
            String string = property.getDisplayName();
            String string2 = property2.getDisplayName();
            return String.CASE_INSENSITIVE_ORDER.compare(string, string2);
        }

        public String toString() {
            return "Name comparator";
        }
    };
    private static List<String> missing = null;
    private static Set<Node.Property> externallyEdited = new HashSet<Node.Property>(3);

    private static Preferences preferences() {
        return NbPreferences.forModule(PropUtils.class);
    }

    private PropUtils() {
    }

    static boolean useOptimizedCustomButtonPainting() {
        if (useOptimizedCustomButtonPainting == null) {
            useOptimizedCustomButtonPainting = "Windows".equals(UIManager.getLookAndFeel().getID()) ? Boolean.valueOf(PropUtils.isXPTheme()) : Boolean.valueOf("Aqua".equals(UIManager.getLookAndFeel().getID()));
        }
        return useOptimizedCustomButtonPainting;
    }

    static void log(Class clazz, String string, boolean bl) {
        PropUtils.log(clazz, string);
        if (bl) {
            PropUtils.dumpStack(clazz);
        }
    }

    static void log(Class clazz, String string) {
        Logger.getLogger(clazz.getName()).fine(string);
    }

    static void log(Class clazz, FocusEvent focusEvent) {
        if (PropUtils.isLoggable(clazz)) {
            StringBuffer stringBuffer = new StringBuffer(30);
            PropUtils.focusEventToString(focusEvent, stringBuffer);
            PropUtils.log(clazz, stringBuffer.toString());
        }
    }

    static boolean isLoggable(Class clazz) {
        return Logger.getLogger(clazz.getName()).isLoggable(Level.FINE);
    }

    static void logFocusOwner(Class clazz, String string) {
        if (PropUtils.isLoggable(clazz)) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append(" focus owner: ");
            Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            PropUtils.compToString(component, stringBuffer);
        }
    }

    static void focusEventToString(FocusEvent focusEvent, StringBuffer stringBuffer) {
        Component component = (Component)focusEvent.getSource();
        Component component2 = focusEvent.getOppositeComponent();
        stringBuffer.append(" focus ");
        stringBuffer.append(focusEvent.getID() == 1004 ? " gained by " : " lost by ");
        PropUtils.compToString(component, stringBuffer);
        stringBuffer.append(focusEvent.getID() == 1004 ? " from " : " to ");
        PropUtils.compToString(component2, stringBuffer);
        stringBuffer.append(" isTemporary: ");
        stringBuffer.append(focusEvent.isTemporary());
    }

    static void compToString(Component component, StringBuffer stringBuffer) {
        if (component == null) {
            stringBuffer.append(" null ");
            return;
        }
        String string = component.getName();
        Class<?> clazz = component.getClass();
        String string2 = clazz.getName();
        int n = string2.lastIndexOf(46);
        if (n != -1 && n != string2.length() - 1) {
            string2 = string2.substring(n + 1);
        }
        if (string != null) {
            stringBuffer.append("\"");
            stringBuffer.append(string);
            stringBuffer.append("\" (");
            stringBuffer.append(string2);
            stringBuffer.append(") ");
        } else {
            stringBuffer.append(' ');
            stringBuffer.append(string2);
            stringBuffer.append(' ');
        }
        if (!component.isVisible()) {
            stringBuffer.append(" [NOT VISIBLE] ");
        }
        if (!component.isDisplayable()) {
            stringBuffer.append(" [HAS NO PARENT COMPONENT] ");
        }
    }

    public static void dumpStack(Class clazz) {
        if (Logger.getLogger(clazz.getName()).isLoggable(Level.FINE)) {
            StringWriter stringWriter = new StringWriter();
            new Throwable().printStackTrace(new PrintWriter(stringWriter));
            PropUtils.log(clazz, stringWriter.getBuffer().toString());
        }
    }

    static Color getButtonColor() {
        return UIManager.getColor("netbeans.ps.buttonColor");
    }

    static int getCustomButtonWidth() {
        Icon icon = PropUtils.getCustomButtonIcon();
        return icon.getIconWidth() + (isAqua ? 5 : 3);
    }

    static boolean checkEnabled(Component component, PropertyEditor propertyEditor, PropertyEnv propertyEnv) {
        if (propertyEditor instanceof NoPropertyEditorEditor) {
            return false;
        }
        if (propertyEnv != null) {
            Boolean bl = (Boolean)propertyEnv.getFeatureDescriptor().getValue("canEditAsText");
            if (!propertyEnv.isEditable() || Boolean.FALSE.equals(bl)) {
                return false;
            }
        }
        return true;
    }

    static Graphics getScratchGraphics(Component component) {
        if (scratchGraphics == null) {
            scratchGraphics = new BufferedImage(1, 1, 1).getGraphics();
        }
        return scratchGraphics;
    }

    static Color getErrorColor() {
        Color color = UIManager.getColor("nb.errorForeground");
        if (color == null) {
            color = Color.RED;
        }
        return color;
    }

    static Color getDisabledForeground() {
        if (disFg == null && (disFg = UIManager.getColor("textInactiveText")) == null) {
            disFg = Color.GRAY;
        }
        return disFg;
    }

    static float getFontSizeFactor() {
        if (fsfactor == -1.0f) {
            Font font = UIManager.getFont("controlFont");
            if (font == null) {
                JLabel jLabel = new JLabel();
                font = jLabel.getFont();
            }
            int n = 12;
            fsfactor = n / font.getSize();
        }
        return fsfactor;
    }

    static int getMinimumPropPanelWidth() {
        if (minW == -1) {
            int n = 50;
            minW = Math.round((float)n * PropUtils.getFontSizeFactor());
        }
        return minW;
    }

    static int getMinimumPropPanelHeight() {
        if (minH == -1) {
            int n = 18;
            minH = Math.round((float)n * PropUtils.getFontSizeFactor());
        }
        return minH;
    }

    static Dimension getMinimumPanelSize() {
        return new Dimension(PropUtils.getMinimumPropPanelWidth(), PropUtils.getMinimumPropPanelHeight());
    }

    static boolean updateProp(PropertyModel propertyModel, PropertyEditor propertyEditor, String string) {
        Object object = propertyEditor.getValue();
        Object object2 = PropUtils.noDlgUpdateProp(propertyModel, propertyEditor);
        if (object2 instanceof Exception) {
            if (object2 instanceof InvocationTargetException) {
                object2 = ((InvocationTargetException)object2).getTargetException();
            }
            PropUtils.processThrowable((Throwable)object2, string, object);
        }
        boolean bl = object2 instanceof Boolean ? (Boolean)object2 : false;
        return bl;
    }

    static Object noDlgUpdateProp(PropertyModel propertyModel, PropertyEditor propertyEditor) {
        Object object = propertyEditor.getValue();
        Serializable serializable = Boolean.FALSE;
        try {
            try {
                Object[] objectArray;
                Object object2 = propertyModel.getValue();
                int n = 0;
                if (propertyModel instanceof NodePropertyModel && null != (objectArray = ((NodePropertyModel)propertyModel).getBeans())) {
                    n = objectArray.length;
                }
                if (object != null && !object.equals(object2) || object == null && (object2 != null || n > 1)) {
                    propertyModel.setValue(object);
                    serializable = Boolean.TRUE;
                }
            }
            catch (ProxyNode.DifferentValuesException differentValuesException) {
                propertyModel.setValue(object);
                serializable = Boolean.TRUE;
            }
        }
        catch (Exception exception) {
            serializable = exception;
        }
        return serializable;
    }

    static Exception updatePropertyEditor(PropertyEditor propertyEditor, Object object) {
        Exception exception = null;
        try {
            if (object instanceof String) {
                try {
                    propertyEditor.setAsText((String)object);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (null == Exceptions.findLocalizedMessage((Throwable)illegalArgumentException)) {
                        Exceptions.attachLocalizedMessage((Throwable)illegalArgumentException, (String)NbBundle.getMessage(PropUtils.class, (String)"MSG_SetAsText_InvalidValue", (Object)object));
                    }
                    exception = illegalArgumentException;
                }
            } else {
                propertyEditor.setValue(object);
            }
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        return exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean updateProp(InplaceEditor inplaceEditor) {
        JComponent jComponent = inplaceEditor.getComponent();
        Cursor cursor = jComponent.getCursor();
        try {
            boolean bl;
            String string;
            jComponent.setCursor(Cursor.getPredefinedCursor(3));
            Object object = inplaceEditor.getValue();
            Exception exception = PropUtils.updatePropertyEditor(inplaceEditor.getPropertyEditor(), object);
            String string2 = string = object == null ? NbBundle.getMessage(PropUtils.class, (String)"NULL") : object.toString();
            if (exception != null) {
                String string3;
                PropertyModel propertyModel = inplaceEditor.getPropertyModel();
                if (propertyModel instanceof NodePropertyModel) {
                    Node.Property property = ((NodePropertyModel)propertyModel).getProperty();
                    string3 = property.getDisplayName();
                } else {
                    string3 = propertyModel instanceof DefaultPropertyModel ? ((DefaultPropertyModel)propertyModel).propertyName : NbBundle.getMessage(PropUtils.class, (String)"MSG_unknown_property_name");
                }
                PropUtils.processThrowable(exception, string3, string);
            }
            boolean bl2 = bl = exception == null ? PropUtils.updateProp(inplaceEditor.getPropertyModel(), inplaceEditor.getPropertyEditor(), string) : false;
            return bl2;
        }
        finally {
            jComponent.setCursor(cursor);
        }
    }

    private static void processThrowable(Throwable throwable, String string, Object object) {
        String string2;
        if (throwable instanceof ThreadDeath) {
            throw (ThreadDeath)throwable;
        }
        String string3 = Exceptions.findLocalizedMessage((Throwable)throwable);
        if (string3 != null && throwable.getLocalizedMessage() != throwable.getMessage()) {
            string2 = NbBundle.getMessage(PropUtils.class, (String)"FMT_ErrorSettingProperty", (Object)object, (Object)string);
            Exceptions.attachLocalizedMessage((Throwable)throwable, (String)string2);
        } else if (throwable instanceof NumberFormatException) {
            Exceptions.attachLocalizedMessage((Throwable)throwable, (String)NbBundle.getMessage(PropUtils.class, (String)"FMT_BAD_NUMBER_FORMAT", (Object)object));
        }
        string2 = Exceptions.findLocalizedMessage((Throwable)throwable);
        if (null == string2 || string2.isEmpty()) {
            string2 = throwable.getMessage();
        }
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string2, 1);
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)message);
    }

    static synchronized String findLocalizedMessage(Throwable throwable, Object object, String string) {
        try {
            if (throwable == null) {
                return null;
            }
            if (throwable.getLocalizedMessage() != throwable.getMessage()) {
                return throwable.getLocalizedMessage();
            }
            String string2 = Exceptions.findLocalizedMessage((Throwable)throwable);
            if (string2 != null) {
                return string2;
            }
            if (throwable instanceof NumberFormatException) {
                return NbBundle.getMessage(PropUtils.class, (String)"FMT_BAD_NUMBER_FORMAT", (Object)object);
            }
            return NbBundle.getMessage(PropUtils.class, (String)"FMT_CannotUpdateProperty", (Object)object, (Object)string);
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
            return null;
        }
    }

    static Comparator<Node.Property> getComparator(int n) {
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                return SORTER_NAME;
            }
            case 2: {
                return SORTER_TYPE;
            }
        }
        throw new IllegalArgumentException("Unknown sorting mode: " + Integer.toString(n));
    }

    public static ComboBoxUI createComboUI(JComboBox jComboBox, boolean bl) {
        return new CleanComboUI(bl);
    }

    private static List<String> getMissing() {
        if (missing == null) {
            missing = new ArrayList<String>();
        }
        return missing;
    }

    private static PropertyEditor ignored(PropertyEditor propertyEditor) {
        if (propertyEditor != null && (propertyEditor.getClass().getName().equals("sun.beans.editors.EnumEditor") || propertyEditor.getClass().getName().equals("com.sun.beans.editors.EnumEditor"))) {
            return null;
        }
        return propertyEditor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PropertyEditor getPropertyEditor(Class<?> clazz) {
        PropertyEditor propertyEditor = PropUtils.ignored(PropertyEditorManager.findEditor(clazz));
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
        if (propertyEditor == null && classLoader != null && classLoader2 != classLoader) {
            try {
                Thread.currentThread().setContextClassLoader(classLoader);
                propertyEditor = PropertyEditorManager.findEditor(clazz);
            }
            finally {
                Thread.currentThread().setContextClassLoader(classLoader2);
            }
        }
        if (propertyEditor == null && Enum.class.isAssignableFrom(clazz)) {
            propertyEditor = new EnumPropertyEditor(clazz.asSubclass(Enum.class));
        }
        if (propertyEditor == null) {
            propertyEditor = new NoPropertyEditorEditor();
        }
        return propertyEditor;
    }

    static PropertyEditor getPropertyEditor(Node.Property property) {
        return PropUtils.getPropertyEditor(property, true);
    }

    static PropertyEditor getPropertyEditor(Node.Property property, boolean bl) {
        PropertyEditor propertyEditor;
        block16: {
            propertyEditor = property.getPropertyEditor();
            if (property instanceof Node.IndexedProperty && propertyEditor == null) {
                propertyEditor = new IndexedPropertyEditor();
                property.setValue("changeImmediate", (Object)Boolean.FALSE);
            }
            if (propertyEditor == null) {
                propertyEditor = PropUtils.getPropertyEditor(property.getValueType());
            }
            if (propertyEditor == null) {
                String string;
                List<String> list = PropUtils.getMissing();
                if (!list.contains(string = property.getValueType().getName())) {
                    Logger.getAnonymousLogger().fine("No property editor registered for type " + string);
                    list.add(string);
                }
                propertyEditor = new NoPropertyEditorEditor();
            } else if (property.canRead()) {
                try {
                    try {
                        try {
                            if ((property.getValueType() == Boolean.class || property.getValueType() == Boolean.TYPE) && property.getValue() == null) {
                                propertyEditor = new Boolean3WayEditor();
                            }
                            if (bl || null == propertyEditor.getValue()) {
                                PropUtils.updateEdFromProp(property, propertyEditor, property.getDisplayName());
                            }
                        }
                        catch (ProxyNode.DifferentValuesException differentValuesException) {
                            if (property.getValueType() == Boolean.class || property.getValueType() == Boolean.TYPE) {
                                propertyEditor = new Boolean3WayEditor();
                                break block16;
                            }
                            if (propertyEditor instanceof ExPropertyEditor) {
                                propertyEditor = new ExDifferentValuesEditor(propertyEditor);
                                break block16;
                            }
                            propertyEditor = new DifferentValuesEditor(propertyEditor);
                        }
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw (IllegalStateException)new IllegalStateException("Error getting property value").initCause(illegalAccessException);
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw (IllegalStateException)new IllegalStateException("Error getting property value").initCause(invocationTargetException);
                }
            }
        }
        return propertyEditor;
    }

    private static void updateEdFromProp(Node.Property property, PropertyEditor propertyEditor, String string) throws ProxyNode.DifferentValuesException, IllegalAccessException, InvocationTargetException {
        Object object = property.getValue();
        if (object instanceof String && ((String)object).length() > 2048) {
            propertyEditor.setValue(object);
            return;
        }
        Object object2 = propertyEditor.getValue();
        if (object == null && object2 == null) {
            return;
        }
        if (object != null && !object.equals(object2) || object == null && object2 != null) {
            if (object2 instanceof Object[] && object instanceof Object[] && Arrays.equals((Object[])object2, (Object[])object)) {
                return;
            }
            propertyEditor.setValue(object);
        }
    }

    static Color getControlColor() {
        if (controlColor == null) {
            PropUtils.deriveColorsAndMargin();
        }
        return controlColor;
    }

    static Color getShadowColor() {
        if (shadowColor == null) {
            PropUtils.deriveColorsAndMargin();
        }
        return shadowColor;
    }

    static Color getAltBg() {
        if (altBg == null) {
            PropUtils.deriveColorsAndMargin();
        }
        return altBg;
    }

    static boolean noAltBg() {
        if (noAltBg == null) {
            noAltBg = UIManager.getColor(KEY_ALTBG) == null ? Boolean.TRUE : Boolean.FALSE;
        }
        return noAltBg;
    }

    static Color getTextFieldBackground() {
        if (tfBg == null) {
            tfBg = UIManager.getColor("TextField.background");
            if (tfBg == null) {
                tfBg = UIManager.getColor("text");
            }
            if (tfBg == null) {
                tfBg = Color.WHITE;
            }
        }
        return tfBg;
    }

    static Color getTextFieldForeground() {
        if (tfFg == null) {
            tfFg = UIManager.getColor("TextField.foreground");
            if (tfFg == null) {
                tfFg = UIManager.getColor("textText");
            }
            if (tfFg == null) {
                tfFg = Color.BLACK;
            }
        }
        return tfFg;
    }

    private static void deriveColorsAndMargin() {
        Object object;
        int n;
        int n2;
        int n3;
        controlColor = UIManager.getColor("control");
        if (controlColor == null) {
            controlColor = Color.LIGHT_GRAY;
        }
        boolean bl = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel".equals(UIManager.getLookAndFeel().getClass().getName());
        boolean bl2 = "Nimbus".equals(UIManager.getLookAndFeel().getID());
        boolean bl3 = "GTK".equals(UIManager.getLookAndFeel().getID());
        setRendererColor = UIManager.getColor(KEY_SETBG);
        selectedSetRendererColor = UIManager.getColor(KEY_SELSETBG);
        if (bl2 || bl3) {
            setRendererColor = UIManager.getColor("Menu.background");
            selectedSetRendererColor = UIManager.getColor("Tree.selectionBackground");
        }
        if (setRendererColor == null && setRendererColor == null) {
            n3 = PropUtils.adjustColorComponent(controlColor.getRed(), -25, -25);
            n2 = PropUtils.adjustColorComponent(controlColor.getGreen(), -25, -25);
            n = PropUtils.adjustColorComponent(controlColor.getBlue(), -25, -25);
            setRendererColor = new Color(n3, n2, n);
        }
        if (selectedSetRendererColor == null) {
            Object object2 = object = bl ? UIManager.getColor("Table.selectionBackground") : UIManager.getColor("activeCaptionBorder");
            if (object == null) {
                object = Color.BLUE;
            }
            n3 = PropUtils.adjustColorComponent(((Color)object).getRed(), -25, -25);
            n2 = PropUtils.adjustColorComponent(((Color)object).getGreen(), -25, -25);
            n = PropUtils.adjustColorComponent(((Color)object).getBlue(), -25, -25);
            selectedSetRendererColor = new Color(n3, n2, n);
        }
        if ((shadowColor = UIManager.getColor("controlShadow")) == null) {
            shadowColor = Color.GRAY;
        }
        setForegroundColor = UIManager.getColor(KEY_SETFG);
        if (bl2 || bl3) {
            setForegroundColor = new Color(UIManager.getColor("Menu.foreground").getRGB());
        }
        if (setForegroundColor == null && (setForegroundColor = UIManager.getColor("Table.foreground")) == null && (setForegroundColor = UIManager.getColor("textText")) == null) {
            setForegroundColor = Color.BLACK;
        }
        if ((selectedSetForegroundColor = UIManager.getColor(KEY_SELSETFG)) == null && (selectedSetForegroundColor = UIManager.getColor("Table.selectionForeground")) == null) {
            selectedSetForegroundColor = Color.WHITE;
        }
        if ((altBg = UIManager.getColor(KEY_ALTBG)) == null) {
            altBg = UIManager.getColor("Tree.background");
            if (altBg == null) {
                altBg = Color.WHITE;
            }
            noAltBg = Boolean.TRUE;
        } else {
            noAltBg = Boolean.FALSE;
        }
        object = PropUtils.getCollapsedIcon();
        int n4 = 9;
        if (object != null) {
            n4 = object.getIconWidth();
            marginWidth = Math.max(14, n4 - 2);
        } else {
            marginWidth = 13;
        }
        Integer n5 = (Integer)UIManager.get(KEY_ICONMARGIN);
        iconMargin = n5 != null ? n5 : ("com.sun.java.swing.plaf.windows.WindowsLookAndFeel".equals(UIManager.getLookAndFeel().getClass().getName()) ? 4 : 0);
        n5 = (Integer)UIManager.get(KEY_ROWHEIGHT);
        spinnerHeight = n5 != null ? n5 : n4;
    }

    static Icon getExpandedIcon() {
        Icon icon = UIManager.getIcon(isGtk ? "Tree.gtk_expandedIcon" : "Tree.expandedIcon");
        if (icon == null) {
            LOG.info("no Tree.expandedIcon found");
        }
        return icon;
    }

    static Icon getCollapsedIcon() {
        Icon icon = UIManager.getIcon(isGtk ? "Tree.gtk_collapsedIcon" : "Tree.collapsedIcon");
        if (icon == null) {
            LOG.info("no Tree.collapsedIcon found");
        }
        return icon;
    }

    static Color getSetRendererColor() {
        if (setRendererColor == null) {
            PropUtils.deriveColorsAndMargin();
        }
        return setRendererColor;
    }

    static Color getSelectedSetRendererColor() {
        if (selectedSetRendererColor == null) {
            PropUtils.deriveColorsAndMargin();
        }
        return selectedSetRendererColor;
    }

    static Color getSetForegroundColor() {
        if (setForegroundColor == null) {
            PropUtils.deriveColorsAndMargin();
        }
        return setForegroundColor;
    }

    static Color getSelectedSetForegroundColor() {
        if (selectedSetForegroundColor == null) {
            PropUtils.deriveColorsAndMargin();
        }
        return selectedSetForegroundColor;
    }

    static int getMarginWidth() {
        if (marginWidth == -1) {
            PropUtils.deriveColorsAndMargin();
        }
        return marginWidth;
    }

    static int getSpinnerHeight() {
        if (spinnerHeight == -1) {
            PropUtils.deriveColorsAndMargin();
        }
        return spinnerHeight;
    }

    static int getIconMargin() {
        if (iconMargin == -1) {
            PropUtils.deriveColorsAndMargin();
        }
        return iconMargin;
    }

    static Icon getCustomButtonIcon() {
        return new BpIcon();
    }

    private static int adjustColorComponent(int n, int n2, int n3) {
        n = n > 128 ? (n -= n2) : (n += n3);
        if (n < 0) {
            n = 0;
        }
        if (n > 255) {
            n = 255;
        }
        return n;
    }

    static String basicPropsTabName() {
        if (bptn == null) {
            bptn = NbBundle.getMessage(PropUtils.class, (String)"LBL_BasicTab");
        }
        return bptn;
    }

    static Comparator getTabListComparator() {
        if (comp == null) {
            comp = new TabListComparator();
        }
        return comp;
    }

    static SplitPaneUI createSplitPaneUI() {
        return new CleanSplitPaneUI();
    }

    static boolean shouldShowDescription() {
        return PropUtils.preferences().getBoolean(PREF_KEY_SHOWDESCRIPTION, true);
    }

    static void saveShowDescription(boolean bl) {
        PropUtils.preferences().putBoolean(PREF_KEY_SHOWDESCRIPTION, bl);
    }

    static String[] getSavedClosedSetNames() {
        String string = PropUtils.preferences().get(PREF_KEY_CLOSEDSETNAMES, null);
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            String[] stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreElements()) {
                stringArray[n] = stringTokenizer.nextToken();
                ++n;
            }
            return stringArray;
        }
        return new String[0];
    }

    static void putSavedClosedSetNames(Set set) {
        if (set.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer(set.size() * 20);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(',');
            }
            PropUtils.preferences().put(PREF_KEY_CLOSEDSETNAMES, stringBuffer.toString());
        } else {
            PropUtils.preferences().put(PREF_KEY_CLOSEDSETNAMES, "");
        }
    }

    static void putSortOrder(int n) {
        PropUtils.preferences().putInt(PREF_KEY_SORTORDER, n);
    }

    static int getSavedSortOrder() {
        return PropUtils.preferences().getInt(PREF_KEY_SORTORDER, 0);
    }

    static int getTextMargin() {
        if ("apple.laf.AquaLookAndFeel".equals(UIManager.getLookAndFeel().getClass().getName())) {
            return 0;
        }
        if (textMargin == -1) {
            Object object = UIManager.get("netbeans.ps.textMargin");
            textMargin = object instanceof Integer ? (Integer)object : 2;
        }
        return textMargin;
    }

    static String createHtmlTooltip(String string, String string2) {
        boolean bl = false;
        if (string2.matches("\\<(html|HTML)\\>.*\\<\\/(html|HTML)\\>")) {
            string2 = string2.replaceAll("\\<\\/{0,1}(html|HTML)\\>", "");
            bl = true;
        }
        String string3 = null;
        if (string2.indexOf(" ") != -1) {
            string3 = " ";
        } else if (string2.indexOf(",") != -1) {
            string3 = ",";
        } else if (string2.indexOf(";") != -1) {
            string3 = ";";
        } else if (string2.indexOf("/") != -1) {
            string3 = "/";
        } else if (string2.indexOf("\\") != -1) {
            string3 = "\\";
        } else {
            return string2;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string3, true);
        StringBuffer stringBuffer = new StringBuffer(string2.length() + 20);
        stringBuffer.append("<html>");
        stringBuffer.append("<b><u>");
        stringBuffer.append(string);
        stringBuffer.append("</u></b><br>");
        int n = 0;
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (!bl) {
                string4 = string4.replace("&", "&amp;");
                string4 = string4.replace("<", "&lt;");
                string4 = string4.replace(">", "&gt;");
            }
            n += string4.length();
            stringBuffer.append(string4);
            if (stringTokenizer.hasMoreTokens()) {
                ++n;
            }
            if (n <= 80) continue;
            stringBuffer.append("<br>");
            n = 0;
            if (++n2 <= 10) continue;
            stringBuffer.append(NbBundle.getMessage(PropUtils.class, (String)"MSG_ELLIPSIS"));
            return stringBuffer.toString();
        }
        stringBuffer.append("</html>");
        return stringBuffer.toString();
    }

    static InplaceEditor findInnermostInplaceEditor(InplaceEditor inplaceEditor) {
        while (inplaceEditor instanceof IconPanel || inplaceEditor instanceof ButtonPanel) {
            if (inplaceEditor instanceof IconPanel) {
                inplaceEditor = ((IconPanel)inplaceEditor).getInplaceEditor();
                continue;
            }
            inplaceEditor = ((ButtonPanel)inplaceEditor).getInplaceEditor();
        }
        return inplaceEditor;
    }

    static boolean shouldDrawMargin(PropertySetModel propertySetModel) {
        return false;
    }

    private static Color getIconForeground() {
        return UIManager.getColor("PropSheet.customButtonForeground");
    }

    public static boolean isXPTheme() {
        Boolean bl = (Boolean)Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive");
        return bl == null ? false : bl;
    }

    static boolean isWindowsVistaLaF() {
        if (!"Windows".equals(UIManager.getLookAndFeel().getID())) {
            return false;
        }
        if (!PropUtils.isXPTheme()) {
            return false;
        }
        return PropUtils.isWindowsVista() || PropUtils.isWindows7() || PropUtils.isWindows8();
    }

    private static boolean isWindowsVista() {
        String string = System.getProperty("os.name");
        return string.indexOf("Vista") >= 0 || string.equals("Windows NT (unknown)") && "6.0".equals(System.getProperty("os.version"));
    }

    private static boolean isWindows7() {
        String string = System.getProperty("os.name");
        return string.indexOf("Windows 7") >= 0 || string.equals("Windows NT (unknown)") && "6.1".equals(System.getProperty("os.version"));
    }

    private static boolean isWindows8() {
        String string = System.getProperty("os.name");
        return string.indexOf("Windows 8") >= 0 || string.equals("Windows NT (unknown)") && "6.2".equals(System.getProperty("os.version"));
    }

    static boolean shallBeRDVEnabled(FeatureDescriptor featureDescriptor) {
        if (featureDescriptor != null && featureDescriptor instanceof Node.Property) {
            return PropUtils.shallBeRDVEnabled((Node.Property)featureDescriptor);
        }
        return false;
    }

    static boolean shallBeRDVEnabled(Node.Property property) {
        if (property == null || !property.supportsDefaultValue()) {
            return false;
        }
        try {
            if (property.getClass().getMethod("isDefaultValue", new Class[0]).getDeclaringClass() == Node.Property.class) {
                return true;
            }
            return !property.isDefaultValue();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            assert (false) : "No isDefaultValue in " + property.getClass() + ": " + noSuchMethodException;
            return true;
        }
    }

    static void addExternallyEdited(Node.Property property) {
        externallyEdited.add(property);
    }

    static void removeExternallyEdited(Node.Property property) {
        externallyEdited.remove(property);
    }

    static boolean isExternallyEdited(Node.Property property) {
        return externallyEdited.contains(property);
    }

    static void notifyEditingCancelled(PropertyEnv propertyEnv) {
        if (null == propertyEnv || null == propertyEnv.getFeatureDescriptor()) {
            return;
        }
        Object object = propertyEnv.getFeatureDescriptor().getValue("nb.property.editor.callback");
        if (object instanceof PropertyChangeListener) {
            ((PropertyChangeListener)object).propertyChange(new PropertyChangeEvent(propertyEnv.getFeatureDescriptor(), "editingCancelled", null, Boolean.TRUE));
        }
    }

    static boolean supportsValueIncrement(PropertyEnv propertyEnv) {
        if (null == propertyEnv || null == propertyEnv.getFeatureDescriptor()) {
            return false;
        }
        Object object = propertyEnv.getFeatureDescriptor().getValue("valueIncrement");
        return object instanceof SpinnerModel;
    }

    static Object getNextValue(PropertyEnv propertyEnv, boolean bl) {
        Object object;
        Object object2 = null;
        if (null != propertyEnv && null != propertyEnv.getFeatureDescriptor() && (object = propertyEnv.getFeatureDescriptor().getValue("valueIncrement")) instanceof SpinnerModel) {
            SpinnerModel spinnerModel = (SpinnerModel)object;
            object2 = bl ? spinnerModel.getNextValue() : spinnerModel.getPreviousValue();
        }
        return object2;
    }

    static void wrapUpDownArrowActions(JComponent jComponent, IncrementPropertyValueSupport incrementPropertyValueSupport) {
        InputMap inputMap = jComponent.getInputMap(0);
        PropUtils.wrapAction(inputMap.get(KeyStroke.getKeyStroke(38, 0)), jComponent.getActionMap(), incrementPropertyValueSupport, true);
        PropUtils.wrapAction("selectPrevious", jComponent.getActionMap(), incrementPropertyValueSupport, true);
        PropUtils.wrapAction("selectPrevious2", jComponent.getActionMap(), incrementPropertyValueSupport, true);
        PropUtils.wrapAction(inputMap.get(KeyStroke.getKeyStroke(68, 0)), jComponent.getActionMap(), incrementPropertyValueSupport, false);
        PropUtils.wrapAction("selectNext", jComponent.getActionMap(), incrementPropertyValueSupport, false);
        PropUtils.wrapAction("selectNext2", jComponent.getActionMap(), incrementPropertyValueSupport, false);
    }

    private static void wrapAction(Object object, ActionMap actionMap, IncrementPropertyValueSupport incrementPropertyValueSupport, boolean bl) {
        if (null == object) {
            return;
        }
        Action action = actionMap.get(object);
        if (null != action && !(action instanceof IncrementValueActionWrapper)) {
            actionMap.put(object, new IncrementValueActionWrapper(action, incrementPropertyValueSupport, bl));
        }
    }

    static class BpIcon
    implements Icon {
        boolean larger;

        public BpIcon() {
            Font font = UIManager.getFont("Table.font");
            this.larger = font != null ? font.getSize() > 13 : false;
        }

        @Override
        public int getIconHeight() {
            return 12;
        }

        @Override
        public int getIconWidth() {
            return this.larger ? 16 : 12;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            int n3 = component.getWidth();
            int n4 = component.getHeight();
            int n5 = n4 - 5;
            int n6 = n3 / 2;
            int n7 = n6 - 4;
            int n8 = n6 + 4;
            graphics.setColor(PropUtils.getIconForeground() == null ? component.getForeground() : PropUtils.getIconForeground());
            this.drawDot(graphics, n7 + 1, n5, this.larger);
            this.drawDot(graphics, n6, n5, this.larger);
            this.drawDot(graphics, n8 - 1, n5, this.larger);
        }

        private void drawDot(Graphics graphics, int n, int n2, boolean bl) {
            if (!bl) {
                graphics.drawLine(n, n2, n, n2);
            } else {
                graphics.drawLine(n - 1, n2, n + 1, n2);
                graphics.drawLine(n, n2 - 1, n, n2 + 1);
            }
        }
    }

    private static class SplitBorder
    implements Border {
        private SplitBorder() {
        }

        @Override
        public Insets getBorderInsets(Component component) {
            if (UIManager.getLookAndFeel() instanceof MetalLookAndFeel) {
                return new Insets(2, 0, 1, 0);
            }
            return new Insets(1, 0, 1, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (UIManager.getLookAndFeel() instanceof MetalLookAndFeel) {
                graphics.setColor(UIManager.getColor("controlShadow"));
                graphics.drawLine(n, n2, n + n3, n2);
                graphics.setColor(UIManager.getColor("controlHighlight"));
                graphics.drawLine(n, n2 + 1, n + n3, n2 + 1);
                graphics.drawLine(n, n2 + n4 - 1, n + n3, n2 + n4 - 1);
                graphics.setColor(UIManager.getColor("controlShadow"));
                graphics.drawLine(n, n2 + n4 - 2, n + n3, n2 + n4 - 2);
            } else {
                graphics.setColor(UIManager.getColor("controlHighlight"));
                graphics.drawLine(n, n2, n + n3, n2);
                graphics.setColor(UIManager.getColor("controlShadow"));
                graphics.drawLine(n, n2 + n4 - 1, n + n3, n2 + n4 - 1);
            }
        }
    }

    private static class CleanSplitPaneDivider
    extends BasicSplitPaneDivider
    implements Accessible {
        private AccessibleContext accessibleContext;

        public CleanSplitPaneDivider(BasicSplitPaneUI basicSplitPaneUI) {
            super(basicSplitPaneUI);
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (null == this.accessibleContext) {
                this.accessibleContext = new Component.AccessibleAWTComponent(){

                    @Override
                    public AccessibleRole getAccessibleRole() {
                        return AccessibleRole.SPLIT_PANE;
                    }
                };
                this.accessibleContext.setAccessibleName(NbBundle.getMessage(DescriptionComponent.class, (String)"ACS_Splitter"));
                this.accessibleContext.setAccessibleDescription(NbBundle.getMessage(DescriptionComponent.class, (String)"ACSD_Splitter"));
            }
            return this.accessibleContext;
        }
    }

    private static class CleanSplitPaneUI
    extends BasicSplitPaneUI {
        private CleanSplitPaneUI() {
        }

        @Override
        protected void installDefaults() {
            super.installDefaults();
            this.divider.setBorder(new SplitBorder());
        }

        @Override
        public BasicSplitPaneDivider createDefaultDivider() {
            return new CleanSplitPaneDivider(this);
        }
    }

    private static class TabListComparator
    implements Comparator {
        private TabListComparator() {
        }

        public int compare(Object object, Object object2) {
            String string = (String)object;
            String string2 = (String)object2;
            if (string == string2) {
                return 0;
            }
            String string3 = PropUtils.basicPropsTabName();
            if (string3.equals(string)) {
                return -1;
            }
            if (string3.equals(string2)) {
                return 1;
            }
            return string.compareTo(string2);
        }
    }

    static final class NoPropertyEditorEditor
    implements PropertyEditor {
        NoPropertyEditorEditor() {
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        @Override
        public String getAsText() {
            return NbBundle.getMessage(PropertySheet.class, (String)"CTL_NoPropertyEditor");
        }

        @Override
        public Component getCustomEditor() {
            return null;
        }

        @Override
        public String getJavaInitializationString() {
            return "";
        }

        @Override
        public String[] getTags() {
            return null;
        }

        @Override
        public Object getValue() {
            return this.getAsText();
        }

        @Override
        public boolean isPaintable() {
            return false;
        }

        @Override
        public void paintValue(Graphics graphics, Rectangle rectangle) {
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        @Override
        public void setAsText(String string) throws IllegalArgumentException {
        }

        @Override
        public void setValue(Object object) {
        }

        @Override
        public boolean supportsCustomEditor() {
            return false;
        }
    }

    static final class ExDifferentValuesEditor
    extends DifferentValuesEditor
    implements ExPropertyEditor {
        public ExDifferentValuesEditor(PropertyEditor propertyEditor) {
            super(propertyEditor);
        }

        @Override
        public void attachEnv(PropertyEnv propertyEnv) {
            ((ExPropertyEditor)this.ed).attachEnv(propertyEnv);
        }
    }

    static class DifferentValuesEditor
    implements PropertyEditor {
        protected PropertyEditor ed;
        private boolean notSet = true;

        public DifferentValuesEditor(PropertyEditor propertyEditor) {
            this.ed = propertyEditor;
            this.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    DifferentValuesEditor.this.notSet = false;
                }
            });
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.ed.addPropertyChangeListener(propertyChangeListener);
        }

        @Override
        public String getAsText() {
            String string = this.notSet ? NbBundle.getMessage(PropUtils.class, (String)"CTL_Different_Values") : this.ed.getAsText();
            return string;
        }

        @Override
        public Component getCustomEditor() {
            return this.ed.getCustomEditor();
        }

        @Override
        public String getJavaInitializationString() {
            return this.ed.getJavaInitializationString();
        }

        @Override
        public String[] getTags() {
            return this.ed.getTags();
        }

        @Override
        public Object getValue() {
            Object object = this.notSet ? null : this.ed.getValue();
            return object;
        }

        @Override
        public boolean isPaintable() {
            return this.notSet ? false : this.ed.isPaintable();
        }

        @Override
        public void paintValue(Graphics graphics, Rectangle rectangle) {
            if (this.isPaintable()) {
                this.ed.paintValue(graphics, rectangle);
            }
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.ed.removePropertyChangeListener(propertyChangeListener);
        }

        @Override
        public void setAsText(String string) throws IllegalArgumentException {
            this.ed.setAsText(string);
            this.notSet = false;
        }

        @Override
        public void setValue(Object object) {
            this.ed.setValue(object);
            this.notSet = false;
        }

        @Override
        public boolean supportsCustomEditor() {
            return this.ed.supportsCustomEditor();
        }
    }

    private static class IncrementValueActionWrapper
    extends AbstractAction {
        private final Action originalAction;
        private final IncrementPropertyValueSupport incrementSupport;
        private final boolean increment;

        public IncrementValueActionWrapper(Action action, IncrementPropertyValueSupport incrementPropertyValueSupport, boolean bl) {
            this.originalAction = action;
            this.incrementSupport = incrementPropertyValueSupport;
            this.increment = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl;
            boolean bl2 = bl = this.increment ? this.incrementSupport.incrementValue() : this.incrementSupport.decrementValue();
            if (bl) {
                return;
            }
            this.originalAction.actionPerformed(actionEvent);
        }

        @Override
        public boolean isEnabled() {
            return this.incrementSupport.isIncrementEnabled() || this.originalAction.isEnabled();
        }
    }
}

