/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.greychart.ui.views;

import com.jrockit.mc.greychart.ui.views.ChartSelectionListener;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import se.hirt.greychart.Selection;
import se.hirt.greychart.SelectionRenderer;

public class ChartCanvas
extends Canvas {
    private final JComponent m_swingComponent;
    private final Selection m_selection = new Selection();
    private ImageData m_imageDataSWT;
    private BufferedImage m_imageAWT;
    private Graphics2D m_graphicsAWT;
    private int lastDesiredWidth;
    private SelectionRenderer m_selectionDrawer;

    public ChartCanvas(Composite parent, JComponent swingComponent) {
        super(parent, 262144);
        this.m_swingComponent = swingComponent;
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                ChartCanvas.this.paint(e);
            }
        });
        this.m_selection.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                ChartCanvas.this.redraw();
            }
        });
        ChartSelectionListener chs = new ChartSelectionListener(this.m_selection);
        this.addMouseMoveListener(chs);
        this.addMouseListener((MouseListener)chs);
    }

    public void setSelectionRenderer(SelectionRenderer drawer) {
        this.m_selectionDrawer = drawer;
    }

    public void paint(PaintEvent e) {
        Rectangle rect = this.getClientArea();
        if (this.m_imageDataSWT == null || this.lastDesiredWidth != rect.width || this.m_imageDataSWT.height != rect.height) {
            this.lastDesiredWidth = rect.width;
            int width = rect.width;
            while (((width * 24 + 7) / 8 + 2) / 3 * 3 % 4 != 0) {
                ++width;
            }
            this.m_imageAWT = new BufferedImage(width, rect.height, 5);
            PaletteData vpPalette = new PaletteData(255, 65280, 0xFF0000);
            int scanlinePad = 3;
            byte[] byteData = ((DataBufferByte)this.m_imageAWT.getRaster().getDataBuffer()).getData();
            this.m_graphicsAWT = this.m_imageAWT.createGraphics();
            this.m_imageDataSWT = new ImageData(width, rect.height, 24, vpPalette, scanlinePad, byteData);
        }
        this.m_swingComponent.setSize(rect.width, rect.height);
        this.m_swingComponent.paint(this.m_graphicsAWT);
        if (this.m_selectionDrawer != null) {
            this.m_selectionDrawer.setSelection(this.m_selection);
            this.m_selectionDrawer.paint(this.m_graphicsAWT);
        }
        try {
            Image img = new Image((Device)e.display, this.m_imageDataSWT);
            e.gc.drawImage(img, rect.x, rect.y);
            img.dispose();
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            ex.printStackTrace();
        }
    }

    public Selection getSelection() {
        return this.m_selection;
    }

    public SelectionRenderer getSelectionRenderer() {
        return this.m_selectionDrawer;
    }
}

