/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.util;

import com.jrockit.mc.common.unit.IQuantity;
import com.jrockit.mc.common.util.Messages;
import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanParameterInfo;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;

public final class TypeHandling {
    private static final HashMap<String, String> formalPrimitiveMap = new HashMap();
    private static final String VALUE_COMPOSITE_DATA = "CompositeData";
    private static final String VALUE_TABULAR_DATA = "TabularData";
    private static HashMap<String, Class<?>> primitiveNameToClassMap;
    private static HashMap<Class<?>, Class<?>> primitiveToObjectClassMap;

    static {
        formalPrimitiveMap.put("B", "byte");
        formalPrimitiveMap.put("C", "char");
        formalPrimitiveMap.put("D", "double");
        formalPrimitiveMap.put("F", "float");
        formalPrimitiveMap.put("I", "int");
        formalPrimitiveMap.put("J", "long");
        formalPrimitiveMap.put("S", "short");
        formalPrimitiveMap.put("Z", "boolean");
        primitiveNameToClassMap = new HashMap();
        primitiveNameToClassMap.put(Integer.TYPE.getName(), Integer.TYPE);
        primitiveNameToClassMap.put(Long.TYPE.getName(), Long.TYPE);
        primitiveNameToClassMap.put(Short.TYPE.getName(), Short.TYPE);
        primitiveNameToClassMap.put(Character.TYPE.getName(), Character.TYPE);
        primitiveNameToClassMap.put(Byte.TYPE.getName(), Byte.TYPE);
        primitiveNameToClassMap.put(Float.TYPE.getName(), Float.TYPE);
        primitiveNameToClassMap.put(Double.TYPE.getName(), Double.TYPE);
        primitiveNameToClassMap.put(Boolean.TYPE.getName(), Boolean.TYPE);
        primitiveToObjectClassMap = new HashMap();
        primitiveToObjectClassMap.put(Integer.TYPE, Integer.class);
        primitiveToObjectClassMap.put(Long.TYPE, Long.class);
        primitiveToObjectClassMap.put(Short.TYPE, Short.class);
        primitiveToObjectClassMap.put(Character.TYPE, Character.class);
        primitiveToObjectClassMap.put(Byte.TYPE, Byte.class);
        primitiveToObjectClassMap.put(Float.TYPE, Float.class);
        primitiveToObjectClassMap.put(Double.TYPE, Double.class);
        primitiveToObjectClassMap.put(Boolean.TYPE, Boolean.class);
    }

    private TypeHandling() {
    }

    public static String simplifyType(String typeName) {
        if (typeName == null) {
            return "null";
        }
        StringBuilder arrayBuilder = new StringBuilder();
        while (typeName.startsWith("[")) {
            typeName = typeName.substring(1);
            arrayBuilder.append("[]");
        }
        if (typeName.endsWith(";")) {
            typeName = typeName.substring(1, typeName.length() - 1);
        }
        if (typeName.equals(CompositeData.class.getName())) {
            typeName = VALUE_COMPOSITE_DATA;
        } else if (typeName.equals(TabularData.class.getName())) {
            typeName = VALUE_TABULAR_DATA;
        } else if (typeName.equals(String.class.getName())) {
            typeName = "String";
        } else if (formalPrimitiveMap.containsKey(typeName)) {
            typeName = formalPrimitiveMap.get(typeName);
        } else if (typeName.startsWith("java.lang.") && typeName.lastIndexOf(46) == 9) {
            typeName = typeName.substring(10);
        }
        return String.valueOf(typeName) + arrayBuilder.toString();
    }

    public static String getPrimitiveTypeName(Object value) {
        if (value instanceof Boolean) {
            return Boolean.TYPE.getName();
        }
        if (value instanceof Character) {
            return Character.TYPE.getName();
        }
        if (value instanceof Byte) {
            return Byte.TYPE.getName();
        }
        if (value instanceof Short) {
            return Short.TYPE.getName();
        }
        if (value instanceof Integer) {
            return Integer.TYPE.getName();
        }
        if (value instanceof Long) {
            return Long.TYPE.getName();
        }
        if (value instanceof Float) {
            return Float.TYPE.getName();
        }
        if (value instanceof Double) {
            return Double.TYPE.getName();
        }
        return null;
    }

    public static String buildParameterString(MBeanParameterInfo[] params) {
        StringBuffer buf = new StringBuffer();
        buf.append('(');
        int p = 0;
        while (p < params.length) {
            if (p != 0) {
                buf.append(", ");
            }
            buf.append(TypeHandling.simplifyType(params[p].getType()));
            buf.append(' ');
            buf.append(params[p].getName());
            ++p;
        }
        buf.append(')');
        return buf.toString();
    }

    private static String createSizeString(String typeName, int size) {
        return MessageFormat.format(Messages.getString("TypeHandling_MESSAGE_SIZE"), typeName, size);
    }

    public static String getValueString(Object value) {
        if (value != null) {
            if (value instanceof CompositeData) {
                return TypeHandling.createSizeString(VALUE_COMPOSITE_DATA, ((CompositeData)value).values().size());
            }
            if (value instanceof TabularData) {
                return TypeHandling.createSizeString(VALUE_TABULAR_DATA, ((TabularData)value).size());
            }
            if (value.getClass().isArray()) {
                String typeString = TypeHandling.simplifyType(value.getClass().getName());
                int firstBracketIndex = typeString.indexOf("[");
                return String.valueOf(typeString.substring(0, firstBracketIndex + 1)) + Array.getLength(value) + typeString.substring(firstBracketIndex + 1);
            }
            if (value instanceof Collection) {
                return TypeHandling.createSizeString(value.getClass().getName(), ((Collection)value).size());
            }
            if (value instanceof Map) {
                return TypeHandling.createSizeString(value.getClass().getName(), ((Map)value).size());
            }
            if (value instanceof IQuantity) {
                return ((IQuantity)value).displayUsing("auto");
            }
            return value.toString();
        }
        return "null";
    }

    public static Class<?> getClassWithName(String name) throws ClassNotFoundException {
        if (name == null) {
            throw new ClassNotFoundException("The class name may not be null!");
        }
        Class<?> c = primitiveNameToClassMap.get(name);
        if (c == null) {
            return Class.forName(name);
        }
        return c;
    }

    public static Class<?> toNonPrimitiveClass(Class<?> primitiveClass) {
        if (primitiveClass.isPrimitive()) {
            return primitiveToObjectClassMap.get(primitiveClass);
        }
        return primitiveClass;
    }

    public static boolean isPrimitive(String className) {
        return primitiveNameToClassMap.containsKey(className);
    }
}

