/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.util;

public class JavaVersion {
    private final int major;
    private final int minor;
    private final int micro;
    private final int update;
    public static final int UNKNOWN = -1;

    public JavaVersion(String version) {
        String[] numbers = version.split("[\\._]");
        this.major = this.parseNumber(0, numbers);
        this.minor = this.parseNumber(1, numbers);
        this.micro = this.parseNumber(2, numbers);
        this.update = this.parseNumber(3, numbers);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public int getUpdate() {
        return this.update;
    }

    private int parseNumber(int index, String[] numbers) {
        if (index + 1 > numbers.length) {
            return -1;
        }
        StringBuilder numberStringBuilder = new StringBuilder();
        int i = 0;
        while (i < numbers[index].length()) {
            char c = numbers[index].charAt(i);
            if (!Character.isDigit(c)) break;
            numberStringBuilder.append(c);
            ++i;
        }
        try {
            return Integer.parseInt(numberStringBuilder.toString());
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.major;
        result = 31 * result + this.micro;
        result = 31 * result + this.minor;
        result = 31 * result + this.update;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JavaVersion other = (JavaVersion)obj;
        if (this.major != other.major) {
            return false;
        }
        if (this.micro != other.micro) {
            return false;
        }
        if (this.minor != other.minor) {
            return false;
        }
        return this.update == other.update;
    }

    public boolean isGreaterThan(JavaVersion otherVersion) {
        return this.getComparisonValue(this) > this.getComparisonValue(otherVersion);
    }

    private int getComparisonValue(JavaVersion javaVersion) {
        return this.unknownAsZero(javaVersion.getMajor()) << 24 | this.unknownAsZero(javaVersion.getMinor()) << 16 | this.unknownAsZero(javaVersion.getMicro()) << 8 | this.unknownAsZero(javaVersion.getUpdate());
    }

    private int unknownAsZero(int value) {
        return value == -1 ? 0 : value;
    }
}

