/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.unit;

import com.jrockit.mc.common.unit.IUnit;
import com.jrockit.mc.common.unit.LinearKindOfQuantity;
import com.jrockit.mc.common.unit.LinearQuantity;
import com.jrockit.mc.common.unit.LinearUnit;
import java.util.Arrays;
import java.util.Collection;

public class CustomUnitSelector
implements IUnit.UnitSelector<LinearQuantity, LinearUnit> {
    protected final LinearKindOfQuantity kindOfQuantity;
    protected final double[] multiplierArr;
    protected final LinearUnit[] unitArr;
    protected final IUnit.UnitSelector<LinearQuantity, LinearUnit> smallSelector;
    protected final IUnit.UnitSelector<LinearQuantity, LinearUnit> bigSelector;

    public CustomUnitSelector(LinearKindOfQuantity kindOfQuantity, IUnit.UnitSelector<LinearQuantity, LinearUnit> smallSelector, Collection<LinearUnit> units) {
        this(kindOfQuantity, smallSelector, units, smallSelector);
    }

    public CustomUnitSelector(LinearKindOfQuantity kindOfQuantity, IUnit.UnitSelector<LinearQuantity, LinearUnit> smallSelector, Collection<LinearUnit> units, IUnit.UnitSelector<LinearQuantity, LinearUnit> bigSelector) {
        this.kindOfQuantity = kindOfQuantity;
        this.smallSelector = smallSelector;
        this.bigSelector = bigSelector;
        this.unitArr = units.toArray(new LinearUnit[units.size()]);
        Arrays.sort(this.unitArr);
        this.multiplierArr = new double[this.unitArr.length + 1];
        int i = 0;
        while (i < this.unitArr.length) {
            this.multiplierArr[i] = this.unitArr[i].valueFactorTo(kindOfQuantity.atomUnit).getMultiplier();
            ++i;
        }
        this.multiplierArr[this.unitArr.length] = this.multiplierArr[this.unitArr.length - 1] * 1000.0;
    }

    @Override
    public LinearUnit getPreferredUnit(LinearQuantity quantity, double minNumericalValue, double maxNumericalValue) {
        LinearUnit atomUnit = this.kindOfQuantity.atomUnit;
        double absVal = Math.abs(quantity.doubleValueIn(atomUnit));
        if (absVal < this.multiplierArr[0]) {
            return this.smallSelector.getPreferredUnit(quantity, minNumericalValue, maxNumericalValue);
        }
        if (absVal < this.multiplierArr[this.unitArr.length]) {
            int i = 1;
            while (i < this.multiplierArr.length) {
                if (absVal < this.multiplierArr[i]) {
                    return this.unitArr[i - 1];
                }
                ++i;
            }
        }
        return this.bigSelector.getPreferredUnit(quantity, minNumericalValue, maxNumericalValue);
    }
}

