/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.persistence;

import com.jrockit.mc.common.persistence.Setting;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class SettingsImportHandler
extends DefaultHandler {
    private static final String NO_TAG = "<<>>";
    private final StringBuilder m_currentCharacters = new StringBuilder();
    private Setting m_currentSetting;
    private String m_lastStartElement = "<<>>";
    private boolean m_isRoot = true;

    public SettingsImportHandler(Setting setting) {
        this.m_currentSetting = setting;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.m_currentCharacters.setLength(0);
        if (!this.m_isRoot) {
            this.m_currentSetting = this.m_currentSetting.createChild(qName);
        } else {
            this.m_isRoot = false;
        }
        this.m_lastStartElement = qName;
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (qName.equals(this.m_lastStartElement)) {
            this.m_currentSetting.getParent().removeChild(this.m_currentSetting);
            this.m_currentSetting.getParent().setChildObject(qName, this.m_currentCharacters.toString());
        }
        this.m_lastStartElement = NO_TAG;
        this.m_currentSetting = this.m_currentSetting.getParent();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.m_currentCharacters.append(ch, start, length);
    }
}

