/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.persistence;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.common.persistence.ISettingFetcher;
import com.jrockit.mc.common.persistence.PrettyPrinter;
import com.jrockit.mc.common.persistence.Setting;
import com.jrockit.mc.common.persistence.SettingList;
import com.jrockit.mc.common.persistence.SettingsImportHandler;
import com.jrockit.mc.common.persistence.Type;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public final class PersistenceToolkit {
    static final String ATTRIBUTE_DEFINITION = "attributes";
    static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!-- Copyright \u00a9 1999, 2014, Oracle and/or its affiliates. All rights reserved. -->";
    private static WeakHashMap<Class<? extends Object>, ISettingFetcher<? extends Object>> m_typeFetchers = new WeakHashMap();

    private PersistenceToolkit() {
    }

    static void importFromFile(Setting setting, File importFile) throws IOException {
        FileInputStream fis = new FileInputStream(importFile);
        try {
            PersistenceToolkit.readSetting(setting, fis);
        }
        finally {
            fis.close();
        }
    }

    static void prettyPrint(Writer writer, Setting setting) throws IOException {
        PrettyPrinter p = new PrettyPrinter(writer);
        p.printDeep(setting);
    }

    static void prettyPrintShallow(Writer writer, Setting setting, boolean exportL9nAsText) throws IOException {
        PrettyPrinter p = new PrettyPrinter(writer);
        p.printShallow(setting);
    }

    static void exportToFile(Setting setting, File exportFile) throws IOException {
        PrintWriter fw = new PrintWriter(exportFile, "UTF-8");
        try {
            PersistenceToolkit.writeSetting(fw, setting);
        }
        finally {
            fw.close();
        }
    }

    public static void exportObjectToFile(Object object, File exportFile) throws IOException {
        Setting setting = PersistenceToolkit.getSetting(object);
        PersistenceToolkit.exportToFile(setting, exportFile);
    }

    public static <T> T createObjectFromFile(Class<T> clazz, File file) throws IOException {
        try {
            T object = clazz.newInstance();
            PersistenceToolkit.importIntoObjectFromFile(object, file);
            return PersistenceToolkit.cast(object);
        }
        catch (InstantiationException ie) {
            throw new RuntimeException(ie);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
    }

    private static <T> T cast(Object object) {
        return (T)object;
    }

    public static void importIntoObjectFromFile(Object object, File importFile) throws IOException {
        Setting setting = PersistenceToolkit.getSetting(object);
        setting.clear();
        PersistenceToolkit.importFromFile(setting, importFile);
    }

    private static void writeSetting(Writer writer, Setting setting) throws IOException {
        writer.write(XML_HEADER);
        writer.write("\n");
        new PrettyPrinter(writer).printDeep(setting);
    }

    public static void readSetting(Setting setting, InputStream is) {
        try {
            SAXParserFactory.newInstance().newSAXParser().parse(is, (DefaultHandler)new SettingsImportHandler(setting));
        }
        catch (SAXParseException spe) {
            if (spe.getLineNumber() == -1 && spe.getColumnNumber() == -1) {
                return;
            }
            throw new RuntimeException("Could not parse settings at " + spe.getLineNumber() + ' ' + spe.getColumnNumber(), spe);
        }
        catch (IOException spe) {
            throw new RuntimeException("Could not parse settings at ", spe);
        }
        catch (SAXException e) {
            throw new RuntimeException("Could not parse settings  ", e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Could not configure sax parser settings  ", e);
        }
    }

    static Setting copy(Setting sourceSetting, Setting parent) {
        Setting copiedSetting = new Setting(sourceSetting.getName());
        Map<String, String> properties = sourceSetting.getProperties();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            copiedSetting.setChildObject(entry.getKey(), entry.getValue());
        }
        for (Setting child : sourceSetting.getChildren()) {
            copiedSetting.addChild(PersistenceToolkit.copy(child, copiedSetting));
        }
        return copiedSetting;
    }

    public static <T> void inject(T destination, T source) {
        PersistenceToolkit.inject(PersistenceToolkit.getSetting(destination), PersistenceToolkit.getSetting(source));
    }

    static void inject(Setting destination, Setting source) {
        destination.clear();
        Map<String, String> properties = source.getProperties();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            destination.setChildObject(entry.getKey(), entry.getValue());
        }
        for (Setting child : source.getChildren()) {
            destination.addChild(PersistenceToolkit.copy(child, destination));
        }
    }

    public static <T> boolean isEqual(T a, T b) {
        return PersistenceToolkit.isEqual(PersistenceToolkit.getSetting(a), PersistenceToolkit.getSetting(b));
    }

    static boolean isEqual(Setting a, Setting b) {
        if (a.getProperties().equals(b.getProperties())) {
            List<Setting> aChilds = PersistenceToolkit.getSortedChildren(a);
            List<Setting> bChilds = PersistenceToolkit.getSortedChildren(b);
            if (aChilds.size() == bChilds.size()) {
                int i = 0;
                while (i < aChilds.size()) {
                    if (!PersistenceToolkit.isEqual(aChilds.get(i), bChilds.get(i))) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    static List<Setting> getSortedChildren(Setting setting) {
        ArrayList<Setting> children = new ArrayList<Setting>(setting.getChildren());
        Collections.sort(children, new Comparator<Setting>(){

            @Override
            public int compare(Setting o1, Setting o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return children;
    }

    public static <T> void registerFetcher(Class<T> clazz, ISettingFetcher<T> fetcher) {
        m_typeFetchers.put(clazz, fetcher);
    }

    public static <T> Setting getSetting(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        ISettingFetcher fetcher = (ISettingFetcher)PersistenceToolkit.cast(m_typeFetchers.get(t.getClass()));
        if (fetcher != null) {
            return fetcher.getSetting(t);
        }
        throw new IllegalArgumentException("No settings element for type: " + t.getClass() + "  could be found");
    }

    static Object create(Type type, Setting source) {
        Object object = PersistenceToolkit.create(type);
        Setting destination = PersistenceToolkit.getSetting(object);
        destination.setName(source.getName());
        return object;
    }

    public static <T> T createWorkingCopy(T t) {
        Object destinationObject = PersistenceToolkit.createInstance(t.getClass());
        Setting destination = PersistenceToolkit.getSetting(destinationObject);
        Setting source = PersistenceToolkit.getSetting(t);
        PersistenceToolkit.inject(destination, source);
        destination.setSource(source);
        return PersistenceToolkit.cast(destinationObject);
    }

    public static <T> T createCopy(T t) {
        Object destinationObject = PersistenceToolkit.createInstance(t.getClass());
        Setting destination = PersistenceToolkit.getSetting(destinationObject);
        Setting source = PersistenceToolkit.getSetting(t);
        PersistenceToolkit.inject(destination, source);
        return PersistenceToolkit.cast(destinationObject);
    }

    static Setting createSettingWorkingCopy(Setting source) {
        Setting destination = new Setting();
        PersistenceToolkit.inject(destination, source);
        destination.setSource(source);
        return destination;
    }

    static void commit(Setting setting) {
        Setting source = setting.getSource();
        if (source == null) {
            throw new IllegalArgumentException("Not a working copy, or the working copy has alreday been commited");
        }
        PersistenceToolkit.inject(source, setting);
    }

    public static void commit(Object object) {
        PersistenceToolkit.commit(PersistenceToolkit.getSetting(object));
    }

    static Object create(Type type) {
        if (type.getClazz().equals(List.class)) {
            return new SettingList(type.getChild(0));
        }
        return PersistenceToolkit.createInstance(type.getClazz());
    }

    private static Object createInstance(Class<? extends Object> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T createObjectFromInputStream(Class<T> clazz, InputStream in) {
        Object object = PersistenceToolkit.createInstance(clazz);
        Setting setting = PersistenceToolkit.getSetting(object);
        setting.clear();
        PersistenceToolkit.readSetting(setting, in);
        return PersistenceToolkit.cast(object);
    }

    public static String exportToString(Object object) {
        StringWriter sw = new StringWriter();
        PrettyPrinter pp = new PrettyPrinter(sw);
        try {
            pp.prettyPrint(PersistenceToolkit.getSetting(object), "", Integer.MAX_VALUE);
        }
        catch (IOException e) {
            return null;
        }
        return sw.toString();
    }

    public static boolean importFromString(String text, Object object) {
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(text.getBytes());
            Setting setting = PersistenceToolkit.getSetting(object);
            setting.clear();
            PersistenceToolkit.readSetting(setting, is);
            return true;
        }
        catch (Exception e) {
            IOToolkit.closeSilently(is);
            return false;
        }
    }
}

