/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;

public class ByteArrayDataSource
implements DataSource {
    private byte[] data;
    private String type;
    private String name = "";

    public ByteArrayDataSource(InputStream inputStream, String string) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        this.data = byteArrayOutputStream.toByteArray();
        this.type = string;
    }

    public ByteArrayDataSource(byte[] byArray, String string) {
        this.data = byArray;
        this.type = string;
    }

    public ByteArrayDataSource(String string, String string2) throws IOException {
        String string3 = null;
        try {
            ContentType contentType = new ContentType(string2);
            string3 = contentType.getParameter("charset");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (string3 == null) {
            string3 = MimeUtility.getDefaultJavaCharset();
        }
        this.data = string.getBytes(string3);
        this.type = string2;
    }

    public InputStream getInputStream() throws IOException {
        if (this.data == null) {
            throw new IOException("no data");
        }
        return new ByteArrayInputStream(this.data);
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException("cannot do this");
    }

    public String getContentType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }
}

