/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.model;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.common.unit.QuantityConversionException;
import com.jrockit.mc.flightrecorder.configuration.IRecordingConfiguration;
import com.jrockit.mc.flightrecorder.configuration.spi.ITemplateStorageDelegate;
import com.jrockit.mc.flightrecorder.controlpanel.ui.ControlPanel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.xml.IXMLValidator;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.xml.JFCGrammar;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.xml.JFCXMLValidator;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLModel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLTagInstance;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.VolatileStorageDelegate;
import com.jrockit.mc.rjmx.services.flr.EventOptionID;
import com.jrockit.mc.rjmx.services.flr.EventTypeID;
import com.jrockit.mc.rjmx.services.flr.IConvertibleValue;
import com.jrockit.mc.rjmx.services.flr.IEventSettingsHolder;
import com.jrockit.mc.rjmx.services.flr.IOptionConstraint;
import com.jrockit.mc.rjmx.services.flr.OptionHelper;
import com.jrockit.mc.rjmx.services.flr.StringConvertibleValue;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class RecordingTemplate
implements IRecordingConfiguration,
IEventSettingsHolder {
    private static final String FILE_FORMAT_VERSION = "1.0";
    private XMLModel xmlModel;
    private final ITemplateStorageDelegate storageDelegate;
    private final IRecordingConfiguration original;

    public static void validate(File jfcFile) throws ParseException, IOException {
        block6: {
            String schemaFile = "jfc.xsd";
            InputStream is = RecordingTemplate.class.getResourceAsStream(schemaFile);
            if (is != null) {
                try {
                    try {
                        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                        XMLModel.validate((File)jfcFile, (Schema)schemaFactory.newSchema(new StreamSource(is)));
                        break block6;
                    }
                    catch (SAXException e) {
                        throw new IOException("Trouble parsing schema " + schemaFile, e);
                    }
                }
                finally {
                    IOToolkit.closeSilently((Closeable)is);
                }
            }
            throw new IOException("Could not locate schema " + schemaFile);
        }
    }

    public static IRecordingConfiguration createEmpty(ITemplateStorageDelegate delegate) {
        XMLModel model = XMLModel.createEmpty((IXMLValidator)JFCXMLValidator.getValidator());
        model.getRoot().setValue(JFCGrammar.ATTRIBUTE_VERSION, FILE_FORMAT_VERSION);
        RecordingTemplate config = new RecordingTemplate(model, delegate, null);
        config.setName(Messages.RECORDING_TEMPLATE_NEW_NAME);
        return config;
    }

    public static XMLModel createModel(String xmlText) throws ParseException, IOException {
        return XMLModel.create((InputSource)new InputSource(new StringReader(xmlText)), (IXMLValidator)JFCXMLValidator.getValidator());
    }

    public static XMLModel createModel(File file) throws FileNotFoundException, IOException, ParseException {
        return RecordingTemplate.createModel(new FileInputStream(file));
    }

    public static XMLModel createModel(InputStream inStream) throws IOException, ParseException {
        XMLModel model;
        try {
            model = XMLModel.create((InputSource)new InputSource(inStream), (IXMLValidator)JFCXMLValidator.getValidator());
        }
        finally {
            IOToolkit.closeSilently((Closeable)inStream);
        }
        return model;
    }

    public RecordingTemplate(XMLModel xml) {
        this(xml, VolatileStorageDelegate.getWorkingCopyDelegate(), null);
    }

    public RecordingTemplate(ITemplateStorageDelegate delegate) throws IOException, ParseException {
        this(RecordingTemplate.createModel(delegate.getContents()), delegate, null);
    }

    public RecordingTemplate(XMLModel xml, ITemplateStorageDelegate storageDelegate) {
        this(xml, storageDelegate, null);
    }

    public RecordingTemplate(XMLModel xml, ITemplateStorageDelegate storageDelegate, IRecordingConfiguration original) {
        this.xmlModel = xml;
        this.storageDelegate = storageDelegate;
        this.original = original;
    }

    boolean replaceWithContentsFrom(IRecordingConfiguration workingCopy) {
        if (workingCopy.getOriginal() == this && workingCopy instanceof RecordingTemplate) {
            this.xmlModel = ((RecordingTemplate)workingCopy).getXMLModel().deepClone();
            return true;
        }
        return false;
    }

    private XMLTagInstance getRoot() {
        return this.xmlModel.getRoot();
    }

    public String getName() {
        return this.getRoot().getValue(JFCGrammar.ATTRIBUTE_NAME);
    }

    public void setName(String name) {
        this.getRoot().setValue(JFCGrammar.ATTRIBUTE_NAME, name);
    }

    public String getDescription() {
        return this.getRoot().getValue(JFCGrammar.ATTRIBUTE_DESCRIPTION);
    }

    public void setDescription(String description) {
        this.getRoot().setValue(JFCGrammar.ATTRIBUTE_DESCRIPTION, description);
    }

    public Map<EventOptionID, IConvertibleValue<?>> getEventOptions() {
        HashMap optionMap = new HashMap();
        for (XMLTagInstance producer : this.getRoot().getTagsInstances(JFCGrammar.TAG_PRODUCER)) {
            String producerURI = producer.getValue(JFCGrammar.ATTRIBUTE_URI);
            for (XMLTagInstance event : producer.getTagsInstances(JFCGrammar.TAG_EVENTTYPE)) {
                String eventPath = event.getValue(JFCGrammar.ATTRIBUTE_PATH);
                EventTypeID eventTypeID = new EventTypeID(producerURI, eventPath);
                this.getOptionsFromEventTo(eventTypeID, event, optionMap);
            }
        }
        return optionMap;
    }

    public Map<EventOptionID, IConvertibleValue<?>> getEventOptionsFor(EventTypeID eventTypeID) {
        XMLTagInstance eventElement = this.findEvent(eventTypeID, false);
        if (eventElement == null) {
            return Collections.emptyMap();
        }
        HashMap optionMap = new HashMap();
        this.getOptionsFromEventTo(eventTypeID, eventElement, optionMap);
        return optionMap;
    }

    public IConvertibleValue<?> getEventOption(EventOptionID eventOptionID) {
        XMLTagInstance settingElement = this.find(eventOptionID, false);
        return settingElement != null ? this.getOptionFrom(eventOptionID, settingElement) : null;
    }

    private void getOptionsFromEventTo(EventTypeID eventTypeID, XMLTagInstance eventElement, Map<EventOptionID, IConvertibleValue<?>> optionMap) {
        for (XMLTagInstance settingElement : eventElement.getTagsInstances(JFCGrammar.TAG_SETTING)) {
            String optionKey = settingElement.getValue(JFCGrammar.ATTRIBUTE_NAME);
            EventOptionID eventOptionID = new EventOptionID(eventTypeID, optionKey);
            IConvertibleValue<?> value = this.getOptionFrom(eventOptionID, settingElement);
            if (value == null) continue;
            optionMap.put(eventOptionID, value);
        }
    }

    private IConvertibleValue<?> getOptionFrom(EventOptionID eventOptionID, XMLTagInstance settingElement) {
        String value = settingElement.getContent();
        IOptionConstraint constraint = OptionHelper.getBestKnownConstraintFor((String)eventOptionID.getOptionKey());
        try {
            return StringConvertibleValue.create((IOptionConstraint)constraint, (String)value);
        }
        catch (QuantityConversionException e) {
            Logger logger = ControlPanel.getDefault().getLogger();
            logger.log(Level.WARNING, String.valueOf(NLS.bind((String)"Unable to convert \"{0}\" for option {1}: ", (Object)value, (Object)eventOptionID.getOptionURI())) + e.getMessage());
            return null;
        }
    }

    public boolean hasOption(EventOptionID eventOptionID) {
        return this.find(eventOptionID, false) != null;
    }

    private XMLTagInstance findProducer(String producerURI, boolean create) {
        XMLTagInstance producer = this.getRoot().findTagWithAttribute(JFCGrammar.TAG_PRODUCER, JFCGrammar.ATTRIBUTE_URI, producerURI);
        if (create && producer == null) {
            producer = this.getRoot().create(JFCGrammar.TAG_PRODUCER);
            producer.setValue(JFCGrammar.ATTRIBUTE_URI, producerURI);
        }
        return producer;
    }

    private XMLTagInstance findEvent(EventTypeID eventTypeID, boolean create) {
        XMLTagInstance eventType;
        XMLTagInstance producer = this.findProducer(eventTypeID.getProducerURI(), create);
        XMLTagInstance xMLTagInstance = eventType = producer != null ? producer.findTagWithAttribute(JFCGrammar.TAG_EVENTTYPE, JFCGrammar.ATTRIBUTE_PATH, eventTypeID.getEventPath()) : null;
        if (create && eventType == null) {
            eventType = producer.create(JFCGrammar.TAG_EVENTTYPE);
            eventType.setValue(JFCGrammar.ATTRIBUTE_PATH, eventTypeID.getEventPath());
        }
        return eventType;
    }

    private XMLTagInstance find(EventOptionID eventOptionID, boolean create) {
        XMLTagInstance option;
        XMLTagInstance eventType = this.findEvent(eventOptionID.getEventTypeID(), create);
        XMLTagInstance xMLTagInstance = option = eventType != null ? eventType.findTagWithAttribute(JFCGrammar.TAG_SETTING, JFCGrammar.ATTRIBUTE_NAME, eventOptionID.getOptionKey()) : null;
        if (create && option == null) {
            option = eventType.create(JFCGrammar.TAG_SETTING);
            option.setValue(JFCGrammar.ATTRIBUTE_NAME, eventOptionID.getOptionKey());
        }
        return option;
    }

    public void setOption(EventOptionID optionID, String valueWithUnit) {
        XMLTagInstance optionTag = this.find(optionID, true);
        optionTag.setContent(valueWithUnit);
    }

    public void removeOption(EventOptionID optionID) {
        XMLTagInstance optionTag = this.find(optionID, false);
        if (optionTag != null) {
            optionTag.getParent().remove(optionTag);
        }
    }

    public IRecordingConfiguration createClone() {
        return this.createCloneWithStorage(this.storageDelegate);
    }

    public IRecordingConfiguration createCloneWithStorage(ITemplateStorageDelegate storageDelegate) {
        return new RecordingTemplate(this.xmlModel.deepClone(), storageDelegate, this.original);
    }

    public IRecordingConfiguration createWorkingCopy() {
        return new RecordingTemplate(this.xmlModel.deepClone(), VolatileStorageDelegate.getWorkingCopyDelegate(), this);
    }

    public IRecordingConfiguration getOriginal() {
        return this.original;
    }

    public void exportToFile(File file) throws IOException {
        this.xmlModel.saveToFile(file);
    }

    public boolean hasControlElements() {
        for (XMLTagInstance producerTag : this.xmlModel.getRoot().getTagsInstances(JFCGrammar.TAG_PRODUCER)) {
            if (producerTag.getTagsInstances(JFCGrammar.TAG_CONTROL).size() <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean removeControlElements() {
        boolean changed = false;
        for (XMLTagInstance producerElement : this.xmlModel.getRoot().getTagsInstances(JFCGrammar.TAG_PRODUCER)) {
            for (XMLTagInstance controlElement : producerElement.getTagsInstances(JFCGrammar.TAG_CONTROL)) {
                producerElement.remove(controlElement);
                changed = true;
            }
            for (XMLTagInstance eventElement : producerElement.getTagsInstances(JFCGrammar.TAG_EVENTTYPE)) {
                for (XMLTagInstance settingElement : eventElement.getTagsInstances(JFCGrammar.TAG_SETTING)) {
                    changed |= settingElement.setValue(JFCGrammar.ATTRIBUTE_CONTROL_REFERENCE, null);
                }
            }
        }
        return changed;
    }

    public XMLModel getXMLModel() {
        return this.xmlModel;
    }

    public String getLocationInfo() {
        return this.storageDelegate.getLocationInfo();
    }

    public boolean isDeletable() {
        return this.storageDelegate.isDeletable();
    }

    public boolean delete() {
        return this.storageDelegate.delete();
    }

    public boolean isSaveable() {
        return this.storageDelegate.isSaveable();
    }

    public boolean save() {
        StringWriter writer = new StringWriter(2000);
        if (this.xmlModel.writeTo((Writer)writer)) {
            try {
                return this.storageDelegate.save(((Object)writer).toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean equalSettings(IEventSettingsHolder other) {
        if (other == this) {
            return true;
        }
        Map<EventOptionID, IConvertibleValue<?>> ourOptions = this.getEventOptions();
        for (Map.Entry<EventOptionID, IConvertibleValue<?>> entry : ourOptions.entrySet()) {
            if (entry.getValue().equals((Object)other.getEventOption(entry.getKey()))) continue;
            return false;
        }
        return ourOptions.size() == other.getEventOptions().size();
    }
}

