/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.model;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.flightrecorder.configuration.spi.ITemplateStorageDelegate;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.TemplateRepositoryFactory;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;

public class PrivateStorageDelegate
implements ITemplateStorageDelegate {
    private final File file;

    public static ITemplateStorageDelegate getDelegate() throws IOException {
        File dir = TemplateRepositoryFactory.getCreatedStorageDir();
        File file = File.createTempFile("template-", ".jfc", dir);
        return new PrivateStorageDelegate(file);
    }

    PrivateStorageDelegate(File file) {
        this.file = file;
    }

    public InputStream getContents() {
        try {
            return this.file.exists() ? new FileInputStream(this.file) : null;
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public boolean isSaveable() {
        return true;
    }

    public boolean save(String fileContent) throws IOException {
        try {
            Charset charset = Charset.forName("UTF-8");
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), charset);
            try {
                out.write(fileContent);
                ((Writer)out).flush();
            }
            finally {
                IOToolkit.closeSilently((Closeable)out);
            }
        }
        catch (IllegalCharsetNameException e) {
            return false;
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    public boolean isDeletable() {
        return true;
    }

    public boolean delete() {
        return this.file.delete();
    }

    public String getLocationInfo() {
        return this.file.exists() ? null : Messages.CONFIG_DELETED;
    }
}

