/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui;

import com.jrockit.mc.common.IDescribable;
import com.jrockit.mc.common.IDisconnectable;
import com.jrockit.mc.common.IUserAction;
import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.flightrecorder.controlpanel.ui.ControlPanel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.RecordingProvider;
import com.jrockit.mc.flightrecorder.controlpanel.ui.actions.DumpDefaultRecordingAction;
import com.jrockit.mc.flightrecorder.controlpanel.ui.actions.StartRecordingAction;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.IServerHandle;
import com.jrockit.mc.rjmx.JVMSupportToolkit;
import com.jrockit.mc.rjmx.actionprovider.IActionProvider;
import com.jrockit.mc.rjmx.actionprovider.IDoubleClickable;
import com.jrockit.mc.rjmx.services.flr.IFlightRecorderService;
import com.jrockit.mc.rjmx.services.flr.IRecordingDescriptor;
import com.jrockit.mc.rjmx.ui.misc.SimpleActionProvider;
import com.jrockit.mc.ui.misc.IGraphical;
import com.jrockit.mc.ui.misc.IRefreshable;
import com.jrockit.mc.ui.misc.WarningDescriptorHelper;
import com.jrockit.mc.ui.wizards.AbstractWizardUserAction;
import java.io.Closeable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;

public class FlightRecorderProvider
implements IActionProvider,
IRefreshable,
IDescribable,
IGraphical,
IDisconnectable,
IDoubleClickable {
    private final IServerHandle server;
    private final Map<Long, RecordingProvider> children = new HashMap<Long, RecordingProvider>();
    private IConnectionHandle refreshConnection;
    private final List<? extends IUserAction> actions = Arrays.asList(new AbstractWizardUserAction[]{new StartRecordingAction(this), new DumpDefaultRecordingAction(this)});
    private static List<SimpleActionProvider> LOADING_RECORDINGS = Arrays.asList(new SimpleActionProvider(Messages.RECORDING_INFO_LOADING, Messages.RECORDING_INFO_LOADING_DESCRIPTION));
    private final List<SimpleActionProvider> NO_RECORDINGS = Arrays.asList(new SimpleActionProvider(Messages.RECORDING_INFO_NO_RECORDINGS, Messages.RECORDING_INFO_NO_RECORDINGS_DESCRIPTION, null, Arrays.asList(new StartRecordingAction(this)), 0));
    private final WarningDescriptorHelper warningDescriptorHelper = new WarningDescriptorHelper();

    FlightRecorderProvider(IServerHandle server) {
        this.server = server;
        String errorMessage = JVMSupportToolkit.checkFlightRecorderSupport((IServerHandle)server, (boolean)true);
        if (errorMessage != null) {
            this.warningDescriptorHelper.setSpecificWarning(errorMessage);
        }
    }

    public synchronized Collection<? extends IActionProvider> getChildren() {
        return this.getRefreshConnection() == null ? LOADING_RECORDINGS : (this.children.size() > 0 ? this.children.values() : this.NO_RECORDINGS);
    }

    public boolean hasChildren() {
        return true;
    }

    public List<? extends IUserAction> getActions() {
        return this.actions;
    }

    public IUserAction getDoubleClickAction() {
        return this.actions.get(0);
    }

    public boolean refresh() {
        IConnectionHandle connection = this.getRefreshConnection();
        try {
            try {
                if (connection == null) {
                    connection = this.server.connect(Messages.FLIGHT_RECORDER_MONITOR);
                }
                this.refreshRecordings(connection);
            }
            catch (Exception e) {
                IOToolkit.closeSilently((Closeable)connection);
                IServerHandle.State state = this.server.getState();
                if (state == IServerHandle.State.DISPOSED || state == IServerHandle.State.FAILED) {
                    this.warningDescriptorHelper.setWarning(Messages.FLIGHT_RECORDER_SERVER_DISPOSED);
                    if (!this.reuseRefreshConnection(connection)) {
                        IOToolkit.closeSilently((Closeable)connection);
                    }
                    return false;
                }
                this.warningDescriptorHelper.setWarning(e.getLocalizedMessage());
                throw new RuntimeException(e.getLocalizedMessage(), e);
            }
        }
        finally {
            if (!this.reuseRefreshConnection(connection)) {
                IOToolkit.closeSilently((Closeable)connection);
            }
        }
        this.warningDescriptorHelper.resetWarning();
        return true;
    }

    public void refreshRecordings(IConnectionHandle connectionHandle) throws Exception {
        IFlightRecorderService service = (IFlightRecorderService)connectionHandle.getServiceOrDummy(IFlightRecorderService.class);
        List availableRecordings = service.getAvailableRecordings();
        Set<Long> recordingsIds = this.getRecordingIds();
        for (IRecordingDescriptor rec : availableRecordings) {
            RecordingProvider c = this.getRecording(rec);
            c.updateRecording(rec, connectionHandle);
            recordingsIds.remove(rec.getId());
        }
        this.removeRecordings(recordingsIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordingProvider findRecording(Long id, IConnectionHandle connectionHandle) throws Exception {
        this.refreshRecordings(connectionHandle);
        FlightRecorderProvider flightRecorderProvider = this;
        synchronized (flightRecorderProvider) {
            return this.children.get(id);
        }
    }

    public synchronized RecordingProvider getRecording(IRecordingDescriptor rec) {
        long id = rec.getId();
        RecordingProvider c = this.children.get(id);
        if (c == null) {
            c = new RecordingProvider(this.server, rec);
            this.children.put(id, c);
        }
        return c;
    }

    private synchronized Set<Long> getRecordingIds() {
        return new HashSet<Long>(this.children.keySet());
    }

    private synchronized void removeRecordings(Iterable<Long> recordingIds) {
        for (Long recId : recordingIds) {
            this.children.remove(recId);
        }
    }

    private synchronized boolean reuseRefreshConnection(IConnectionHandle connection) {
        if (this.refreshConnection == null || !this.refreshConnection.isConnected()) {
            this.refreshConnection = connection;
            return true;
        }
        return this.refreshConnection == connection;
    }

    private synchronized IConnectionHandle getRefreshConnection() {
        return this.refreshConnection == null || !this.refreshConnection.isConnected() ? null : this.refreshConnection;
    }

    private synchronized IConnectionHandle removeRefreshConnection() {
        IConnectionHandle tmp = this.refreshConnection;
        this.refreshConnection = null;
        return tmp;
    }

    public IServerHandle getServerHandle() {
        return this.server;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.warningDescriptorHelper.getImageDescriptor(ControlPanel.getDefault().getMCImageDescriptor("flr.gif"));
    }

    public String getName() {
        return this.warningDescriptorHelper.getName(Messages.FLIGHT_RECORDER_NAME);
    }

    public String getDescription() {
        return this.warningDescriptorHelper.getDescription(Messages.FLIGHT_RECORDER_DESCRIPTION);
    }

    public String toString() {
        return String.valueOf(this.getServerHandle().getServerDescriptor().getDisplayName()) + "/" + this.getName();
    }

    public void setWarning(String message) {
        this.warningDescriptorHelper.setWarning(message);
    }

    public void resetWarning() {
        this.warningDescriptorHelper.resetWarning();
    }

    public void disconnect() {
        IOToolkit.closeSilently((Closeable)this.removeRefreshConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        FlightRecorderProvider flightRecorderProvider = this;
        synchronized (flightRecorderProvider) {
            return this.refreshConnection != null && this.refreshConnection.isConnected();
        }
    }
}

