/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.notification.tab;

import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.RJMXPlugin;
import com.jrockit.mc.rjmx.triggers.TriggerRule;
import com.jrockit.mc.rjmx.triggers.internal.NotificationRegistry;
import com.jrockit.mc.ui.checkedstate.ICheckedStateModifierProvider;
import java.util.Collection;
import org.eclipse.jface.viewers.CheckboxTreeViewer;

public class RuleCheckedStateProvider
implements ICheckedStateModifierProvider {
    private final IConnectionHandle m_connectionHandle;

    public RuleCheckedStateProvider(IConnectionHandle connectionHandle) {
        this.m_connectionHandle = connectionHandle;
    }

    public Boolean isChecked(Object element) {
        if (element instanceof TriggerRule) {
            Collection list = this.getNotificationRepository().getRegisteredRules(this.m_connectionHandle.getServerDescriptor().getGUID());
            return list.contains(element);
        }
        return null;
    }

    public Boolean isGreyed(Object element) {
        if (element instanceof TriggerRule) {
            return Boolean.FALSE;
        }
        return null;
    }

    public boolean setChecked(Object element, boolean checked) {
        if (element instanceof TriggerRule) {
            this.setRuleRegistered((TriggerRule)element, checked);
            return true;
        }
        return false;
    }

    public boolean setGreyed(Object element, boolean greyed) {
        return element instanceof TriggerRule;
    }

    private void setRuleRegistered(TriggerRule rule, boolean register) {
        String serverGuid = this.m_connectionHandle.getServerDescriptor().getGUID();
        if (register) {
            this.getNotificationRepository().registerRule(rule, serverGuid);
        } else {
            this.getNotificationRepository().unregisterRule(rule, serverGuid);
        }
    }

    private NotificationRegistry getNotificationRepository() {
        return (NotificationRegistry)RJMXPlugin.getDefault().getService(NotificationRegistry.class);
    }

    public void checkStateChanged(CheckboxTreeViewer viewer) {
    }
}

